/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz83;
import com.aspose.words.internal.zzBk;
import com.aspose.words.internal.zzVPv;
import com.aspose.words.internal.zzW8I;
import com.aspose.words.internal.zzX6J;
import com.aspose.words.internal.zzXd8;
import com.aspose.words.internal.zzYLw;
import com.aspose.words.internal.zzYYA;
import com.aspose.words.internal.zzYlt;
import com.aspose.words.internal.zzZEv;
import com.aspose.words.internal.zzZYv;
import com.aspose.words.internal.zzZe9;
import com.aspose.words.zzLO;
import com.aspose.words.zzVPc;
import com.aspose.words.zzWqG;
import com.aspose.words.zzXbG;
import com.aspose.words.zzY3S;
import com.aspose.words.zzY8Q;
import com.aspose.words.zzYXF;
import com.aspose.words.zzZok;
import com.aspose.words.zziN;
import com.aspose.words.zzyD;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzYN3(zzZe9 zzZe92, zzZe9 zzZe93, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzBk.zzj0((Object)zzZe92, "srcStream");
        zzBk.zzj0((Object)zzZe93, "dstStream");
        zzBk.zzj0((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzj0(zzZe92, zzZe93, certificateHolder, signOptions);
        zzZe93.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzYN3(zzZe9.zzj0(srcStream), (zzZe9)zzZe9.zzZAU(dstStream), certHolder, signOptions);
    }

    private static void zzj0(zzZe9 zzZe92, zzZe9 zzZe93, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZAU(digitalSignature);
        }
        if (zzZok.zzUi(zzZe92)) {
            DigitalSignatureUtil.zzYN3(zzZe92, zzZe93, digitalSignature, true);
            return;
        }
        zzZok zzZok2 = new zzZok();
        zzZe9 zzZe94 = zzZe92;
        zzZok zzZok3 = zzZok2;
        FileFormatInfo fileFormatInfo = zzZok2.zzj0(zzZe94, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZEv zzZEv2 = new zzZEv(zzZe92);
                int n = fileFormatInfo.zzXfy() == 1 ? 1 : 2;
                zzYXF.zzYN3(zzZEv2, digitalSignature, n);
                zzZe93.zzWqc(0L);
                zzZEv2.zzZ8g(zzZe93);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzYN3(fileFormatInfo.zz5Z(), zzZe93, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzYN3(zzZe92, zzZe93, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzYN3(zzZe92, zzZe93, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzBk.zzYN3(srcFileName, "srcFileName");
        zzBk.zzYN3(dstFileName, "dstFileName");
        try (zzVPv zzVPv2 = zzBk.zzj0(srcFileName, 3, 1);){
            try (zzVPv zzVPv3 = zzBk.zzj0(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYN3((zzZe9)zzVPv2, (zzZe9)zzVPv3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYLw zzYLw2 = zzZe9.zzZAU(dstStream);
        zzZe9 zzZe92 = zzZe9.zzj0(srcStream);
        DigitalSignatureUtil.zzYN3(zzZe92, (zzZe9)zzYLw2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzVPv zzVPv2 = zzBk.zzj0(srcFileName, 3, 1);){
            try (zzVPv zzVPv3 = zzBk.zzj0(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWUu(zzVPv2, zzVPv3);
            }
            return;
        }
    }

    private static void zzWUu(zzZe9 zzZe92, zzZe9 zzZe93) throws Exception {
        zzZok zzZok2 = new zzZok();
        zzZe9 zzZe94 = zzZe92;
        zzZok zzZok3 = zzZok2;
        FileFormatInfo fileFormatInfo = zzZok2.zzj0(zzZe94, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZEv zzZEv2 = new zzZEv(zzZe92);
                zzZEv2.zzZQJ().zzXho("_xmlsignatures");
                zzZEv2.zzZQJ().zzXho("_signatures");
                zzZe93.zzWHG(0L);
                zzZEv2.zzZ8g(zzZe93);
                zzZe9 zzZe95 = zzZe93;
                zzZe95.zzWqc(zzZe95.zzXMW());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzW8I zzW8I2 = new zzW8I(zzZe92);
                zz83 zz832 = zzW8I2.zzYN3(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zz832 != null) {
                    for (zzYlt zzYlt2 : zz832.zzWhN()) {
                        String string = zz832.zzYN3(zzYlt2);
                        zzW8I2.zzFa().remove(string);
                    }
                    zzW8I2.zzFa().remove(zz832.getName());
                    zzYlt zzYlt3 = zzW8I2.zzWhN().zzrD("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzW8I2.zzWhN().remove(zzYlt3.getId());
                    zzW8I2.zzYFH();
                }
                zzZe93.zzWHG(0L);
                zzW8I2.zzZ8g(zzZe93);
                zzZe9 zzZe96 = zzZe93;
                zzZe96.zzWqc(zzZe96.zzXMW());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzWUu(zzZe9.zzj0(srcStream), zzZe9.zzZAU(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzVPv zzVPv2 = zzBk.zzj0(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYgk(zzVPv2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYgk(zzZe9 zzZe92) throws Exception {
        if (zzZok.zzUi(zzZe92)) {
            return DigitalSignatureUtil.zzYhC(zzZe92);
        }
        zzZok zzZok2 = new zzZok();
        zzZe9 zzZe93 = zzZe92;
        zzZok zzZok3 = zzZok2;
        FileFormatInfo fileFormatInfo = zzZok2.zzj0(zzZe93, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzZe92, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYgk(zzZe9.zzj0(stream));
    }

    static zzZYv zzYN3(zzZEv zzZEv2, String string) throws Exception {
        zziN zziN2 = new zziN(zzZEv2);
        if (zziN2.zzXiI()) {
            zzZYv zzZYv2 = zziN2.zzXxz(string);
            return zzZYv2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzXRG(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzYYA.zzj0("Unexpected digest algorithm: {0}.", n));
    }

    static String zzYzF(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzXRG(n);
    }

    private static void zzYN3(zzZe9 zzZe92, zzZe9 zzZe93, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzW8I zzW8I2 = new zzW8I(zzZe92);
        zzLO zzLO2 = bl ? new zzyD(zzW8I2) : new zzXbG(zzW8I2);
        zzLO2.zzj0(digitalSignature);
        zzZe93.zzWqc(0L);
        zzW8I2.zzZ8g(zzZe93);
    }

    private static void zzYN3(zzZe9 zzZe92, zzZe9 zzZe93, DigitalSignature digitalSignature) throws Exception {
        zzY3S zzY3S2 = new zzY3S(zzZe92);
        zzVPc zzVPc2 = new zzVPc(zzY3S2);
        zzVPc2.zzj0(digitalSignature);
        zzZe93.zzWqc(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzZe9 zzZe94 = zzZe93;
        zzY3S zzY3S3 = zzY3S2;
        zzY3S3.zzYN3(zzZe94, string, null);
    }

    private static void zzYN3(zzZEv zzZEv2, zzZe9 zzZe92, DigitalSignature digitalSignature, String string) throws Exception {
        zzZYv zzZYv2 = DigitalSignatureUtil.zzYN3(zzZEv2, string);
        zzZYv zzZYv3 = new zzZYv();
        DigitalSignatureUtil.zzYN3((zzZe9)zzZYv2, (zzZe9)zzZYv3, digitalSignature, false);
        zzZEv zzZEv3 = zziN.zzZAU(zzZYv3, string);
        zzZEv3.zzZ8g(zzZe92);
    }

    private static DigitalSignatureCollection zzYhC(zzZe9 zzZe92) throws Exception {
        zzZe92.zzWHG(0L);
        zzW8I zzW8I2 = new zzW8I(zzZe92);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zz83 zz832 = zzW8I2.zzYN3(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zz832 != null) {
            for (zzYlt zzYlt2 : zz832.zzWhN()) {
                String string = zz832.zzYN3(zzYlt2);
                zz83 zz833 = zzW8I2.zzYfg(string);
                zz83 zz834 = zzW8I2.zzYN3(zz833, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzX6J zzX6J2 = zzXd8.zzXVE(zz834.zzWGG().zzWvj());
                zzWqG.zzYN3(zz833.zzZv9(), zzX6J2, new zzY8Q(zzW8I2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

