/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz1o;
import com.aspose.words.internal.zzBk;
import com.aspose.words.internal.zzM9;
import com.aspose.words.internal.zzVRw;
import com.aspose.words.internal.zzW3l;
import com.aspose.words.internal.zzWao;
import com.aspose.words.internal.zzWnx;
import com.aspose.words.internal.zzXTu;
import com.aspose.words.internal.zzXjs;
import com.aspose.words.internal.zzYYA;
import com.aspose.words.internal.zzYsh;
import com.aspose.words.internal.zzZ5t;
import com.aspose.words.internal.zzZVq;
import com.aspose.words.internal.zzZYv;
import com.aspose.words.internal.zzZe9;
import com.aspose.words.internal.zzZjp;
import com.aspose.words.zz4v;
import com.aspose.words.zz8c;
import com.aspose.words.zzGI;
import com.aspose.words.zzMX;
import com.aspose.words.zzQq;
import com.aspose.words.zzVQc;
import com.aspose.words.zzVTu;
import com.aspose.words.zzVYi;
import com.aspose.words.zzWQa;
import com.aspose.words.zzWVQ;
import com.aspose.words.zzWgX;
import com.aspose.words.zzWl8;
import com.aspose.words.zzWoM;
import com.aspose.words.zzWwF;
import com.aspose.words.zzX5z;
import com.aspose.words.zzXSL;
import com.aspose.words.zzXfn;
import com.aspose.words.zzXpD;
import com.aspose.words.zzY6Y;
import com.aspose.words.zzYCW;
import com.aspose.words.zzYG;
import com.aspose.words.zzYGY;
import com.aspose.words.zzYHU;
import com.aspose.words.zzYXw;
import com.aspose.words.zzYZM;
import com.aspose.words.zzYqc;
import com.aspose.words.zzYzF;
import com.aspose.words.zzZ1p;
import com.aspose.words.zzZ37;
import com.aspose.words.zzZ6M;
import com.aspose.words.zzZMK;
import com.aspose.words.zzZP1;
import com.aspose.words.zzZWy;
import com.aspose.words.zzZn1;
import com.aspose.words.zzZpe;
import com.aspose.words.zzZqA;
import com.aspose.words.zzZtB;
import com.aspose.words.zzZuX;
import com.aspose.words.zzyv;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzY6Y,
zzYXw,
zzYqc {
    private Document zzWJG;
    private Node zzWXY;
    private Node zzXJj;
    private zzVQc zzXwd;
    private Font zzW8y;
    private zzM9<zzVQc> zzWNw;
    private zzM9<zzVYi> zzbL;
    private zzM9<zzYN3> zzrg;
    private zzZuX zzYnN = zzZuX.zzW1y();
    private zzXpD zzWwJ = new zzXpD();
    private RowFormat zzYYX;
    private CellFormat zzZtw;
    private zzM9<zzyv> zzXTZ;
    private int zzZoH = 0;
    private int zzWre = -1;
    private int zzYFT;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzXkK(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzXkK(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzXkK(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYN3(documentBuilder.getCurrentSection(), zzZpe.zzYjS(headerFooterType), 0, 0);
    }

    private void zzXkK(int n, int n2, int n3, int n4) {
        this.zzWJG.ensureMinimum();
        Section section = (Section)this.zzWJG.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzYN3(section, 1, n3, n4);
    }

    private void zzYN3(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZpe.zzYpx(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzWJG, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzWJG));
            }
        }
        this.zzYN3(story, n2, n3);
    }

    private void zzYN3(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYN3(paragraph2, n3);
    }

    final void zzZAU(Paragraph paragraph, int n) {
        this.zzYN3(paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzVQe().zzYDf() ? zzYGY.zzZZx(this.zzWJG, fieldName) : zzYGY.zzYyq(this.zzVQe(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzYN3(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzYN3(field, isAfter, false);
    }

    private boolean zzYN3(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzXfn zzXfn2 = field.getFormat().zzZqF();
        Inline inline = zzXfn2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzYN3(inline.zzYue(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzYCW.zzYN3(this.zzWJG, bookmarkName) : zzYCW.zzj0(this.zzWJG, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzYo8() == 6) {
            this.zzj0((Paragraph)node.zzZah(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYG.zzBo(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzj0(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYN3(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzYR0(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzYN3(cell, characterIndex);
    }

    private void zzj0(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzYo8() == 6) {
            this.zzWro(node);
        } else {
            Node node2 = node;
            if (zzYG.zzZ1I(node2.getNodeType())) {
                Paragraph paragraph = zzYG.zzBo(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzWro(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzYo8() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzWro(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzYFT = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzX8G();
            return;
        }
        if (!this.zzX7g()) {
            this.zzX8G();
        }
    }

    private boolean zzX7g() {
        Node node = this.zzVQe();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzVQe(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzYN3(inline.zzYue(), true);
            return true;
        }
        return false;
    }

    private void zzX8G() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYN3(documentBuilder.getCurrentParagraph().zzXbf(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzYR0(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzXKE() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzVQe().zzXh9(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZkz();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzYN3(paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzXw6(text, false);
    }

    public void writeln(String text) {
        this.zzXw6(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzY8N();
        Paragraph paragraph = this.getCurrentParagraph();
        zzWVQ zzWVQ2 = new zzWVQ(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzWJG, this.zzWb2(), this.zzOx());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzj0(this.zzVQe(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzWVQ2.dispose();
        }
        if (this.getDocument().zzWgc()) {
            zzZ37.zzZAU(paragraph, this.getDocument().zzVRq());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zz3D() {
        zzVQc zzVQc2;
        Run run;
        Run run2;
        zzY6Y zzY6Y2;
        this.zzY8N();
        Node node = this.zzVQe();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            zzY6Y2 = paragraph;
            run2 = zzY6Y2.zzZi3(false);
        } else {
            run2 = run = (Run)node.zzYEV(21);
        }
        if (run2 == null && zzBk.zzW3B(node, paragraph.zzX1f())) {
            run = paragraph.zzX1f();
        }
        if (run != null) {
            zzY6Y2 = run.zzYue();
            zzVQc2 = (zzVQc)((zzYzF)((Object)zzY6Y2)).zzYEK();
        } else {
            zzY6Y2 = paragraph.zzXbf();
            zzVQc2 = (zzVQc)((zzYzF)((Object)zzY6Y2)).zzYEK();
        }
        zzVQc zzVQc3 = zzVQc2;
        Paragraph paragraph2 = new Paragraph(this.zzWJG, this.zzWb2(), zzVQc3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzWVQ zzWVQ2 = new zzWVQ(this.zzWJG);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzj0(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzWVQ2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXSL.zz7N(this);
    }

    public void insertBreak(int breakType) {
        this.zzXeR(breakType, true);
    }

    final void zzXeR(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzZi2(bl)) {
                    this.zzWva(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzZi2(bl)) {
                    this.zzWva(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzZi2(bl)) {
                    this.zzZNn(1);
                }
                return;
            }
            case 5: {
                if (this.zzZi2(bl)) {
                    this.zzZNn(2);
                }
                return;
            }
            case 3: {
                if (this.zzZi2(bl)) {
                    this.zzZNn(0);
                }
                return;
            }
            case 6: {
                if (this.zzZi2(bl)) {
                    this.zzZNn(3);
                }
                return;
            }
            case 7: {
                if (this.zzZi2(bl)) {
                    this.zzZNn(4);
                }
                return;
            }
            case 8: {
                this.zzWva(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzYsh.zzYSx(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzYYA.zzj0("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzY8N();
        return zzYG.zzYN3(fieldType, updateField, this.zzOx(), this.zzVQe(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzY8N();
        return zzYG.zzYN3(fieldCode, this.zzOx(), this.zzVQe(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzY8N();
        return zzYG.zzYN3(fieldCode, fieldValue, this.zzOx(), this.zzVQe(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzBk.zzj0((Object)displayText, "displayText");
        zzBk.zzj0((Object)urlOrBookmark, "hrefOrBookmark");
        zzZtB zzZtB2 = this.zzj0(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzZtB2.zzj0(documentBuilder.zzBo(88, true));
        return zzYG.zzYN3(zzZtB2.getStart(), zzZtB2.getSeparator(), zzZtB2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzW5V(70);
        if (zzYsh.zzYSx(name)) {
            this.startBookmark(name);
        }
        this.zzWNG(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzYyF(70);
        String string = zzYsh.zzYSx(fieldValue) ? fieldValue : FormField.zzWTS;
        Run run = new Run(this.zzWJG, string, this.zzOx());
        this.insertNode(run);
        Node node = this.zzBo(70, true);
        if (zzYsh.zzYSx(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzGA(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzj0((Paragraph)node.zzZah(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzW5V(71);
        if (zzYsh.zzYSx(name)) {
            this.startBookmark(name);
        }
        this.zzWNG(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzBo(71, false);
        if (zzYsh.zzYSx(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzGA(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzW5V(83);
        if (zzYsh.zzYSx(name)) {
            this.startBookmark(name);
        }
        this.zzWNG(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzBo(83, false);
        if (zzYsh.zzYSx(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzGA(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzWJG, footnoteType, !zzYsh.zzYSx(referenceMark), referenceMark, this.zzOx());
        Style style = this.getDocument().getStyles().zzCJ(zzYG.zzZdp(footnoteType));
        footnote.zzYue().set(50, style.zzYiV());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzWJG);
        Style style2 = this.getDocument().getStyles().zzCJ(zzYG.zzYSQ(footnoteType));
        paragraph.zzWMC().set(1000, style2.zzYiV());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzWJG, '\u0002', new zzVQc()) : new Run(this.zzWJG, footnote.getReferenceMark(), new zzVQc());
        inline.zzYue().set(50, style.zzYiV());
        paragraph.appendChild(inline);
        if (zzYsh.zzYSx(footnoteText)) {
            Node node = this.zzVQe();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzWro(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzY9q(zzZe9 zzZe92) throws Exception {
        return this.zzYN3(zzZe92, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzY9q(zzZe9.zzj0(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzYN3(zzZe9 zzZe92, double d, double d2) throws Exception {
        return this.zzYN3(zzZe92, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzYN3(zzZe9.zzj0(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzZYv zzZYv2 = new zzZYv();){
            zzZ5t.zzYN3(image, zzZYv2);
            Shape shape = this.zzYN3(zzZYv2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzBk.zzYN3(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzXjs.zzZ2n(fileName);
        try {
            Shape shape = this.zzYN3((zzZe9)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzZe9)object).close();
            }
        }
    }

    private Shape zzYN3(zzZe9 zzZe92, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzZe92 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzBk.zzYyq(zzZe92);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYN3(zzZe9.zzj0(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl = zzZjp.zzYKq(imageBytes);
        boolean bl2 = this.zzWJG.getCompatibilityOptions().getMswVersion() > 12 || this.zzWJG.getCompatibilityOptions().getMswVersion() == 0;
        if (bl2) {
            shape = new Shape((DocumentBase)this.zzWJG, 0);
            zz4v zz4v2 = new zz4v();
            zz4v2.zzYN3(zzWgX.zzWoh("rect"));
            zz4v2.zzYN3(new zzX5z());
            zz4v2.zzZxC().zzXJN().zzj0(this.zzWJG);
            zzMX zzMX2 = new zzMX();
            zzMX2.zzj0(new zzZWy(this.zzWJG.zzZWh(), ""));
            zzMX2.zzYN3(new zz8c());
            zz4v2.zzYN3(zzMX2);
            shape.zzXI4(75);
            shape.zz7N(zz4v2);
            if (bl) {
                zz4v2.zzZxC().zzXJN().setExtensions(new zz1o<zzWQa>());
                zzWQa zzWQa2 = zzWQa.zzYN3(imageBytes, this.zzWJG);
                zz4v2.zzZxC().zzXJN().getExtensions().zzWUu(zzWQa2.getUri(), zzWQa2);
            }
        } else {
            shape = new Shape((DocumentBase)this.zzWJG, 75);
        }
        shape.zzYN3(this.zzOx());
        if (bl) {
            imageBytes = shape.getImageData().zzYN3(imageBytes, new zzWl8(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), bl2 ? 6 : 2);
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzmC(width, height);
        return shape;
    }

    private Shape zzYN3(zzZe9 zzZe92, String string, boolean bl, zzZe9 zzZe93) throws Exception {
        zzQq zzQq2 = zzQq.zzYzp(string);
        Shape shape = this.zzYN3(zzZe93, bl, zzQq2, null);
        zzZP1 zzZP12 = zzZn1.zzYN3(zzZe92, string, bl);
        return DocumentBuilder.zzYN3(null, false, shape, zzQq2.zzXpe, zzZP12);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYN3(zzZe9.zzj0(stream), progId, asIcon, zzZe9.zzj0(presentation));
    }

    private Shape zzYN3(String string, boolean bl, boolean bl2, zzZe9 zzZe92) throws Exception {
        zzQq zzQq2 = zzQq.zzXeh(zzZVq.zzYKX(string));
        return this.zzYN3(string, bl, bl2, zzZe92, zzQq2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYN3(fileName, isLinked, asIcon, zzZe9.zzj0(presentation));
    }

    private Shape zzYN3(String string, String string2, boolean bl, boolean bl2, zzZe9 zzZe92) throws Exception {
        zzQq zzQq2 = zzQq.zzYzp(string2);
        return this.zzYN3(string, bl, bl2, zzZe92, zzQq2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYN3(fileName, progId, isLinked, asIcon, zzZe9.zzj0(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzQq zzQq2 = zzQq.zzXeh(zzZVq.zzYKX(fileName));
        return this.zzYN3(fileName, isLinked, iconFile, iconCaption, zzQq2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzQq zzQq2 = zzQq.zzYzp(progId);
        return this.zzYN3(fileName, isLinked, iconFile, iconCaption, zzQq2);
    }

    private Shape zzYN3(zzZe9 zzZe92, String string, String string2, String string3) throws Exception {
        zzQq zzQq2 = zzQq.zzYzp(string);
        Shape shape = this.zzYN3(string2, string3, zzQq2);
        zzZP1 zzZP12 = zzZn1.zzYN3(zzZe92, string, true);
        return DocumentBuilder.zzYN3(null, false, shape, zzQq2.zzXpe, zzZP12);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzYN3(zzZe9.zzj0(stream), progId, iconFile, iconCaption);
    }

    final Shape zzYN3(zzZMK zzZMK2, zzZe9 zzZe92) throws Exception {
        Shape shape = this.zzBk(zzZe92);
        shape.zzXI4(201);
        shape.getOleFormat().zzj0(zzZMK2.zzWXZ());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzYN3(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZ1p zzZ1p2 = new zzZ1p();
        zzZ1p2.zzW7S(useBuilderFormatting);
        zzZ1p2.zzYGU(useBuilderFormatting);
        this.zzYN3(html, zzZ1p2);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzY8N();
        return zzYG.zzYN3(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzY8N();
        return zzYG.zzYN3(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZqA zzZqA2 = new zzZqA();
        return zzZqA2.zzYN3(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZ6M(this).zzYN3(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZ6M(this).zzYN3(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzWJG, 75);
        shape.zzYN3(this.zzOx());
        shape.zzXoF(true);
        shape.getSignatureLine().zzYN3(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzmC(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzYQb(this.zzWJG);
        this.insertNode(shape);
        return shape;
    }

    private void zzYN3(String string, zzZ1p zzZ1p2) throws Exception {
        this.zzY8N();
        if (this.zzYKe()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzXK3(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzYHU zzYHU2 = zzYG.zzYN3(string, zzZ1p2, this);
        zzYHU2.zzXtk();
    }

    private boolean zzYKe() {
        boolean bl = false;
        if (this.zzVQe().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzVQe().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzXK3(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzY8N();
        if (this.zzXKE() == null) {
            this.startTable();
        }
        if (this.zzXKE().zzSN() == 1) {
            this.zzXKE().zzbu();
        }
        if (this.zzXKE().zzSN() == 3) {
            this.zzXKE().zzBr();
        }
        return this.zzXKE().zzX1G();
    }

    public Table startTable() {
        this.zzXTZ.push(new zzyv(this));
        return this.zzXKE().startTable();
    }

    public Table endTable() {
        if (this.zzXKE() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzXKE().endTable();
        this.zzXTZ.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzXKE() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzXKE().endRow();
        if (this.zzW8y != null && this.zzW8y.getHidden()) {
            row.zzWJO().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWJG, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWJG, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYH5();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWJG, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzYBB();
        bookmarkStart.zzWvz(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYH5();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzYBB();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWJG, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzZHU(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzWJG);
        this.zzWre = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzWre == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWJG, this.zzWre);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWJG, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzBk.zzj0((Object)importFormatOptions, "ImportFormatOptions");
        this.zzY8N();
        return zzWwF.zzYN3(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzWJG;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzWJG) {
            return;
        }
        this.zzWJG = value;
        this.zzWro(null);
        this.zzXwd = new zzVQc();
        this.zzWNw = null;
        this.zzbL = null;
        this.zzW8y = null;
        this.zzXTZ = new zzM9();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzW8y == null) {
            DocumentBuilder documentBuilder = this;
            this.zzW8y = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzW8y;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzYYX == null) {
            this.zzYYX = new RowFormat(this);
        }
        return this.zzYYX;
    }

    public CellFormat getCellFormat() {
        if (this.zzZtw == null) {
            this.zzZtw = new CellFormat(this);
        }
        return this.zzZtw;
    }

    final void zzac(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzVQc zzVQc2 = this.getCurrentParagraph().zzXbf();
        this.zzXEQ().push(new zzYN3(this.zzOx(), (zzVQc)zzVQc2.zzYEK()));
    }

    public void popFont() {
        zzM9<zzYN3> zzM92 = this.zzXEQ();
        if (zzM92.size() > 0) {
            zzYN3 zzYN32 = (zzYN3)this.zzXEQ().pop();
            this.zzYN3(zzYN32.zzYue(), false);
            this.getCurrentParagraph().zzW00(zzYN32.zzZSc());
        }
    }

    final void zzao() {
        this.zzW9y().push(this.zzOx());
    }

    final void zznp() {
        zzM9<zzVQc> zzM92 = this.zzW9y();
        if (zzM92.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzYN3((zzVQc)documentBuilder.zzW9y().pop(), false);
        }
    }

    final void zzWlc() {
        this.zzYag().push(this.zzWb2());
    }

    final void zzYz2() {
        zzM9<zzVYi> zzM92 = this.zzYag();
        if (zzM92.size() > 0) {
            this.getCurrentParagraph().zzYN3((zzVYi)this.zzYag().pop());
        }
    }

    final zzZtB zzj0(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzW5V(88);
        zzYZM zzYZM2 = new zzYZM();
        zzYZM2.setTarget(string2);
        zzYZM2.setScreenTip(string3);
        if (bl) {
            zzYZM2.setSubAddress(string);
        } else {
            zzYZM2.setAddress(zzWao.zzXCb(string));
            zzYZM2.setSubAddress(zzWao.zzXd8(string));
        }
        this.zzWNG(zzYZM2.toString());
        FieldSeparator fieldSeparator = this.zzYyF(88);
        return new zzZtB(fieldStart, fieldSeparator, null);
    }

    final zzZtB zzWwk(String string, String string2, String string3) {
        boolean bl = zzWao.zzYYx(string);
        String string4 = bl ? zzWao.zzXd8(string) : string;
        return this.zzj0(string4, bl, string2, string3);
    }

    final FieldEnd zzZuL() {
        return this.zzBo(88, true);
    }

    final zzVQc zzOx() {
        zzVQc zzVQc2 = this.zzXwd;
        return (zzVQc)zzVQc2.zzYEK();
    }

    final zzVYi zzWb2() {
        zzVYi zzVYi2 = this.getCurrentParagraph().zzWMC();
        return (zzVYi)zzVYi2.zzYEK();
    }

    final zzZuX zzYnl() {
        zzZuX zzZuX2 = this.zzWJO();
        return (zzZuX)zzZuX2.zzYEK();
    }

    final zzXpD zzZtq() {
        zzXpD zzXpD2 = this.zzVs();
        return (zzXpD)zzXpD2.zzYEK();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzVQe(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzVQe().getNodeType() == 8;
    }

    private void zzXw6(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzZpe.zzXWR(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzMr(string2.substring(n4, n4 + n2));
                }
                switch (this.zzZoH) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzWva(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzMr(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzY8N();
        if (this.zzXKE() != null && this.zzXKE().zzSN() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzVQe().getParentNode().insertBefore(node, this.zzVQe());
    }

    final void zzYjt(int n) {
        this.zzZi2(true);
        this.zzZNn(n);
    }

    private void zzZNn(int n) {
        this.insertParagraph();
        zzWVQ zzWVQ2 = new zzWVQ(this.getDocument());
        try {
            zzVTu zzVTu2 = this.getCurrentSection().zzVS1();
            zzVTu zzVTu3 = (zzVTu)zzVTu2.zzYEK();
            Section section = new Section(this.zzWJG, zzVTu3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzWJG));
            this.zzWJG.insertAfter(section, this.getCurrentSection());
            section.getBody().zzj0(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzWVQ2.dispose();
        }
    }

    final FieldStart zzW5V(int n) {
        this.zzY8N();
        return zzYG.zzYN3(n, this.zzOx(), this.zzVQe(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzWNG(String string) {
        return zzYG.zzj0(string, this.zzOx(), this.zzVQe(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzBo(int n, boolean bl) {
        return zzYG.zzj0(n, bl, this.zzOx(), this.zzVQe(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzYyF(int n) {
        return zzYG.zzj0(n, this.zzOx(), this.zzVQe(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzGA(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzWJG, new zzWoM(), this.zzOx());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzZi2(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzXKE() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzYR0(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzMr(String string) {
        if (this.zzWuZ(string)) {
            zzW3l zzW3l2 = new zzW3l(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzVRw zzVRw2 : zzW3l2.zzZCD(this.getParagraphFormat().getBidi())) {
                zzGI zzGI2 = zzGI.zzYuZ(zzVRw2.zzXH());
                zzVQc zzVQc2 = this.zzOx();
                zzVQc2.zzWwk(265, zzGI2);
                if (zzVRw2.zzYyC()) {
                    zzVQc2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzWJG, zzVRw2.getText(), zzVQc2);
                this.insertNode(run);
            }
            return;
        }
        this.zzWva(string);
    }

    private boolean zzWuZ(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzXTu.zzcd(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzYN3(zzVQc zzVQc2, boolean bl) {
        zzVQc zzVQc3;
        if (bl) {
            zzVQc zzVQc4 = zzVQc2;
            zzVQc3 = (zzVQc)zzVQc4.zzYEK();
        } else {
            zzVQc3 = zzVQc2;
        }
        this.zzXwd = zzVQc3;
    }

    final void zzWSq() {
        this.zzXwd.clear();
    }

    final void zzlg() {
        if (this.zzYH5() != null) {
            zzXpD zzXpD2;
            zzXpD zzXpD3 = zzXpD2 = this.zzYH5().zzVs();
            this.zzWwJ = (zzXpD)zzXpD3.zzYEK();
            zzXpD2.zzj0(this.zzWwJ);
        }
    }

    private Shape zzYN3(String string, boolean bl, boolean bl2, zzZe9 zzZe92, zzQq zzQq2) throws Exception {
        if (zzQq2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzYN3(zzZe92, bl2, zzQq2, string);
        zzZP1 zzZP12 = zzZn1.zzYN3(string, bl, bl2, zzQq2);
        return DocumentBuilder.zzYN3(string, bl, shape, zzQq2.zzXpe, zzZP12);
    }

    private Shape zzYN3(String string, boolean bl, String string2, String string3, zzQq zzQq2) throws Exception {
        if (zzQq2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzZVq.zzWts(string);
        }
        Shape shape = string2 != null ? this.zzYsC(string2, string3) : this.zzYN3(null, string3, zzQq2);
        zzZP1 zzZP12 = zzZn1.zzYN3(string, bl, true, zzQq2);
        return DocumentBuilder.zzYN3(string, bl, shape, zzQq2.zzXpe, zzZP12);
    }

    private static Shape zzYN3(String string, boolean bl, Shape shape, String string2, zzZP1 zzZP12) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzXI4(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzj0(zzZP12);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzYN3(zzZe9 zzZe92, boolean bl, zzQq zzQq2, String string) throws Exception {
        if (zzQq2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzZe92 != null) {
            return this.zzBk(zzZe92);
        }
        if (!bl) {
            return this.zzYcu(zzZn1.zzZcA().get("normal"));
        }
        String string2 = string != null ? zzZVq.zzWts(string) : zzZn1.zzoR(zzQq2.zzXBl);
        return this.zzYN3(zzQq2, string2);
    }

    private Shape zzYN3(String string, String string2, zzQq zzQq2) throws Exception {
        if (zzQq2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzZn1.zzoR(zzQq2.zzXBl);
        }
        if (string != null) {
            return this.zzYsC(string, string2);
        }
        return this.zzYN3(zzQq2, string2);
    }

    private Shape zzYN3(zzQq zzQq2, String string) throws Exception {
        if (zzQq2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzZn1.zzZBi(zzQq2.zzXBl);
        zzWnx zzWnx2 = new zzWnx(byArray, null, string, this.getDocument().zzL());
        return this.zzYcu(zzWnx2.zzWnl());
    }

    private Shape zzYsC(String string, String string2) throws Exception {
        zzWnx zzWnx2 = new zzWnx(string, string2, this.getDocument().zzL());
        return this.zzYcu(zzWnx2.zzWnl());
    }

    private Shape zzBk(zzZe9 zzZe92) throws Exception {
        byte[] byArray = zzBk.zzYyq(zzZe92);
        return this.zzYcu(byArray);
    }

    private Shape zzYcu(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzWJG, 1);
        shape.zzXI4(75);
        shape.zzYN3(this.zzOx());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzmC(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzYN3(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzj0(compositeNode, n);
            return;
        }
        this.zzZAU(compositeNode, n);
    }

    private void zzj0(CompositeNode compositeNode, int n) {
        com.aspose.words.zzM9 zzM92 = com.aspose.words.zzM9.zzZCk(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzM92.zzYN3(null, true, true, true, false, true);
            node = zzM92.getNode();
            if (zzM92.zzYAE() && (!node.isComposite() || node.zzYo8() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzZ3G().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzj0(null, node);
            this.zzYFT = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzZAU(CompositeNode compositeNode, int n) {
        com.aspose.words.zzM9 zzM92 = com.aspose.words.zzM9.zzZMb(compositeNode);
        while (zzM92.getNode() != compositeNode || !zzM92.zzYAE()) {
            int n2;
            Node node = zzM92.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZ3G().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzj0(null, node);
                this.zzYFT = n;
                return;
            }
            while (zzM92.zzYN3(null, false, true, true, false, true) && zzM92.zzYAE() && zzM92.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzY8N() {
        int n = this.zzYFT;
        if (n == 0) {
            return;
        }
        this.zzYFT = 0;
        Run run = zzBk.zzYN3((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zz2s(n);
        }
    }

    private Run zzWva(String string) {
        Run run = new Run(this.zzWJG, string, this.zzOx());
        this.insertNode(run);
        return run;
    }

    final boolean zzYsT() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZCe() {
        return this.zzZoH;
    }

    final void zzYbm(int n) {
        this.zzZoH = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzVQe();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzVQe();
        }
        return (Paragraph)this.zzVQe().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzyv zzXKE() {
        zzM9<zzyv> zzM92 = this.zzXTZ;
        if (zzM92.size() > 0) {
            return (zzyv)this.zzXTZ.peek();
        }
        return null;
    }

    private Cell zzYH5() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzVVa();
    }

    private zzM9<zzVQc> zzW9y() {
        if (this.zzWNw == null) {
            this.zzWNw = new zzM9();
        }
        return this.zzWNw;
    }

    private zzM9<zzVYi> zzYag() {
        if (this.zzbL == null) {
            this.zzbL = new zzM9();
        }
        return this.zzbL;
    }

    private zzM9<zzYN3> zzXEQ() {
        if (this.zzrg == null) {
            this.zzrg = new zzM9();
        }
        return this.zzrg;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXwd.zzZsc(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzXfo(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzXfo(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXwd.zzWwk(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWbG()) {
            this.getCurrentParagraph().zzXbf().zzWwk(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXwd.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXwd.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWbG()) {
            this.getCurrentParagraph().zzXbf().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWJO().zzZsc(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWJO().zzYVd(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWJO().zzXr8(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWJO().zzWwk(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWJO().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWJO().clear();
        zzZuX.zzW1y().zzj0(this.zzWJO());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzVs().zzZsc(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzVs().zzYVd(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzVs().zzXr8(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzBk.zzYN3(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzYH5() != null ? this.zzYH5().getCellFormat() : this.getCellFormat();
            border.zzYN3(cellFormat);
        }
        this.zzVs().zzWwk(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzVs().clear();
    }

    private Node zzVQe() {
        Node node = this.zzWXY != null && this.zzWXY.getParentNode() == null ? this.zzXJj : this.zzWXY;
        if (node != null && node.zzYo8() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzWro(Node node) {
        this.zzWXY = node;
        if (this.zzWXY != null) {
            this.zzXJj = this.zzWXY.getParentNode();
        }
    }

    private zzZuX zzWJO() {
        if (this.zzXKE() != null && this.zzXKE().zzSN() == 1) {
            return this.zzYnN;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWJO();
        }
        return this.zzYnN;
    }

    private zzXpD zzVs() {
        if (this.zzXKE() != null && this.zzXKE().zzSN() != 3) {
            return this.zzWwJ;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzVVa().zzVs();
        }
        return this.zzWwJ;
    }

    static final class zzYN3 {
        private zzVQc zzXwd;
        private zzVQc zzX2S;

        public zzYN3(zzVQc zzVQc2, zzVQc zzVQc3) {
            this.zzXwd = zzVQc2;
            this.zzX2S = zzVQc3;
        }

        public final zzVQc zzYue() {
            return this.zzXwd;
        }

        public final zzVQc zzZSc() {
            return this.zzX2S;
        }
    }
}

