/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzBk;
import com.aspose.words.internal.zzVPv;
import com.aspose.words.internal.zzYsh;
import com.aspose.words.internal.zzZGT;
import com.aspose.words.internal.zzZe9;
import com.aspose.words.internal.zzk2;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZok;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzVSK = new HashMap();
    private static HashMap<Integer, Integer> zzZIp = new HashMap();
    private static HashMap<Integer, Integer> zzYD = new HashMap();
    private static HashMap<Integer, Integer> zzW8j = new HashMap();
    private static HashMap<Integer, Integer> zzDU = new HashMap();
    private static HashMap<Integer, Integer> zzWKc = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzBk.zzYN3(fileName, "fileName");
        try (zzVPv zzVPv2 = zzBk.zzXoD(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzWTX(zzVPv2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzWTX(zzZGT.zzYN3(stream));
    }

    static FileFormatInfo zzWTX(zzZe9 zzZe92) throws Exception {
        if (zzZe92 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzZok zzZok2 = new zzZok();
            zzZe9 zzZe93 = zzZe92;
            zzZok zzZok3 = zzZok2;
            return zzZok2.zzj0(zzZe93, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzj0(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzYXR(zzk2.zzWDh(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzYct(zzk2.zzWDh(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzYsh.zzYSx(string = zzk2.zzZi2(FileFormatUtil.zzYUz(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzYXR(FileFormatUtil.zzWzX(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzYct(FileFormatUtil.zzYUz(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzk2.zzZi2(FileFormatUtil.zzWzX(saveFormat));
        if (zzYsh.zzYSx(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzYct(zzk2.zzZ7p(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzk2.zzZi2(FileFormatUtil.zzYJo(imageType));
    }

    static Exception zzj0(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzWM7(int n) {
        return zzk2.toString(FileFormatUtil.zzWzX(n));
    }

    static int zzYct(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzBk.zzYN3(zzDU, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzGg(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzBk.zzYN3(zzWKc, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zz4q(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYUz(int n) {
        return zzBk.zzYN3(zzVSK, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzWzX(int n) {
        return zzBk.zzYN3(zzZIp, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYJo(int n) {
        return zzBk.zzYN3(zzYD, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYXR(int n) {
        return zzBk.zzYN3(zzW8j, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzWwk(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzBk.zzj0(zzDU, Integer.valueOf(n), Integer.valueOf(n2));
            zzBk.zzj0(zzZIp, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzW8j.containsKey(n)) {
                zzBk.zzj0(zzW8j, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzBk.zzj0(zzVSK, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzBk.zzj0(zzWKc, Integer.valueOf(n), Integer.valueOf(n4));
            zzBk.zzj0(zzYD, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzWwk(11, 10, 10, 1);
        FileFormatUtil.zzWwk(11, 0, 0, 1);
        FileFormatUtil.zzWwk(12, 11, 11, 1);
        FileFormatUtil.zzWwk(13, 20, 20, 1);
        FileFormatUtil.zzWwk(13, 0, 254, 1);
        FileFormatUtil.zzWwk(14, 21, 21, 1);
        FileFormatUtil.zzWwk(15, 22, 22, 1);
        FileFormatUtil.zzWwk(16, 23, 23, 1);
        FileFormatUtil.zzWwk(18, 24, 24, 1);
        FileFormatUtil.zzWwk(19, 25, 25, 1);
        FileFormatUtil.zzWwk(20, 26, 26, 1);
        FileFormatUtil.zzWwk(21, 27, 27, 1);
        FileFormatUtil.zzWwk(24, 30, 30, 1);
        FileFormatUtil.zzWwk(17, 31, 31, 1);
        FileFormatUtil.zzWwk(25, 50, 50, 1);
        FileFormatUtil.zzWwk(26, 45, 255, 1);
        FileFormatUtil.zzWwk(27, 51, 51, 1);
        FileFormatUtil.zzWwk(28, 0, 52, 1);
        FileFormatUtil.zzWwk(29, 0, 53, 1);
        FileFormatUtil.zzWwk(22, 60, 60, 1);
        FileFormatUtil.zzWwk(23, 61, 61, 1);
        FileFormatUtil.zzWwk(33, 40, 64, 1);
        FileFormatUtil.zzWwk(40, 47, 255, 1);
        FileFormatUtil.zzWwk(41, 48, 255, 1);
        FileFormatUtil.zzWwk(34, 41, 255, 1);
        FileFormatUtil.zzWwk(35, 46, 255, 1);
        FileFormatUtil.zzWwk(37, 42, 255, 1);
        FileFormatUtil.zzWwk(36, 44, 255, 1);
        FileFormatUtil.zzWwk(30, 52, 255, 1);
        FileFormatUtil.zzWwk(31, 70, 62, 1);
        FileFormatUtil.zzWwk(32, 73, 63, 1);
        FileFormatUtil.zzWwk(38, 71, 255, 1);
        FileFormatUtil.zzWwk(8, 100, 255, 1);
        FileFormatUtil.zzWwk(9, 105, 255, 1);
        FileFormatUtil.zzWwk(6, 101, 255, 6);
        FileFormatUtil.zzWwk(7, 102, 255, 7);
        FileFormatUtil.zzWwk(5, 104, 255, 5);
        FileFormatUtil.zzWwk(4, 0, 255, 4);
        FileFormatUtil.zzWwk(3, 0, 255, 3);
        FileFormatUtil.zzWwk(39, 72, 255, 1);
        FileFormatUtil.zzWwk(2, 103, 255, 2);
    }
}

