/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzBk;
import com.aspose.words.zzY6Y;
import com.aspose.words.zzYG;
import com.aspose.words.zzZ4Z;

public class ListFormat {
    private zzZ4Z zzXdc;
    private zzY6Y zzXqr;
    private ListCollection zzYYW;
    private ListLevel zzVUz;
    private ListLevel zzYUu;

    ListFormat(zzZ4Z parentParaAttrs, zzY6Y parentRunAttrs, ListCollection lists) {
        this.zzXdc = parentParaAttrs;
        this.zzXqr = parentRunAttrs;
        this.zzYYW = lists;
    }

    public void applyBulletDefault() {
        if (this.zzYYW.getCount() > 2046) {
            zzYG.zzj0(this.zzYYW.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzXvh(listFormat.zzYYW.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzVUz = null;
    }

    public void applyNumberDefault() {
        if (this.zzYYW.getCount() > 2046) {
            zzYG.zzj0(this.zzYYW.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzXvh(listFormat.zzYYW.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzVUz = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzVUz = null;
    }

    public void listIndent() throws Exception {
        if (this.zzVYK() < 8) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzVYK() + 1);
            ListFormat listFormat2 = this;
            this.zzVUz = null;
        }
    }

    public void listOutdent() throws Exception {
        if (this.zzVYK() > 0) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzVYK() - 1);
            ListFormat listFormat2 = this;
            this.zzVUz = null;
        }
    }

    public int getListLevelNumber() {
        Document document = zzBk.zzYN3((Object)this.zzYYW.getDocument(), Document.class);
        if (document != null && document.getRevisionsView() == 1) {
            return this.zzZLX();
        }
        return this.zzVYK();
    }

    public void setListLevelNumber(int value) {
        this.zzXdc.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzVUz = null;
    }

    final int zzVYK() {
        return (Integer)this.zzXdc.fetchParaAttr(1110);
    }

    final int zzZLX() {
        Paragraph paragraph = zzBk.zzYN3((Object)this.zzXdc, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzXZf(1110, 1);
        }
        return this.zzVYK();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzYYW.zzX4t(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzXvh(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzYYW.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzXvh(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzVUz = null;
    }

    final List zzXns() {
        int n = this.zzYyU();
        if (n != 0) {
            return this.zzYYW.zzX4t(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            Document document = zzBk.zzYN3((Object)this.zzYYW.getDocument(), Document.class);
            if (document != null && document.getRevisionsView() == 1) {
                return this.zzZnO();
            }
            return this.zzXAJ();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ListLevel zzXAJ() {
        try {
            if (this.zzVUz == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zzXhP(this.zzVYK()) : null;
                this.zzVUz = listLevel != null ? new ListLevel(listLevel, this.zzXqr) : null;
            }
            return this.zzVUz;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzZnO() {
        if (this.zzYUu == null) {
            List list = this.zzXns();
            ListLevel listLevel = list != null ? list.zzXhP(this.zzZLX()) : null;
            this.zzYUu = listLevel != null ? new ListLevel(listLevel, this.zzXqr) : null;
        }
        return this.zzYUu;
    }

    final int getListId() {
        return (Integer)this.zzXdc.fetchParaAttr(1120);
    }

    private void zzXvh(int n) {
        Object object = this.zzXdc.getDirectParaAttr(1160);
        int n2 = object != null ? (Integer)object : 0;
        int n3 = 0;
        if (n2 != 0 && n != 0 && this.getListLevel() != null && n2 < (n3 = this.getListLevel().zzWMC().zzYxV() + this.getListLevel().zzWMC().zzWWG())) {
            n3 = 0;
        }
        this.zzXdc.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzVUz = null;
        if (n == 0 || object == null || this.getListLevel() == null) {
            return;
        }
        if (n2 == 0) {
            this.zzXdc.removeParaAttr(1160);
            return;
        }
        int n4 = n2 - n3 + this.getListLevel().zzWMC().zzYxV() + this.getListLevel().zzWMC().zzWWG();
        this.zzXdc.setParaAttr(1160, n4);
    }

    private int zzYyU() {
        Paragraph paragraph = zzBk.zzYN3((Object)this.zzXdc, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzXZf(1120, 1);
        }
        return this.getListId();
    }
}

