/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzBk;
import com.aspose.words.internal.zzYYA;
import com.aspose.words.zzM9;
import com.aspose.words.zzWhT;
import com.aspose.words.zzYG;
import com.aspose.words.zzYPL;

public abstract class Node
implements Cloneable {
    private Node zzWMF;
    private Node zzVRP;
    private Node zzXDm;
    private int zzXu1;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzj0(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzWMF == null) {
            return null;
        }
        if (this.zzWMF.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzWMF;
    }

    final CompositeNode zzZah() {
        if (zzYG.zzYjd(this.getParentNode())) {
            return this.getParentNode().zzZah();
        }
        return this.getParentNode();
    }

    final CompositeNode zzYQh() {
        if (zzYG.zzYjd(this.getParentNode()) || zzYG.zzYQb(this.getParentNode())) {
            return this.getParentNode().zzYQh();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzWMF != null) {
            return this.zzWMF.getDocument();
        }
        return null;
    }

    final Document zzXUu() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzqA() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzvv();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzXDm;
    }

    final Node zzZZI() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzYG.zzZ1I((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzY3j() {
        Node node = zzYG.zzYyq(this.getPreviousSibling(), false);
        if (node == null && zzYG.zzYjd(this.getParentNode())) {
            node = this.getParentNode().zzY3j();
        }
        return node;
    }

    final Node zzWmT() {
        Node node = zzYG.zzZZx(this.getNextSibling(), false);
        if (node == null && zzYG.zzYjd(this.getParentNode())) {
            node = this.getParentNode().zzWmT();
        }
        return node;
    }

    final CompositeNode zzXaJ() {
        Node node = this;
        while ((node = node.zzY3j()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZkz() {
        Node node = this;
        while ((node = node.zzWmT()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzVRP;
    }

    final Node zzO7() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzYG.zzZ1I((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZQL() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzFl() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZbs() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzYG.zzZjY(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZq9() {
        return this.zzVRP;
    }

    final void zzYMT(Node node) {
        this.zzVRP = node;
    }

    final Node zzZyK() {
        return this.zzXDm;
    }

    final void zzZ6w(Node node) {
        this.zzXDm = node;
    }

    final Node zzZOI() {
        Node node = this;
        if (node.zzVRP != null) {
            node = this;
            return node.zzVRP;
        }
        return this.getParentNode();
    }

    final int zzYo8() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzYG.zzX38(this);
        boolean bl2 = zzYG.zzWHG(this);
        boolean bl3 = zzYG.zzZTP(this);
        boolean bl4 = zzYG.zzWUJ(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzYo8() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzYo8() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzYN3(isCloneChildren, null);
    }

    Node zzYN3(boolean bl, zzWhT zzWhT2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzWMF != null) {
            node.zzWMF = this.getDocument().zz4y();
        }
        node.zzVRP = null;
        node.zzXDm = null;
        if (zzWhT2 != null) {
            zzWhT2.zzRX(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzXoD(StringBuilder stringBuilder) {
        zzBk.zzj0(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzVWQ(Node node) {
        this.zzWMF = node != null ? node : this.getDocument().zz4y();
    }

    final void zzj0(DocumentBase documentBase) {
        this.zzWMF = documentBase != null ? documentBase.zz4y() : null;
    }

    final boolean zzXh9(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzZkS() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzYAB(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYEV(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzW3B(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzZQ5(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzYPL zzYPL2 = zzYG.zztH(saveFormat);
        return zzYPL2.zzWtL(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzYPL zzYPL2 = zzYG.zzYN3(saveOptions);
        return zzYPL2.zzWtL(this);
    }

    final Node zzb(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzYG.zzWqc(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzM9 zzZZT() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzM9.zzZMb(node);
        }
        return zzM9.zzZCk(this.getParentNode());
    }

    final zzM9 zzbi() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzM9.zzZCk(node);
        }
        return zzM9.zzZMb(this.getParentNode());
    }

    final boolean zzYfg(Node node) {
        return Node.zzWzC(this, node);
    }

    final boolean zzYDf() {
        return this.getAncestor(1) == null;
    }

    static Node zzWfx(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        com.aspose.words.internal.zzM9<Node> zzM92 = Node.zzWK1(node);
        com.aspose.words.internal.zzM9<Node> zzM93 = Node.zzWK1(node2);
        return Node.zzYN3(zzM92, zzM93);
    }

    static boolean zzWzC(Node node, Node node2) {
        com.aspose.words.internal.zzM9<Node> zzM92;
        if (node == null || node2 == null) {
            return false;
        }
        com.aspose.words.internal.zzM9<Node> zzM93 = Node.zzWK1(node);
        Node node3 = Node.zzYN3(zzM93, zzM92 = Node.zzWK1(node2));
        if (node3 == null) {
            return false;
        }
        com.aspose.words.internal.zzM9<Node> zzM94 = zzM93;
        if (zzM94.size() == 0 || (zzM94 = zzM92).size() == 0) {
            zzM94 = zzM92;
            boolean bl = zzM94.size() > 0;
            return bl;
        }
        Object e = zzM93.peek();
        Object e2 = zzM92.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static com.aspose.words.internal.zzM9<Node> zzWK1(Node node) {
        com.aspose.words.internal.zzM9<Node> zzM92 = new com.aspose.words.internal.zzM9<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzM92.push(node2);
        }
        return zzM92;
    }

    private static Node zzYN3(com.aspose.words.internal.zzM9<Node> zzM92, com.aspose.words.internal.zzM9<Node> zzM93) {
        Node node = null;
        while (zzM92.peek() == zzM93.peek()) {
            node = (Node)zzM92.pop();
            zzM93.pop();
            com.aspose.words.internal.zzM9<Node> zzM94 = zzM92;
            if (zzM94.size() != 0 && (zzM94 = zzM93).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzXu1;
    }

    public void setCustomNodeId(int value) {
        this.zzXu1 = value;
    }

    private String zzZxl() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzBk.zzYN3(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzYYA.zzZN7(stringBuilder.toString());
    }

    public String toString() {
        return zzYYA.zzZN7(zzYYA.zzj0("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzZxl()));
    }

    public void dd() {
    }

    final Node zzZyS(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzcd(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYCW(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzcd(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzcd(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

