/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzBk;
import com.aspose.words.zzFT;
import com.aspose.words.zzTS;
import com.aspose.words.zzZBE;
import com.aspose.words.zzZl8;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZl8,
Iterable<T> {
    private Node zzYI5;
    private CompositeNode zzXkC;
    private DocumentBase zzZuR;
    private boolean zzZZo;
    private int zzWVi;
    private int zzY9T;
    private Node zzko;
    private int zzYE1;
    private zzTS zzYmX;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzZBE(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZBE(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzTS matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzXkC = container;
        this.zzZuR = container.getDocument();
        this.zzYmX = matcher;
        this.zzZZo = isDeep;
        this.zzXRb();
    }

    public Node get(int index) {
        try {
            this.zzW3V();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzY9T == index) {
                return this.zzko;
            }
            int n = index - this.zzY9T;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzXeS(nodeCollection.zzko, n);
            if (node != null) {
                this.zzY9T = index;
                this.zzko = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZZo) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzXkC.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZZo) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzXkC.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzWae();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzFT(this);
    }

    final <TNode extends Node> zzFT<TNode> zzWJD() {
        return new zzFT(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzWae() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzBk.zzYN3(arrayList, node);
        }
        return arrayList;
    }

    private Node zzXeS(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzX5G(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzYrV(curNode, true);
    }

    private Node zzYrV(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzYI5 = node;
        do {
            node2 = this.zzYI5;
            Node node3 = this.zzZZo ? this.zzYN3(true, this.zzYI5) : (this.zzYI5 = this.zzYmX.zzWXu() ? this.zzZAU(true, this.zzYI5) : this.zzj0(true, this.zzYI5));
        } while (this.zzYI5 != null && !this.zzYmX.zzW3B(this.zzYI5));
        return node2;
    }

    private Node zzX5G(Node node, boolean bl) throws Exception {
        while ((this.zzZZo ? this.zzYN3(bl, node) : (node = this.zzYmX.zzWXu() ? this.zzZAU(bl, node) : this.zzj0(bl, node))) != null && !this.zzYmX.zzW3B(node)) {
        }
        return node;
    }

    private Node zzYN3(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzXkC);
        }
        return node.previousPreOrder(this.zzXkC);
    }

    private Node zzj0(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzXkC) {
                return this.zzXkC.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzXkC) {
            return this.zzXkC.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzZAU(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzXkC ? this.zzXkC.zzpk() : node.zzWmT();
        } else {
            Node node3 = node2 = node == this.zzXkC ? this.zzXkC.zzYi9() : node.zzY3j();
        }
        if (node2 == this.zzXkC.getNextSibling() || node2 == this.zzXkC.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzW3V() {
        if (this.zzWVi != this.zzW24()) {
            this.zzXRb();
        }
    }

    private void zzXRb() {
        this.zzWVi = this.zzW24();
        this.zzY9T = -1;
        this.zzko = this.zzXkC;
        this.zzYE1 = -1;
    }

    private int zzW24() {
        if (this.zzZuR != null) {
            return this.zzZuR.zzW0t();
        }
        return 0;
    }

    public int getCount() {
        this.zzW3V();
        if (this.zzYE1 == -1) {
            this.zzYE1 = zzFT.zzYN3(this);
        }
        return this.zzYE1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYI5;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzXkC;
    }
}

