/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzZVq;
import com.aspose.words.internal.zzk2;

public abstract class SaveOptions {
    private boolean zzZjF;
    private boolean zzYnU = true;
    private boolean zzJI = false;
    private boolean zzYAw = true;
    private boolean zzZsH;
    private String zzFl;
    private boolean zzYtY;
    private boolean zzZMI = false;
    private boolean zzX4h = true;
    private int zzY4C = 1;
    private int zzIT = 0;
    private String zzSM = "";
    private boolean zzWF3 = true;
    private boolean zzXN = true;
    private boolean zz9l;
    private boolean zzVSd;
    private int zzX63 = 0;
    private boolean zzWlC = true;
    private boolean zzWZ9 = false;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZy4() {
        return false;
    }

    boolean zzVOU() {
        return true;
    }

    final boolean zzWvW() {
        return this.zzYAw;
    }

    public String getTempFolder() {
        return this.zzFl;
    }

    public void setTempFolder(String value) {
        this.zzFl = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZsH;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZsH = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYtY;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYtY = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzZMI;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzZMI = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzX4h;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzX4h = value;
    }

    public int getDmlRenderingMode() {
        return this.zzY4C;
    }

    public void setDmlRenderingMode(int value) {
        this.zzY4C = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzIT;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzIT = value;
    }

    public String getDefaultTemplate() {
        return this.zzSM;
    }

    public void setDefaultTemplate(String value) {
        this.zzSM = value;
    }

    public boolean getUpdateFields() {
        return this.zzWF3;
    }

    public void setUpdateFields(boolean value) {
        this.zzWF3 = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zz9l;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zz9l = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzVSd;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzVSd = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzWZ9;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzWZ9 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzJI;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzJI = value;
    }

    final boolean zzZ8n() {
        return this.zzXN;
    }

    final boolean zzXTK() {
        return this.zzWlC;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzYct(zzk2.zzZ7p(zzZVq.zzYKX(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzX63;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzX63 = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZjF;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZjF = value;
    }

    final boolean zzO() {
        return this.zzYnU;
    }
}

