/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzBk;
import com.aspose.words.zzVTu;
import com.aspose.words.zzWhT;
import com.aspose.words.zzYDP;

public final class Section
extends CompositeNode<Node>
implements zzYDP {
    private zzVTu zzzt;
    private PageSetup zzXa0;
    private HeaderFooterCollection zzZUU;

    public Section(DocumentBase doc) {
        this(doc, new zzVTu());
    }

    Section(DocumentBase doc, zzVTu sectPr) {
        super(doc);
        this.zzzt = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzZUU == null) {
            this.zzZUU = new HeaderFooterCollection(this);
        }
        return this.zzZUU;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXa0 == null) {
            Section section = this;
            this.zzXa0 = new PageSetup(section, section.getDocument().zzYKV(), this.getDocument().getStyles(), new zzYN3(this));
        }
        return this.zzXa0;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZMF();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYcB(!value);
    }

    final zzVTu zzVS1() {
        return this.zzzt;
    }

    final void zzj0(zzVTu zzVTu2) {
        this.zzzt = zzVTu2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzYN3(boolean bl, zzWhT zzWhT2) {
        zzVTu zzVTu2;
        Section section = (Section)super.zzYN3(bl, zzWhT2);
        zzVTu zzVTu3 = this.zzzt;
        section.zzzt = zzVTu2 = (zzVTu)zzVTu3.zzYEK();
        section.zzXa0 = null;
        section.zzZUU = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYN3(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzj0(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzRX(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzRX(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzgk(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzYyq(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzgk(n) == null;
            }
        }
        return false;
    }

    final void zzZAU(Shape shape, boolean bl) {
        this.zzYN3(shape, 4, bl);
        this.zzYN3(shape, 0, bl);
        this.zzYN3(shape, 1, bl);
    }

    private void zzYN3(Shape shape, int n, boolean bl) {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzWsO() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZd2()) {
                if (!shape.zzZQ()) continue;
                shape.remove();
            }
        }
    }

    private void zzRX(Section section, boolean bl) {
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        Paragraph paragraph = bl ? body2.getLastParagraph() : null;
        body2.zzj0(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzzt.zzZsc(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzYKV().zz3J.zzYVd(key);
        }
        return zzVTu.zzZ2t(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzzt.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzYKV().zz3J.zzWwk(key, value);
            return;
        }
        this.zzzt.zzWwk(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzzt.clear();
    }

    final boolean zzZxO() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZCv() {
        return this.getParentNode().getLastChild() == this;
    }

    static final class zzYN3
    implements zzYDP {
        private Section zzZfZ;

        zzYN3(Section section) {
            this.zzZfZ = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzWL4().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzWL4().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzWL4().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzYDP zzWL4() {
            Document document = zzBk.zzYN3((Object)this.zzZfZ.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzZfZ;
        }
    }
}

