/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz8t;
import com.aspose.words.internal.zzBk;
import com.aspose.words.internal.zzW3l;
import com.aspose.words.internal.zzWnw;
import com.aspose.words.internal.zzYRm;
import com.aspose.words.internal.zzYYA;
import com.aspose.words.internal.zzYsh;
import com.aspose.words.zzVVj;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzWJG;
    private zzVVj zzZsj;

    Watermark(Document doc, zzVVj watermarkProvider) {
        this.zzWJG = doc;
        this.zzZsj = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzZsF(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzYN3(text, textWatermarkOptions, this.zzWJG);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzBk.zzj0((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzWJG, 75);
        shape.getImageData().setImage(image);
        this.zzYN3(shape, options, this.zzWJG);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzBk.zzj0((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzWJG, 75);
        shape.getImageData().setImage(imagePath);
        this.zzYN3(shape, options, this.zzWJG);
    }

    public final int getType() {
        Shape shape = this.zzZsj.get();
        if (shape == null) {
            return 2;
        }
        shape.zzZQ();
        if (shape.zzWlr()) {
            return 0;
        }
        if (shape.zzVYc()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzZsj.add(shape);
    }

    public final void remove() {
        this.zzZsj.remove();
    }

    private static void zzZsF(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzYsh.zzZWC(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzBk.zzYN3(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzYN3(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzj0(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzWUu(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzj0(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzJt() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zz7J()) / d2) > (double)(f = pageSetup.zzWCU())) {
            d = (double)f / d3;
        }
        shape.zzWot(zzWnw.zzYN3(d2 * d, 2, zzYRm.zzWBK));
        shape.zzZ7C(zzWnw.zzYN3(d3 * d, 2, zzYRm.zzWBK));
    }

    private Shape zzYN3(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzYN3(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzWUu(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzYN3(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzWgf() ? 1.0f : textWatermarkOptions.getFontSize();
        zz8t zz8t2 = document.zzL().zzZAU(shape.getTextPath().getFontFamily(), f, 0);
        long l = zz8t2.zzBo(shape.getTextPath().getText());
        if (textWatermarkOptions.zzWgf()) {
            l = Watermark.zzYN3(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzWot(zzWnw.zzYN3(Float.intBitsToFloat(n), 2, zzYRm.zzWBK));
        shape.zzZ7C(zzWnw.zzYN3(zzW3l.zzWtw(l), 2, zzYRm.zzWBK));
    }

    private static long zzYN3(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zz7J();
        float f2 = pageSetup.zzWCU();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzW3l.zzWtw(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzW3l.zzYrV(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzW3l.zzWtw(l) >= Float.intBitsToFloat(n)) {
            return zzW3l.zzYrV(f2 / f3, f2);
        }
        float f6 = f;
        return zzW3l.zzYrV(f6, f6 * f3);
    }

    private static void zzWUu(Shape shape, String string) {
        shape.setName(zzYYA.zzj0("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

