/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzIl;
import com.aspose.words.internal.zzKP;
import com.aspose.words.internal.zzXOE;
import com.aspose.words.internal.zzXoC;
import com.aspose.words.internal.zzYP5;
import com.aspose.words.internal.zzYZS;
import com.aspose.words.internal.zzZee;
import com.aspose.words.internal.zzZgH;
import com.aspose.words.internal.zzwf;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzX8b
extends CertPathBuilderSpi {
    private final zzZgH zzsx;
    private zzwf zzYgo;

    zzX8b(zzZgH zzZgH2) {
        this.zzsx = zzZgH2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzYZS pkixParams;
        if (params instanceof zzYZS) {
            pkixParams = (zzYZS)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzYZS.zzYN3((PKIXBuilderParameters)params).zzZqd();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzYZS.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzIl zzIl2 = pkixParams.zzZn9().zzYJ();
        try {
            collection = zzZee.zzYN3(zzIl2, pkixParams.zzZn9().zzX7O());
            collection.addAll(zzZee.zzYN3(zzIl2, pkixParams.zzZn9().zzVZW()));
        }
        catch (zzwf zzwf2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzwf2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzYN3(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzYgo != null) {
            throw new CertPathBuilderException(this.zzYgo.getMessage(), this.zzYgo.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzYN3(X509Certificate x509Certificate, zzYZS zzYZS2, List list) throws CertPathBuilderException {
        zzYP5 zzYP52;
        zzKP zzKP2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzYZS2.zzm2().contains(x509Certificate)) {
            return null;
        }
        if (zzYZS2.zzZsd() != -1 && list.size() - 1 > zzYZS2.zzZsd()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzKP2 = new zzKP(this.zzsx);
            zzYP52 = new zzYP5(this.zzsx);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZee.zzYN3(x509Certificate, zzYZS2.zzZn9().zzZgK(), zzYZS2.zzZn9().zzZro()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzKP2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzwf("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzYP52.engineValidate(certPath, zzYZS2);
                }
                catch (Exception exception) {
                    throw new zzwf("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzXOE> arrayList = new ArrayList<zzXOE>();
            arrayList.addAll(zzYZS2.zzZn9().zzX7O());
            try {
                arrayList.addAll(zzZee.zzYN3(x509Certificate.getExtensionValue(zzXoC.zzYkt.getId()), zzYZS2.zzZn9().zzWUr()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzwf("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZee.zzYN3(x509Certificate, zzYZS2.zzZn9().zzVZW(), arrayList));
            }
            catch (zzwf zzwf2) {
                throw new zzwf("Cannot find issuer certificate for certificate in certification path.", zzwf2);
            }
            if (hashSet.isEmpty()) {
                throw new zzwf("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzYN3(x509Certificate2, zzYZS2, list);
            }
        }
        catch (zzwf zzwf3) {
            this.zzYgo = zzwf3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

