/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYYA;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzWFo = new ArrayList();
    private final Map<String, DataColumn> zzZy5 = new HashMap<String, DataColumn>();
    private DataTable zzZ2W;

    DataColumnCollection(DataTable table) {
        this.zzZ2W = table;
    }

    public void add(DataColumn column) {
        if (zzYYA.zzXFf(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzxI(column.getColumnName());
        if (this.zzZy5.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzj0(this.zzZ2W);
        column.setOrdinal(this.zzWFo.size());
        this.zzWFo.add(column);
        this.zzZy5.put(string, column);
        this.zzZ2W.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZ2W);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzYYA.zzXFf(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzxI(columnName);
        DataColumn dataColumn = this.zzZy5.get(string);
        if (dataColumn != null) {
            int n = this.zzWFo.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzWFo.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzWFo.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzWFo.remove(n);
            this.zzZy5.remove(DataColumnCollection.zzxI(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzZ2W.getRows()) {
                dataRow.remove(n);
            }
            this.zzZ2W.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzWFo.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzWFo.iterator();
    }

    public void clear() {
        this.zzZy5.clear();
        this.zzWFo.clear();
    }

    final DataColumn[] zzjL() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzWFo);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzYN3(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzWFo.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzWFo.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzxI(string);
            String string3 = DataColumnCollection.zzxI(dataColumn.getColumnName());
            this.zzZy5.remove(string3);
            this.zzZy5.put(string2, dataColumn);
            return;
        }
    }

    private static String zzxI(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

