/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWU2;
import com.aspose.words.internal.zzXBm;
import com.aspose.words.internal.zzY5X;
import com.aspose.words.internal.zzYYA;
import com.aspose.words.internal.zzZGT;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzRX;
import com.aspose.words.net.System.Data.zzj0;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzZ2W;
    private Object[] zzWsO;
    private int zzZBn = 1;
    private int zzZ8A;
    private String zzZu3;
    private Map<String, Object> zzWSz = new HashMap<String, Object>();
    private Map<String, String> zzZDs = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzZ2W = table;
        this.zzWsO = new Object[table.getColumns().getCount()];
        Arrays.fill(this.zzWsO, DBNull.Value);
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzj0.zzZAU(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzZ2W.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzZ2W.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzZ2W;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzZ2W.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzZ2W.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzZ2W.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzZ2W.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzZ2W.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzZ2W.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzZ2W) {
            throw new IllegalStateException(zzYYA.zzj0("Table {0} is not the child table in the relation {1}", this.zzZ2W.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzYN3(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzZMb(columnIndex, value);
        this.zzZ2W.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzZ2W.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzZBn;
    }

    public void setRowState(int state) {
        this.zzZBn = state;
    }

    public void delete() {
        zzRX.zzj0(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzWSz.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzWSz.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzWsO.length];
        System.arraycopy(this.zzWsO, 0, objectArray, 0, this.zzWsO.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzWsO.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzWsO.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzZMb(i, array[i]);
        }
        this.zzZ2W.onDataRowChanged(this);
    }

    final int zzIY() {
        return this.zzZ8A;
    }

    final void zzWK1(String string, String string2) {
        this.zzZDs.put(string, string2);
    }

    final void zz9n(String string, String string2) {
        this.zzZu3 = zzYYA.zzj0(string, string2);
    }

    final String zzSZ() {
        return this.zzZu3;
    }

    final void zzZ89(int n) {
        this.zzZ8A = n;
    }

    final Object[] zzXyQ() {
        return this.zzWsO;
    }

    static boolean zzYN3(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null && dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzZtl(index)) {
            return null;
        }
        return this.zzWsO[index];
    }

    private void zzZMb(int n, Object object) {
        if (!this.zzZtl(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzYN3((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzYN3((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzYN3(clazz, object)))));
        this.zzWsO[n] = object2;
    }

    private static Object zzYN3(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        if (clazz == String.class) {
            return string;
        }
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzWU2.class) {
                return zzWU2.zzYN3(string, zzY5X.zzYsG(), 128).zzVVj();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzXBm.zzZAU(exception);
        }
        return object;
    }

    private boolean zzZtl(int n) {
        this.zzZ41();
        return this.zzWsO != null && n >= 0 && n < this.zzWsO.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzZ2W.getColumns().getCount();
        if (this.zzWsO.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWsO.length - index];
        System.arraycopy(this.zzWsO, index, objectArray, 0, this.zzWsO.length - index);
        System.arraycopy(objectArray, 1, this.zzWsO, index, objectArray.length - 1);
    }

    private void zzZ41() {
        if (this.zzZ2W == null || this.zzZ2W.getColumns() == null || this.zzWsO == null) {
            return;
        }
        int n = this.zzZ2W.getColumns().getCount();
        if (this.zzWsO.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWsO.length];
        System.arraycopy(this.zzWsO, 0, objectArray, 0, this.zzWsO.length);
        this.zzWsO = new Object[n];
        int n2 = Math.min(objectArray.length, this.zzWsO.length);
        System.arraycopy(objectArray, 0, this.zzWsO, 0, n2);
        for (int i = n2; i < this.zzWsO.length; ++i) {
            this.zzWsO[i] = DBNull.Value;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] zzYN3(Blob blob) {
        InputStream inputStream;
        byte[] byArray;
        block11: {
            byArray = null;
            inputStream = null;
            if (blob != null && blob.length() != 0L) break block11;
            return null;
        }
        Object object = new ByteArrayOutputStream();
        inputStream = blob.getBinaryStream();
        zzZGT.zzYN3(inputStream, (OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            object = iOException;
            zzXBm.zzZAU(iOException);
        }
        return byArray;
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
                zzXBm.zzZAU(exception);
                if (inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzXBm.zzZAU(iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                zzXBm.zzZAU(iOException);
            }
            return byArray;
        }
    }

    private static String zzYN3(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzXBm.zzZAU(exception);
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzXBm.zzZAU(iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzWsO;
        int n = dataRow.zzWsO.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

