/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXBm;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zz7N;
import com.aspose.words.net.System.Data.zzZAU;
import com.aspose.words.net.System.Data.zzZZx;
import com.aspose.words.net.System.Data.zzj0;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzYDr;
    private final DataColumnCollection zzXVW;
    private final ConstraintCollection zzNd;
    private final zzZZx zzbz;
    private ResultSet zzYia;
    private String zzGe;
    private DataSet zzYxz;
    private String zzJb;
    private UniqueConstraint zzWCW;
    private boolean zzZ2;
    private final List<DataTableEventListener> zzH7;
    private final Set<DataRow> zzXxm;

    public DataTable() {
        this.zzYDr = new DataRowCollection(this);
        this.zzXVW = new DataColumnCollection(this);
        this.zzNd = new ConstraintCollection(this);
        this.zzbz = new zzZZx(this);
        this.zzJb = "";
        this.zzZ2 = true;
        this.zzH7 = new ArrayList<DataTableEventListener>();
        this.zzXxm = new HashSet<DataRow>();
    }

    public DataTable(String tableName) {
        this.zzYDr = new DataRowCollection(this);
        this.zzXVW = new DataColumnCollection(this);
        this.zzNd = new ConstraintCollection(this);
        this.zzbz = new zzZZx(this);
        this.zzJb = "";
        this.zzZ2 = true;
        this.zzH7 = new ArrayList<DataTableEventListener>();
        this.zzXxm = new HashSet<DataRow>();
        this.zzGe = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzj0.zzYN3(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzYDr = new DataRowCollection(this);
        this.zzXVW = new DataColumnCollection(this);
        this.zzNd = new ConstraintCollection(this);
        this.zzbz = new zzZZx(this);
        this.zzJb = "";
        this.zzZ2 = true;
        this.zzH7 = new ArrayList<DataTableEventListener>();
        this.zzXxm = new HashSet<DataRow>();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzYia = resultSet;
        this.zzGe = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzYia != null) {
            if (this.zzYia.getStatement() != null) {
                this.zzYia.getStatement().getConnection().close();
            }
            this.zzYia = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzGe;
    }

    public void setTableName(String tableName) {
        this.zzGe = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXVW.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXVW.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzYia;
    }

    public DataSet getDataSet() {
        return this.zzYxz;
    }

    final void zzRX(DataSet dataSet) {
        this.zzYxz = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYxz.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYxz.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzYDr;
    }

    public DataColumnCollection getColumns() {
        return this.zzXVW;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzNd;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzWCW == null) {
            return new DataColumn[0];
        }
        return this.zzWCW.getColumns();
    }

    final void zzZZx(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzWCW != null) {
                this.zzWCW.zzYVv(false);
                this.getConstraints().remove(this.zzWCW);
                this.zzWCW = null;
            }
            return;
        }
        if (this.zzWCW != null && DataColumn.areColumnSetsTheSame(value, this.zzWCW.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzYN3(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzWCW != null) {
            this.zzWCW.zzYVv(false);
            this.getConstraints().remove(this.zzWCW);
            this.zzWCW = null;
        }
        UniqueConstraint.zzYN3(this.getConstraints(), uniqueConstraint);
        this.zzWCW = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzJb;
    }

    public void setNamespace(String namespace) {
        this.zzJb = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZ2;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZ2 = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXxm.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzj0.zzYN3(this.getResultSet(), this);
            zzj0.zzj0(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXBm.zzRX(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzj0.zzZAU(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzH7.contains(listener)) {
            this.zzH7.add(listener);
        }
    }

    public void removeEventListener(zzZAU listener) {
        if (this.zzH7.contains(listener)) {
            this.zzH7.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzH7.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXxm.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzH7) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXxm.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzH7) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXxm.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzH7) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzH7) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzH7) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zz7N zzYN3(zzj0[] zzj0Array) {
        DataColumn[] dataColumnArray = new DataColumn[zzj0Array.length];
        for (int i = 0; i < zzj0Array.length; ++i) {
            dataColumnArray[i] = zzj0Array[i].zzXu6();
        }
        DataTable dataTable = this;
        zz7N zz7N2 = dataTable.zzbz.zzRX(dataColumnArray);
        if (zz7N2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zz7N2;
    }

    final zzZZx zzXMt() {
        return this.zzbz;
    }

    final Set<DataRow> zzWSP() {
        return this.zzXxm;
    }
}

