/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzWym;
import com.aspose.words.zz21;
import com.aspose.words.zzVTG;
import com.aspose.words.zzW0t;
import com.aspose.words.zzWex;
import com.aspose.words.zzX22;
import com.aspose.words.zzXwu;
import com.aspose.words.zzYPA;
import com.aspose.words.zzYYf;
import com.aspose.words.zzYza;
import com.aspose.words.zzZnM;

public class Cell
extends CompositeNode<Node>
implements zzVTG,
zzYYf {
    private zzYza zzXC6;
    private CellFormat zzZTk;
    private ParagraphCollection zzXq0;
    private TableCollection zzmP;

    public Cell(DocumentBase doc) {
        this(doc, new zzYza());
    }

    Cell(DocumentBase doc, zzYza cellPr) {
        super(doc);
        this.zzXC6 = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzWtn();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzXkk();
    }

    public Row getParentRow() {
        return (Row)this.zzXTR();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzWaH() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzWCy(this, true);
        }
        return -1;
    }

    final int zzVUD() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzVUD();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzZTk == null) {
            this.zzZTk = new CellFormat(this);
        }
        return this.zzZTk;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzXq0 == null) {
            this.zzXq0 = new ParagraphCollection(this);
        }
        return this.zzXq0;
    }

    public TableCollection getTables() {
        if (this.zzmP == null) {
            this.zzmP = new TableCollection(this);
        }
        return this.zzmP;
    }

    final zzYza zzAU() {
        return this.zzXC6;
    }

    final void zzS(zzYza zzYza2) {
        this.zzXC6 = zzYza2;
    }

    @Override
    final Node zzS(boolean bl, zzZnM zzZnM2) {
        zzYza zzYza2;
        Cell cell = (Cell)super.zzS(bl, zzZnM2);
        zzYza zzYza3 = this.zzXC6;
        cell.zzXC6 = zzYza2 = (zzYza)zzYza3.zzWvW();
        cell.zzZTk = null;
        cell.zzXq0 = null;
        cell.zzmP = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzWex.zzXGB(this);
    }

    @Override
    final boolean zzYVq(Node node) {
        return zzXwu.zzXYA(node);
    }

    final int zzWPw() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXC6.zzYGg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzXC6.zzYGg(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzYPA zzYPA2 = zzWym.zzS(object, zzYPA.class);
        if (zzYPA2 != null && zzYPA2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZJk(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzYza.zzvx(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzXC6.zzYH9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXC6.clear();
    }

    private Object zzZJk(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzWym.zzS((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzS(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz21 getInsertRevision() {
        Cell cell = this;
        return cell.zzXC6.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zz21 value) {
        Cloneable cloneable = this;
        zz21 zz212 = value;
        cloneable = cloneable.zzXC6;
        ((zzW0t)cloneable).zzYH9(14, zz212);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz21 getDeleteRevision() {
        Cell cell = this;
        return cell.zzXC6.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zz21 value) {
        Cloneable cloneable = this;
        zz21 zz212 = value;
        cloneable = cloneable.zzXC6;
        ((zzW0t)cloneable).zzYH9(12, zz212);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzX22 getMoveFromRevision() {
        Cell cell = this;
        return cell.zzXC6.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzX22 value) {
        Cloneable cloneable = this;
        zzX22 zzX222 = value;
        cloneable = cloneable.zzXC6;
        ((zzW0t)cloneable).zzYH9(13, zzX222);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzX22 getMoveToRevision() {
        Cell cell = this;
        return cell.zzXC6.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzX22 value) {
        Cloneable cloneable = this;
        zzX22 zzX222 = value;
        cloneable = cloneable.zzXC6;
        ((zzW0t)cloneable).zzYH9(15, zzX222);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzXC6.remove(13);
        cell = this;
        cell.zzXC6.remove(15);
    }

    final zzYza zzXHS(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzYza zzYza2 = new zzYza();
        this.zzS(3120, zzYza2);
        this.zzS(3140, zzYza2);
        this.zzS(3110, zzYza2);
        this.zzS(3130, zzYza2);
        this.zzS(3090, zzYza2);
        this.zzS(3100, zzYza2);
        this.zzS(3070, zzYza2);
        this.zzS(3080, zzYza2);
        if (bl && (tableStyle = zzWym.zzS((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzDW(this, zzYza2);
        }
        this.zzXC6.zzDW((zzW0t)zzYza2);
        return zzYza2;
    }

    private void zzS(int n, zzYza zzYza2) {
        zzYza2.zzYH9(n, this.fetchInheritedCellAttr(n));
    }
}

