/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzO7;
import com.aspose.words.zzFe;
import com.aspose.words.zzTE;
import com.aspose.words.zzTR;
import com.aspose.words.zzWFd;
import com.aspose.words.zzWZ3;
import com.aspose.words.zzWoU;
import com.aspose.words.zzWsi;
import com.aspose.words.zzXBz;
import com.aspose.words.zzXIr;
import com.aspose.words.zzXal;
import com.aspose.words.zzXkK;
import com.aspose.words.zzYHO;
import com.aspose.words.zzZBS;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzWZ3 zzVd;

    ChartSeriesCollection(zzWZ3 chartSeriesSource) {
        this.zzVd = chartSeriesSource;
    }

    public ChartSeries get(int index) {
        return this.zzY0t().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        return this.zzY0t().iterator();
    }

    public void removeAt(int index) {
        this.zzVd.removeAt(index);
    }

    public void clear() {
        this.zzVd.clear();
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzS(chartSeriesCollection.zzW6N(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzS(chartSeriesCollection.zzW6N(), seriesName, xValues, yValues);
    }

    private ChartSeries zzS(String string, zzO7[] zzO7Array, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzS(chartSeriesCollection.zzW6N(), string, zzO7Array, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzS(seriesName, zzO7.zzS(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzS(chartSeriesCollection.zzW6N(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzS(zzYHO zzYHO2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzS(zzYHO2, string, dArray);
        chartSeries.zzXKM().zzWCy(ChartSeriesCollection.zzYHi(stringArray));
        return chartSeries;
    }

    final ChartSeries zzS(zzYHO zzYHO2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzS(zzYHO2, string, dArray2);
        chartSeries.zzXKM().zzWCy(ChartSeriesCollection.zzZlZ(dArray));
        return chartSeries;
    }

    private ChartSeries zzS(zzYHO zzYHO2, String string, zzO7[] zzO7Array, double[] dArray) {
        if (zzO7Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzO7Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzO7Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzS(zzYHO2, string, dArray);
        chartSeries.zzXKM().zzWCy(ChartSeriesCollection.zzS(zzO7Array));
        if (!zzYHO2.zzWpn()) {
            zzYHO2.zzZFH(true);
        }
        return chartSeries;
    }

    final ChartSeries zzS(zzYHO zzYHO2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzYHO2.zzXao() != 15) {
            zzYHO2.zzYVq(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzS(zzYHO2, string, dArray2);
        chartSeries.zzYSL().zzWUL().zzZSY(3, chartSeries.zzZXd().zzqM());
        chartSeries.zzXKM().zzWCy(ChartSeriesCollection.zzZlZ(dArray));
        if (dArray3 != null) {
            chartSeries.zzw2().zzWCy(ChartSeriesCollection.zzZlZ(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzS(zzYHO zzYHO2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzYHO2);
        chartSeries.setName(string);
        ChartSeriesCollection.zzYR3(chartSeries);
        chartSeries.zzXFm().zzWCy(ChartSeriesCollection.zzZlZ(dArray));
        zzXkK zzXkK2 = this.zzVd.zzW6N().getChartSpace();
        zzXkK2.zzon();
        zzZBS zzZBS2 = zzXkK2.zzWnj().zzVZ8();
        zzZBS2.zzWql(chartSeries);
        return chartSeries;
    }

    private static void zzYR3(ChartSeries chartSeries) {
        chartSeries.zzYSL().zzWUL().zzZSY(5, new zzWoU());
        if (ChartDataPointCollection.zzZwC(chartSeries.zzZXd().zzXao())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzZXd().zzXao()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzS(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzS(chartSeries, 5);
                ChartSeriesCollection.zzh5(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzS(chartSeries, 1);
                ChartSeriesCollection.zzh5(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzYH9(chartSeries);
            }
        }
    }

    private static void zzYH9(ChartSeries chartSeries) {
        zzWoU zzWoU2 = new zzWoU();
        zzWoU2.setOutline(new zzXBz());
        zzWsi zzWsi2 = new zzWsi();
        zzWsi2.setValue(1);
        zzWoU2.getOutline().setFill(new zzTE(zzWsi2));
        zzWoU2.getOutline().zzZw5(19050.0);
        chartSeries.zzYSL().zzWUL().zzZSY(5, zzWoU2);
    }

    private static void zzh5(ChartSeries chartSeries) {
        zzWoU zzWoU2 = new zzWoU();
        zzWoU2.setOutline(new zzXBz());
        zzWoU2.getOutline().setFill(new zzXIr());
        zzWoU2.getOutline().setEndCap(0);
        zzWoU2.getOutline().zzZw5(19050.0);
        chartSeries.zzYSL().zzWUL().zzZSY(5, zzWoU2);
    }

    private static void zzS(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzZXd());
        chartMarker.zzYYQ().zzZSY(0, n);
        chartSeries.zzYSL().zzWUL().zzZSY(4, chartMarker);
    }

    private static zzXal zzZlZ(double[] dArray) {
        int n = 0;
        zzXal zzXal2 = new zzXal(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzXal2.zzYt(new zzWFd(n, d, "General"));
            }
            ++n;
        }
        zzXal2.zzYt4(dArray.length);
        return zzXal2;
    }

    private static zzXal zzS(zzO7[] zzO7Array) {
        int n = 0;
        zzXal zzXal2 = new zzXal(2);
        zzO7[] zzO7Array2 = zzO7Array;
        int n2 = zzO7Array.length;
        for (int i = 0; i < n2; ++i) {
            zzO7 zzO72 = zzO7Array2[i];
            zzXal2.zzYt(new zzWFd(n++, zzFe.zzX5A(zzO72), "m/d/yyyy"));
        }
        zzXal2.zzYt4(zzO7Array.length);
        return zzXal2;
    }

    private static zzXal zzYHi(String[] stringArray) {
        int n = 0;
        zzXal zzXal2 = new zzXal(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzXal2.zzYt(new zzTR(n++, string));
        }
        zzXal2.zzYt4(stringArray.length);
        return zzXal2;
    }

    public int getCount() {
        return this.zzY0t().size();
    }

    private ArrayList<ChartSeries> zzY0t() {
        return this.zzVd.zzZCo();
    }

    private zzYHO zzW6N() {
        return this.zzVd.zzW6N();
    }
}

