/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzO7;
import com.aspose.words.internal.zzWym;
import com.aspose.words.internal.zzYBU;
import com.aspose.words.zzWEs;
import com.aspose.words.zzWH;
import com.aspose.words.zzX22;
import com.aspose.words.zzYYO;
import com.aspose.words.zzYek;
import com.aspose.words.zzxR;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzWEs,
zzYek {
    private int zzWUo;
    private boolean zzBW;
    private boolean zzWiW;
    private int zzlE;
    private int zzZBy = -1;
    private String zz97 = "";
    private String zzwR = "";
    private zzO7 zzWib = zzO7.zzW3i;
    private zzO7 zzYjM = zzO7.zzW3i;
    private CommentCollection zzXzq;

    Comment(DocumentBase doc, zzWH runPr) {
        super(doc, runPr);
        this.zzlE = doc.zzWLy();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzO7.zzW3i);
    }

    private Comment(DocumentBase doc, String author, String initial, zzO7 dateTime) {
        this(doc, new zzWH());
        this.setAuthor(author);
        this.setInitial(initial);
        zzO7 zzO72 = dateTime;
        Comment comment = this;
        this.zzWib = zzO72;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzO7.zzS(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzlE;
    }

    public final void setId(int value) {
        this.zzlE = value;
        if (this.getDocument() != null) {
            this.getDocument().zzXcm();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zz97;
    }

    public final void setInitial(String value) {
        zzWym.zzDW((Object)value, "Initial");
        this.zz97 = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzO7.zzh5(comment.zzWib);
    }

    private void zzk6(zzO7 zzO72) {
        this.zzWib = zzO72;
        if (!zzO7.zzS(this.zzYjM, zzO7.zzW3i)) {
            this.zzYjM = !zzO7.zzS(zzO72, zzO7.zzW3i) ? zzO72.zzYRL() : zzO7.zzW3i;
        }
    }

    public final void setDateTime(Date value) {
        this.zzk6(zzO7.zzS(value));
    }

    final zzO7 zzXUp() {
        return this.zzWib;
    }

    final void zzZB3(zzO7 zzO72) {
        this.zzWib = zzO72;
    }

    final zzO7 zzXn6() {
        return this.zzYjM;
    }

    final void zzZX4(zzO7 zzO72) {
        this.zzYjM = zzO72;
    }

    public final String getAuthor() {
        return this.zzwR;
    }

    public final void setAuthor(String value) {
        zzWym.zzDW((Object)value, "Author");
        this.zzwR = value;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzS(String string, String string2, zzO7 zzO72, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzO72);
        comment.setIdInternal(zzxR.zzS(this.getDocument()));
        comment.setParentId(this.zzlE);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzWym.zzS((Object)this.zzZkB(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzlE) {
            comment2 = comment3;
            comment3 = zzWym.zzS((Object)comment3.zzZkB(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zzYYO zzYYO2 = new zzYYO();
        if (zzYYO2.zziY(this.getDocument(), this.zzlE)) {
            this.zzS(zzYYO2.zzWBk(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzS(zzYYO2.zzXCR(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzS(author, initial, zzO7.zzS(dateTime), text);
    }

    private void zzS(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzYBU.zzS(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).zzAm(commentRangeStart2);
    }

    private void zzS(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzYBU.zzS(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzlE) break;
            object = node;
        }
        ((Node)object).zzAm(commentRangeEnd2);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzYYO zzYYO2 = new zzYYO();
        if (zzYYO2.zziY(this.getDocument(), reply.getId())) {
            zzYYO2.zzWBk().remove();
            zzYYO2.zzXCR().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzZtE()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzYwr());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzYwr(), '\u0005', new zzWH());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzXzq == null) {
            this.zzXzq = new CommentCollection(this.getDocument(), this);
        }
        return this.zzXzq;
    }

    public final boolean getDone() {
        return this.zzWiW;
    }

    public final void setDone(boolean value) {
        this.zzWiW = value;
    }

    public final int getParentId() {
        return this.zzZBy;
    }

    public final void setParentId(int value) {
        this.zzZBy = value;
        if (this.getDocument() != null) {
            this.getDocument().zzXcm();
        }
    }

    final int zzZyP() {
        return this.zzWUo;
    }

    final void zzXe1(int n) {
        this.zzWUo = n;
    }

    final boolean zzXWz() {
        return this.zzBW;
    }

    final void zzZw5(boolean bl) {
        this.zzBW = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzX22 getMoveFromRevision() {
        return this.zzZko().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzX22 value) {
        zzX22 zzX222 = value;
        zzWH zzWH2 = this.zzZko();
        zzWH2.zzYH9(13, zzX222);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzX22 getMoveToRevision() {
        return this.zzZko().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzX22 value) {
        zzX22 zzX222 = value;
        zzWH zzWH2 = this.zzZko();
        zzWH2.zzYH9(15, zzX222);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzZko().remove(13);
        this.zzZko().remove(15);
    }

    final String zzbU() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZvA(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

