/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzWym;
import com.aspose.words.zzNq;
import com.aspose.words.zzWrL;
import com.aspose.words.zzXZL;
import com.aspose.words.zzXwu;
import com.aspose.words.zzYMd;
import com.aspose.words.zzYd0;
import com.aspose.words.zzZ5C;
import com.aspose.words.zzZnM;
import com.aspose.words.zzhj;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzZ5C,
Iterable<V> {
    private Node zzZaf;
    private Node zzZPp;
    private Node zzVVc;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzWrL zzWrL2 = new zzWrL(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zz2E(this, true);
            return;
        }
        finally {
            zzWrL2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzY9B() {
        return this.zzXAS() != null;
    }

    final boolean zzWto() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzYSf() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzYMd) {
                return true;
            }
            CompositeNode compositeNode = zzWym.zzS((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzYSf()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzZaf;
    }

    public Node getLastChild() {
        return this.zzZPp;
    }

    final Node zzXAS() {
        return zzXwu.zzYR3(this.getFirstChild(), false);
    }

    final Node zzZbQ() {
        return zzXwu.zzYH9(this.getLastChild(), false);
    }

    final CompositeNode zzY2h() {
        return (CompositeNode)zzXwu.zzYR3(this.getFirstChild(), true);
    }

    final CompositeNode zz64() {
        return (CompositeNode)zzXwu.zzYH9(this.getLastChild(), true);
    }

    final Node zzWlF() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzXwu.zzWHM((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzcB() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzXwu.zzWHM((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzS(boolean bl, zzZnM zzZnM2) {
        CompositeNode compositeNode = (CompositeNode)super.zzS(bl, zzZnM2);
        ((CompositeNode)super.zzS(bl, zzZnM2)).zzZPp = null;
        compositeNode.zzZaf = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzXVL(node.zzS(true, zzZnM2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZvA(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZvA(StringBuilder stringBuilder) {
        this.zzWql(stringBuilder);
        zzWym.zzDW(stringBuilder, this.zzYOH());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzDW(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzXwu.zzWhe(nodeType);
            Node node2 = node = bl ? this.zzXAS() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZAF() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXZL.zziY(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXZL.zz2E(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzNq(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzS(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzS(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zz2E(oldChild, false);
    }

    private <T extends Node> T zz2E(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = zzXwu.zzS(documentBase, t, (Node)this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzZBX() && zzXwu.zzXny(t)) {
            return t;
        }
        zzXwu.zzS(documentBase, nodeChangingArgs);
        if (!bl && zzXwu.zzXVX(t)) {
            zzXwu.zzWAX(t, false);
        }
        T t2 = this.zzZYC(t);
        zzXwu.zzDW(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzYd0.zzZxw(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzXVL(Node node) {
        node.getParentNode();
        if (this.zzZPp == null) {
            node.zzX5O(null);
            node.zzdl(null);
            this.zzZaf = node;
        } else {
            node.zzX5O(this.zzZPp);
            node.zzdl(null);
            this.zzZPp.zzdl(node);
        }
        this.zzZPp = node;
        node.zzZJH(this);
        return node;
    }

    final void zzS(Node node, Node node2, Node node3) {
        this.zzS(node, node2, node3, false);
    }

    final void zzS(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzYVq(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzDW(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzWCy(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzXwu.zzWHM(node3.getNodeType())) continue;
            if (zzXwu.zzZlZ(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzYOH().length();
    }

    String zzYOH() {
        return "";
    }

    final String zzZka() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWql(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzWql(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZvA(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzYVq(Node node) {
        return true;
    }

    final <T extends Node> T zzS(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzXo4(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        zzXwu.zzDW(documentBase, documentBase2);
        if (t.getNodeType() != 37 && !this.zzYVq(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzhj(documentBase);
            try {
                compositeNode.zz2E(t, true);
            }
            finally {
                ((zzhj)object).dispose();
            }
        }
        object = zzXwu.zzS(documentBase, t, null, (Node)this, 0);
        zzXwu.zzS(documentBase, (NodeChangingArgs)object);
        if (this.zzZPp == null) {
            t.zzX5O(null);
            t.zzdl(null);
            this.zzZaf = t;
            this.zzZPp = t;
        } else if (bl) {
            if (node != null) {
                this.zzDW(t, node);
            } else {
                this.zziY(t, this.zzZaf);
            }
        } else if (node != null) {
            this.zziY(t, node);
        } else {
            this.zzDW(t, this.zzZPp);
        }
        t.zzZJH(this);
        zzXwu.zzDW(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzZBX()) {
            zzXwu.zzS(t, compositeNode, node2);
        }
        return t;
    }

    private void zzDW(Node node, Node node2) {
        Node node3 = node2.zzYtp();
        node.zzX5O(node2);
        node.zzdl(node3);
        node2.zzdl(node);
        if (node3 == null) {
            this.zzZPp = node;
            return;
        }
        node3.zzX5O(node);
    }

    private void zziY(Node node, Node node2) {
        Node node3 = node2.zzZvL();
        node.zzX5O(node3);
        node.zzdl(node2);
        node2.zzX5O(node);
        if (node3 == null) {
            this.zzZaf = node;
            return;
        }
        node3.zzdl(node);
    }

    private <T extends Node> T zzZYC(T t) {
        if (t == this.zzZaf) {
            if (this.zzZaf == this.zzZPp) {
                this.zzZaf = null;
                this.zzZPp = null;
            } else {
                this.zzZaf = t.zzYtp();
                this.zzZaf.zzX5O(null);
            }
        } else {
            Node node = t.zzZvL();
            Node node2 = t.zzYtp();
            node.zzdl(node2);
            if (node2 == null) {
                this.zzZPp = node;
            } else {
                node2.zzX5O(node);
            }
        }
        t.zzdl(null);
        t.zzX5O(null);
        t.zzZJH(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzVVc = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzVVc;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

