/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzLR;
import com.aspose.words.internal.zzW5w;
import com.aspose.words.internal.zzWqd;
import com.aspose.words.internal.zzWym;
import com.aspose.words.internal.zzXaN;
import com.aspose.words.internal.zzXml;
import com.aspose.words.internal.zzXqS;
import com.aspose.words.internal.zzYQz;
import com.aspose.words.internal.zzZqS;
import com.aspose.words.internal.zzZxR;
import com.aspose.words.internal.zzZzN;
import com.aspose.words.internal.zzby;
import com.aspose.words.zzVRH;
import com.aspose.words.zzWZe;
import com.aspose.words.zzWrg;
import com.aspose.words.zzX1w;
import com.aspose.words.zzX34;
import com.aspose.words.zzXDe;
import com.aspose.words.zzXII;
import com.aspose.words.zzYZN;
import com.aspose.words.zzZDI;
import com.aspose.words.zzZFg;
import com.aspose.words.zzbc;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzS(zzLR zzLR2, zzLR zzLR3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzWym.zzDW((Object)zzLR2, "srcStream");
        zzWym.zzDW((Object)zzLR3, "dstStream");
        zzWym.zzDW((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzDW(zzLR2, zzLR3, certificateHolder, signOptions);
        zzLR3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzS(zzLR.zzDW(srcStream), (zzLR)zzLR.zziY(dstStream), certHolder, signOptions);
    }

    private static void zzDW(zzLR zzLR2, zzLR zzLR3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zziY(digitalSignature);
        }
        if (zzX1w.zzZCu(zzLR2)) {
            DigitalSignatureUtil.zzS(zzLR2, zzLR3, digitalSignature, true);
            return;
        }
        zzX1w zzX1w2 = new zzX1w();
        zzLR zzLR4 = zzLR2;
        zzX1w zzX1w3 = zzX1w2;
        FileFormatInfo fileFormatInfo = zzX1w2.zzDW(zzLR4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXml zzXml2 = new zzXml(zzLR2);
                int n = fileFormatInfo.zzZE8() == 1 ? 1 : 2;
                zzZDI.zzS(zzXml2, digitalSignature, n);
                zzLR3.zzZYC(0L);
                zzXml2.zzXGB(zzLR3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzS(fileFormatInfo.zzTB(), zzLR3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzS(zzLR2, zzLR3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzS(zzLR2, zzLR3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzWym.zziY(srcFileName, "srcFileName");
        zzWym.zziY(dstFileName, "dstFileName");
        try (zzXaN zzXaN2 = zzWym.zzDW(srcFileName, 3, 1);){
            try (zzXaN zzXaN3 = zzWym.zzDW(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzS((zzLR)zzXaN2, (zzLR)zzXaN3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYQz zzYQz2 = zzLR.zziY(dstStream);
        zzLR zzLR2 = zzLR.zzDW(srcStream);
        DigitalSignatureUtil.zzS(zzLR2, (zzLR)zzYQz2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzXaN zzXaN2 = zzWym.zzDW(srcFileName, 3, 1);){
            try (zzXaN zzXaN3 = zzWym.zzDW(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWCy(zzXaN2, zzXaN3);
            }
            return;
        }
    }

    private static void zzWCy(zzLR zzLR2, zzLR zzLR3) throws Exception {
        zzX1w zzX1w2 = new zzX1w();
        zzLR zzLR4 = zzLR2;
        Object object = zzX1w2;
        FileFormatInfo fileFormatInfo = zzX1w2.zzDW(zzLR4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXml zzXml2 = new zzXml(zzLR2);
                zzXml2.zzua().zzVYD("_xmlsignatures");
                zzXml2.zzua().zzVYD("_signatures");
                zzLR3.zzXZJ(0L);
                zzXml2.zzXGB(zzLR3);
                zzLR zzLR5 = zzLR3;
                zzLR5.zzZYC(zzLR5.zzX3Z());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZqS zzZqS2 = new zzZqS(zzLR2);
                zzZxR zzZxR2 = zzZqS2.zzS(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzZxR2 != null) {
                    for (zzXqS zzXqS2 : zzZxR2.zzYQy()) {
                        String string = zzZxR2.zzS(zzXqS2);
                        zzZqS2.zzYZB().remove(string);
                    }
                    zzZqS2.zzYZB().remove(zzZxR2.getName());
                    zzXqS zzXqS3 = zzZqS2.zzYQy().zzYYO("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZqS2.zzYQy().remove(zzXqS3.getId());
                    zzZqS2.zzYT9();
                }
                zzLR3.zzXZJ(0L);
                zzZqS2.zzXGB(zzLR3);
                zzLR zzLR6 = zzLR3;
                zzLR6.zzZYC(zzLR6.zzX3Z());
                return;
            }
            case 60: 
            case 61: {
                zzYZN zzYZN2 = new zzYZN(zzLR2);
                zzX34 zzX342 = zzYZN2.zzWt7("/META-INF/documentsignatures.xml");
                if (zzX342 != null) {
                    zzYZN2.zzWwG().remove(zzX342.getName());
                }
                zzLR3.zzXZJ(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzLR4 = zzLR3;
                object = zzYZN2;
                ((zzYZN)object).zzS(zzLR4, string, null);
                zzLR zzLR7 = zzLR3;
                zzLR7.zzZYC(zzLR7.zzX3Z());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzWCy(zzLR.zzDW(srcStream), zzLR.zziY(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzXaN zzXaN2 = zzWym.zzDW(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzXaG(zzXaN2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzXaG(zzLR zzLR2) throws Exception {
        if (zzX1w.zzZCu(zzLR2)) {
            return DigitalSignatureUtil.zzWkG(zzLR2);
        }
        zzX1w zzX1w2 = new zzX1w();
        zzLR zzLR3 = zzLR2;
        zzX1w zzX1w3 = zzX1w2;
        FileFormatInfo fileFormatInfo = zzX1w2.zzDW(zzLR3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzLR2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzXaG(zzLR.zzDW(stream));
    }

    static zzW5w zzS(zzXml zzXml2, String string) throws Exception {
        zzXDe zzXDe2 = new zzXDe(zzXml2);
        if (zzXDe2.zzWri()) {
            zzW5w zzW5w2 = zzXDe2.zzXB2(string);
            return zzW5w2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzY8x(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzZzN.zzDW("Unexpected digest algorithm: {0}.", n));
    }

    static String zzZww(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzY8x(n);
    }

    private static void zzS(zzLR zzLR2, zzLR zzLR3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZqS zzZqS2 = new zzZqS(zzLR2);
        zzWrg zzWrg2 = bl ? new zzZFg(zzZqS2) : new zzWZe(zzZqS2);
        zzWrg2.zzDW(digitalSignature);
        zzLR3.zzZYC(0L);
        zzZqS2.zzXGB(zzLR3);
    }

    private static void zzS(zzLR zzLR2, zzLR zzLR3, DigitalSignature digitalSignature) throws Exception {
        zzYZN zzYZN2 = new zzYZN(zzLR2);
        zzbc zzbc2 = new zzbc(zzYZN2);
        zzbc2.zzDW(digitalSignature);
        zzLR3.zzZYC(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzLR zzLR4 = zzLR3;
        zzYZN zzYZN3 = zzYZN2;
        zzYZN3.zzS(zzLR4, string, null);
    }

    private static void zzS(zzXml zzXml2, zzLR zzLR2, DigitalSignature digitalSignature, String string) throws Exception {
        zzW5w zzW5w2 = DigitalSignatureUtil.zzS(zzXml2, string);
        zzW5w zzW5w3 = new zzW5w();
        DigitalSignatureUtil.zzS((zzLR)zzW5w2, (zzLR)zzW5w3, digitalSignature, false);
        zzXml zzXml3 = zzXDe.zzWCy(zzW5w3, string);
        zzXml3.zzXGB(zzLR2);
    }

    private static DigitalSignatureCollection zzWkG(zzLR zzLR2) throws Exception {
        zzLR2.zzXZJ(0L);
        zzZqS zzZqS2 = new zzZqS(zzLR2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzZxR zzZxR2 = zzZqS2.zzS(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzZxR2 != null) {
            for (zzXqS zzXqS2 : zzZxR2.zzYQy()) {
                String string = zzZxR2.zzS(zzXqS2);
                zzZxR zzZxR3 = zzZqS2.zzW75(string);
                zzZxR zzZxR4 = zzZqS2.zzS(zzZxR3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzby zzby2 = zzWqd.zzVZF(zzZxR4.zzZ1Y().zzY3j());
                zzXII.zzS(zzZxR3.zzKc(), zzby2, new zzVRH(zzZqS2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

