/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzLR;
import com.aspose.words.internal.zzOu;
import com.aspose.words.internal.zzQd;
import com.aspose.words.internal.zzW3W;
import com.aspose.words.internal.zzW5w;
import com.aspose.words.internal.zzWXD;
import com.aspose.words.internal.zzWuB;
import com.aspose.words.internal.zzWym;
import com.aspose.words.internal.zzXE3;
import com.aspose.words.internal.zzXa6;
import com.aspose.words.internal.zzXtc;
import com.aspose.words.internal.zzY6R;
import com.aspose.words.internal.zzYAq;
import com.aspose.words.internal.zzYEn;
import com.aspose.words.internal.zzZ9n;
import com.aspose.words.internal.zzZIE;
import com.aspose.words.internal.zzZW8;
import com.aspose.words.internal.zzZzN;
import com.aspose.words.zzFf;
import com.aspose.words.zzJS;
import com.aspose.words.zzRD;
import com.aspose.words.zzVTG;
import com.aspose.words.zzW0t;
import com.aspose.words.zzW36;
import com.aspose.words.zzW8o;
import com.aspose.words.zzWGK;
import com.aspose.words.zzWH;
import com.aspose.words.zzWH4;
import com.aspose.words.zzWX9;
import com.aspose.words.zzWcR;
import com.aspose.words.zzWex;
import com.aspose.words.zzWmk;
import com.aspose.words.zzWsW;
import com.aspose.words.zzWyf;
import com.aspose.words.zzXDb;
import com.aspose.words.zzXEx;
import com.aspose.words.zzXFJ;
import com.aspose.words.zzXM2;
import com.aspose.words.zzXQ0;
import com.aspose.words.zzXbl;
import com.aspose.words.zzXia;
import com.aspose.words.zzXlU;
import com.aspose.words.zzXwu;
import com.aspose.words.zzYEe;
import com.aspose.words.zzYOi;
import com.aspose.words.zzYPy;
import com.aspose.words.zzYYf;
import com.aspose.words.zzYa4;
import com.aspose.words.zzYfO;
import com.aspose.words.zzYt4;
import com.aspose.words.zzYzF;
import com.aspose.words.zzYza;
import com.aspose.words.zzZ2e;
import com.aspose.words.zzZBh;
import com.aspose.words.zzZGR;
import com.aspose.words.zzZNh;
import com.aspose.words.zzZY4;
import com.aspose.words.zzZbb;
import com.aspose.words.zzZhZ;
import com.aspose.words.zzZy2;
import com.aspose.words.zzhV;
import com.aspose.words.zzhj;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzVTG,
zzYOi,
zzYa4,
zzZy2 {
    private Document zzmj;
    private Node zz1d;
    private Node zzXNm;
    private zzWH zzYog;
    private Font zzXuu;
    private zzXtc<zzWH> zzWQ4;
    private zzXtc<zzZGR> zzZOC;
    private zzXtc<zzS> zzWJH;
    private zzWH4 zzVRN = zzWH4.zzXvE();
    private zzYza zzXC6 = new zzYza();
    private zzZGR zzYV6;
    private RowFormat zzXLM;
    private CellFormat zzZTk;
    private ParagraphFormat zzZzX;
    private zzXtc<zzXQ0> zzXP1;
    private int zz8f = 0;
    private int zzYB8 = -1;
    private int zzXfx;
    private boolean zzXGJ;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzYR3(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzYR3(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzYR3(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzS(documentBuilder.getCurrentSection(), zzWex.zz7y(headerFooterType), 0, 0);
    }

    private void zzYR3(int n, int n2, int n3, int n4) {
        this.zzmj.ensureMinimum();
        Section section = (Section)this.zzmj.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzS(section, 1, n3, n4);
    }

    private void zzS(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzWex.zzXkM(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = section.appendChild(new HeaderFooter(this.zzmj, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzmj));
            }
        }
        this.zzS(story, n2, n3);
    }

    private void zzS(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzS((CompositeNode)paragraph2, n3);
    }

    final void zzS(Paragraph paragraph, int n) {
        this.zzS((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXUD().zzWnQ() ? zzYzF.zziV(this.zzmj, fieldName) : zzYzF.zzZ51(this.zzXUD(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzS(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzS(field, isAfter, false);
    }

    private boolean zzS(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzW8o zzW8o2 = field.getFormat().zzX8X();
        Inline inline = zzW8o2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzS(inline.zzZko(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzXFJ.zzS(this.zzmj, bookmarkName) : zzXFJ.zzDW(this.zzmj, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzZ2H() == 6) {
            this.zzS(node.zzXTR(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzXwu.zzXKZ(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzS((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzS(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzDW(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzS(structuredDocumentTag);
            return;
        }
        this.zziY(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzXo4(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzS((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzZ2H() == 6) {
            this.zzZB3(node);
        } else {
            Node node2 = node;
            if (zzXwu.zzWHM(node2.getNodeType())) {
                Paragraph paragraph = zzXwu.zzXKZ(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzZB3(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzZ2H() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzZB3(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzXfx = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzZGA();
            return;
        }
        if (!this.zzX1h()) {
            this.zzZGA();
        }
    }

    private void zzS(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzX1h() {
        Node node = this.zzXUD();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzXUD().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzS(((StructuredDocumentTag)documentBuilder.zzXUD().getParentNode()).zzW(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzXUD(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzS(inline.zzZko(), true);
            return true;
        }
        return false;
    }

    private void zzZGA() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzS(documentBuilder.getCurrentParagraph().zzXPn(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzXo4(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzX2V() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXUD().zzXo4(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzWtn();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzS((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzYfO(text, false);
    }

    public void writeln(String text) {
        this.zzYfO(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzXUD() != null && this.zzXUD().zzZ2H() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzXUD().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzXtT();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzhj zzhj2 = new zzhj(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzmj, this.zzYYa(), this.zzOq());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().zzAm(paragraph);
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzDW(this.zzXUD(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzhj2.dispose();
        }
        if (this.getDocument().zzZBX()) {
            zzXwu.zziY((zzYYf)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzhR());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzYpd() {
        zzWH zzWH2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzXtT();
        Node node = this.zzXUD();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzYvU(false);
        } else {
            run2 = run = (Run)node.zzWYV(21);
        }
        if (run2 == null && zzWym.zzZSY(node, paragraph.zzXpY())) {
            run = paragraph.zzXpY();
        }
        if (run != null) {
            cloneable = run.zzZko();
            zzWH2 = (zzWH)((zzW0t)cloneable).zzWvW();
        } else {
            cloneable = paragraph.zzXPn();
            zzWH2 = (zzWH)((zzW0t)cloneable).zzWvW();
        }
        zzWH zzWH3 = zzWH2;
        Paragraph paragraph2 = new Paragraph(this.zzmj, this.zzYYa(), zzWH3);
        paragraph.zzZuf(paragraph2);
        zzhj zzhj2 = new zzhj(this.zzmj);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzDW(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzhj2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzZhZ.zziV(this);
    }

    public void insertBreak(int breakType) {
        this.zzXm4(breakType, true);
    }

    final void zzXm4(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzWdH(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzmv(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzXbQ())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzWdH(bl)) {
                        this.zzmv(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzWdH(bl)) {
                        this.zzZSR(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzWdH(bl)) {
                        this.zzZSR(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzWdH(bl)) {
                        this.zzZSR(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzWdH(bl)) {
                        this.zzZSR(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzWdH(bl)) {
                        this.zzZSR(4);
                    }
                    return;
                }
                case 8: {
                    this.zzmv(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzQd.zzWq4(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzZzN.zzDW("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzXtT();
        return zzXwu.zzS(fieldType, updateField, this.zzOq(), this.zzWVn(), this.zzWWt(), this.zzWWt() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzXtT();
        return zzXwu.zzS(fieldCode, this.zzOq(), this.zzWVn(), this.zzWWt(), this.zzWWt() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzXtT();
        return zzXwu.zzS(fieldCode, fieldValue, this.zzOq(), this.zzWVn(), this.zzWWt(), this.zzWWt() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzWym.zzDW((Object)displayText, "displayText");
        zzWym.zzDW((Object)urlOrBookmark, "hrefOrBookmark");
        zzWsW zzWsW2 = this.zzDW(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        Object object = this;
        zzWsW2.zziY(((DocumentBuilder)object).zzVWc(88, true));
        object = zzWsW2;
        return zzXwu.zzS((zzWsW)object);
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzc0(70);
        if (zzQd.zzWq4(name)) {
            this.startBookmark(name);
        }
        this.zz9K(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzmH(70);
        String string = zzQd.zzWq4(fieldValue) ? fieldValue : FormField.zzX4O;
        Run run = new Run(this.zzmj, string, this.zzOq());
        this.insertNode(run);
        Node node = this.zzVWc(70, true);
        if (zzQd.zzWq4(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzk6(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzS((CompositeNode)((Paragraph)node.zzXTR()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzc0(71);
        if (zzQd.zzWq4(name)) {
            this.startBookmark(name);
        }
        this.zz9K(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzVWc(71, false);
        if (zzQd.zzWq4(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzk6(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzc0(83);
        if (zzQd.zzWq4(name)) {
            this.startBookmark(name);
        }
        this.zz9K(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzVWc(83, false);
        if (zzQd.zzWq4(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzk6(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzmj, footnoteType, !zzQd.zzWq4(referenceMark), referenceMark, this.zzOq());
        Style style = this.getDocument().getStyles().zzY62(zzXwu.zzYIa(footnoteType));
        footnote.zzZko().set(50, style.zzWYp());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzmj);
        Style style2 = this.getDocument().getStyles().zzY62(zzXwu.zzWnC(footnoteType));
        paragraph.zzZxm().set(1000, style2.zzWYp());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzmj, '\u0002', new zzWH()) : new Run(this.zzmj, footnote.getReferenceMark(), new zzWH());
        inline.zzZko().set(50, style.zzWYp());
        paragraph.appendChild(inline);
        if (zzQd.zzWq4(footnoteText)) {
            Node node = this.zzXUD();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzZB3(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzYjE(zzLR zzLR2) throws Exception {
        return this.zzS(zzLR2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzYjE(zzLR.zzDW(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzS(zzLR zzLR2, double d, double d2) throws Exception {
        return this.zzS(zzLR2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzS(zzLR.zzDW(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        try (zzW5w zzW5w2 = new zzW5w();){
            zzWuB.zzS(image, zzW5w2);
            Shape shape = this.zzS(zzW5w2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzWym.zziY(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzZ9n.zzWLA(fileName);
        try {
            Shape shape = this.zzS((zzLR)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzLR)object).close();
            }
        }
    }

    private Shape zzS(zzLR zzLR2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzLR2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzWym.zzZ51(zzLR2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzS(zzLR.zzDW(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzS(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzS(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzZW8.zzWl3(object)) {
            object4 = new zzWuB((byte[])object);
            bl2 = true;
            ((zzW3W)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzmj.getCompatibilityOptions().getMswVersion() > 12 || this.zzmj.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzmj, 0);
            object3 = new zzXEx();
            ((zzYEe)object3).zzS(zzYPy.zzXCr("rect"));
            ((zzXEx)object3).zzS(new zzXlU());
            ((zzXEx)object3).zzXcY().zzXxI().zziY(this.zzmj);
            object2 = new zzWX9();
            ((zzWmk)object2).zzDW(new zzXbl(this.zzmj.zzW3N(), ""));
            ((zzWmk)object2).zzS(new zzYt4());
            ((zzXia)object3).zzS((zzWmk)object2);
            shape.setShapeType(75);
            shape.zzZlZ((zzXia)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzmj, 75);
        }
        if (zzZW8.zzWuB(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzS((byte[])object, new zzZBh(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzZBh(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzZW8.zzW61((byte[])object2));
                this.zzS((zzXEx)shape.zzX4T(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXEx)shape.zzX4T()).zzXcY().zzXxI().zzWCb((byte[])object);
            object3 = zzZW8.zzZzf(object);
            object4 = new zzZBh(((zzYAq)object3).getWidthPoints(), ((zzYAq)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzDW(this.zzOq());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzZW8.zzBh(object)) {
            d5 = DocumentBuilder.zzS(shape, object);
        }
        shape.zzS(d3, d4, (zzZBh)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzS(Shape shape, byte[] byArray) throws Exception {
        int n = zzZW8.zzYBU(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzXwu.zzZnJ(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzXwu.zzXX1(n);
        return d;
    }

    private void zzS(zzXEx zzXEx2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXEx2.zzXcY().zzXxI().getExtensions();
        try (zzW5w zzW5w2 = new zzW5w(byArray);){
            object = zzXwu.zzS(zzW5w2, this.zzmj);
            ((zzWyf)object).zzGG(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzWyf)object).zzXT5();
            byArray2 = ((zzWyf)object).zzDP(true);
        }
        zzXEx2.zzXcY().zzXxI().setExtensions(new zzYEn<zzWcR>());
        object = zzWcR.zzS(byArray2, this.zzmj);
        zzXEx2.zzXcY().zzXxI().getExtensions().zzWCy(((zzWcR)object).getUri(), (zzWcR)object);
    }

    private Shape zzS(zzLR zzLR2, String string, boolean bl, zzLR zzLR3) throws Exception {
        zzWGK zzWGK2 = zzWGK.zzXA(string);
        Shape shape = this.zzS(zzLR3, bl, zzWGK2, null);
        zzRD zzRD2 = zzhV.zzS(zzLR2, string, bl);
        return DocumentBuilder.zzS(null, false, shape, zzWGK2.zzZ6n, zzRD2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzS(zzLR.zzDW(stream), progId, asIcon, zzLR.zzDW(presentation));
    }

    private Shape zzS(String string, boolean bl, boolean bl2, zzLR zzLR2) throws Exception {
        zzWGK zzWGK2 = zzWGK.zzVRC(zzY6R.zzW9J(string));
        return this.zzS(string, bl, bl2, zzLR2, zzWGK2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzS(fileName, isLinked, asIcon, zzLR.zzDW(presentation));
    }

    private Shape zzS(String string, String string2, boolean bl, boolean bl2, zzLR zzLR2) throws Exception {
        zzWGK zzWGK2 = zzWGK.zzXA(string2);
        return this.zzS(string, bl, bl2, zzLR2, zzWGK2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzS(fileName, progId, isLinked, asIcon, zzLR.zzDW(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWGK zzWGK2 = zzWGK.zzVRC(zzY6R.zzW9J(fileName));
        return this.zzS(fileName, isLinked, iconFile, iconCaption, zzWGK2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWGK zzWGK2 = zzWGK.zzXA(progId);
        return this.zzS(fileName, isLinked, iconFile, iconCaption, zzWGK2);
    }

    private Shape zzDW(zzLR zzLR2, String string, String string2, String string3) throws Exception {
        zzWGK zzWGK2 = zzWGK.zzXA(string);
        Shape shape = this.zzS(string2, string3, zzWGK2);
        zzRD zzRD2 = zzhV.zzS(zzLR2, string, true);
        return DocumentBuilder.zzS(null, false, shape, zzWGK2.zzZ6n, zzRD2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzDW(zzLR.zzDW(stream), progId, iconFile, iconCaption);
    }

    final Shape zzS(zzJS zzJS2, zzLR zzLR2) throws Exception {
        Shape shape = this.zzZzf(zzLR2);
        shape.setShapeType(201);
        shape.zzVXS(4112, zzJS2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzXtT();
        if (this.zzZ6C()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzYdf(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZbb zzZbb2 = zzXwu.zzS(html, options, this);
        zzZbb2.zzXIr();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzXtT();
        return zzXwu.zzS(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzXtT();
        return zzXwu.zzS(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZNh zzZNh2 = new zzZNh();
        return zzZNh2.zzS(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZY4(this).zzS(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZY4(this).zzS(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzmj, 75);
        shape.zzDW(this.zzOq());
        shape.zzXt6(true);
        shape.getSignatureLine().zzS(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzxX(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzXYA(this.zzmj);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzZ6C() {
        boolean bl = false;
        if (this.zzXUD().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXUD().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzYdf(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzXtT();
        if (this.zzX2V() == null) {
            this.startTable();
        }
        if (this.zzX2V().zz0o() == 1) {
            this.zzX2V().zzX7a();
        }
        if (this.zzX2V().zz0o() == 3) {
            this.zzX2V().zzWH6();
        }
        return this.zzX2V().zz6e();
    }

    public Table startTable() {
        this.zzXP1.push(new zzXQ0(this));
        return this.zzX2V().startTable();
    }

    public Table endTable() {
        if (this.zzX2V() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzX2V().endTable();
        this.zzXP1.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzX2V() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzX2V().endRow();
        if (this.zzXuu != null && this.zzXuu.getHidden()) {
            row.zzYdd().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzmj, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzmj, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzXLw();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzmj, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzWPw();
        bookmarkStart.zzW1M(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzXLw();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzWPw();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzmj, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzZo1(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzmj);
        this.zzYB8 = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzYB8 == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzmj, this.zzYB8);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzmj, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzWym.zzDW((Object)importFormatOptions, "ImportFormatOptions");
        this.zzXtT();
        return zzXDb.zzS(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Node insertDocumentInline(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzWym.zzDW((Object)importFormatOptions, "ImportFormatOptions");
        this.zzXtT();
        importFormatOptions.zzWFj(true);
        Node node = zzXDb.zzS(this, srcDoc, importFormatMode, importFormatOptions);
        importFormatOptions.zzWFj(false);
        return node;
    }

    public Document getDocument() {
        return this.zzmj;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzmj) {
            return;
        }
        this.zzmj = value;
        this.zzZB3(null);
        this.zzYog = new zzWH();
        this.zzWQ4 = null;
        this.zzZOC = null;
        this.zzXuu = null;
        this.zzXP1 = new zzXtc();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzXuu == null) {
            DocumentBuilder documentBuilder = this;
            this.zzXuu = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzXuu;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzZzX == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZzX = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzZzX;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzXLM == null) {
            this.zzXLM = new RowFormat(this);
        }
        return this.zzXLM;
    }

    public CellFormat getCellFormat() {
        if (this.zzZTk == null) {
            this.zzZTk = new CellFormat(this);
        }
        return this.zzZTk;
    }

    final void zzY8e(Node node) {
        this.getCurrentParagraph().zzZuf(node);
    }

    public void pushFont() {
        zzWH zzWH2;
        if (this.getCurrentParagraph() != null) {
            zzWH zzWH3 = this.getCurrentParagraph().zzXPn();
            zzWH2 = (zzWH)zzWH3.zzWvW();
        } else {
            zzWH2 = this.zzOq();
        }
        zzWH zzWH5 = zzWH2;
        this.zz1l().push(new zzS(this.zzOq(), zzWH5));
    }

    public void popFont() {
        zzXtc<zzS> zzXtc2 = this.zz1l();
        if (zzXtc2.size() > 0) {
            zzS zzS2 = (zzS)this.zz1l().pop();
            this.zzS(zzS2.zzZko(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzY8e(zzS2.zzZZS());
            }
        }
    }

    final void zzKC() {
        this.zzY9W().push(this.zzOq());
    }

    final void zzZAj() {
        zzXtc<zzWH> zzXtc2 = this.zzY9W();
        if (zzXtc2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzS((zzWH)documentBuilder.zzY9W().pop(), false);
        }
    }

    final void zzYa5() {
        this.zzW2C().push(this.zzYYa());
    }

    final void zzUK() {
        zzXtc<zzZGR> zzXtc2 = this.zzW2C();
        if (zzXtc2.size() > 0) {
            zzZGR zzZGR2 = (zzZGR)this.zzW2C().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzS(zzZGR2);
            }
        }
    }

    private zzWsW zzDW(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzc0(88);
        zzZ2e zzZ2e2 = new zzZ2e();
        zzZ2e2.setTarget(string2);
        zzZ2e2.setScreenTip(string3);
        if (bl) {
            zzZ2e2.setSubAddress(string);
        } else {
            zzZ2e2.setAddress(zzWXD.zzZbn(string));
            zzZ2e2.setSubAddress(zzWXD.zzXcA(string));
        }
        this.zz9K(zzZ2e2.zzWel());
        FieldSeparator fieldSeparator = this.zzmH(88);
        return new zzWsW(fieldStart, fieldSeparator, null);
    }

    final zzWsW zzh5(String string, String string2, String string3) {
        boolean bl = zzWXD.zzYS5(string);
        String string4 = bl ? zzWXD.zzXcA(string) : string;
        return this.zzDW(string4, bl, string2, string3);
    }

    final zzWsW zzS(zzZ2e zzZ2e2) {
        FieldStart fieldStart = this.zzc0(88);
        this.zz9K(zzZ2e2.zzWel());
        FieldSeparator fieldSeparator = this.zzmH(88);
        return new zzWsW(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzXp2() {
        return this.zzVWc(88, true);
    }

    final zzWH zzOq() {
        zzWH zzWH2 = this.zzYog;
        return (zzWH)zzWH2.zzWvW();
    }

    final zzZGR zzYYa() {
        zzZGR zzZGR2 = this.zzZxm();
        return (zzZGR)zzZGR2.zzWvW();
    }

    final zzWH4 zzZAz() {
        zzWH4 zzWH42 = this.zzYdd();
        return (zzWH4)zzWH42.zzWvW();
    }

    final zzYza zzYmo() {
        zzYza zzYza2 = this.zzAU();
        return (zzYza)zzYza2.zzWvW();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXUD(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXUD().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzXGJ && this.zzXUD().getNodeType() == 28;
    }

    private void zzYfO(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzXUD()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzWex.zzYGa(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzW2D(string2.substring(n4, n4 + n2));
                }
                switch (this.zz8f) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzmv(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzW2D(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzXtT();
        if (this.zzX2V() != null && this.zzX2V().zz0o() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzXUD().zzZuf(node);
    }

    final void zzXDb(int n) {
        this.zzWdH(true);
        this.zzZSR(n);
    }

    private void zzZSR(int n) {
        this.insertParagraph();
        zzhj zzhj2 = new zzhj(this.getDocument());
        try {
            zzXM2 zzXM22 = this.getCurrentSection().zzX66();
            zzXM2 zzXM23 = (zzXM2)zzXM22.zzWvW();
            Section section = new Section(this.zzmj, zzXM23);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzmj));
            this.zzmj.insertAfter(section, this.getCurrentSection());
            section.getBody().zzDW(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzhj2.dispose();
        }
    }

    final FieldStart zzc0(int n) {
        this.zzXtT();
        return zzXwu.zzS(n, this.zzOq(), this.zzWVn(), this.zzWWt(), this.zzWWt() == null);
    }

    final Run zz9K(String string) {
        return zzXwu.zzDW(string, this.zzOq(), this.zzWVn(), this.zzWWt(), this.zzWWt() == null);
    }

    final FieldEnd zzVWc(int n, boolean bl) {
        return zzXwu.zzDW(n, bl, this.zzOq(), this.zzWVn(), this.zzWWt(), this.zzWWt() == null);
    }

    final FieldSeparator zzmH(int n) {
        return zzXwu.zzDW(n, this.zzOq(), this.zzWVn(), this.zzWWt(), this.zzWWt() == null);
    }

    private FormField zzk6(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzmj, new zzW36(), this.zzOq());
        CompositeNode compositeNode = node == null ? this.zzWVn() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzWdH(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzX2V() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzXo4(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzW2D(String string) {
        if (this.zzW0r(string)) {
            zzXE3 zzXE32 = new zzXE3(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzZIE zzZIE2 : zzXE32.zzXWe(this.getParagraphFormat().getBidi())) {
                zzYfO zzYfO2 = zzYfO.zzZ6X(zzZIE2.zzVSY());
                zzWH zzWH2 = this.zzOq();
                zzWH2.zzYH9(265, zzYfO2);
                if (zzZIE2.zzYa7()) {
                    zzWH2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzmj, zzZIE2.getText(), zzWH2);
                this.insertNode(run);
            }
            return;
        }
        this.zzmv(string);
    }

    private boolean zzW0r(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzOu.zzZMi(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzS(zzWH zzWH2, boolean bl) {
        zzWH zzWH3;
        if (bl) {
            zzWH zzWH5 = zzWH2;
            zzWH3 = (zzWH)zzWH5.zzWvW();
        } else {
            zzWH3 = zzWH2;
        }
        this.zzYog = zzWH3;
    }

    final void zzXhB() {
        this.zzYog.clear();
    }

    final void zzZHO() {
        if (this.zzXLw() != null) {
            zzYza zzYza2;
            zzYza zzYza3 = zzYza2 = this.zzXLw().zzAU();
            this.zzXC6 = (zzYza)zzYza3.zzWvW();
            zzYza2.zzDW(this.zzXC6);
        }
    }

    private Shape zzS(String string, boolean bl, boolean bl2, zzLR zzLR2, zzWGK zzWGK2) throws Exception {
        if (zzWGK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzS(zzLR2, bl2, zzWGK2, string);
        zzRD zzRD2 = zzhV.zzS(string, bl, bl2, zzWGK2);
        return DocumentBuilder.zzS(string, bl, shape, zzWGK2.zzZ6n, zzRD2);
    }

    private Shape zzS(String string, boolean bl, String string2, String string3, zzWGK zzWGK2) throws Exception {
        if (zzWGK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzY6R.zzXEl(string);
        }
        Shape shape = string2 != null ? this.zzf0(string2, string3) : this.zzS(null, string3, zzWGK2);
        zzRD zzRD2 = zzhV.zzS(string, bl, true, zzWGK2);
        return DocumentBuilder.zzS(string, bl, shape, zzWGK2.zzZ6n, zzRD2);
    }

    private static Shape zzS(String string, boolean bl, Shape shape, String string2, zzRD zzRD2) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzDW(zzRD2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzS(zzLR zzLR2, boolean bl, zzWGK zzWGK2, String string) throws Exception {
        if (zzWGK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzLR2 != null) {
            return this.zzZzf(zzLR2);
        }
        if (!bl) {
            return this.zz35(zzhV.zzZcM().get("normal"));
        }
        String string2 = string != null ? zzY6R.zzXEl(string) : zzhV.zzSG(zzWGK2.zzYwR);
        return this.zzS(zzWGK2, string2);
    }

    private Shape zzS(String string, String string2, zzWGK zzWGK2) throws Exception {
        if (zzWGK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzhV.zzSG(zzWGK2.zzYwR);
        }
        if (string != null) {
            return this.zzf0(string, string2);
        }
        return this.zzS(zzWGK2, string2);
    }

    private Shape zzS(zzWGK zzWGK2, String string) throws Exception {
        if (zzWGK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzhV.zzZkH(zzWGK2.zzYwR);
        zzXa6 zzXa62 = new zzXa6(byArray, null, string, this.getDocument().zzWRT());
        return this.zz35(zzXa62.zzXdW());
    }

    private Shape zzf0(String string, String string2) throws Exception {
        zzXa6 zzXa62 = new zzXa6(string, string2, this.getDocument().zzWRT());
        return this.zz35(zzXa62.zzXdW());
    }

    private Shape zzZzf(zzLR zzLR2) throws Exception {
        byte[] byArray = zzWym.zzZ51(zzLR2);
        return this.zz35(byArray);
    }

    private Shape zz35(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzmj, 1);
        shape.setShapeType(75);
        shape.zzDW(this.zzOq());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzxX(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzS(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzDW(compositeNode, n);
            return;
        }
        this.zziY(compositeNode, n);
    }

    private void zzDW(CompositeNode compositeNode, int n) {
        zzFf zzFf2 = zzFf.zzZHh(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzFf2.zzS(null, true, true, true, false, true);
            node = zzFf2.getNode();
            if (zzFf2.zzYkk() && (!node.isComposite() || node.zzZ2H() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzYOH().length() : node.getTextLength();
            if (!zzFf2.zzYkk() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzFf2.zzYkk() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzS((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzS(null, node);
            this.zzXfx = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzS(StructuredDocumentTag structuredDocumentTag) {
        this.zzZB3(structuredDocumentTag);
        this.zzXGJ = true;
        this.zzXfx = 0;
        zzWH zzWH2 = structuredDocumentTag.zzW();
        switch (structuredDocumentTag.zzZ2H()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzcB(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzWH2 = ((Inline)node).zzZko();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzWH2 = paragraph.zzXPn();
                break;
            }
            default: {
                return;
            }
        }
        this.zzS(zzWH2, true);
    }

    private void zziY(CompositeNode compositeNode, int n) {
        zzFf zzFf2 = zzFf.zzW0t(compositeNode);
        while (zzFf2.getNode() != compositeNode || !zzFf2.zzYkk()) {
            int n2;
            Node node = zzFf2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzYOH().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzS(null, node);
                this.zzXfx = n;
                return;
            }
            while (zzFf2.zzS(null, false, true, true, false, true) && zzFf2.zzYkk() && zzFf2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzXtT() {
        int n = this.zzXfx;
        if (n == 0) {
            return;
        }
        this.zzXfx = 0;
        Run run = zzWym.zzS((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzX0K(n);
        }
    }

    private Run zzmv(String string) {
        Run run = new Run(this.zzmj, string, this.zzOq());
        this.insertNode(run);
        return run;
    }

    final boolean zzYTb() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzWIC() {
        return this.zz8f;
    }

    final void zzWVz(int n) {
        this.zz8f = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXUD();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXUD();
        }
        return (Paragraph)this.zzXUD().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzXUD();
        }
        return (StructuredDocumentTag)this.zzXUD().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzXUD().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzXQ0 zzX2V() {
        return zzWym.zzS(this.zzXP1);
    }

    private Cell zzXLw() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzYTx();
    }

    private CompositeNode zzWVn() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzXUD();
        }
        return this.zzXUD().getParentNode();
    }

    private Node zzWWt() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXUD();
    }

    private zzXtc<zzWH> zzY9W() {
        if (this.zzWQ4 == null) {
            this.zzWQ4 = new zzXtc();
        }
        return this.zzWQ4;
    }

    private zzXtc<zzZGR> zzW2C() {
        if (this.zzZOC == null) {
            this.zzZOC = new zzXtc();
        }
        return this.zzZOC;
    }

    private zzXtc<zzS> zz1l() {
        if (this.zzWJH == null) {
            this.zzWJH = new zzXtc();
        }
        return this.zzWJH;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzYog.zzYGg(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzYog.zzYFL(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzMO(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzMO(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzYog.zzYH9(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZar()) {
            this.getCurrentParagraph().zzXPn().zzYH9(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzYog.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzYog.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZar()) {
            this.getCurrentParagraph().zzXPn().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzZxm().zzYGg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzZxm().zzYFL(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzZhc(key, 0);
        }
        return this.getDocument().getStyles().zzZRT().zzYZx(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzZxm().zzYH9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzZxm().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzZxm().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzYdd().zzYGg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzYdd().zzYZx(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzYdd().zziz(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzYdd().zzYH9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzYdd().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzYdd().clear();
        zzWH4.zzXvE().zzDW(this.zzYdd());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzAU().zzYGg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzAU().zzYZx(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzAU().zziz(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzWym.zzS(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzXLw() != null ? this.zzXLw().getCellFormat() : this.getCellFormat();
            border.zzS(cellFormat);
        }
        this.zzAU().zzYH9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzAU().clear();
    }

    private Node zzXUD() {
        Node node = this.zz1d != null && this.zz1d.getParentNode() == null ? this.zzXNm : this.zz1d;
        if (node != null && node.zzZ2H() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzXGJ = this.zzXGJ && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzZB3(Node node) {
        this.zz1d = node;
        if (this.zz1d != null) {
            this.zzXNm = this.zz1d.getParentNode();
        }
        this.zzXGJ = false;
    }

    private zzZGR zzZxm() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzZxm();
        }
        if (this.zzYV6 == null) {
            this.zzYV6 = new zzZGR();
        }
        return this.zzYV6;
    }

    private zzWH4 zzYdd() {
        if (this.zzX2V() != null && this.zzX2V().zz0o() == 1) {
            return this.zzVRN;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzYdd();
        }
        return this.zzVRN;
    }

    private zzYza zzAU() {
        if (this.zzX2V() != null && this.zzX2V().zz0o() != 3) {
            return this.zzXC6;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzYTx().zzAU();
        }
        return this.zzXC6;
    }

    static final class zzS {
        private zzWH zzYog;
        private zzWH zzXmI;

        public zzS(zzWH zzWH2, zzWH zzWH3) {
            this.zzYog = zzWH2;
            this.zzXmI = zzWH3;
        }

        public final zzWH zzZko() {
            return this.zzYog;
        }

        public final zzWH zzZZS() {
            return this.zzXmI;
        }
    }
}

