/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzLR;
import com.aspose.words.internal.zzQd;
import com.aspose.words.internal.zzWym;
import com.aspose.words.internal.zzX9p;
import com.aspose.words.internal.zzXaN;
import com.aspose.words.internal.zzYBU;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzX1w;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zz6j = new HashMap();
    private static HashMap<Integer, Integer> zzZfT = new HashMap();
    private static HashMap<Integer, Integer> zzZ0l = new HashMap();
    private static HashMap<Integer, Integer> zzZqO = new HashMap();
    private static HashMap<Integer, Integer> zzWzj = new HashMap();
    private static HashMap<Integer, Integer> zzW4N = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzWym.zziY(fileName, "fileName");
        try (zzXaN zzXaN2 = zzWym.zzYpX(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzVU6(zzXaN2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzVU6(zzYBU.zzS(stream));
    }

    static FileFormatInfo zzVU6(zzLR zzLR2) throws Exception {
        if (zzLR2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzX1w zzX1w2 = new zzX1w();
            zzLR zzLR3 = zzLR2;
            zzX1w zzX1w3 = zzX1w2;
            return zzX1w2.zzDW(zzLR3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zziY(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzqn(zzX9p.zzYjs(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzmm(zzX9p.zzYjs(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzQd.zzWq4(string = zzX9p.zzuW(FileFormatUtil.zzW7Z(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzqn(FileFormatUtil.zzXx9(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzmm(FileFormatUtil.zzW7Z(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzX9p.zzuW(FileFormatUtil.zzXx9(saveFormat));
        if (zzQd.zzWq4(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzmm(zzX9p.zzXeC(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzX9p.zzuW(FileFormatUtil.zzYZI(imageType));
    }

    static Exception zziY(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzXLq(int n) {
        return zzX9p.toString(FileFormatUtil.zzXx9(n));
    }

    static int zzmm(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWym.zzS(zzWzj, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzZ4v(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWym.zzS(zzW4N, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzYmt(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzW7Z(int n) {
        return zzWym.zzS(zz6j, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzXx9(int n) {
        return zzWym.zzS(zzZfT, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYZI(int n) {
        return zzWym.zzS(zzZ0l, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzqn(int n) {
        return zzWym.zzS(zzZqO, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzh5(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzWym.zzDW(zzWzj, Integer.valueOf(n), Integer.valueOf(n2));
            zzWym.zzDW(zzZfT, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZqO.containsKey(n)) {
                zzWym.zzDW(zzZqO, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzWym.zzDW(zz6j, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzWym.zzDW(zzW4N, Integer.valueOf(n), Integer.valueOf(n4));
            zzWym.zzDW(zzZ0l, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzh5(13, 10, 10, 1);
        FileFormatUtil.zzh5(13, 0, 0, 1);
        FileFormatUtil.zzh5(14, 11, 11, 1);
        FileFormatUtil.zzh5(15, 20, 20, 1);
        FileFormatUtil.zzh5(15, 0, 254, 1);
        FileFormatUtil.zzh5(16, 21, 21, 1);
        FileFormatUtil.zzh5(17, 22, 22, 1);
        FileFormatUtil.zzh5(18, 23, 23, 1);
        FileFormatUtil.zzh5(20, 24, 24, 1);
        FileFormatUtil.zzh5(21, 25, 25, 1);
        FileFormatUtil.zzh5(22, 26, 26, 1);
        FileFormatUtil.zzh5(23, 27, 27, 1);
        FileFormatUtil.zzh5(26, 30, 30, 1);
        FileFormatUtil.zzh5(19, 31, 31, 1);
        FileFormatUtil.zzh5(27, 50, 50, 1);
        FileFormatUtil.zzh5(28, 45, 255, 1);
        FileFormatUtil.zzh5(29, 51, 51, 1);
        FileFormatUtil.zzh5(30, 54, 52, 1);
        FileFormatUtil.zzh5(31, 0, 53, 1);
        FileFormatUtil.zzh5(33, 53, 54, 1);
        FileFormatUtil.zzh5(24, 60, 60, 1);
        FileFormatUtil.zzh5(25, 61, 61, 1);
        FileFormatUtil.zzh5(36, 40, 64, 1);
        FileFormatUtil.zzh5(43, 47, 255, 1);
        FileFormatUtil.zzh5(44, 48, 255, 1);
        FileFormatUtil.zzh5(37, 41, 255, 1);
        FileFormatUtil.zzh5(38, 46, 255, 1);
        FileFormatUtil.zzh5(40, 42, 255, 1);
        FileFormatUtil.zzh5(39, 44, 255, 1);
        FileFormatUtil.zzh5(32, 52, 55, 1);
        FileFormatUtil.zzh5(34, 70, 62, 1);
        FileFormatUtil.zzh5(35, 73, 63, 1);
        FileFormatUtil.zzh5(41, 71, 255, 1);
        FileFormatUtil.zzh5(8, 100, 255, 1);
        FileFormatUtil.zzh5(9, 105, 255, 1);
        FileFormatUtil.zzh5(6, 101, 255, 6);
        FileFormatUtil.zzh5(7, 102, 255, 7);
        FileFormatUtil.zzh5(5, 104, 255, 5);
        FileFormatUtil.zzh5(4, 0, 255, 4);
        FileFormatUtil.zzh5(3, 0, 255, 3);
        FileFormatUtil.zzh5(42, 72, 255, 1);
        FileFormatUtil.zzh5(2, 103, 255, 2);
        FileFormatUtil.zzh5(10, 106, 255, 8);
        FileFormatUtil.zzh5(48, 80, 255, 1);
        FileFormatUtil.zzh5(11, 107, 255, 9);
    }
}

