/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzLR;
import com.aspose.words.internal.zzYQz;
import com.aspose.words.zzWVz;
import java.io.InputStream;
import java.io.OutputStream;

public class Merger {
    private Merger() {
    }

    public static void merge(String outputFile, String[] inputFiles) throws Exception {
        Merger.merge(outputFile, inputFiles, SaveOptions.createSaveOptions(outputFile), 1);
    }

    public static void merge(String outputFile, String[] inputFiles, int saveFormat, int mergeFormatMode) throws Exception {
        Merger.merge(outputFile, inputFiles, SaveOptions.createSaveOptions(saveFormat), mergeFormatMode);
    }

    public static void merge(String outputFile, String[] inputFiles, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Document document = Merger.merge(inputFiles, mergeFormatMode);
        if (document.getOriginalLoadFormat() == 64 && !saveOptions.zzYAx()) {
            document.updatePageLayout();
        }
        document.save(outputFile, saveOptions);
    }

    public static Document merge(String[] inputFiles, int mergeFormatMode) throws Exception {
        Document document = null;
        String[] stringArray = inputFiles;
        int n = inputFiles.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (document == null) {
                document = new Document(string);
                continue;
            }
            if (mergeFormatMode == 2) {
                Document[] documentArray = new Document[]{new Document(string)};
                Document document2 = document;
                zzWVz.zzS(document2, documentArray);
                continue;
            }
            document.appendDocument(new Document(string), Merger.zzWR5(mergeFormatMode));
        }
        return document;
    }

    public static Document merge(Document[] inputDocuments, int mergeFormatMode) throws Exception {
        return Merger.zzS(inputDocuments, mergeFormatMode);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, int saveFormat) throws Exception {
        int n = saveFormat;
        zzLR[] zzLRArray = zzLR.zzS(inputStreams);
        zzYQz zzYQz2 = zzLR.zziY(outputStream);
        Merger.zzS(zzYQz2, zzLRArray, n);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        int n = mergeFormatMode;
        SaveOptions saveOptions2 = saveOptions;
        zzLR[] zzLRArray = zzLR.zzS(inputStreams);
        zzYQz zzYQz2 = zzLR.zziY(outputStream);
        Merger.zzS(zzYQz2, zzLRArray, saveOptions2, n);
    }

    public static Document merge(InputStream[] inputStreams, int mergeFormatMode) throws Exception {
        int n = mergeFormatMode;
        zzLR[] zzLRArray = zzLR.zzS(inputStreams);
        return Merger.zzS(zzLRArray, n);
    }

    private static Document zzS(Document[] documentArray, int n) throws Exception {
        if (documentArray == null || documentArray.length == 0) {
            return null;
        }
        Document document = documentArray[0].deepClone();
        for (int i = 1; i < documentArray.length; ++i) {
            if (n == 2) {
                Document[] documentArray2 = new Document[]{documentArray[i]};
                Document document2 = document;
                zzWVz.zzS(document2, documentArray2);
                continue;
            }
            document.appendDocument(documentArray[i], Merger.zzWR5(n));
        }
        return document;
    }

    private static void zzS(zzLR zzLR2, zzLR[] zzLRArray, int n) throws Exception {
        Merger.zzS(zzLR2, zzLRArray, SaveOptions.createSaveOptions(n), 1);
    }

    private static void zzS(zzLR zzLR2, zzLR[] zzLRArray, SaveOptions saveOptions, int n) throws Exception {
        Document document = Merger.zzS(zzLRArray, n);
        if (document.getOriginalLoadFormat() == 64 && !saveOptions.zzYAx()) {
            document.updatePageLayout();
        }
        document.zzYjG(zzLR2, saveOptions.getSaveFormat());
    }

    private static Document zzS(zzLR[] zzLRArray, int n) throws Exception {
        Document document = null;
        zzLR[] zzLRArray2 = zzLRArray;
        int n2 = zzLRArray.length;
        for (int i = 0; i < n2; ++i) {
            zzLR zzLR2 = zzLRArray2[i];
            if (document == null) {
                document = new Document(zzLR2);
                continue;
            }
            if (n == 2) {
                Document[] documentArray = new Document[]{new Document(zzLR2)};
                Document document2 = document;
                zzWVz.zzS(document2, documentArray);
                continue;
            }
            document.appendDocument(new Document(zzLR2), Merger.zzWR5(n));
        }
        return document;
    }

    private static int zzWR5(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 1;
    }
}

