/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWym;
import com.aspose.words.internal.zzXtc;
import com.aspose.words.internal.zzZzN;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzFf;
import com.aspose.words.zzWEs;
import com.aspose.words.zzX4s;
import com.aspose.words.zzXwu;
import com.aspose.words.zzY0K;
import com.aspose.words.zzZnM;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzYkV;
    private Node zzZMz;
    private Node zzWvA;
    private int zzYQX;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zziY(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYkV == null) {
            return null;
        }
        if (this.zzYkV.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzYkV;
    }

    final CompositeNode zzXTR() {
        if (zzXwu.zzVYD(this.getParentNode())) {
            return this.getParentNode().zzXTR();
        }
        return this.getParentNode();
    }

    final CompositeNode zzZ92() {
        if (zzXwu.zzVYD(this.getParentNode()) || zzXwu.zzVXS(this.getParentNode())) {
            return this.getParentNode().zzZ92();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzYkV != null) {
            return this.zzYkV.getDocument();
        }
        return null;
    }

    final Document zzYwr() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzWVo() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzW6X();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzWvA;
    }

    final Node zzWlS() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzXwu.zzWHM((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzYqo() {
        Node node = zzXwu.zzYH9(this.getPreviousSibling(), false);
        if (node == null && zzXwu.zzVYD(this.getParentNode())) {
            node = this.getParentNode().zzYqo();
        }
        return node;
    }

    final Node zzZAF() {
        Node node = zzXwu.zzYR3(this.getNextSibling(), false);
        if (node == null && zzXwu.zzVYD(this.getParentNode())) {
            node = this.getParentNode().zzZAF();
        }
        return node;
    }

    final CompositeNode zzXkk() {
        Node node = this;
        while ((node = node.zzYqo()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzWtn() {
        Node node = this;
        while ((node = node.zzZAF()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzZMz;
    }

    final Node zzZkB() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzXwu.zzWHM((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzYlx() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXSz() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZHA() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzXwu.zzXzT(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzYtp() {
        return this.zzZMz;
    }

    final void zzdl(Node node) {
        this.zzZMz = node;
    }

    final Node zzZvL() {
        return this.zzWvA;
    }

    final void zzX5O(Node node) {
        this.zzWvA = node;
    }

    final Node zzVXt() {
        Node node = this;
        if (node.zzZMz != null) {
            node = this;
            return node.zzZMz;
        }
        return this.getParentNode();
    }

    final int zzZ2H() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzXwu.zzXeC(this);
        boolean bl2 = zzXwu.zzXYA(this);
        boolean bl3 = zzXwu.zzYjs(this);
        boolean bl4 = zzXwu.zzuf(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzZ2H() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzZ2H() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzS(isCloneChildren, new zzS(this));
    }

    Node zzS(boolean bl, zzZnM zzZnM2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYkV != null) {
            node.zzYkV = this.getDocument().zzZvF();
        }
        node.zzZMz = null;
        node.zzWvA = null;
        if (zzZnM2 != null) {
            zzZnM2.zz2E(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzZvA(StringBuilder stringBuilder) {
        zzWym.zzDW(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    final zzY0K zzWhp() {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            zzY0K zzY0K2 = zzWym.zzS((Object)compositeNode, zzY0K.class);
            if (zzY0K2 == null) continue;
            return zzY0K2;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZJH(Node node) {
        this.zzYkV = node != null ? node : this.getDocument().zzZvF();
    }

    final void zziY(DocumentBase documentBase) {
        this.zzYkV = documentBase != null ? documentBase.zzZvF() : null;
    }

    final boolean zzXo4(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzZuA() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzYBu(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWYV(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzZvA(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzWql(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzYtr(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final Node zzAm(Node node) {
        return this.getParentNode().insertAfter(node, this);
    }

    final void zzZB3(Node node, Node node2) {
        this.getParentNode().zzDW(node, node2, this);
    }

    final Node zzZuf(Node node) {
        return this.getParentNode().insertBefore(node, this);
    }

    final void zzZX4(Node node, Node node2) {
        this.getParentNode().zzS(node, node2, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzX4s zzX4s2 = zzXwu.zzZbM(saveFormat);
        return zzX4s2.zzWpm(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzX4s zzX4s2 = zzXwu.zzDW(saveOptions);
        return zzX4s2.zzWpm(this);
    }

    final Node zzEn(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzXwu.zzXCD(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzFf zzZAH() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzFf.zzW0t(node);
        }
        return zzFf.zzZHh(this.getParentNode());
    }

    final zzFf zzYYF() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzFf.zzZHh(node);
        }
        return zzFf.zzW0t(this.getParentNode());
    }

    final boolean zzZCG(Node node) {
        return Node.zzZHh(this, node);
    }

    final boolean zzWnQ() {
        return this.getAncestor(1) == null;
    }

    static Node zzYfO(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzXtc<Node> zzXtc2 = Node.zzZw5(node);
        zzXtc<Node> zzXtc3 = Node.zzZw5(node2);
        return Node.zzS(zzXtc2, zzXtc3);
    }

    static boolean zzZHh(Node node, Node node2) {
        zzXtc<Node> zzXtc2;
        if (node == null || node2 == null) {
            return false;
        }
        zzXtc<Node> zzXtc3 = Node.zzZw5(node);
        Node node3 = Node.zzS(zzXtc3, zzXtc2 = Node.zzZw5(node2));
        if (node3 == null) {
            return false;
        }
        zzXtc<Node> zzXtc4 = zzXtc3;
        if (zzXtc4.size() == 0 || (zzXtc4 = zzXtc2).size() == 0) {
            zzXtc4 = zzXtc2;
            boolean bl = zzXtc4.size() > 0;
            return bl;
        }
        Object e = zzXtc3.peek();
        Object e2 = zzXtc2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzXtc<Node> zzZw5(Node node) {
        zzXtc<Node> zzXtc2 = new zzXtc<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzXtc2.push(node2);
        }
        return zzXtc2;
    }

    private static Node zzS(zzXtc<Node> zzXtc2, zzXtc<Node> zzXtc3) {
        Node node = null;
        while (zzXtc2.peek() == zzXtc3.peek()) {
            node = (Node)zzXtc2.pop();
            zzXtc3.pop();
            zzXtc<Node> zzXtc4 = zzXtc2;
            if (zzXtc4.size() != 0 && (zzXtc4 = zzXtc3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzYQX;
    }

    public void setCustomNodeId(int value) {
        this.zzYQX = value;
    }

    private String zzZA9() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzWym.zzS(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzZzN.zzYqW(stringBuilder.toString());
    }

    public String toString() {
        return zzZzN.zzYqW(zzZzN.zzDW("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzZA9()));
    }

    public void dd() {
    }

    final Node zzXzT(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzYxj(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzXS8(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzYxj(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzYxj(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzS
    implements zzZnM {
        private Node zzWep;
        private HashMap<Integer, Integer> zzVXV;

        zzS(Node node) {
            this.zzWep = node;
        }

        @Override
        public final void zz2E(Node node, Node node2) {
            if (node == this.zzWep) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzWEs zzWEs2 = (zzWEs)((Object)node2);
            if (this.zzVXV == null) {
                this.zzVXV = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzWym.zzS(this.zzVXV, Integer.valueOf(zzWEs2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzWLy();
                zzWym.zzDW(this.zzVXV, Integer.valueOf(zzWEs2.getIdInternal()), Integer.valueOf(n));
            }
            zzWEs2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzWym.zzS(this.zzVXV, Integer.valueOf(zzWEs2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzWEs2.setParentIdInternal(n2);
            }
        }
    }
}

