/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzYBU;
import com.aspose.words.zzNq;
import com.aspose.words.zzSf;
import com.aspose.words.zzX9i;
import com.aspose.words.zzZ5C;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZ5C,
Iterable<T> {
    private Node zzVVc;
    private CompositeNode zzY5G;
    private DocumentBase zzWqe;
    private boolean zzWbl;
    private int zzn5;
    private int zzZTw;
    private Node zzY3p;
    private int zzY2d;
    private zzX9i zzPB;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzSf.zzZpv(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzSf(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzX9i matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: container");
        }
        if (matcher == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: matcher");
        }
        this.zzY5G = container;
        this.zzWqe = container.getDocument();
        this.zzPB = matcher;
        this.zzWbl = isDeep;
        this.zzZS2();
    }

    public Node get(int index) {
        try {
            this.zzVUN();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzZTw == index) {
                return this.zzY3p;
            }
            int n = index - this.zzZTw;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzWaM(nodeCollection.zzY3p, n);
            if (node != null) {
                this.zzZTw = index;
                this.zzY3p = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzWbl) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzY5G.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzWbl) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzY5G.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzZtE();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzNq(this);
    }

    final <TNode extends Node> zzNq<TNode> zzSd() {
        return new zzNq(this);
    }

    final ArrayList<Node> zzX7U() {
        return this.zzZtE();
    }

    final <TValue extends Node> ArrayList<TValue> zzZtE() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzYBU.zzS(arrayList, node);
        }
        return arrayList;
    }

    private Node zzWaM(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZww(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzZWL(curNode, true);
    }

    private Node zzZWL(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzVVc = node;
        do {
            node2 = this.zzVVc;
            Node node3 = this.zzWbl ? this.zzS(true, this.zzVVc) : (this.zzVVc = this.zzPB.zzYZY() ? this.zziY(true, this.zzVVc) : this.zzDW(true, this.zzVVc));
        } while (this.zzVVc != null && !this.zzPB.zzZSY(this.zzVVc));
        return node2;
    }

    private Node zzZww(Node node, boolean bl) throws Exception {
        while ((this.zzWbl ? this.zzS(bl, node) : (node = this.zzPB.zzYZY() ? this.zziY(bl, node) : this.zzDW(bl, node))) != null && !this.zzPB.zzZSY(node)) {
        }
        return node;
    }

    private Node zzS(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzY5G);
        }
        return node.previousPreOrder(this.zzY5G);
    }

    private Node zzDW(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzY5G) {
                return this.zzY5G.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzY5G) {
            return this.zzY5G.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zziY(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzY5G ? this.zzY5G.zzXAS() : node.zzZAF();
        } else {
            Node node3 = node2 = node == this.zzY5G ? this.zzY5G.zzZbQ() : node.zzYqo();
        }
        if (node2 == this.zzY5G.getNextSibling() || node2 == this.zzY5G.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzVUN() {
        if (this.zzn5 != this.zzXBF()) {
            this.zzZS2();
        }
    }

    private void zzZS2() {
        this.zzn5 = this.zzXBF();
        this.zzZTw = -1;
        this.zzY3p = this.zzY5G;
        this.zzY2d = -1;
    }

    private int zzXBF() {
        if (this.zzWqe != null) {
            return this.zzWqe.zzTC();
        }
        return 0;
    }

    public int getCount() {
        this.zzVUN();
        if (this.zzY2d == -1) {
            this.zzY2d = zzNq.zzS(this);
        }
        return this.zzY2d;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzVVc;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzY5G;
    }
}

