/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzX9p;
import com.aspose.words.internal.zzY6R;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzjH;
    private boolean zzWTI;
    boolean zzYa = true;
    private boolean zzTb = true;
    private boolean zzYFf = false;
    private boolean zz23;
    private boolean zzZCW = true;
    private boolean zzVWU;
    private String zzXXF;
    private boolean zzj3;
    private boolean zzWLH = false;
    private int zzEW = 1;
    private int zzZJz = 1;
    private int zzyH = 0;
    private String zzXAi = "";
    private boolean zzXGq = true;
    private boolean zzXd8 = true;
    private boolean zzR3;
    private boolean zzZaC;
    private int zzRY = 0;
    private boolean zzXb6 = true;
    private boolean zzYP8 = false;

    protected SaveOptions() {
    }

    final boolean zzYPA() {
        return this.zz23;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzYTu() {
        return false;
    }

    boolean zzYAx() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzZCW;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzZCW = value;
    }

    public String getTempFolder() {
        return this.zzXXF;
    }

    public void setTempFolder(String value) {
        this.zzXXF = value;
    }

    public boolean getPrettyFormat() {
        return this.zzVWU;
    }

    public void setPrettyFormat(boolean value) {
        this.zzVWU = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzj3;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzj3 = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWLH;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWLH = value;
    }

    public int getDmlRenderingMode() {
        return this.zzEW;
    }

    public void setDmlRenderingMode(int value) {
        this.zzEW = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzyH;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzyH = value;
    }

    public int getImlRenderingMode() {
        return this.zzZJz;
    }

    public void setImlRenderingMode(int value) {
        this.zzZJz = value;
    }

    public String getDefaultTemplate() {
        return this.zzXAi;
    }

    public void setDefaultTemplate(String value) {
        this.zzXAi = value;
    }

    public boolean getUpdateFields() {
        return this.zzXGq;
    }

    public void setUpdateFields(boolean value) {
        this.zzXGq = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzR3;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzR3 = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZaC;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZaC = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYP8;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYP8 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYFf;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYFf = value;
    }

    final boolean zzvI() {
        return this.zzXd8;
    }

    final boolean zzZ8v() {
        return this.zzXb6;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzmm(zzX9p.zzXeC(zzY6R.zzW9J(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzRY;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzRY = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzjH;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzjH = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzWTI;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzWTI = value;
    }

    final boolean zzXBn() {
        return this.zzTb;
    }

    final void zzX6C(boolean bl) {
        this.zzTb = false;
    }
}

