/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzWym;
import com.aspose.words.internal.zzZzN;
import com.aspose.words.zzXM2;
import com.aspose.words.zzXnL;
import com.aspose.words.zzZnM;

public final class Section
extends CompositeNode<Node>
implements zzXnL {
    private zzXM2 zz2I;
    private PageSetup zzWsE;
    private HeaderFooterCollection zzXNV;

    public Section(DocumentBase doc) {
        this(doc, new zzXM2());
    }

    Section(DocumentBase doc, zzXM2 sectPr) {
        super(doc);
        this.zz2I = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzXNV == null) {
            this.zzXNV = new HeaderFooterCollection(this);
        }
        return this.zzXNV;
    }

    public final PageSetup getPageSetup() {
        if (this.zzWsE == null) {
            Section section = this;
            this.zzWsE = new PageSetup(section, section.getDocument().zzXfy(), this.getDocument().getStyles(), new zzS(this));
        }
        return this.zzWsE;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzWlH();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzcj(!value);
    }

    final zzXM2 zzX66() {
        return this.zz2I;
    }

    final void zzDW(zzXM2 zzXM22) {
        this.zz2I = zzXM22;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzS(boolean bl, zzZnM zzZnM2) {
        zzXM2 zzXM22;
        Section section = (Section)super.zzS(bl, zzZnM2);
        zzXM2 zzXM23 = this.zz2I;
        section.zz2I = zzXM22 = (zzXM2)zzXM23.zzWvW();
        section.zzWsE = null;
        section.zzXNV = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zz2E(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zz2E(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzWIG(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzYVq(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzWIG(n) == null;
            }
        }
        return false;
    }

    final void zziY(Shape shape, boolean bl) throws Exception {
        this.zzS(shape, 4, bl);
        this.zzS(shape, 0, bl);
        this.zzS(shape, 1, bl);
    }

    private void zzS(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzW3N());
        shape2.setName(zzZzN.zzDW("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzXRa() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzWmb()) {
                if (!shape.zzWKg()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zz2E(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzDW(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zz2I.zzYGg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzXfy().zzkN.zzYZx(key);
        }
        return zzXM2.zzvx(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zz2I.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzXfy().zzkN.zzYH9(key, value);
            return;
        }
        this.zz2I.zzYH9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zz2I.clear();
    }

    final boolean zzXGX() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zznd() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zz2I.getSectionStart());
        return zzZzN.zzDW("{0} {1}", objectArray);
    }

    static final class zzS
    implements zzXnL {
        private Section zzFc;

        zzS(Section section) {
            this.zzFc = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzYrv().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzYrv().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzYrv().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzXnL zzYrv() {
            Document document = zzWym.zzS((Object)this.zzFc.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzFc;
        }
    }
}

