/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzQd;
import com.aspose.words.internal.zzWym;
import com.aspose.words.internal.zzXE3;
import com.aspose.words.internal.zzY2s;
import com.aspose.words.internal.zzYSV;
import com.aspose.words.internal.zzZzN;
import com.aspose.words.zzXtP;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzmj;
    private zzXtP zzZYo;

    Watermark(Document doc, zzXtP watermarkProvider) {
        this.zzmj = doc;
        this.zzZYo = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzX3l(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzS(text, textWatermarkOptions, this.zzmj);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzWym.zzDW((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzmj, 75);
        shape.getImageData().setImage(image);
        this.zzS(shape, options, this.zzmj);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzWym.zzDW((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzmj, 75);
        shape.getImageData().setImage(imagePath);
        this.zzS(shape, options, this.zzmj);
    }

    public final int getType() {
        Shape shape = this.zzZYo.get();
        if (shape == null) {
            return 2;
        }
        shape.zzWKg();
        if (shape.zzZSs()) {
            return 0;
        }
        if (shape.zzZz()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzZYo.add(shape);
    }

    public final void remove() {
        this.zzZYo.remove();
    }

    private static void zzX3l(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzQd.zzZi6(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzWym.zzS(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzS(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzDW(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzWCy(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzDW(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzWOF() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzWpU()) / d2) > (double)(f = pageSetup.zzWlh())) {
            d = (double)f / d3;
        }
        shape.zzZhc(zzY2s.zziY(d2 * d, 2, 1));
        shape.zzXQE(zzY2s.zziY(d3 * d, 2, 1));
    }

    private Shape zzS(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzS(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzWCy(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzS(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzXF8() ? 1.0f : textWatermarkOptions.getFontSize();
        zzYSV zzYSV2 = document.zzWRT().zziY(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzYSV2.zzVWc(shape.getTextPath().getText());
        if (textWatermarkOptions.zzXF8()) {
            l = Watermark.zzS(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZhc(zzY2s.zziY(Float.intBitsToFloat(n), 2, 1));
        shape.zzXQE(zzY2s.zziY(zzXE3.zz35(l), 2, 1));
    }

    private static long zzS(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzWpU();
        float f2 = pageSetup.zzWlh();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzXE3.zz35(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzXE3.zzXVL(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzXE3.zz35(l) >= Float.intBitsToFloat(n)) {
            return zzXE3.zzXVL(f2 / f3, f2);
        }
        float f6 = f;
        return zzXE3.zzXVL(f6, f6 * f3);
    }

    private static void zzWCy(Shape shape, String string) {
        shape.setName(zzZzN.zzDW("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

