/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzKi;
import com.aspose.words.internal.zzVXH;
import com.aspose.words.internal.zzX6F;
import com.aspose.words.internal.zzXRj;
import com.aspose.words.internal.zzXmK;
import com.aspose.words.internal.zzYHB;
import com.aspose.words.internal.zzYND;
import com.aspose.words.internal.zzZLw;
import com.aspose.words.internal.zzZpR;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzY9P
extends CertPathBuilderSpi {
    private final zzZpR zzXHd;
    private zzVXH zzZWt;

    zzY9P(zzZpR zzZpR2) {
        this.zzXHd = zzZpR2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzX6F pkixParams;
        if (params instanceof zzX6F) {
            pkixParams = (zzX6F)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzX6F.zzS((PKIXBuilderParameters)params).zzyS();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzX6F.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzYND zzYND2 = pkixParams.zzZWF().zzWKn();
        try {
            collection = zzZLw.zzS(zzYND2, pkixParams.zzZWF().zzZuV());
            collection.addAll(zzZLw.zzS(zzYND2, pkixParams.zzZWF().zzLL()));
        }
        catch (zzVXH zzVXH2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzVXH2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzS(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzZWt != null) {
            throw new CertPathBuilderException(this.zzZWt.getMessage(), this.zzZWt.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzS(X509Certificate x509Certificate, zzX6F zzX6F2, List list) throws CertPathBuilderException {
        zzXRj zzXRj2;
        zzKi zzKi2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzX6F2.zzX6B().contains(x509Certificate)) {
            return null;
        }
        if (zzX6F2.zzOk() != -1 && list.size() - 1 > zzX6F2.zzOk()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzKi2 = new zzKi(this.zzXHd);
            zzXRj2 = new zzXRj(this.zzXHd);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZLw.zzS(x509Certificate, zzX6F2.zzZWF().zzVS5(), zzX6F2.zzZWF().zzW6m()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzKi2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzVXH("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzXRj2.engineValidate(certPath, zzX6F2);
                }
                catch (Exception exception) {
                    throw new zzVXH("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzXmK> arrayList = new ArrayList<zzXmK>();
            arrayList.addAll(zzX6F2.zzZWF().zzZuV());
            try {
                arrayList.addAll(zzZLw.zzS(x509Certificate.getExtensionValue(zzYHB.zzZJs.getId()), zzX6F2.zzZWF().zznT()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzVXH("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZLw.zzS(x509Certificate, zzX6F2.zzZWF().zzLL(), arrayList));
            }
            catch (zzVXH zzVXH2) {
                throw new zzVXH("Cannot find issuer certificate for certificate in certification path.", zzVXH2);
            }
            if (hashSet.isEmpty()) {
                throw new zzVXH("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzS(x509Certificate2, zzX6F2, list);
            }
        }
        catch (zzVXH zzVXH3) {
            this.zzZWt = zzVXH3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

