/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZzN;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzZ0i = new ArrayList();
    private final Map<String, DataColumn> zzWuZ = new HashMap<String, DataColumn>();
    private DataTable zzWyY;

    DataColumnCollection(DataTable table) {
        this.zzWyY = table;
    }

    public void add(DataColumn column) {
        if (zzZzN.zzYn8(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzYLD(column.getColumnName());
        if (this.zzWuZ.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zz2E(this.zzWyY);
        column.setOrdinal(this.zzZ0i.size());
        this.zzZ0i.add(column);
        this.zzWuZ.put(string, column);
        this.zzWyY.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWyY);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWyY);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzZzN.zzYn8(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzYLD(columnName);
        DataColumn dataColumn = this.zzWuZ.get(string);
        if (dataColumn != null) {
            int n = this.zzZ0i.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzZ0i.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzZ0i.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzZ0i.remove(n);
            this.zzWuZ.remove(DataColumnCollection.zzYLD(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzWyY.getRows()) {
                dataRow.remove(n);
            }
            this.zzWyY.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzZ0i.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzZ0i.iterator();
    }

    public void clear() {
        this.zzWuZ.clear();
        this.zzZ0i.clear();
    }

    final DataColumn[] zzXU5() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzZ0i);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzS(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzZ0i.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzZ0i.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzYLD(string);
            String string3 = DataColumnCollection.zzYLD(dataColumn.getColumnName());
            this.zzWuZ.remove(string3);
            this.zzWuZ.put(string2, dataColumn);
            return;
        }
    }

    private static String zzYLD(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

