/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZzN;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzZlZ;

public class DataRelation {
    private DataKey zzWDZ;
    private DataKey zzYeW;
    private String zzXU8;
    private String zzZxm;
    private String zzYP3;
    private String[] zzVSR;
    private String[] zzWAO;
    private DataColumn[] zzYMS;
    private DataColumn[] zzZ30;
    private UniqueConstraint zzWMW;
    private ForeignKeyConstraint zzZq8;
    private boolean zzVW4 = true;
    private DataSet zzXFB;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        DataColumn[] dataColumnArray = DataRelation.zzDW(parentTable, parentColumnNames);
        DataColumn[] dataColumnArray2 = DataRelation.zzDW(childTable, childColumnNames);
        this.zzS(relationName, dataColumnArray, dataColumnArray2, true);
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        this.zzS(relationName, parentColumns, childColumns, createConstraints);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    private static DataColumn[] zzDW(DataTable dataTable, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Column names need to have at least one column name.");
        }
        if (dataTable == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        DataColumn[] dataColumnArray = new DataColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DataColumn dataColumn = dataTable.getColumns().get(stringArray[i]);
            if (dataColumn == null) {
                throw new IllegalArgumentException(zzZzN.zzDW("The given column {0} does not exist in {1}", stringArray[i], dataTable.getTableName()));
            }
            dataColumnArray[i] = dataColumn;
        }
        return dataColumnArray;
    }

    private void zzS(String string, DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, boolean bl) {
        int n;
        DataColumn dataColumn;
        int n2;
        if (dataColumnArray == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        if (dataColumnArray2 == null) {
            throw new IllegalArgumentException("childColumns");
        }
        if (dataColumnArray.length != dataColumnArray2.length) {
            throw new IllegalArgumentException("Key Length mismatch");
        }
        DataTable dataTable = dataColumnArray[0].getTable();
        DataTable dataTable2 = dataColumnArray2[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            if (dataColumnArray[i].getTable().getDataSet() != null && dataColumnArray2[i].getTable().getDataSet() != null) continue;
            throw new IllegalArgumentException("Parent or Child columns do not have DataSet");
        }
        DataColumn[] dataColumnArray3 = dataColumnArray;
        int n3 = dataColumnArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray3 = dataColumnArray2;
        n3 = dataColumnArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < dataColumnArray2.length; ++n) {
            if (dataColumnArray[n].zziY(dataColumnArray2[n])) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzYMS = dataColumnArray;
        this.zzZ30 = dataColumnArray2;
        this.zzXU8 = string == null ? "" : string;
        this.zzVW4 = bl;
        this.zzYeW = new DataKey(dataColumnArray, true);
        this.zzWDZ = new DataKey(dataColumnArray2, true);
        this.zzXFB = dataTable.getDataSet();
        this.zzVSR = new String[this.zzYMS.length];
        for (n = 0; n < this.zzYMS.length; ++n) {
            this.zzVSR[n] = this.zzYMS[n].getColumnName();
        }
        this.zzWAO = new String[this.zzZ30.length];
        for (n = 0; n < this.zzZ30.length; ++n) {
            this.zzWAO[n] = this.zzZ30[n].getColumnName();
        }
    }

    public String getRelationName() {
        return this.zzXU8;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        return this.getParentKey().getTable();
    }

    public DataTable getChildTable() {
        return this.getChildKey().getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzVSR;
    }

    public String[] getChildColumnNames() {
        return this.zzWAO;
    }

    public DataColumn[] getParentColumns() {
        return this.zzYMS;
    }

    public DataColumn[] getChildColumns() {
        return this.zzZ30;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzWMW;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzWMW = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzZq8;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzZq8 = childKeyConstraint;
    }

    public DataKey getChildKey() {
        return this.zzWDZ;
    }

    public DataKey getParentKey() {
        return this.zzYeW;
    }

    public DataSet getDataSet() {
        return this.zzXFB;
    }

    public int hashCode() {
        int n = 31 + this.zzXU8.hashCode();
        n = n * 31 + this.zzZxm.hashCode();
        n = n * 31 + this.zzYP3.hashCode();
        for (int i = 0; i < this.zzVSR.length; ++i) {
            n = n * 31 + this.zzVSR[i].hashCode();
            n = n * 31 + this.zzWAO[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    static DataRow[] zzS(DataKey dataKey, DataKey dataKey2, DataRow dataRow) {
        Object[] objectArray = dataRow.getKeyValues(dataKey2);
        if (DataRelation.zzYt(objectArray)) {
            return new DataRow[0];
        }
        zzZlZ zzZlZ2 = dataKey.getSortIndex();
        return zzZlZ2.zzYR3(objectArray);
    }

    private static boolean zzYt(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray2[i];
            if (DataRelation.zzZk2(object)) continue;
            return false;
        }
        return true;
    }

    private static boolean zzZk2(Object object) {
        return object == null || DBNull.Value == object;
    }

    final void zzYHC() throws InvalidConstraintException, DataException {
        if (!this.zzVW4) {
            return;
        }
        DataRelation dataRelation = this;
        ForeignKeyConstraint foreignKeyConstraint = dataRelation.zziY(dataRelation.getChildTable().getConstraints());
        DataRelation dataRelation2 = this;
        UniqueConstraint uniqueConstraint = dataRelation2.zzDW(dataRelation2.getParentTable().getConstraints());
        if (uniqueConstraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private UniqueConstraint zzDW(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof UniqueConstraint)) continue;
            UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
            if (!DataRelation.zzS(this.getParentColumns(), uniqueConstraint.getColumns())) continue;
            return uniqueConstraint;
        }
        return null;
    }

    private ForeignKeyConstraint zziY(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)constraint;
            if (!DataRelation.zzS(this.getChildColumns(), foreignKeyConstraint.getColumns()) || !DataRelation.zzS(this.getParentColumns(), foreignKeyConstraint.getRelatedColumns())) continue;
            return foreignKeyConstraint;
        }
        return null;
    }

    private static boolean zzS(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

