/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzO7;
import com.aspose.words.internal.zzXSq;
import com.aspose.words.internal.zzYBU;
import com.aspose.words.internal.zzYE2;
import com.aspose.words.internal.zzZzN;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zz2E;
import com.aspose.words.net.System.Data.zzDW;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzWyY;
    private Object[] zzzW;
    private int zzjq = 1;
    private int zzYAR;
    private String zzVZs;
    private Map<String, Object> zzZab = new HashMap<String, Object>();
    private Map<String, String> zzWcX = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzWyY = table;
        this.zzzW = new Object[table.getColumns().getCount()];
        Arrays.fill(this.zzzW, DBNull.Value);
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzDW.zziY(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzWyY.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzWyY.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzWyY;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzWyY.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzWyY.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzWyY.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzWyY.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzWyY.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzWyY.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzWyY) {
            throw new IllegalStateException(zzZzN.zzDW("Table {0} is not the child table in the relation {1}", this.zzWyY.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzS(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzXKZ(columnIndex, value);
        this.zzWyY.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzWyY.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzjq;
    }

    public void setRowState(int state) {
        this.zzjq = state;
    }

    public void delete() {
        zz2E.zzDW(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzZab.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzZab.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzzW.length];
        System.arraycopy(this.zzzW, 0, objectArray, 0, this.zzzW.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzzW.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzzW.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzXKZ(i, array[i]);
        }
        this.zzWyY.onDataRowChanged(this);
    }

    final int zzZVY() {
        return this.zzYAR;
    }

    final void zzYhQ(String string, String string2) {
        this.zzWcX.put(string, string2);
    }

    final void zzW75(String string, String string2) {
        this.zzVZs = zzZzN.zzDW(string, string2);
    }

    final String zzZSj() {
        return this.zzVZs;
    }

    final void zzWEp(int n) {
        this.zzYAR = n;
    }

    final Object[] zztd() {
        return this.zzzW;
    }

    static boolean zzS(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null && dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzXv(index)) {
            return null;
        }
        return this.zzzW[index];
    }

    private void zzXKZ(int n, Object object) {
        if (!this.zzXv(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzS((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzS((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzS(clazz, object)))));
        this.zzzW[n] = object2;
    }

    private static Object zzS(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        try {
            if (clazz == String.class) {
                return string;
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzO7.class) {
                return zzO7.zzS(string, zzYE2.zzW46(), 128).zz57();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzXSq.zziY(exception);
        }
        return object;
    }

    private boolean zzXv(int n) {
        this.zzZke();
        return this.zzzW != null && n >= 0 && n < this.zzzW.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzWyY.getColumns().getCount();
        if (this.zzzW.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzzW.length - 1];
        System.arraycopy(this.zzzW, 0, objectArray, 0, index);
        System.arraycopy(this.zzzW, index + 1, objectArray, index, this.zzzW.length - index - 1);
        this.zzzW = objectArray;
    }

    private void zzZke() {
        if (this.zzWyY == null || this.zzWyY.getColumns() == null || this.zzzW == null) {
            return;
        }
        int n = this.zzWyY.getColumns().getCount();
        if (this.zzzW.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzzW.length];
        System.arraycopy(this.zzzW, 0, objectArray, 0, this.zzzW.length);
        this.zzzW = new Object[n];
        int n2 = Math.min(objectArray.length, this.zzzW.length);
        System.arraycopy(objectArray, 0, this.zzzW, 0, n2);
        for (int i = n2; i < this.zzzW.length; ++i) {
            this.zzzW[i] = DBNull.Value;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] zzS(Blob blob) {
        InputStream inputStream;
        byte[] byArray;
        block13: {
            byArray = null;
            inputStream = null;
            if (blob != null && blob.length() != 0L) break block13;
            byte[] byArray2 = byArray;
            if (inputStream == null) return byArray2;
            try {
                inputStream.close();
                return byArray2;
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                zzXSq.zziY(iOException);
            }
            return byArray2;
        }
        Object object = new ByteArrayOutputStream();
        inputStream = blob.getBinaryStream();
        zzYBU.zzS(inputStream, (OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            object = iOException;
            zzXSq.zziY(iOException);
        }
        return byArray;
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
                zzXSq.zziY(exception);
                if (inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException3 = iOException;
                    zzXSq.zziY(iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                zzXSq.zziY(iOException);
            }
            return byArray;
        }
    }

    private static String zzS(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzXSq.zziY(exception);
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzXSq.zziY(iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.getTable().getTableName() == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzzW;
        int n = dataRow.zzzW.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

