/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXSq;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzDW;
import com.aspose.words.net.System.Data.zzYVq;
import com.aspose.words.net.System.Data.zzZlZ;
import com.aspose.words.net.System.Data.zziY;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzW9I;
    private final DataColumnCollection zzX3U;
    private final ConstraintCollection zzWk2;
    private final zzYVq zzZRF;
    private ResultSet zzYBR;
    private String zzG8;
    private DataSet zzXFB;
    private String zzW9;
    private UniqueConstraint zzZNs;
    private boolean zzZOo;
    private final List<DataTableEventListener> zznJ;
    private final Set<DataRow> zzVYB;
    private DataRelationCollection zzYwE;

    public DataTable() {
        this.zzW9I = new DataRowCollection(this);
        this.zzX3U = new DataColumnCollection(this);
        this.zzWk2 = new ConstraintCollection(this);
        this.zzZRF = new zzYVq(this);
        this.zzW9 = "";
        this.zzZOo = true;
        this.zznJ = new ArrayList<DataTableEventListener>();
        this.zzVYB = new HashSet<DataRow>();
        this.zzYwE = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzW9I = new DataRowCollection(this);
        this.zzX3U = new DataColumnCollection(this);
        this.zzWk2 = new ConstraintCollection(this);
        this.zzZRF = new zzYVq(this);
        this.zzW9 = "";
        this.zzZOo = true;
        this.zznJ = new ArrayList<DataTableEventListener>();
        this.zzVYB = new HashSet<DataRow>();
        this.zzYwE = new DataRelationCollection();
        this.zzG8 = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzDW.zzS(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzW9I = new DataRowCollection(this);
        this.zzX3U = new DataColumnCollection(this);
        this.zzWk2 = new ConstraintCollection(this);
        this.zzZRF = new zzYVq(this);
        this.zzW9 = "";
        this.zzZOo = true;
        this.zznJ = new ArrayList<DataTableEventListener>();
        this.zzVYB = new HashSet<DataRow>();
        this.zzYwE = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzYBR = resultSet;
        this.zzG8 = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzYBR != null) {
            if (this.zzYBR.getStatement() != null) {
                this.zzYBR.getStatement().getConnection().close();
            }
            this.zzYBR = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzG8;
    }

    public void setTableName(String tableName) {
        this.zzG8 = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzX3U.getCount();
    }

    public String getColumnName(int index) {
        return this.zzX3U.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzYBR;
    }

    public DataSet getDataSet() {
        return this.zzXFB;
    }

    final void zz2E(DataSet dataSet) {
        this.zzXFB = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzXFB.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzYwE.add(dataRelation);
        }
        return this.zzYwE;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzXFB.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzW9I;
    }

    public DataColumnCollection getColumns() {
        return this.zzX3U;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzWk2;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzZNs == null) {
            return new DataColumn[0];
        }
        return this.zzZNs.getColumns();
    }

    final void zzYVq(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzZNs != null) {
                this.zzZNs.zzZno(false);
                this.getConstraints().remove(this.zzZNs);
                this.zzZNs = null;
            }
            return;
        }
        if (this.zzZNs != null && DataColumn.areColumnSetsTheSame(value, this.zzZNs.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzS(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzZNs != null) {
            this.zzZNs.zzZno(false);
            this.getConstraints().remove(this.zzZNs);
            this.zzZNs = null;
        }
        UniqueConstraint.zzS(this.getConstraints(), uniqueConstraint);
        this.zzZNs = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzW9;
    }

    public void setNamespace(String namespace) {
        this.zzW9 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZOo;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZOo = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzVYB.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzDW.zzS(this.getResultSet(), this);
            zzDW.zzDW(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXSq.zz2E(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzDW.zzWCy(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zznJ.contains(listener)) {
            this.zznJ.add(listener);
        }
    }

    public void removeEventListener(zziY listener) {
        if (this.zznJ.contains(listener)) {
            this.zznJ.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zznJ.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzVYB.add(row);
        for (DataTableEventListener dataTableEventListener : this.zznJ) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzVYB.add(row);
        for (DataTableEventListener dataTableEventListener : this.zznJ) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzVYB.add(row);
        for (DataTableEventListener dataTableEventListener : this.zznJ) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zznJ) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zznJ) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzZlZ zzS(zzDW[] zzDWArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzDWArray.length];
        for (int i = 0; i < zzDWArray.length; ++i) {
            dataColumnArray[i] = zzDWArray[i].zzYKp();
        }
        DataTable dataTable = this;
        zzZlZ zzZlZ2 = dataTable.zzZRF.zz2E(dataColumnArray);
        if (zzZlZ2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzZlZ2;
    }

    final zzYVq zzYCm() {
        return this.zzZRF;
    }

    final Set<DataRow> zzX5M() {
        return this.zzVYB;
    }
}

