/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Font;
import com.aspose.pdf.exceptions.FontNotFoundException;
import com.aspose.pdf.internal.p230.z111;
import com.aspose.pdf.internal.p230.z48;
import com.aspose.pdf.internal.p244.z1;
import com.aspose.pdf.internal.p244.z11;
import com.aspose.pdf.internal.p244.z31;
import com.aspose.pdf.internal.p244.z38;
import com.aspose.pdf.internal.p425.z16;
import com.aspose.pdf.internal.p438.z2;
import com.aspose.pdf.internal.p96.z147;
import com.aspose.pdf.internal.p96.z149;
import com.aspose.pdf.internal.p96.z156;
import com.aspose.pdf.internal.p96.z158;
import com.aspose.pdf.internal.p96.z213;
import com.aspose.pdf.internal.p96.z25;
import com.aspose.pdf.text.FontSourceCollection;
import com.aspose.pdf.text.FontTypes;
import java.io.InputStream;

public final class FontRepository {
    public static com.aspose.pdf.internal.p420.z1 getSubstitutions() {
        return z16.m1().m2();
    }

    public static FontSourceCollection getSources() {
        return z16.m1().m3();
    }

    public static Font findFont(String fontName) {
        z156 z1562 = z16.m1().m1(fontName);
        if (z1562 == null) {
            throw new FontNotFoundException(z111.m1("Font {0} was not found", new Object[]{fontName}));
        }
        z213 z2132 = z2.m1(z1562);
        return new Font(z2132);
    }

    public static Font findFont(String fontFamilyName, int style) {
        String string = fontFamilyName;
        String string2 = z111.m1;
        com.aspose.pdf.internal.p231.z1 z1543 = new com.aspose.pdf.internal.p231.z1();
        if (z111.m8(fontFamilyName, "Bold") != -1) {
            style |= 1;
            string = z111.m1(string, "Bold", "");
        }
        if (z111.m8(fontFamilyName, "Italic") != -1) {
            style |= 2;
            string = z111.m1(string, "Italic", "");
        }
        if (z111.m8(fontFamilyName, "Oblique") != -1) {
            style |= 2;
            string = z111.m1(string, "Oblique", "");
        }
        if ((style & 1) != 0) {
            string2 = "Bold";
        }
        if ((style & 2) != 0) {
            z1543.addItem(z111.m1(new String[]{string, string2, "Italic"}));
            z1543.addItem(z111.m1(new String[]{string, "Italic", string2}));
            z1543.addItem(z111.m1(new String[]{string, string2, "Oblique"}));
            z1543.addItem(z111.m1(new String[]{string, "Oblique", string2}));
        } else {
            z1543.addItem(z111.m1(new String[]{string, string2}));
            if (style == 0) {
                z1543.addItem(z111.m1(new String[]{string, "Regular"}));
            }
        }
        z156 z1562 = null;
        for (String string3 : z1543) {
            z1562 = z16.m1().m1(string3);
            if (z1562 == null) continue;
            break;
        }
        if (z1562 == null) {
            if (style != 0) {
                throw new IllegalStateException(z111.m1("Font {0} with style {1} was not found", new Object[]{fontFamilyName, style}));
            }
            throw new IllegalStateException(z111.m1("Font {0}was not found", new Object[]{fontFamilyName}));
        }
        z213 z2132 = z2.m1(z1562);
        return new Font(z2132);
    }

    public static Font openFont(InputStream fontStream, int fontType) {
        return FontRepository.m1(z38.fromJava(fontStream), fontType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Font m1(z38 z3810, int n) {
        if (n == 0 || n == 0) {
            byte[] byArray;
            int n2 = 0;
            z1 z1543 = new z1(z3810);
            try {
                byArray = z1543.m9((int)z3810.getLength());
            }
            finally {
                if (z1543 != null) {
                    z1543.dispose();
                }
            }
            return new Font(z149.m1(new z156(n2, new z158[]{new z158(new z25(byArray))})));
        }
        throw new IllegalStateException(z111.m1("font type {0} is not supported", new Object[]{z48.m1(FontTypes.class, n)}));
    }

    public static Font openFont(String fontFilePath) {
        return FontRepository.openFont(fontFilePath, null);
    }

    public static Font openFont(String fontFilePath, String metricsFilePath) {
        int n;
        if (!z11.m5(fontFilePath)) {
            throw new IllegalStateException("Specified font file was not found");
        }
        String string = z111.m1(z111.m7(z31.m5(fontFilePath)), ".", "");
        if ("otf".equals(string) || "ttc".equals(string) || "ttf".equals(string)) {
            n = 0;
        } else if ("pfa".equals(string) || "pfb".equals(string)) {
            n = 1;
        } else {
            throw new IllegalStateException("Could not determine font type of font file specified");
        }
        com.aspose.pdf.internal.p231.z1 z1543 = new com.aspose.pdf.internal.p231.z1(2);
        z1543.addItem(new z158(string, new z147(fontFilePath)));
        if (metricsFilePath != null && !z111.m5(metricsFilePath, z111.m1)) {
            if (!z11.m5(metricsFilePath)) {
                throw new IllegalStateException("Specified font metrics file was not found");
            }
            z1543.addItem(new z158(z111.m7(z31.m5(metricsFilePath)), new z147(fontFilePath)));
        }
        z158[] z158Array = new z158[z1543.size()];
        int n2 = 0;
        for (z158 z1582 : z1543) {
            z158Array[n2++] = z1582;
        }
        return new Font(z149.m1(new z156(n, z158Array)));
    }
}

