/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Border;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.p230.z111;
import com.aspose.pdf.internal.p230.z44;
import com.aspose.pdf.internal.p230.z68;
import com.aspose.pdf.internal.p231.z1;
import com.aspose.pdf.internal.p231.z10;
import com.aspose.pdf.internal.p231.z19;
import com.aspose.pdf.internal.p244.z41;
import com.aspose.pdf.internal.p264.z395;
import com.aspose.pdf.internal.p264.z543;
import com.aspose.pdf.internal.p264.z574;
import com.aspose.pdf.internal.p434.z13;
import com.aspose.pdf.internal.p434.z15;
import com.aspose.pdf.internal.p434.z21;
import com.aspose.pdf.internal.p434.z26;
import com.aspose.pdf.internal.p434.z28;
import com.aspose.pdf.internal.p434.z4;
import java.util.List;

public final class InkAnnotation
extends MarkupAnnotation {
    @Override
    void writeXfdf(z574 writer) {
        writer.m16("ink");
        this.m1(writer);
        if (this.getEngineDict().m4("BS")) {
            this.getBorder().m1(writer);
        }
        if (this.getEngineDict().m4("InkList")) {
            writer.m16("inklist");
            for (Object t : this.getInkList()) {
                writer.m16("gesture");
                StringBuilder stringBuilder = new StringBuilder();
                for (Point point : (Point[])t) {
                    stringBuilder.append(z111.m1(this.m2, "{0},{1};", point.getX(), point.getY()));
                }
                stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                writer.m5(stringBuilder.toString());
                writer.m10();
            }
        } else {
            throw new IllegalStateException("Required entry is absent in annotation dictionary");
        }
        writer.m10();
        this.m2(writer);
        writer.m10();
    }

    @Override
    void m1(z395 z3952) {
        z1 z1543;
        this.m2(z3952);
        this.setBorder(new Border(this));
        this.getBorder().m1(z3952);
        z10 z10100 = XfdfReader.m1(z3952);
        if (z10100.containsKey("inklist")) {
            z543 z5432 = new z543(new z41((String)z10100.get_Item("inklist")));
            z5432.m8();
            z1543 = new z1();
            while (z5432.m8()) {
                if (z5432.m26() != 1 || !"gesture".equals(z5432.m23())) continue;
                String[] stringArray = z111.m6(z5432.af_(), ';');
                Point[] pointArray = new Point[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = z111.m6(stringArray[i], ',');
                    pointArray[i] = new Point(z44.m1(stringArray2[0], (z68)this.m2), z44.m1(stringArray2[1], (z68)this.m2));
                }
                z1543.addItem(pointArray);
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        this.setInkList(z1543);
        this.m1(z10100);
    }

    @Override
    public void accept(AnnotationSelector visitor) {
        visitor.visit(this);
    }

    InkAnnotation(z13 engineAnnot, IDocument document) {
        super(engineAnnot, document);
    }

    public InkAnnotation(Page page, Rectangle rect, z19 inkList) {
        super(page, rect);
        this.getEngineDict().m2("Subtype", (z15)new z26("Ink"));
        this.setInkList(inkList);
    }

    public z19 getInkList() {
        try {
            z1 z1543 = new z1();
            z4 z4100 = this.getEngineDict().m3("InkList").m58();
            for (z15 z1544 : z4100) {
                z4 z4101 = z1544.m58();
                int n = z4101.m9() / 2;
                Point[] pointArray = new Point[n];
                for (int i = 0; i < n; ++i) {
                    pointArray[i] = new Point(z4101.m1(2 * i).m63().m9(), z4101.m1(2 * i + 1).m63().m9());
                }
                z1543.addItem(pointArray);
            }
            return z1543;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public void setInkList(z19 value) {
        if (value != null) {
            z21 z2110 = new z21(this.getEngineDict());
            for (Object t : value) {
                z21 z2111 = new z21(this.getEngineDict());
                for (Point point : (Point[])t) {
                    z2111.m1((z15)new z28(point.getX()));
                    z2111.m1((z15)new z28(point.getY()));
                }
                z2110.m1((z15)z2111);
            }
            this.getEngineDict().m1("InkList", (z15)z2110);
        }
    }

    @Override
    boolean m3() {
        return true;
    }

    @Override
    List m2(Annotation.z1 z1543, Annotation annotation) {
        z1 z1544 = new z1();
        z1544.addItem(new Operator.GSave());
        z1544.addItem(new Operator.SetRGBColorStroke(this.getColor().toRgb()));
        if (this.getEngineDict().m4("BS") && this.getEngineDict().m2("BS").m57() != null && this.getEngineDict().m2("BS").m57().m4("W") && this.getEngineDict().m2("BS").m57().m2("W").m63() != null) {
            z1544.addItem(new Operator.SetLineWidth(this.getEngineDict().m2("BS").m57().m2("W").m63().m9()));
        }
        if (this.getOpacity() < 1.0) {
            z1544.addItem(new Operator.GS("opacity"));
        }
        if (this.getInkList() != null) {
            for (Object t : this.getInkList()) {
                Point[] pointArray = (Point[])t;
                boolean bl = true;
                for (Point point : pointArray) {
                    if (bl) {
                        z1544.addItem(new Operator.MoveTo(point.getX(), point.getY()));
                    } else {
                        z1544.addItem(new Operator.LineTo(point.getX(), point.getY()));
                    }
                    bl = false;
                }
            }
        }
        z1544.addItem(new Operator.Stroke());
        z1544.addItem(new Operator.GRestore());
        return z1544;
    }
}

