/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Border;
import com.aspose.pdf.Color;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LineEndingConverter;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.p230.z111;
import com.aspose.pdf.internal.p230.z44;
import com.aspose.pdf.internal.p230.z55;
import com.aspose.pdf.internal.p230.z68;
import com.aspose.pdf.internal.p231.z10;
import com.aspose.pdf.internal.p264.z395;
import com.aspose.pdf.internal.p264.z574;
import com.aspose.pdf.internal.p383.z1;
import com.aspose.pdf.internal.p434.z13;
import com.aspose.pdf.internal.p434.z15;
import com.aspose.pdf.internal.p434.z21;
import com.aspose.pdf.internal.p434.z26;
import com.aspose.pdf.internal.p434.z28;
import com.aspose.pdf.internal.p434.z38;
import com.aspose.pdf.internal.p434.z4;
import com.aspose.pdf.z127;

public abstract class PolyAnnotation
extends MarkupAnnotation {
    PolyAnnotation(z13 annotation, IDocument document) {
        super(annotation, document);
    }

    protected PolyAnnotation(Page page, Rectangle rect, Point[] vertices) {
        super(page, rect);
        this.setVertices(vertices);
    }

    @Override
    protected void m1(z574 z5742) {
        super.m1(z5742);
        if (this.getEngineDict().m4("AP") && !this.getEngineDict().m4("BS")) {
            this.getBorder().m2(z5742);
        }
        if (this.getEngineDict().m4("BS")) {
            this.getBorder().m1(z5742);
        }
        if (this.getEngineDict().m4("IC")) {
            z5742.m3("interior-color", this.getInteriorColor().toString());
        }
        if (this.getEngineDict().m4("LE")) {
            z5742.m3("head", LineEndingConverter.toString(this.getStartingStyle()));
            z5742.m3("tail", LineEndingConverter.toString(this.getEndingStyle()));
        }
        if (this.getEngineDict().m4("IT")) {
            z5742.m3("intent", z127.m2(this.getIntent()));
        }
    }

    @Override
    protected void m2(z574 z5742) {
        StringBuilder stringBuilder;
        if (this.getEngineDict().m4("Vertices")) {
            z5742.m16("vertices");
            stringBuilder = new StringBuilder();
            for (Point point : this.getVertices()) {
                stringBuilder.append(z111.m1(this.m2, "{0},{1};", point.getX(), point.getY()));
            }
        } else {
            throw new IllegalStateException("Required entry is absent in annotation dictionary");
        }
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        z5742.m5(stringBuilder.toString());
        z5742.m10();
        super.m2(z5742);
    }

    @Override
    protected void m2(z395 z3952) {
        super.m2(z3952);
        this.setBorder(new Border(this));
        this.getBorder().m1(z3952);
        if (z3952.m4("interior-color")) {
            this.setInteriorColor(Color.parse(z3952.m1("interior-color")));
        }
        if (z3952.m4("head")) {
            this.setStartingStyle(LineEndingConverter.toEnum(z3952.m1("head")));
        }
        if (z3952.m4("tail")) {
            this.setEndingStyle(LineEndingConverter.toEnum(z3952.m1("tail")));
        }
        if (z3952.m4("intent")) {
            this.setIntent(z127.m1(z3952.m1("intent")));
        }
    }

    @Override
    protected void m1(z10 z10100) {
        Point[] pointArray;
        if (z10100.containsKey("vertices")) {
            String[] stringArray = z111.m6((String)z10100.get_Item("vertices"), ';');
            int n = stringArray.length;
            pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = z111.m6(stringArray[i], ',');
                double d = z44.m1(stringArray2[0], (z68)this.m2);
                double d2 = z44.m1(stringArray2[1], (z68)this.m2);
                pointArray[i] = new Point(d, d2);
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        this.setVertices(pointArray);
        super.m1(z10100);
    }

    @Override
    void m1(z395 z3952) {
        this.m2(z3952);
        this.m1(XfdfReader.m1(z3952));
    }

    public Point[] getVertices() {
        try {
            z4 z4100 = this.getEngineDict().m3("Vertices").m58();
            int n = z4100.m9() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(z4100.m1(2 * i).m63().m9(), z4100.m1(2 * i + 1).m63().m9());
            }
            return pointArray;
        }
        catch (z55 z5510) {
            return null;
        }
    }

    public void setVertices(Point[] value) {
        if (value != null) {
            z21 z2110 = new z21(this.getEngineDict());
            for (Point point : value) {
                z2110.m1((z15)new z28(point.getX()));
                z2110.m1((z15)new z28(point.getY()));
            }
            this.getEngineDict().m1("Vertices", (z15)z2110);
        }
    }

    public Color getInteriorColor() {
        if (this.getEngineDict().m4("IC")) {
            z4 z4100 = this.getEngineDict().m3("IC").m58();
            double[] dArray = new double[z4100.m9()];
            for (int i = 0; i < z4100.m9(); ++i) {
                dArray[i] = z4100.m1(i).m63().m9();
            }
            return new Color(dArray);
        }
        return null;
    }

    public void setInteriorColor(Color value) {
        z21 z2110 = new z21(this.getEngineDict());
        for (double d : value.getData()) {
            z2110.m1((z15)new z28(d));
        }
        this.getEngineDict().m1("IC", (z15)z2110);
    }

    public int getStartingStyle() {
        try {
            z4 z4100 = this.getEngineDict().m3("LE").m58();
            return LineEndingConverter.toEnum(z4100.m1(0).m56().toString());
        }
        catch (z55 z5510) {
            return 0;
        }
    }

    public void setStartingStyle(int value) {
        z4 z4100;
        if (this.getEngineDict().m4("LE")) {
            z4100 = this.getEngineDict().m3("LE").m58();
            if (z4100.m9() != 2) {
                throw new IllegalStateException("Invalid internal array");
            }
        } else {
            z4100 = new z21(this.getEngineDict());
            z4100.m1((z15)new z38(this.getEngineDict(), "None"));
            z4100.m1((z15)new z38(this.getEngineDict(), "None"));
            this.getEngineDict().m1("LE", (z15)z4100);
        }
        z4100.m2(0);
        z4100.m1((z15)new z26(LineEndingConverter.toString(value)), 0);
    }

    public int getEndingStyle() {
        try {
            z4 z4100 = this.getEngineDict().m3("LE").m58();
            return LineEndingConverter.toEnum(z4100.m1(1).m56().toString());
        }
        catch (z55 z5510) {
            return 0;
        }
    }

    public void setEndingStyle(int value) {
        z4 z4100;
        if (this.getEngineDict().m4("LE")) {
            z4100 = this.getEngineDict().m3("LE").m58();
            if (z4100.m9() != 2) {
                throw new IllegalStateException("Invalid internal array");
            }
        } else {
            z4100 = new z21(this.getEngineDict());
            z4100.m1((z15)new z38(this.getEngineDict(), "None"));
            z4100.m1((z15)new z38(this.getEngineDict(), "None"));
            this.getEngineDict().m1("LE", (z15)z4100);
        }
        z4100.m2(1);
        z4100.m1((z15)new z26(LineEndingConverter.toString(value)), 1);
    }

    public int getIntent() {
        return z127.m1(z1.m2(this.getEngineDict(), "IT"));
    }

    public void setIntent(int value) {
        if (value != 0) {
            this.getEngineDict().m1("IT", (z15)new z26(z127.m1(value)));
        }
    }
}

