/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import aspose.pdf.Pdf;
import com.aspose.pdf.Document;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.IIndexBitmapConverter;
import com.aspose.pdf.ImageFormatInternal;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.PdfDocumentBuilder;
import com.aspose.pdf.Point;
import com.aspose.pdf.RenderingOptions;
import com.aspose.pdf.XfaRenderer;
import com.aspose.pdf.devices.BmpDevice;
import com.aspose.pdf.devices.EmfDevice;
import com.aspose.pdf.devices.GifDevice;
import com.aspose.pdf.devices.GraphicsDevice;
import com.aspose.pdf.devices.ImageDevice;
import com.aspose.pdf.devices.JpegDevice;
import com.aspose.pdf.devices.PngDevice;
import com.aspose.pdf.devices.Resolution;
import com.aspose.pdf.devices.TiffDevice;
import com.aspose.pdf.devices.TiffSettings;
import com.aspose.pdf.facades.Facade;
import com.aspose.pdf.internal.p230.z111;
import com.aspose.pdf.internal.p230.z55;
import com.aspose.pdf.internal.p237.z21;
import com.aspose.pdf.internal.p237.z39;
import com.aspose.pdf.internal.p240.z33;
import com.aspose.pdf.internal.p244.z11;
import com.aspose.pdf.internal.p244.z25;
import com.aspose.pdf.internal.p244.z29;
import com.aspose.pdf.internal.p244.z38;
import com.aspose.pdf.internal.p264.z367;
import com.aspose.pdf.internal.p264.z371;
import com.aspose.pdf.internal.p434.z5;
import com.aspose.pdf.internal.p434.z8;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PdfConverter
extends Facade {
    private Resolution m1 = new Resolution(150);
    private int m2 = 1;
    private int m3 = Integer.MAX_VALUE;
    private int m4 = 1;
    private String m5;
    private String m6;
    private int m7 = 0;
    private boolean m8 = false;
    private RenderingOptions m9 = new RenderingOptions();
    private boolean m10 = true;

    public boolean getShowHiddenAreas() {
        return this.m10;
    }

    public void setShowHiddenAreas(boolean value) {
        this.m10 = value;
    }

    private ImageDevice m1(ImageFormatInternal imageFormatInternal, Resolution resolution, int n) {
        return this.m1(imageFormatInternal, 0, 0, resolution, n);
    }

    private ImageDevice m1(float f, float f2, int n, int n2, z39 z3910, float f3, Resolution resolution, int n3, boolean bl, int n4, int n5, boolean bl2) {
        GraphicsDevice graphicsDevice = new GraphicsDevice(new Point(f, f2), n, n2, z3910.m13(), f3, resolution, n3, bl, n4, n5, bl2);
        graphicsDevice.setFormPresentationMode(this.getFormPresentationMode());
        graphicsDevice.setConvertFontsToUnicodeTTF(this.m1());
        graphicsDevice.setRenderingOptions(this.getRenderingOptions());
        return graphicsDevice;
    }

    private ImageDevice m1(ImageFormatInternal imageFormatInternal, int n, int n2, Resolution resolution, int n3) {
        ImageDevice imageDevice = null;
        if (imageFormatInternal.getInternalFormat() == z33.m10()) {
            imageDevice = new JpegDevice(n, n2, resolution, n3);
        } else if (imageFormatInternal.getInternalFormat() == z33.m12()) {
            imageDevice = new PngDevice(n, n2, resolution);
        } else if (imageFormatInternal.getInternalFormat() == z33.m5()) {
            imageDevice = new BmpDevice(n, n2, resolution);
        } else if (imageFormatInternal.getInternalFormat() == z33.m8()) {
            imageDevice = new GifDevice(n, n2, resolution);
        } else if (imageFormatInternal.getInternalFormat() == z33.m6()) {
            imageDevice = new EmfDevice(n, n2, resolution);
        } else {
            if (imageFormatInternal.getInternalFormat() == z33.m13()) {
                throw new z55(z111.m1(new String[]{"Image format ", imageFormatInternal.toString(), " is not supported. SaveAsTIFF methods should be used in order to generate Tiff files."}));
            }
            throw new z55(z111.m1(new String[]{"Image format ", imageFormatInternal.toString(), " is not supported"}));
        }
        imageDevice.setFormPresentationMode(this.getFormPresentationMode());
        imageDevice.setConvertFontsToUnicodeTTF(this.m1());
        imageDevice.setRenderingOptions(this.getRenderingOptions());
        return imageDevice;
    }

    private ImageDevice m1(ImageFormatInternal imageFormatInternal, PageSize pageSize, Resolution resolution, int n) {
        ImageDevice imageDevice = null;
        if (imageFormatInternal.getInternalFormat() == z33.m10()) {
            imageDevice = new JpegDevice(pageSize, resolution, n);
        } else if (imageFormatInternal.getInternalFormat() == z33.m12()) {
            imageDevice = new PngDevice(pageSize, resolution);
        } else if (imageFormatInternal.getInternalFormat() == z33.m5()) {
            imageDevice = new BmpDevice(pageSize, resolution);
        } else if (imageFormatInternal.getInternalFormat() == z33.m8()) {
            imageDevice = new GifDevice(pageSize, resolution);
        } else if (imageFormatInternal.getInternalFormat() == z33.m6()) {
            imageDevice = new EmfDevice(pageSize, resolution);
        } else {
            if (imageFormatInternal.getInternalFormat() == z33.m13()) {
                throw new z55(z111.m1(new String[]{"Image format ", imageFormatInternal.toString(), " is not supported. SaveAsTIFF methods should be used in order to generate Tiff files."}));
            }
            throw new z55(z111.m1(new String[]{"Image format ", imageFormatInternal.toString(), " is not supported"}));
        }
        imageDevice.setFormPresentationMode(this.getFormPresentationMode());
        imageDevice.setConvertFontsToUnicodeTTF(this.m1());
        imageDevice.setRenderingOptions(this.getRenderingOptions());
        return imageDevice;
    }

    public RenderingOptions getRenderingOptions() {
        return this.m9;
    }

    public void setRenderingOptions(RenderingOptions value) {
        this.m9 = value;
    }

    public int getFormPresentationMode() {
        return this.m7;
    }

    public void setFormPresentationMode(int value) {
        this.m7 = value;
    }

    boolean m1() {
        return this.m8;
    }

    void m1(boolean bl) {
        this.m8 = bl;
    }

    public Resolution getResolution() {
        return this.m1;
    }

    public void setResolution(Resolution value) {
        this.m1 = value.getX() <= 0 || value.getY() <= 0 ? new Resolution(150) : value;
    }

    public int getStartPage() {
        return this.m2;
    }

    public void setStartPage(int value) {
        this.m4 = this.m2 = value < 1 ? 1 : value;
    }

    public int getEndPage() {
        this.m4();
        if (this.m3 != Integer.MAX_VALUE) {
            return this.m3;
        }
        return this.getDocument().getPages().size();
    }

    public void setEndPage(int value) {
        this.m4();
        int n = this.m3 = value > this.getDocument().getPages().size() ? this.getDocument().getPages().size() : value;
        if (this.m3 < this.m2) {
            this.m3 = this.m2;
        }
    }

    public void setRangeOfPages(int startPage, int EndPage) {
        if (startPage > EndPage) {
            this.m3 = startPage > this.m11.getPages().size() ? this.m11.getPages().size() : startPage;
            this.m2 = EndPage < 1 ? 1 : EndPage;
        } else {
            this.m3 = EndPage > this.m11.getPages().size() ? this.m11.getPages().size() : EndPage;
            this.m2 = startPage < 1 ? 1 : startPage;
        }
    }

    public String getPassword() {
        return this.m5;
    }

    public void setPassword(String value) {
        this.m5 = value;
    }

    public String getUserPassword() {
        return this.m6;
    }

    public void setUserPassword(String value) {
        this.m6 = value;
    }

    public int getPageCount() {
        this.m4();
        return this.getDocument().getPages().size();
    }

    public void doConvert() {
        this.m4();
        this.m4 = this.m2;
    }

    public void saveAsTIFF(String outputFile) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1(z2510);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int compressionType) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1((z38)z2510, 0, 0, compressionType);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1((z38)z2510, imageWidth, imageHeight);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, PageSize pageSize) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1((z38)z2510, pageSize);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, PageSize pageSize, TiffSettings settings) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1((z38)z2510, pageSize, settings);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, int compressionType) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1((z38)z2510, imageWidth, imageHeight, compressionType);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, TiffSettings settings) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1((z38)z2510, imageWidth, imageHeight, settings);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, TiffSettings settings, IIndexBitmapConverter converter) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1(z2510, imageWidth, imageHeight, settings, converter);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFFClassF(String outputFile, int imageWidth, int imageHeight) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, imageWidth, imageHeight);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFFClassF(String outputFile, PageSize pageSize) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, pageSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFFClassF(OutputStream outputStream, int imageWidth, int imageHeight) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, tiffSettings);
    }

    public void saveAsTIFFClassF(OutputStream outputStream, PageSize pageSize) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, pageSize, tiffSettings);
    }

    public void saveAsTIFF(OutputStream outputStream) {
        this.saveAsTIFF(outputStream, 0, 0, new TiffSettings());
    }

    private void m1(z38 z3810) {
        this.m1(z3810, 0, 0, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, int compressionType) {
        this.saveAsTIFF(outputStream, 0, 0, compressionType);
    }

    public void saveAsTIFF(OutputStream outputStream, PageSize pageSize) {
        this.saveAsTIFF(outputStream, pageSize, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, PageSize pageSize, TiffSettings settings) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(pageSize, this.getResolution(), settings);
        tiffDevice.process(this.m11, this.getStartPage(), this.getEndPage(), outputStream);
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight) {
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, int compressionType) {
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, new TiffSettings(compressionType));
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, TiffSettings settings) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(imageWidth, imageHeight, this.getResolution(), settings);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), outputStream);
    }

    private void m1(z38 z3810, int n, int n2, TiffSettings tiffSettings) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), tiffSettings);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), z3810);
    }

    private void m1(z38 z3810, int n, int n2, int n3) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), new TiffSettings(n3));
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), z3810);
    }

    private void m1(z38 z3810, int n, int n2) {
        this.m1(z3810, n, n2, new TiffSettings());
    }

    private void m1(z38 z3810, int n, int n2, TiffSettings tiffSettings, IIndexBitmapConverter iIndexBitmapConverter) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), tiffSettings, iIndexBitmapConverter);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), z3810);
    }

    private void m1(z38 z3810, PageSize pageSize) {
        this.m1(z3810, pageSize, new TiffSettings());
    }

    private void m1(z38 z3810, PageSize pageSize, TiffSettings tiffSettings) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(pageSize, this.getResolution(), tiffSettings);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), z3810);
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, TiffSettings settings, IIndexBitmapConverter converter) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(imageWidth, imageHeight, this.getResolution(), settings, converter);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), outputStream);
    }

    public boolean hasNextImage() {
        this.m4();
        return this.m4 <= this.getEndPage();
    }

    public void getNextImage(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void getNextImage(String outputFile, PageSize pageSize) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextImage(String outputFile, ImageFormatInternal format) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void getNextImage(String outputFile, PageSize pageSize, ImageFormatInternal format) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream) {
        this.getNextImage(outputStream, ImageFormatInternal.getJpeg(), 0, 0, 100);
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize) {
        this.getNextImage(outputStream, pageSize, ImageFormatInternal.getJpeg(), 100);
    }

    public void getNextImage(OutputStream outputStream, ImageFormatInternal format) {
        this.m4();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, format, 0, 0, 100);
        }
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize, ImageFormatInternal format) {
        this.m4();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, pageSize, format, 100);
        }
    }

    public void getNextImage(String outputFile, ImageFormatInternal format, int imageWidth, int imageHeight, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageFormatInternal format, int imageWidth, int imageHeight, int quality) {
        this.m4();
        z29 z2910 = new z29();
        if (this.hasNextImage()) {
            ImageDevice imageDevice = this.m1(format, imageWidth, imageHeight, this.getResolution(), quality);
            imageDevice.processInternal(this.m11.getPages().get_Item(this.m4), z2910);
            ++this.m4;
        }
        try {
            if (z2910 != null) {
                outputStream.write(z2910.m4());
            }
            z2910.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void getNextImage(String outputFile, ImageFormatInternal format, double imageWidth, double imageHeight, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageFormatInternal format, double imageWidth, double imageHeight, int quality) {
        this.getNextImage(outputStream, format, (int)imageWidth, (int)imageHeight, quality);
    }

    private void m2() {
        z371 z3712;
        if (this.getDocument().getForm().hasXfa() && (z3712 = this.getDocument().getForm().getXFA().getConfig()) != null) {
            z5 z5100;
            z8 z8100;
            z367 z3672 = new z367(this.getDocument().getForm().getXFA().getConfig().m9().m25());
            z3672.m1("cfg", this.getDocument().getForm().getXFA().getConfig().m6());
            z371 z3713 = z3712.m2("cfg:acrobat/cfg:acrobat7/cfg:dynamicRender", z3672);
            if (z3713 != null && z3713.m10() != null && z111.m8(z3713.m10(), "required") != -1 && (z8100 = this.getDocument().getEngineDoc().m2().m57()).m4("NeedsRendering") && (z5100 = z8100.m3("NeedsRendering").m60()).m2()) {
                XfaRenderer xfaRenderer = new XfaRenderer();
                PdfDocumentBuilder pdfDocumentBuilder = xfaRenderer.build(this.getDocument().getForm().getXFA());
                this.bindPdf(pdfDocumentBuilder.getDocument());
            }
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        if (this.getPassword() != null) {
            this.m1(inputFile, this.getPassword());
        } else if (this.getUserPassword() != null) {
            this.m1(inputFile, this.getUserPassword());
        } else {
            this.m1(inputFile, this.getPassword());
        }
        this.m2();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.m6(z38.fromJava(inputStream));
    }

    @Override
    void m6(z38 z3810) {
        this.m1(z3810, this.getPassword());
        this.m2();
    }

    @Override
    public void bindPdf(Pdf pdf) {
        this.bindPdf(new Document(pdf));
        this.m3 = this.m11.getPages().size();
    }

    public PdfConverter() {
    }

    public PdfConverter(IDocument document) {
        super(document);
        this.m3 = this.getDocument().getPages().size();
    }

    @Override
    public void close() {
        super.close();
    }

    public void saveAsTIFFClassF(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, 0, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFFClassF(OutputStream outputStream) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, 0, 0, tiffSettings);
    }

    public void saveAsTIFF(String outputFile, TiffSettings settings) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1((z38)z2510, 0, 0, settings);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, TiffSettings settings, IIndexBitmapConverter converter) {
        z25 z2510 = null;
        try {
            z2510 = z11.m8(outputFile);
            this.m1(z2510, 0, 0, settings, converter);
        }
        catch (z55 z5510) {
            throw new RuntimeException(z5510.getMessage());
        }
        finally {
            if (z2510 != null) {
                try {
                    z2510.close();
                }
                catch (z55 z5511) {
                    z5511.printStackTrace();
                }
            }
        }
    }

    public void saveAsTIFF(OutputStream outputStream, TiffSettings settings) {
        this.saveAsTIFF(outputStream, 0, 0, settings);
    }

    public void saveAsTIFF(OutputStream outputStream, TiffSettings settings, IIndexBitmapConverter converter) {
        this.saveAsTIFF(outputStream, 0, 0, settings, converter);
    }

    public void getNextImage(String outputFile, ImageFormatInternal format, int imageWidth, int imageHeight) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, 100);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageFormatInternal format, int imageWidth, int imageHeight) {
        this.getNextImage(outputStream, format, 0, 0, 100);
    }

    public void getNextImage(OutputStream outputStream, ImageFormatInternal format, int quality) {
        this.m4();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, format, 0, 0, quality);
        }
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize, ImageFormatInternal format, int quality) {
        this.m4();
        if (this.hasNextImage()) {
            ImageDevice imageDevice = this.m1(format, pageSize, this.getResolution(), quality);
            if (!this.m10 && !this.getDocument().getPages().get_Item(this.m4).getCropBox().equals(this.getDocument().getPages().get_Item(this.m4).getMediaBox())) {
                imageDevice.setCoordinateType(0);
            }
            imageDevice.process(this.getDocument().getPages().get_Item(this.m4), outputStream);
            ++this.m4;
        }
    }

    public void getNextImage(String outputFile, ImageFormatInternal format, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextImage(String outputFile, PageSize pageSize, ImageFormatInternal format, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize, format, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    void m1(z21 z2110, float f, float f2, int n, int n2, z39 z3910, float f3, int n3, boolean bl, int n4, int n5, boolean bl2) {
        this.m4();
        if (this.hasNextImage()) {
            ImageDevice imageDevice = this.m1(f, f2, n, n2, z3910.m13(), f3, this.getResolution(), n3, bl, n4, n5, bl2);
            if (!this.m10 && !this.getDocument().getPages().get_Item(this.m4).getCropBox().equals(this.getDocument().getPages().get_Item(this.m4).getMediaBox())) {
                imageDevice.setCoordinateType(0);
            }
            imageDevice.process(this.getDocument().getPages().get_Item(this.m4), z2110);
            ++this.m4;
        }
    }

    @Override
    public void dispose() {
        this.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

