/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Document;
import com.aspose.pdf.DocumentInfo;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Page;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.exceptions.InvalidPasswordException;
import com.aspose.pdf.facades.DocumentPrivilege;
import com.aspose.pdf.facades.PdfXmpMetadata;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.p230.z111;
import com.aspose.pdf.internal.p230.z34;
import com.aspose.pdf.internal.p230.z55;
import com.aspose.pdf.internal.p230.z89;
import com.aspose.pdf.internal.p231.z10;
import com.aspose.pdf.internal.p231.z9;
import com.aspose.pdf.internal.p243.z11;
import com.aspose.pdf.internal.p244.z29;
import com.aspose.pdf.internal.p434.z38;
import com.aspose.pdf.internal.p438.z2;
import com.aspose.pdf.internal.p482.z4;
import com.aspose.pdf.z86;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public final class PdfFileInfo
extends SaveableFacade {
    private String m1;
    private InputStream m2;
    private boolean m3;
    private String m4 = null;
    private z10 m5;
    private boolean m6 = false;
    private static final String m7 = "xmp";
    private static final String m8 = "http://ns.adobe.com/xap/1.0/";

    @Override
    protected void m1(com.aspose.pdf.internal.p244.z38 z3810, String string) {
        try {
            super.m1(z3810, string);
            this.m2();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            this.m4 = invalidPasswordException.getMessage();
            this.m6 = true;
        }
        catch (RuntimeException runtimeException) {
            this.m4 = runtimeException.getMessage();
            this.m3 = false;
        }
    }

    @Override
    protected void m1(String string, String string2) {
        try {
            super.m1(string, string2);
            this.m2();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            this.m4 = invalidPasswordException.getMessage();
            this.m6 = true;
        }
        catch (RuntimeException runtimeException) {
            this.m4 = runtimeException.getMessage();
            this.m3 = false;
        }
    }

    public void bindPdf(Document srcDoc) {
        super.bindPdf(srcDoc);
        this.m3 = true;
    }

    private void m2() {
        this.m4();
        this.m3 = true;
        this.m5 = new z10();
        for (z9 z9100 : this.getDocument().getInfo()) {
            if (DocumentInfo.isPredefinedKey((String)z9100.getKey())) continue;
            this.m5.addItem(z9100.getKey(), z9100.getValue());
        }
        Page page = this.getDocument().getPages().get_Item(1);
    }

    @Override
    protected void m4() {
        if (this.m11 == null) {
            String string = "PdfFileInfo is not initialized. Use constructors with parameters or properties for initialization.";
            if (this.m1 != null) {
                string = z111.m1(string, z111.m1(new String[]{" (File: ", this.m1, ")"}));
            }
            if (this.m4 != null) {
                string = z111.m1(string, z111.m1(new String[]{" (Reason: ", this.m4, ")"}));
            }
            throw new z89(string);
        }
    }

    public String getAuthor() {
        this.m4();
        return this.m11.getInfo().getAuthor();
    }

    public void setAuthor(String value) {
        this.m4();
        this.getDocument().getInfo().setAuthor(value);
    }

    public boolean isEncrypted() {
        if (this.m6) {
            return true;
        }
        this.m4();
        return this.getDocument().isEncrypted();
    }

    public boolean isPdfFile() {
        return this.m3;
    }

    public String getCreationDate() {
        this.m4();
        if (this.getDocument().getInfo().contains("CreationDate")) {
            return (String)this.getDocument().getInfo().get_Item("CreationDate");
        }
        return null;
    }

    public void setCreationDate(String value) {
        this.m4();
        this.getDocument().getInfo().setCreationDate(z34.m4(z2.m1(new z38(this.getDocument().getEngineDoc().m2(), value)).m1().m34()));
    }

    public String getCreator() {
        this.m4();
        return this.getDocument().getInfo().getCreator();
    }

    public void setCreator(String value) {
        this.m4();
        z86.m1(this.getDocument().getInfo(), value);
    }

    public boolean hasCollection() {
        this.m4();
        return this.getDocument().getCollection() != null;
    }

    public Map getHeader() {
        return z10.toJava(this.m1());
    }

    z10 m1() {
        return this.m5;
    }

    public void setHeader(Map value) {
        this.m1(z10.fromJava(value));
    }

    void m1(z10 z10100) {
        this.m5 = z10100;
    }

    @Deprecated
    public String getInputFile() {
        return this.m1;
    }

    @Deprecated
    public void setInputFile(String value) {
        this.m1 = value;
        this.m1(value, null);
    }

    @Deprecated
    public InputStream getInputStream() {
        return this.m2;
    }

    @Deprecated
    public void setInputStream(InputStream value) {
        this.m2 = value;
        this.bindPdf(value, null);
    }

    public String getKeywords() {
        this.m4();
        return this.m11.getInfo().getKeywords();
    }

    public void setKeywords(String value) {
        this.m4();
        this.getDocument().getInfo().setKeywords(value);
    }

    public String getModDate() {
        this.m4();
        if (this.getDocument().getInfo().contains("ModDate")) {
            return (String)this.getDocument().getInfo().get_Item("ModDate");
        }
        return null;
    }

    public void setModDate(String value) {
        this.m4();
        this.getDocument().getInfo().setModDate(z34.m4(z2.m1(new z38(this.getDocument().getEngineDoc().m2(), value)).m1().m34()));
    }

    public int getNumberOfPages() {
        this.m4();
        return this.getDocument().getPages().size();
    }

    public String getProducer() {
        this.m4();
        return this.getDocument().getInfo().getProducer();
    }

    public String getSubject() {
        this.m4();
        return this.getDocument().getInfo().getSubject();
    }

    public void setSubject(String value) {
        this.m4();
        this.getDocument().getInfo().setSubject(value);
    }

    public String getTitle() {
        this.m4();
        return this.getDocument().getInfo().getTitle();
    }

    public void setTitle(String value) {
        this.m4();
        this.getDocument().getInfo().setTitle(value);
    }

    public PdfFileInfo() {
    }

    public PdfFileInfo(InputStream inputStream) {
        this(inputStream, null);
    }

    public PdfFileInfo(InputStream inputStream, String password) {
        this.m2 = inputStream;
        this.bindPdf(inputStream, password);
    }

    public PdfFileInfo(String inputFile) {
        this(inputFile, null);
    }

    public PdfFileInfo(String inputFile, String password) {
        this.m1 = inputFile;
        this.m1(inputFile, password);
    }

    public void clearInfo() {
        this.m4();
        this.getDocument().getInfo().clear();
        this.m5.clear();
    }

    public DocumentPrivilege getDocumentPrivilege() {
        this.m4();
        return new DocumentPrivilege(this.getDocument().getPermissions());
    }

    public String getMetaInfo(String name) {
        this.m4();
        if (!DocumentInfo.isPredefinedKey(name) && this.m5.containsKey(name)) {
            return (String)this.m5.get_Item(name);
        }
        return z111.m1;
    }

    public float getPageHeight(int pageNum) {
        this.m4();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getHeight();
    }

    public int getPageRotation(int pageNum) {
        this.m4();
        switch (this.getDocument().getPages().get_Item(pageNum).getRotate()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public float getPageWidth(int pageNum) {
        this.m4();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getWidth();
    }

    public float getPageXOffset(int pageNum) {
        this.m4();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getLLX();
    }

    public float getPageYOffset(int pageNum) {
        this.m4();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getLLY();
    }

    public String getPdfVersion() {
        this.m4();
        return this.getDocument().getVersion();
    }

    public boolean saveNewInfo(OutputStream outputStream) {
        this.m4();
        try {
            this.save(outputStream);
            return true;
        }
        catch (z55 z5510) {
            return false;
        }
    }

    public boolean saveNewInfo(String outputFile) {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.saveNewInfo(fileOutputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream destStream) {
        z29 z2910 = new z29();
        this.a_(z2910);
        try {
            if (((com.aspose.pdf.internal.p244.z38)z2910).canSeek()) {
                ((com.aspose.pdf.internal.p244.z38)z2910).seek(0L, 0);
            }
            byte[] byArray = new byte[z2910.toInputStream().available()];
            z2910.toInputStream().read(byArray);
            destStream.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (z2910 != null) {
                z2910.close();
            }
        }
    }

    @Override
    void a_(com.aspose.pdf.internal.p244.z38 z3810) {
        this.m3();
        this.getDocument().saveInternal(z3810);
    }

    private void m3() {
        this.m4();
        this.getDocument().getInfo().clearCustomData();
        for (z9 z9100 : this.m1()) {
            this.getDocument().getInfo().addItem(z9100.getKey(), z9100.getValue());
        }
    }

    public void setMetaInfo(String name, String value) {
        this.m4();
        if (this.m5.containsKey(name)) {
            this.m5.removeItem(name);
        }
        this.m5.addItem(name, value);
    }

    public boolean saveNewInfoWithXmp(String outputFileName) {
        PdfXmpMetadata pdfXmpMetadata = new PdfXmpMetadata();
        pdfXmpMetadata.bindPdf(this.m1);
        IDocument iDocument = pdfXmpMetadata.getDocument();
        this.getDocument().getMetadata().registerNamespaceUri(m7, m8);
        if (this.getAuthor() != null) {
            iDocument.getInfo().setAuthor(this.getAuthor());
            pdfXmpMetadata.set_Item("dc:creator", new Object[]{this.getAuthor()});
        }
        if (this.getCreator() != null) {
            z86.m1(iDocument.getInfo(), this.getCreator());
            pdfXmpMetadata.set_Item("xmp:CreatorTool", this.getCreator());
        }
        if (this.getKeywords() != null) {
            iDocument.getInfo().setKeywords(this.getKeywords());
            pdfXmpMetadata.set_Item("pdf:Keywords", this.getKeywords());
        }
        if (this.getSubject() != null) {
            iDocument.getInfo().setSubject(this.getSubject());
            pdfXmpMetadata.set_Item("dc:description", new Object[]{this.getSubject()});
        }
        if (this.getTitle() != null) {
            iDocument.getInfo().setTitle(this.getTitle());
            pdfXmpMetadata.set_Item("dc:title", new Object[]{this.getTitle()});
        }
        pdfXmpMetadata.set_Item("pdf:Producer", "Aspose.Pdf for Java 9.3.1");
        if (this.getCreationDate() != null) {
            iDocument.getInfo().setCreationDate(this.m11.getInfo().getCreationDate());
            pdfXmpMetadata.set_Item("xmp:CreateDate", PdfFileInfo.m1(z34.m1(this.m11.getInfo().getCreationDate())));
        }
        if (this.getModDate() != null) {
            iDocument.getInfo().setModDate(this.m11.getInfo().getModDate());
            pdfXmpMetadata.set_Item("xmp:ModifyDate", PdfFileInfo.m1(z34.m1(this.m11.getInfo().getModDate())));
        }
        for (Object object : this.m5) {
            pdfXmpMetadata.registerNamespaceURI("pdfx", "http://ns.adobe.com/pdfx/1.3/");
            pdfXmpMetadata.addItem(z111.m1(new String[]{"pdfx:", ((z9)object).getKey().toString()}), ((z9)object).getValue().toString());
        }
        for (Object object : this.m1().getKeys()) {
            iDocument.getInfo().removeItem(object);
        }
        for (Object object : this.m1()) {
            iDocument.getInfo().addItem(((z9)object).getKey(), ((z9)object).getValue());
        }
        iDocument.save(outputFileName);
        return true;
    }

    public PdfFileInfo(IDocument document) {
        super(document);
    }

    private static String m1(z34 z3410) {
        String string = z3410.m2("yyyy-MM-ddTHH\\:mm\\:ss\\.fff");
        string = z111.m1(string, z34.m1(z3410, "zzz", z11.m26()));
        return string;
    }

    public int getPasswordType() {
        if (this.m6) {
            return 3;
        }
        if (this.isEncrypted() && this.getDocument() != null) {
            z4 z4100 = this.getDocument().getEngineDoc().m2().m68();
            if (z4100.m1(z4100.m5())) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public boolean hasOpenPassword() {
        z4 z4100 = this.getDocument() != null ? this.getDocument().getEngineDoc().m2().m68() : null;
        switch (this.getPasswordType()) {
            case 3: {
                return true;
            }
            case 1: {
                return !"".equals(z4100.m5());
            }
            case 2: {
                return !z4100.m1("");
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public boolean hasEditPassword() {
        switch (this.getPasswordType()) {
            case 1: {
                z4 z4100 = this.getDocument().getEngineDoc().m2().m68();
                return !z4100.m2(z4100.m5());
            }
            case 3: {
                throw new InvalidPasswordException("Document must be opened with valid password in order to read this property.");
            }
            case 2: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
        this.m2 = null;
        this.m1 = null;
        this.m5 = null;
        this.m3 = false;
        this.m6 = false;
        this.m4 = null;
    }

    @Override
    public void dispose() {
        this.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

