/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import aspose.pdf.Pdf;
import com.aspose.pdf.Annotation;
import com.aspose.pdf.Document;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.facades.AlignmentType;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.facades.VerticalAlignmentType;
import com.aspose.pdf.internal.p230.z111;
import com.aspose.pdf.internal.p230.z148;
import com.aspose.pdf.internal.p230.z5;
import com.aspose.pdf.internal.p230.z6;
import com.aspose.pdf.internal.p230.z88;
import com.aspose.pdf.internal.p231.z10;
import com.aspose.pdf.internal.p237.z39;
import com.aspose.pdf.internal.p244.z29;
import com.aspose.pdf.internal.p244.z38;
import com.aspose.pdf.internal.p346.z9;
import com.aspose.pdf.internal.p387.z12;
import com.aspose.pdf.internal.p387.z16;
import com.aspose.pdf.internal.p434.z13;
import com.aspose.pdf.internal.p434.z15;
import com.aspose.pdf.internal.p434.z24;
import com.aspose.pdf.internal.p434.z26;
import com.aspose.pdf.internal.p434.z28;
import com.aspose.pdf.internal.p434.z8;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;

public final class PdfPageEditor
extends SaveableFacade {
    private static final int m1 = 1;
    private static final int m2 = 2;
    private static final int m3 = 4;
    private int m4 = 0;
    private int m5;
    private int m6;
    private int m7;
    private int[] m8 = null;
    private int m9 = 0;
    private z10 m10 = new z10();
    private float m12 = 1.0f;
    private PageSize m13;
    private int m14 = 1;
    private int m15 = 3;
    private Point m16 = null;
    public static final int SPLITVOUT = 1;
    public static final int SPLITHOUT = 2;
    public static final int SPLITVIN = 3;
    public static final int SPLITHIN = 4;
    public static final int BLINDV = 5;
    public static final int BLINDH = 6;
    public static final int INBOX = 7;
    public static final int OUTBOX = 8;
    public static final int LRWIPE = 9;
    public static final int RLWIPE = 10;
    public static final int BTWIPE = 11;
    public static final int TBWIPE = 12;
    public static final int DISSOLVE = 13;
    public static final int LRGLITTER = 14;
    public static final int TBGLITTER = 15;
    public static final int DGLITTER = 16;
    private static final String m17 = "Invalid rotations structure. Keys and values of rotatins must be integer numbers.";
    private static final String m18 = "Invalid rotate value. Page rotate must be  expressed in degrees and be multiple of 90.";
    private static final z9 m19 = new z9("Center", "Left", "Right", "Top", "Bottom", "trim", "art", "bleed", "crop", "media");

    public PdfPageEditor() {
    }

    public PdfPageEditor(Document document) {
        super(document);
    }

    public int getTransitionDuration() {
        this.m4();
        return this.m7;
    }

    public void setTransitionDuration(int value) {
        this.m4();
        this.m4 |= 1;
        this.m7 = value;
    }

    public int getTransitionType() {
        this.m4();
        return this.m6;
    }

    public void setTransitionType(int value) {
        this.m4();
        this.m4 |= 2;
        this.m6 = value;
    }

    public int getDisplayDuration() {
        this.m4();
        return this.m5;
    }

    public void setDisplayDuration(int value) {
        this.m4();
        this.m4 |= 4;
        this.m5 = value;
    }

    public int[] getPages_Rename_Namesake() {
        this.m4();
        return this.m8;
    }

    public void setPages(int[] value) {
        this.m8 = value;
    }

    public int getRotation() {
        this.m4();
        if (this.m9 < 0) {
            this.m4();
            this.m9 = Page.rotationToInt(this.getDocument().getPages().get_Item(0).getRotate());
        }
        return this.m9;
    }

    public void setRotation(int value) {
        this.m4();
        this.m3(value);
        this.m9 = value;
    }

    public Map getPageRotations() {
        return z10.toJava(this.m1());
    }

    z10 m1() {
        this.m4();
        if (this.m10 == null) {
            this.m10 = new z10();
        }
        return this.m10;
    }

    public void setPageRotations(Map value) {
        this.m1(z10.fromJava(value));
    }

    void m1(z10 z10100) {
        this.m4();
        this.m2(z10100);
        this.m10 = z10100;
    }

    public float getZoom() {
        this.m4();
        return this.m12;
    }

    public void setZoom(float value) {
        this.m12 = value;
    }

    public PageSize getPageSize() {
        this.m4();
        if (this.m13 == null) {
            this.m13 = new PageSize(-1.0f, -1.0f);
        }
        return this.m13;
    }

    public void setPageSize(PageSize value) {
        this.m4();
        this.m13 = value;
    }

    @Deprecated
    public AlignmentType getAlignment() {
        int n = this.getHorizontalAlignment();
        switch (n) {
            case 1: {
                return AlignmentType.Left;
            }
            case 2: {
                return AlignmentType.Center;
            }
            case 3: {
                return AlignmentType.Right;
            }
        }
        throw new z5("Unknown Alignment type");
    }

    @Deprecated
    public void setAlignment(AlignmentType value) {
        AlignmentType alignmentType = value;
        switch (m19.m1(alignmentType.toString())) {
            case 0: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                this.setHorizontalAlignment(1);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(3);
                break;
            }
            default: {
                throw new z88("Center, Right, Left values are valid only");
            }
        }
    }

    public int getHorizontalAlignment() {
        this.m4();
        return this.m14;
    }

    public void setHorizontalAlignment(int value) {
        this.m4();
        this.m14 = value;
    }

    @Deprecated
    public VerticalAlignmentType getVerticalAlignment() {
        int n = this.getVerticalAlignmentType();
        switch (n) {
            case 1: {
                return VerticalAlignmentType.Top;
            }
            case 2: {
                return VerticalAlignmentType.Center;
            }
            case 3: {
                return VerticalAlignmentType.Bottom;
            }
        }
        throw new z5("Unknown Alignment type");
    }

    @Deprecated
    public void setVerticalAlignment(VerticalAlignmentType value) {
        VerticalAlignmentType verticalAlignmentType = value;
        switch (m19.m1(verticalAlignmentType.toString())) {
            case 3: {
                this.setVerticalAlignmentType(1);
                break;
            }
            case 4: {
                this.setVerticalAlignmentType(3);
                break;
            }
            case 0: {
                this.setVerticalAlignmentType(2);
                break;
            }
            default: {
                this.setVerticalAlignmentType(0);
            }
        }
    }

    public int getVerticalAlignmentType() {
        this.m4();
        return this.m15;
    }

    public void setVerticalAlignmentType(int value) {
        this.m4();
        this.m15 = value;
    }

    public void movePosition(float moveX, float moveY) {
        this.m4();
        this.m16 = new Point(moveX, moveY);
    }

    public int getPages() {
        this.m4();
        return this.getDocument().getPages().size();
    }

    public PageSize getPageSize(int page) {
        this.m4();
        Rectangle rectangle = this.getDocument().getPages().get_Item(page).getRect();
        z12 z12100 = this.getDocument().getPages().get_Item((int)page).EnginePage.m1();
        z16 z1610 = null;
        if (z12100.m4() != null) {
            z1610 = z12100.m4();
        } else if (z12100.m3() != null) {
            z1610 = z12100.m3();
        } else {
            throw new z6("Page doesn't have required entry MediaBox");
        }
        double d = z148.m1(z1610.m3() - z1610.m1());
        double d2 = z148.m1(z1610.m4() - z1610.m2());
        for (int i = Page.rotationToInt(this.getDocument().getPages().get_Item(page).getRotate()); i > 0; i -= 90) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return new PageSize((float)d, (float)d2);
    }

    public int getPageRotation(int page) {
        this.m4();
        return Page.rotationToInt(this.getDocument().getPages().get_Item(page).getRotate());
    }

    public java.awt.Rectangle getPageBoxSize(int page, String pageBoxName) {
        return this.m1(page, pageBoxName).m1();
    }

    z39 m1(int n, String string) {
        this.m4();
        switch (m19.m1(string)) {
            case 5: {
                return this.m1(this.getDocument().getPages().get_Item(n).getTrimBox());
            }
            case 6: {
                return this.m1(this.getDocument().getPages().get_Item(n).getArtBox());
            }
            case 7: {
                return this.m1(this.getDocument().getPages().get_Item(n).getBleedBox());
            }
            case 8: {
                return this.m1(this.getDocument().getPages().get_Item(n).getCropBox());
            }
            case 9: {
                return this.m1(this.getDocument().getPages().get_Item(n).getMediaBox());
            }
        }
        throw new z6(z111.m1("\"{0}\" is invalid box name", new Object[]{string}));
    }

    @Override
    public void save(String outputFile) {
        this.m2();
        super.save(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream outputStream) {
        z29 z2910 = new z29();
        this.a_(z2910);
        try {
            if (((z38)z2910).canSeek()) {
                ((z38)z2910).seek(0L, 0);
            }
            byte[] byArray = new byte[z2910.toInputStream().available()];
            z2910.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (z2910 != null) {
                z2910.close();
            }
        }
    }

    @Override
    void a_(z38 z3810) {
        this.m2();
        super.a_(z3810);
    }

    public void applyChanges() {
        this.m2();
        this.m8 = new int[0];
    }

    private void m2() {
        this.m4();
        if (this.m8 == null) {
            for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
                this.m2(i);
            }
        } else {
            for (int n : this.m8) {
                this.m2(n);
            }
        }
    }

    @Override
    public void bindPdf(Pdf pdf) {
        this.bindPdf(new Document(pdf));
    }

    private int m1(int n) {
        int n2 = this.m9;
        if (this.m1().contains(n)) {
            n2 = (Integer)this.m1().get_Item(n);
        }
        return n2 % 360;
    }

    private boolean m1(Page page, String string) {
        return ((z13)((Object)com.aspose.pdf.internal.p346.z5.m1(page.EnginePage, z13.class))).m57().m2(string) != null;
    }

    private void m2(int n) {
        Object object;
        Page page = this.getDocument().getPages().get_Item(n);
        XForm xForm = XForm.createNewForm(page, this.getDocument());
        page.getResources().getForms().add(xForm);
        xForm.setBBox(page.getMediaBox());
        page.clearContents();
        Matrix matrix = new Matrix(new double[]{this.m12, 0.0, 0.0, this.m12, 0.0, 0.0});
        int n2 = this.m1(n);
        Matrix matrix2 = Matrix.rotation(Math.PI * (double)(-n2) / 180.0);
        matrix = matrix2.multiply(matrix);
        Rectangle rectangle = new Rectangle(page.getMediaBox().getLLX(), page.getMediaBox().getLLY(), page.getMediaBox().getURX(), page.getMediaBox().getURY());
        Rectangle rectangle2 = matrix2.transform(rectangle);
        Rectangle rectangle3 = matrix.transform(rectangle);
        matrix.setE(-rectangle3.getLLX());
        matrix.setF(-rectangle3.getLLY());
        PageSize pageSize = this.m13 != null ? new PageSize(this.m13.getWidth(), this.m13.getHeight()) : new PageSize((float)rectangle2.getWidth(), (float)rectangle2.getHeight());
        if (pageSize.getWidth() == -1.0f) {
            pageSize.setWidth((float)page.getRect().getWidth());
        }
        if (pageSize.getHeight() == -1.0f) {
            pageSize.setHeight((float)page.getRect().getHeight());
        }
        PageSize pageSize2 = new PageSize((float)rectangle3.getWidth(), (float)rectangle3.getHeight());
        Point point = new Point(0.0, 0.0);
        if (this.m14 == 3) {
            point.setX(pageSize.getWidth() - pageSize2.getWidth());
        } else if (this.m14 == 2) {
            point.setX((pageSize.getWidth() - pageSize2.getWidth()) / 2.0f);
        }
        if (this.m15 == 1) {
            point.setY(pageSize.getHeight() - pageSize2.getHeight());
        } else if (this.m15 == 2) {
            point.setY((pageSize.getHeight() - pageSize2.getHeight()) / 2.0f);
        }
        matrix.setE(matrix.getE() + point.getX());
        matrix.setF(matrix.getF() + point.getY());
        if (this.m16 != null) {
            matrix.setE(matrix.getE() + this.m16.getX());
            matrix.setF(matrix.getF() + this.m16.getY());
        }
        if (page.getRotate() == 3 || page.getRotate() == 1) {
            pageSize = new PageSize(pageSize.getHeight(), pageSize.getWidth());
        }
        if (this.m1(page, "MediaBox")) {
            page.setMediaBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.m1(page, "CropBox")) {
            page.setCropBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.m1(page, "ArtBox")) {
            page.setArtBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.m1(page, "BleedBox")) {
            page.setBleedBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.m1(page, "TrimBox")) {
            page.setTrimBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if ((this.m4 & 2) != 0) {
            object = new z1(this.getDocument(), this.getTransitionType());
            if ((this.m4 & 1) != 0) {
                ((z1)object).m1(this.getTransitionDuration());
            }
            page.setTransition(((z1)object).m2());
        }
        if ((this.m4 & 4) != 0) {
            page.setDuration(this.getDisplayDuration());
        }
        object = new ArrayList();
        ((ArrayList)object).add(new Operator.GSave());
        ((ArrayList)object).add(new Operator.ConcatenateMatrix(matrix));
        ((ArrayList)object).add(new Operator.Do(xForm.getName()));
        ((ArrayList)object).add(new Operator.GRestore());
        page.getContents().add((Iterable)object);
        for (Annotation annotation : page.getAnnotations()) {
            annotation.setRect(matrix.transform(annotation.getRect()));
            for (String string : annotation.getAppearance().getKeys()) {
                XForm xForm2 = annotation.getAppearance().get_Item(string);
                Matrix matrix3 = xForm2.getMatrix();
                if (matrix3 == null) {
                    matrix3 = new Matrix();
                }
                if (xForm2.getEngineObj().m57().m4("BBox")) {
                    // empty if block
                }
                xForm2.setMatrix(matrix.multiply(matrix3));
            }
        }
    }

    private void m3(int n) {
        if (n % 90 != 0) {
            throw new z6(m18);
        }
    }

    private void m2(z10 z10100) {
        for (Object t : z10100.getKeys()) {
            Object object = z10100.get_Item(t);
            if (t instanceof Integer && object instanceof Integer) {
                int n = (Integer)t;
                int n2 = (Integer)object;
                this.m3(n2);
                Page page = this.getDocument().getPages().get_Item(n);
                continue;
            }
            throw new z6(m17);
        }
    }

    private z39 m1(Rectangle rectangle) {
        return new z39((int)rectangle.getLLX(), (int)rectangle.getLLY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private static class z1 {
        public int m1;
        public IDocument m2;
        public int m3 = 1;

        public z1(IDocument iDocument, int n) {
            this.m1 = n;
            this.m2 = iDocument;
        }

        public int m1() {
            return this.m3;
        }

        public void m1(int n) {
            this.m3 = n;
        }

        public z8 m2() {
            z24 z2410 = new z24(this.m2.getEngineDoc().m2());
            z2410.m2("Type", (z15)new z26("Trans"));
            z2410.m2("D", (z15)new z28(this.m3));
            String string = "";
            String string2 = null;
            String string3 = null;
            z28 z2810 = null;
            switch (this.m1) {
                case 1: {
                    string = "Split";
                    string2 = "V";
                    string3 = "O";
                    break;
                }
                case 2: {
                    string = "Split";
                    string2 = "H";
                    string3 = "O";
                    break;
                }
                case 3: {
                    string = "Split";
                    string2 = "V";
                    string3 = "I";
                    break;
                }
                case 4: {
                    string = "Split";
                    string2 = "H";
                    string3 = "I";
                    break;
                }
                case 5: {
                    string = "Blinds";
                    string2 = "V";
                    break;
                }
                case 6: {
                    string = "Blinds";
                    string2 = "H";
                    break;
                }
                case 7: {
                    string = "Box";
                    string3 = "I";
                    break;
                }
                case 8: {
                    string = "Box";
                    string3 = "O";
                    break;
                }
                case 9: {
                    string = "Wipe";
                    z2810 = new z28(0.0);
                    break;
                }
                case 10: {
                    string = "Wipe";
                    z2810 = new z28(180.0);
                    break;
                }
                case 11: {
                    string = "Wipe";
                    z2810 = new z28(90.0);
                    break;
                }
                case 12: {
                    string = "Wipe";
                    z2810 = new z28(270.0);
                    break;
                }
                case 13: {
                    string = "Dissolve";
                    break;
                }
                case 14: {
                    string = "Glitter";
                    z2810 = new z28(0.0);
                    break;
                }
                case 15: {
                    string = "Glitter";
                    z2810 = new z28(270.0);
                    break;
                }
                case 16: {
                    string = "Glitter";
                    z2810 = new z28(315.0);
                }
            }
            z2410.m2("S", (z15)new z26(string));
            if (string2 != null) {
                z2410.m2("Dm", (z15)new z26(string2));
            }
            if (string3 != null) {
                z2410.m2("M", (z15)new z26(string3));
            }
            if (z2810 != null) {
                z2410.m2("Di", (z15)z2810);
            }
            return z2410;
        }
    }
}

