/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.admin.tables;

import com.atlassian.activeobjects.admin.tables.RowCounter;
import com.atlassian.activeobjects.backup.ActiveObjectsBackup;
import com.atlassian.activeobjects.backup.ActiveObjectsTableReader;
import com.atlassian.activeobjects.backup.ImportExportErrorServiceImpl;
import com.atlassian.activeobjects.backup.PluginInformationFactory;
import com.atlassian.activeobjects.internal.DatabaseProviderFactory;
import com.atlassian.activeobjects.spi.PluginInformation;
import com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider;
import com.atlassian.dbexporter.DatabaseInformation;
import com.atlassian.dbexporter.Table;
import com.atlassian.dbexporter.exporter.TableReader;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import net.java.ao.DatabaseProvider;
import net.java.ao.schema.NameConverters;

public final class TablesController {
    private final DatabaseProviderFactory databaseProviderFactory;
    private final NameConverters nameConverters;
    private final TenantAwareDataSourceProvider tenantAwareDataSourceProvider;
    private final ImportExportErrorServiceImpl errorService;
    private final PluginInformationFactory pluginInformationFactory;
    private final TenantContext tenantContext;

    public TablesController(DatabaseProviderFactory databaseProviderFactory, NameConverters nameConverters, TenantAwareDataSourceProvider tenantAwareDataSourceProvider, ImportExportErrorServiceImpl errorService, PluginInformationFactory pluginInformationFactory, TenantContext tenantContext) {
        this.pluginInformationFactory = (PluginInformationFactory)Preconditions.checkNotNull((Object)pluginInformationFactory);
        this.nameConverters = (NameConverters)Preconditions.checkNotNull((Object)nameConverters);
        this.databaseProviderFactory = (DatabaseProviderFactory)Preconditions.checkNotNull((Object)databaseProviderFactory);
        this.tenantAwareDataSourceProvider = (TenantAwareDataSourceProvider)Preconditions.checkNotNull((Object)tenantAwareDataSourceProvider);
        this.errorService = (ImportExportErrorServiceImpl)Preconditions.checkNotNull((Object)errorService);
        this.tenantContext = (TenantContext)Preconditions.checkNotNull((Object)tenantContext);
    }

    public Multimap<PluginInformation, TableInformation> list() {
        Tenant tenant = this.tenantContext.getCurrentTenant();
        DatabaseProvider databaseProvider = this.getDatabaseProvider(tenant);
        Iterable<Table> tables = this.readTables(this.newTableReader(databaseProvider));
        RowCounter rowCounter = RowCounter.from(databaseProvider);
        return this.tablesPerPlugin(tables, rowCounter);
    }

    private Iterable<Table> readTables(TableReader tableReader) {
        return tableReader.read(this.emptyDatabaseInformation(), this.newEntityNameProcessor());
    }

    private ActiveObjectsBackup.UpperCaseEntityNameProcessor newEntityNameProcessor() {
        return new ActiveObjectsBackup.UpperCaseEntityNameProcessor();
    }

    private DatabaseInformation emptyDatabaseInformation() {
        return new DatabaseInformation(Maps.newHashMap());
    }

    private ActiveObjectsTableReader newTableReader(DatabaseProvider databaseProvider) {
        return new ActiveObjectsTableReader(this.errorService, this.nameConverters, databaseProvider, ActiveObjectsBackup.schemaConfiguration());
    }

    private DatabaseProvider getDatabaseProvider(Tenant tenant) {
        return this.databaseProviderFactory.getDatabaseProvider(this.tenantAwareDataSourceProvider.getDataSource(tenant), this.tenantAwareDataSourceProvider.getDatabaseType(tenant), this.tenantAwareDataSourceProvider.getSchema(tenant));
    }

    private Multimap<PluginInformation, TableInformation> tablesPerPlugin(Iterable<Table> tables, RowCounter rowCounter) {
        HashMultimap tablesPerPlugin = HashMultimap.create();
        for (Table table : tables) {
            String tableName = table.getName();
            tablesPerPlugin.put((Object)this.newPluginInformation(tableName), (Object)this.newTableInformation(tableName, rowCounter));
        }
        return tablesPerPlugin;
    }

    private PluginInformation newPluginInformation(String tableName) {
        return this.pluginInformationFactory.getPluginInformation(tableName);
    }

    private TableInformation newTableInformation(String tableName, RowCounter rowCounter) {
        return new TableInformation(tableName, rowCounter.count(tableName));
    }

    public static final class TableInformation {
        private final String table;
        private final String rows;

        public TableInformation(String table, int rows) {
            this.table = (String)Preconditions.checkNotNull((Object)table);
            this.rows = String.valueOf(rows);
        }

        public String getTable() {
            return this.table;
        }

        public String getRows() {
            return this.rows;
        }
    }
}

