/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.google.common.base.Preconditions;

public final class ClassId {
    private final String packageName;
    private final String className;

    public static ClassId packageAndClass(String packageName, String className) {
        return new ClassId(packageName, className);
    }

    public static ClassId fullyQualified(String fullyQualifiedClassName) {
        Preconditions.checkNotNull((Object)fullyQualifiedClassName);
        int lastDotPos = fullyQualifiedClassName.lastIndexOf(".");
        if (lastDotPos > 0) {
            return new ClassId(fullyQualifiedClassName.substring(0, lastDotPos), fullyQualifiedClassName.substring(lastDotPos + 1));
        }
        return new ClassId("", fullyQualifiedClassName);
    }

    private ClassId(String packageName, String className) {
        this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"packageName");
        this.className = (String)Preconditions.checkNotNull((Object)className, (Object)"className");
    }

    public ClassId packageName(String packageName) {
        return new ClassId(packageName, this.className);
    }

    public ClassId packageNamePrefix(String prefix) {
        return new ClassId(this.packageName.equals("") ? prefix : prefix + "." + this.packageName, this.className);
    }

    public ClassId className(String className) {
        return new ClassId(this.packageName, className);
    }

    public ClassId classNameSuffix(String suffix) {
        return new ClassId(this.packageName, this.className + suffix);
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getName() {
        return this.className;
    }

    public String getFullName() {
        return this.packageName.equals("") ? this.className : this.packageName + "." + this.className;
    }

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object other) {
        if (other instanceof ClassId) {
            ClassId c = (ClassId)other;
            return this.className.equals(c.className) && this.packageName.equals(c.packageName);
        }
        return false;
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }
}

