/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.bitbucket.hook;

import com.atlassian.plugins.codegen.modules.BasicClassModuleProperties;
import com.google.common.collect.Lists;
import java.util.List;

public class BitbucketRepositoryHookProperties
extends BasicClassModuleProperties {
    private static final String ICON = "ICON";
    private static final String FIELDS = "FIELDS";
    private static final String SOY_PACKAGE = "SOY_PACKAGE";
    private final String type;

    public BitbucketRepositoryHookProperties(String fqRequestClassName, String type) {
        super(fqRequestClassName);
        this.type = type;
        this.setConfigured(true);
        this.setIcon(true);
    }

    public String getType() {
        return this.type;
    }

    public String getIcon() {
        return (String)this.get(ICON);
    }

    public void setIcon(boolean icon) {
        if (icon) {
            this.put(ICON, "icon-example.png");
        } else {
            this.remove(ICON);
        }
    }

    public boolean ifConfigured() {
        return this.get(FIELDS) != null;
    }

    public void addField(String fieldName) {
        List fields = (List)this.get(FIELDS);
        if (fields == null) {
            fields = Lists.newArrayList();
            this.put(FIELDS, fields);
        }
        fields.add(fieldName);
    }

    public void setConfigured(boolean configured) {
        if (configured) {
            if (this.type.equals("post")) {
                this.addField("url");
            } else if (this.type.equals("merge")) {
                this.addField("reviewers");
            }
        } else {
            this.remove(FIELDS);
        }
    }

    @Override
    public void setFullyQualifiedClassname(String fqName) {
        super.setFullyQualifiedClassname(fqName);
        this.put(SOY_PACKAGE, this.getClassId().getPackage() + "." + this.getClassId().getName().toLowerCase());
    }

    public String getSoyFile() {
        return this.getProperty("MODULE_KEY") + ".soy";
    }
}

