/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.confluence.blueprint;

import com.atlassian.plugins.codegen.ClassId;
import com.atlassian.plugins.codegen.ComponentDeclaration;
import com.atlassian.plugins.codegen.modules.common.ContextProviderProperties;
import com.atlassian.plugins.codegen.modules.common.Resource;
import com.atlassian.plugins.codegen.modules.common.web.WebItemProperties;
import com.atlassian.plugins.codegen.modules.common.web.WebResourceProperties;
import com.atlassian.plugins.codegen.modules.common.web.WebResourceTransformation;
import com.atlassian.plugins.codegen.modules.common.web.WebResourceTransformer;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintI18nProperty;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintPromptEntries;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintPromptEntry;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintProperties;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintStringer;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.ContentTemplateProperties;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.DialogPageProperties;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.DialogWizardProperties;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;

public class BlueprintBuilder {
    private final BlueprintPromptEntries promptProps;
    private final BlueprintProperties props;
    private BlueprintStringer stringer;

    public BlueprintBuilder(BlueprintPromptEntries promptProps) {
        this.promptProps = promptProps;
        this.props = new BlueprintProperties();
    }

    public BlueprintProperties build() {
        String pluginKey = this.promptProps.getPluginKey();
        this.props.setPluginKey(pluginKey);
        String indexKey = (String)this.promptProps.get((Object)BlueprintPromptEntry.INDEX_KEY_PROMPT);
        this.props.setProperty("INDEX_KEY", indexKey);
        this.stringer = new BlueprintStringer(indexKey, this.props.getPluginKey());
        String blueprintModuleKey = this.stringer.makeBlueprintModuleKey();
        this.props.setModuleKey(blueprintModuleKey);
        WebItemProperties webItem = this.makeWebItem(pluginKey, blueprintModuleKey, indexKey, this.promptProps);
        this.props.setWebItem(webItem);
        String blueprintName = (String)this.promptProps.get((Object)BlueprintPromptEntry.WEB_ITEM_NAME_PROMPT);
        this.props.setModuleName(this.stringer.makeBlueprintModuleName(blueprintName));
        String indexTitleI18nKey = this.stringer.makeI18nKey("index.page.title");
        this.props.setIndexTitleI18nKey(indexTitleI18nKey);
        this.props.addI18nProperty(indexTitleI18nKey, blueprintName + "s");
        List contentTemplateKeys = (List)this.promptProps.get((Object)BlueprintPromptEntry.CONTENT_TEMPLATE_KEYS_PROMPT);
        ContextProviderProperties contextProvider = null;
        String packageName = this.cleanupPackage(pluginKey);
        if (((Boolean)this.promptProps.get((Object)BlueprintPromptEntry.CONTEXT_PROVIDER_PROMPT)).booleanValue()) {
            contextProvider = new ContextProviderProperties(packageName + ".ContentTemplateContextProvider");
        }
        boolean hasDialogWizard = (Boolean)this.promptProps.get((Object)BlueprintPromptEntry.DIALOG_WIZARD_PROMPT);
        boolean skipEditor = (Boolean)this.promptProps.get((Object)BlueprintPromptEntry.SKIP_PAGE_EDITOR_PROMPT);
        String placeholderI18nKey = null;
        String mentionPlaceholderI18nKey = null;
        if (!skipEditor) {
            placeholderI18nKey = BlueprintI18nProperty.CONTENT_TEMPLATE_PLACEHOLDER.getI18nKey(this.stringer);
            mentionPlaceholderI18nKey = BlueprintI18nProperty.CONTENT_TEMPLATE_MENTION_PLACEHOLDER.getI18nKey(this.stringer);
            this.props.addI18nProperty(placeholderI18nKey, BlueprintI18nProperty.CONTENT_TEMPLATE_PLACEHOLDER.getI18nValue());
            this.props.addI18nProperty(mentionPlaceholderI18nKey, BlueprintI18nProperty.CONTENT_TEMPLATE_MENTION_PLACEHOLDER.getI18nValue());
        }
        for (int i = 0; i < contentTemplateKeys.size(); ++i) {
            String contentTemplateKey = (String)contentTemplateKeys.get(i);
            String moduleName = this.stringer.makeContentTemplateName(blueprintName, i);
            String description = "Contains Storage-format XML used by the " + blueprintName + " Blueprint";
            ContentTemplateProperties contentTemplate = this.makeContentTemplate(contentTemplateKey, moduleName, contextProvider, pluginKey, "This text will replace the at:i18n placeholder in the content template XML.", description);
            contentTemplate.setProperty("DIALOG_WIZARD", String.valueOf(hasDialogWizard));
            if (!skipEditor) {
                contentTemplate.setProperty(BlueprintI18nProperty.CONTENT_TEMPLATE_PLACEHOLDER.getPropertyKey(), placeholderI18nKey);
                contentTemplate.setProperty(BlueprintI18nProperty.CONTENT_TEMPLATE_MENTION_PLACEHOLDER.getPropertyKey(), mentionPlaceholderI18nKey);
            }
            this.props.addContentTemplate(contentTemplate);
        }
        WebResourceProperties webResource = new WebResourceProperties();
        webResource.addContext("atl.general");
        webResource.addContext("atl.admin");
        webResource.addDependency("com.atlassian.confluence.plugins.confluence-create-content-plugin:resources");
        Resource cssResource = new Resource();
        cssResource.setType("download");
        cssResource.setName("blueprints.css");
        cssResource.setLocation("css/blueprints.css");
        webResource.addResource(cssResource);
        webResource.setProperty("INDEX_KEY", indexKey);
        this.props.setWebResource(webResource);
        boolean hasHowToUse = (Boolean)this.promptProps.get((Object)BlueprintPromptEntry.HOW_TO_USE_PROMPT);
        String soyPackage = this.stringer.makeSoyTemplatePackage(blueprintName);
        if (hasHowToUse) {
            this.props.setHowToUseTemplate(soyPackage + ".howToUse");
        }
        if (hasDialogWizard) {
            DialogWizardProperties wizard = new DialogWizardProperties();
            wizard.setModuleKey(indexKey + "-wizard");
            DialogPageProperties wizardPage = new DialogPageProperties(0, soyPackage, this.stringer);
            wizard.setDialogPages(Lists.newArrayList((Object[])new DialogPageProperties[]{wizardPage}));
            this.props.setDialogWizard(wizard);
            this.addJsToWebResource(webResource);
            this.addJsI18n(webResource);
            webResource.setProperty("PLUGIN_KEY", pluginKey);
            webResource.setProperty("WEB_ITEM_KEY", webItem.getModuleKey());
            webResource.setProperty("WIZARD_FORM_TITLE_FIELD_ID", indexKey + "-blueprint-page-title");
        }
        if (hasHowToUse || hasDialogWizard) {
            this.addSoyTemplateToWebResource(webResource, this.props.getPluginKey(), indexKey, soyPackage, hasHowToUse, hasDialogWizard);
        }
        if (((Boolean)this.promptProps.get((Object)BlueprintPromptEntry.EVENT_LISTENER_PROMPT)).booleanValue()) {
            ClassId classId = ClassId.packageAndClass((String)packageName, (String)"BlueprintCreatedListener");
            ComponentDeclaration component = ComponentDeclaration.builder((ClassId)classId, (String)"blueprint-created-listener").name(Option.some((Object)"Blueprint Created Event Listener")).build();
            this.props.setEventListener(component);
        }
        if (skipEditor) {
            this.props.setCreateResult("view");
        }
        if (((Boolean)this.promptProps.get((Object)BlueprintPromptEntry.INDEX_PAGE_TEMPLATE_PROMPT)).booleanValue()) {
            String contentTemplateKey = "custom-index-page-template";
            String moduleName = "Custom Index Page Content Template";
            String description = "Contains Storage-format XML used by the " + blueprintName + " Blueprint's Index page";
            ContentTemplateProperties contentTemplate = this.makeContentTemplate(contentTemplateKey, moduleName, contextProvider, pluginKey, "This index page has used instead of the default one, by setting the index-template-key attribute of the blueprint config element.", description);
            this.props.setIndexPageContentTemplate(contentTemplate);
        }
        return this.props;
    }

    private String cleanupPackage(String pluginKey) {
        return pluginKey.replaceAll("[^a-z\\.]", "_");
    }

    private void addJsI18n(WebResourceProperties properties) {
        this.addI18n(properties, BlueprintI18nProperty.WIZARD_FORM_TITLE_FIELD_LABEL);
        this.addI18n(properties, BlueprintI18nProperty.WIZARD_FORM_TITLE_FIELD_PLACEHOLDER);
        this.addI18n(properties, BlueprintI18nProperty.WIZARD_FORM_TITLE_FIELD_ERROR);
        this.addI18n(properties, BlueprintI18nProperty.WIZARD_FORM_JSVAR_FIELD_LABEL);
        this.addI18n(properties, BlueprintI18nProperty.WIZARD_FORM_JSVAR_FIELD_PLACEHOLDER);
        this.addI18n(properties, BlueprintI18nProperty.WIZARD_FORM_PRE_RENDER_TEXT);
        this.addI18n(properties, BlueprintI18nProperty.WIZARD_FORM_POST_RENDER_TEXT);
        this.addI18n(properties, BlueprintI18nProperty.WIZARD_FORM_FIELD_REQUIRED);
    }

    private void addI18n(WebResourceProperties properties, BlueprintI18nProperty i18n) {
        String i18nKey = i18n.getI18nKey(this.stringer);
        properties.setProperty(i18n.getPropertyKey(), i18nKey);
        properties.addI18nProperty(i18nKey, i18n.getI18nValue());
    }

    private void addJsToWebResource(WebResourceProperties properties) {
        WebResourceTransformation transformation = new WebResourceTransformation("js");
        WebResourceTransformer transformer = new WebResourceTransformer();
        transformer.setModuleKey("jsI18n");
        transformation.addTransformer(transformer);
        properties.addTransformation(transformation);
        Resource soyResource = new Resource();
        soyResource.setType("download");
        soyResource.setName("dialog-wizard.js");
        soyResource.setLocation("js/dialog-wizard.js");
        properties.addResource(soyResource);
    }

    private void addSoyTemplateToWebResource(WebResourceProperties properties, String pluginKey, String indexKey, String soyPackage, boolean hasHowToUse, boolean hasDialogWizard) {
        WebResourceTransformation transformation = new WebResourceTransformation("soy");
        WebResourceTransformer transformer = new WebResourceTransformer();
        transformer.setModuleKey("soyTransformer");
        transformer.addFunctions("com.atlassian.confluence.plugins.soy:soy-core-functions");
        transformation.addTransformer(transformer);
        properties.addTransformation(transformation);
        Resource soyResource = new Resource();
        soyResource.setType("download");
        soyResource.setName("templates-soy.js");
        soyResource.setLocation("soy/my-templates.soy");
        properties.addResource(soyResource);
        properties.setProperty("SOY_PACKAGE", soyPackage);
        if (hasHowToUse) {
            properties.put("HOW_TO_USE", (Object)true);
            this.addI18n(properties, BlueprintI18nProperty.HOW_TO_USE_HEADING);
            this.addI18n(properties, BlueprintI18nProperty.HOW_TO_USE_CONTENT);
        }
        if (hasDialogWizard) {
            properties.put("DIALOG_WIZARD", (Object)true);
            properties.setProperty("INDEX_KEY", indexKey);
        }
    }

    private ContentTemplateProperties makeContentTemplate(String contentTemplateKey, String moduleName, ContextProviderProperties contextProvider, String pluginKey, String contentTextValue, String description) {
        ContentTemplateProperties template = new ContentTemplateProperties(contentTemplateKey);
        template.setModuleName(moduleName);
        template.setDescription(description);
        template.setNameI18nKey(pluginKey + "." + contentTemplateKey + ".name");
        template.setDescriptionI18nKey(pluginKey + "." + contentTemplateKey + ".desc");
        template.setContentText(pluginKey + "." + contentTemplateKey + ".content.text", contentTextValue);
        if (contextProvider != null) {
            template.setContextProvider(contextProvider);
        }
        Resource templateResource = new Resource();
        templateResource.setName("template");
        templateResource.setType("download");
        templateResource.setLocation("xml/" + contentTemplateKey + ".xml");
        template.addResource(templateResource);
        return template;
    }

    private WebItemProperties makeWebItem(String pluginKey, String blueprintModuleKey, String indexKey, BlueprintPromptEntries promptProps) {
        WebItemProperties webItem = new WebItemProperties();
        webItem.setModuleKey(blueprintModuleKey + "-web-item");
        webItem.setModuleName((String)promptProps.get((Object)BlueprintPromptEntry.WEB_ITEM_NAME_PROMPT));
        webItem.setDescription((String)promptProps.get((Object)BlueprintPromptEntry.WEB_ITEM_DESC_PROMPT));
        webItem.setNameI18nKey(pluginKey + ".blueprint.display.name");
        webItem.setDescriptionI18nKey(pluginKey + ".blueprint.display.desc");
        webItem.setSection("system.create.dialog/content");
        webItem.addParam("blueprintKey", blueprintModuleKey);
        webItem.setStyleClass("icon-" + indexKey + "-blueprint large");
        return webItem;
    }
}

