package com.atlassian.logging.log4j.layout.json;

import java.util.Map;

/**
 * Provides data necessary to construct a json log.
 */
public interface JsonDataProvider {
    /**
     * Gets Unicorn fields, environment and hostname.  Result will be memoized by JsonLayout - so this will only called once.
     */
    JsonStaticData getStaticData();

    /**
     * Gets request context data
     */
    JsonContextData getContextData(JsonLayoutHelper.LogEvent event);

    /**
     * Data to be injected into the json string, under "ext".  Use periods in key to create objects - for example
     * "a.b" will generate {..., ext: {a: {b: value}}} json.
     */
    Map<String, Object> getExtraData(JsonLayoutHelper.LogEvent event);

    /**
     * @return fully-qualified domain name (FQDN) of this host
     */
    String getHostName();
}
