/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.model.AccountAttribute;
import com.amazonaws.services.ec2.model.Address;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.services.ec2.model.Vpc;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EC2InstanceListener;
import com.atlassian.aws.ec2.InstanceLaunchConfiguration;
import com.atlassian.aws.ec2.Protocol;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.SpotPrices;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.caches.SubnetCache;
import com.atlassian.aws.ec2.model.InstanceId;
import com.atlassian.aws.ec2.model.VpcId;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AWSAccount {
    @Nullable
    public String getAccountValidationError() throws AWSException;

    @NotNull
    public RemoteEC2Instance newEC2Instance(@NotNull InstanceLaunchConfiguration var1, EC2InstanceListener var2);

    @NotNull
    public Iterable<SecurityGroup> describeSecurityGroups() throws AWSException;

    @NotNull
    public SecurityGroup newSecurityGroup(@NotNull String var1, @NotNull String var2, @Nullable VpcId var3) throws AWSException;

    public void ensureInboundTrafficIsAllowed(SecurityGroup var1, Protocol var2, String var3, int var4);

    @NotNull
    public Map<String, KeyPairInfo> describeEc2KeyPairs(String ... var1);

    @NotNull
    public KeyPair newEC2KeyPair(String var1) throws AWSException;

    @NotNull
    public Map<String, AvailabilityZone> getAvailabilityZones() throws AWSException;

    @Nullable
    public String getConsoleOutput(String var1);

    @NotNull
    public Collection<Instance> getAllInstances() throws AWSException;

    @NotNull
    public Collection<SpotInstanceRequest> describePendingSpotInstanceRequests(String ... var1);

    public Collection<Instance> describeInstances(String ... var1);

    @Nullable
    public String getPassword(@NotNull File var1, @NotNull InstanceId var2);

    public Image describeImage(String var1);

    public List<Image> describeImages(String ... var1);

    public Collection<SpotInstanceRequest> describeSpotInstanceRequests(String ... var1);

    @NotNull
    public Collection<Volume> describeVolumes() throws AWSException;

    public String createVolume(@NotNull String var1, @NotNull String var2);

    public void attachVolume(@NotNull String var1, @NotNull String var2, @NotNull String var3, boolean var4);

    public void shutdownInstance(String var1) throws AWSException;

    public void deleteVolume(String var1) throws AWSException;

    @NotNull
    public SpotPrices getSpotPrices();

    public AmazonEC2Async getAmazonEc2();

    public void setMaximumEbsVolumeStatusAgeSeconds(int var1);

    public void setMaximumInstanceStatusAgeSeconds(int var1);

    public void setMaximumSpotRequestStatusAgeSeconds(int var1);

    @NotNull
    public Map<Vpc, Collection<Subnet>> describeVpcs() throws AWSException;

    @NotNull
    public Collection<Subnet> describeSubnets(String ... var1);

    @NotNull
    public List<Address> describeAddresses(String ... var1);

    public void createTag(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public AwsSupportConstants.Region getRegion();

    public void cancelSpotInstanceRequests(String ... var1);

    @NotNull
    public Map<String, AccountAttribute> getAccountAttributes();

    public SubnetCache getSubnetCache();
}

