/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSAccountImpl;
import com.atlassian.aws.AWSManager;
import com.atlassian.aws.Ec2ClientFactory;
import com.atlassian.aws.credentials.AWSCredentials;
import com.atlassian.aws.credentials.StaticAWSCredentials;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ScheduledExecutorService;

public class AWSManagerImpl
implements AWSManager {
    private final Ec2ClientFactory ec2ClientFactory;
    private final ScheduledExecutorService scheduledExecutorService;

    public AWSManagerImpl(Ec2ClientFactory ec2ClientFactory, ScheduledExecutorService scheduledExecutorService) {
        this.ec2ClientFactory = ec2ClientFactory;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public AWSAccount getAWSAccount(AwsSupportConstants.Region region, String awsAccessId, String awsSecretKey) {
        return this.getAWSAccount(region, new StaticAWSCredentials(awsAccessId, awsSecretKey));
    }

    @Override
    public AWSAccount getAWSAccount(AwsSupportConstants.Region region, AWSCredentials awsCredentials) {
        awsCredentials.validateCredentials();
        return this.getAWSAccount(region, awsCredentials.getAWSCredentialsProvider());
    }

    @VisibleForTesting
    public AWSAccount getAWSAccount(AwsSupportConstants.Region region, AWSCredentialsProvider awsCredentialsProvider) {
        return new AWSAccountImpl(this.ec2ClientFactory, this.scheduledExecutorService, awsCredentialsProvider, region);
    }
}

