/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.credentials;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.atlassian.aws.credentials.AWSCredentials;
import com.atlassian.aws.credentials.AWSCredentialsValidationException;
import com.atlassian.aws.ec2.EC2Utils;

public class EC2ProfileCredentials
implements AWSCredentials {
    @Override
    public AWSCredentialsProvider getAWSCredentialsProvider() {
        return InstanceProfileCredentialsProvider.getInstance();
    }

    @Override
    public void validateCredentials() {
        if (!EC2Utils.isHostEC2()) {
            throw new AWSCredentialsValidationException("Current host is not an EC2 instance");
        }
        if (!EC2Utils.hasIAMRoleAttached()) {
            throw new AWSCredentialsValidationException("No instance profile has been found");
        }
    }
}

