/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.credentials;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.atlassian.aws.credentials.AWSCredentials;
import com.atlassian.aws.credentials.AWSCredentialsValidationException;
import org.apache.commons.lang3.StringUtils;

public class StaticAWSCredentials
implements AWSCredentials {
    final String awsAccessId;
    final String awsSecretKey;

    public StaticAWSCredentials(String awsAccessId, String awsSecretKey) {
        this.awsAccessId = awsAccessId;
        this.awsSecretKey = awsSecretKey;
    }

    @Override
    public AWSCredentialsProvider getAWSCredentialsProvider() {
        return new AWSStaticCredentialsProvider((com.amazonaws.auth.AWSCredentials)new BasicAWSCredentials(this.awsAccessId, this.awsSecretKey));
    }

    @Override
    public void validateCredentials() {
        if (StringUtils.isBlank((CharSequence)this.awsAccessId) || StringUtils.isBlank((CharSequence)this.awsSecretKey)) {
            throw new AWSCredentialsValidationException("Both awsAccessId and awsSecretKey must be specified.");
        }
    }
}

