/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.VirtualizationType;
import com.atlassian.aws.ec2.InstanceFamilyData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public enum EC2InstanceType {
    M3Medium(InstanceType.M3Medium, 0, 1, "3.75 GiB RAM, 1 vCPU, 3 EC2 Compute Units, 4 GB of SSD-based local instance storage", "Networking Performance: Moderate"),
    M3Large(InstanceType.M3Large, 0, 1, "7.5 GiB RAM, 2 VCPUs, 6.5 EC2 Compute Units, 32 GB of SSD-based local instance storage", "Networking Performance: Moderate"),
    M3Xlarge(InstanceType.M3Xlarge, 0, 2, "13 EC2 Compute Units (4 virtual cores with 3.25 EC2 Compute Units each)", "15 GiB RAM", "Networking Performance: High", "EBS-Optimized Available: No"),
    M32xlarge(InstanceType.M32xlarge, 0, 2, "26 EC2 Compute Units (8 virtual cores with 3.25 EC2 Compute Units each)", "30 GiB RAM", "Networking Performance: High", "EBS-Optimized Available: No"),
    M4Large(InstanceType.M4Large, 0, 0, "8 GiB RAM, 2 vCPUs, Networking Performance: Moderate"),
    M4Xlarge(InstanceType.M4Xlarge, 0, 0, "16 GiB RAM, 4 vCPUs, Networking Performance: High"),
    M42xlarge(InstanceType.M42xlarge, 0, 0, "32 GiB RAM, 8 vCPUs, Networking Performance: High"),
    M44xlarge(InstanceType.M44xlarge, 0, 0, "64 GiB RAM, 16 vCPUs, Networking Performance: High"),
    M410xlarge(InstanceType.M410xlarge, 0, 0, "160 GiB RAM, 40 vCPUs, Networking Performance: 10 Gbps"),
    M416xlarge(InstanceType.M416xlarge, 0, 0, "256 GiB RAM, 64 vCPUs, Networking Performance: 20 Gbps"),
    M5Large(InstanceType.M5Large, 0, 0, "2 vCPUs", "8 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 3.5 Gbps"),
    M5Xlarge(InstanceType.M5Xlarge, 0, 0, "4 vCPUs", "16 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 3.5 Gbps"),
    M52xlarge(InstanceType.M52xlarge, 0, 0, "8 vCPUs", "32 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 3.5 Gbps"),
    M54xlarge(InstanceType.M54xlarge, 0, 0, "16 vCPUs", "64 GiB RAM", "EBS Optimized", "EBS Bandwidth: 3.5 Gbps"),
    M58xlarge(InstanceType.M58xlarge, 0, 0, "32 vCPUs", "128 GiB RAM", "EBS Optimized", "EBS Bandwidth: 3.5 Gbps"),
    M512xlarge(InstanceType.M512xlarge, 0, 0, "48 vCPUs", "192 GiB RAM", "EBS Optimized", "EBS Bandwidth: 7 Gbps"),
    M516xlarge(InstanceType.M516xlarge, 0, 0, "64 vCPUs", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 14 Gbps"),
    M524xlarge(InstanceType.M524xlarge, 0, 0, "96 vCPUs", "384 GiB RAM", "EBS Optimized", "EBS Bandwidth: 14 Gbps"),
    M5Metal(InstanceType.M5Metal, 0, 0, "96 vCPUs", "384 GiB RAM", "EBS Optimized", "EBS Bandwidth: 14 Gbps"),
    M5dLarge(InstanceType.M5dLarge, 0, 1, "2 vCPUs", "8 GiB RAM", "1 x 75 GB NVMe SSD", "EBS Bandwidth: Up to 3.5 Gbps"),
    M5dXlarge(InstanceType.M5dXlarge, 0, 1, "4 vCPUs", "16 GiB RAM", "1 x 150 GB NVMe SSD", "EBS Bandwidth: Up to 3.5 Gbps"),
    M5d2xlarge(InstanceType.M5d2xlarge, 0, 1, "8 vCPUs", "32 GiB RAM", "1 x 300 GB NVMe SSD", "EBS Bandwidth: Up to 3.5 Gbps"),
    M5d4xlarge(InstanceType.M5d4xlarge, 0, 2, "16 vCPUs", "64 GiB RAM", "2 x 300 GB NVMe SSD", "EBS Bandwidth: 3.5 Gbps"),
    M5d8xlarge(InstanceType.M5d8xlarge, 0, 2, "32 vCPUs", "128 GiB RAM", "2 x 600 GB NVMe SSD", "EBS Bandwidth: 5 Gbps"),
    M5d12xlarge(InstanceType.M5d12xlarge, 0, 2, "48 vCPUs", "192 GiB RAM", "2 x 900 GB NVMe SSD", "EBS Bandwidth: 7 Gbps"),
    M5d16xlarge(InstanceType.M5d16xlarge, 0, 4, "64 vCPUs", "256 GiB RAM", "4 x 600 GB NVMe SSD", "EBS Bandwidth: 10 Gbps"),
    M5d24xlarge(InstanceType.M5d24xlarge, 0, 4, "96 vCPUs", "384 GiB RAM", "4 x 900 GB NVMe SSD", "EBS Bandwidth: 14 Gbps"),
    M5dMetal(InstanceType.M5dMetal, 0, 4, "96 vCPUs", "384 GiB RAM", "4 x 900 GB NVMe SSD", "EBS Bandwidth: 14 Gbps"),
    M5dnLarge(InstanceType.M5dnLarge, 0, 1, "2 vCPUs", "8 GiB RAM", "1 x 75 GB NVMe SSD", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    M5dnXlarge(InstanceType.M5dnXlarge, 0, 1, "4 vCPUs", "16 GiB RAM", "1 x 150 GB NVMe SSD", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    M5dn2xlarge(InstanceType.M5dn2xlarge, 0, 1, "8 vCPUs", "32 GiB RAM", "1 x 300 GB NVMe SSD", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    M5dn4xlarge(InstanceType.M5dn4xlarge, 0, 2, "16 vCPUs", "64 GiB RAM", "2 x 300 GB NVMe SSD", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: 4.75 Gbps"),
    M5dn8xlarge(InstanceType.M5dn8xlarge, 0, 2, "32 vCPUs", "128 GiB RAM", "2 x 600 GB NVMe SSD", "Networking Performance: 25 Gbps", "EBS Bandwidth: 6.8 Gbps"),
    M5dn12xlarge(InstanceType.M5dn12xlarge, 0, 2, "48 vCPUs", "192 GiB RAM", "2 x 900 GB NVMe SSD", "Networking Performance: 50 Gbps", "EBS Bandwidth: 9.5 Gbps"),
    M5dn16xlarge(InstanceType.M5dn16xlarge, 0, 4, "64 vCPUs", "256 GiB RAM", "4 x 600 GB NVMe SSD", "Networking Performance: 75 Gbps", "EBS Bandwidth: 13.6 Gbps"),
    M5dn24xlarge(InstanceType.M5dn24xlarge, 0, 4, "96 vCPUs", "384 GiB RAM", "4 x 900 GB NVMe SSD", "Networking Performance: 100 Gbps", "EBS Bandwidth: 19 Gbps"),
    M5dnMetal(InstanceType.M5dnMetal, 0, 4, "96 CPUs", "384 GiB RAM", "4 x 900 GB NVMe SSD", "Networking Performance: 100 Gbps", "EBS Bandwidth: 19 Gbps"),
    M5aLarge(InstanceType.M5aLarge, 0, 0, "2 vCPUs", "8 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 2.120 Gbps"),
    M5aXlarge(InstanceType.M5aXlarge, 0, 0, "4 vCPUs", "16 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 2.120 Gbps"),
    M5a2xlarge(InstanceType.M5a2xlarge, 0, 0, "8 vCPUs", "32 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 2.120 Gbps"),
    M5a4xlarge(InstanceType.M5a4xlarge, 0, 0, "16 vCPUs", "64 GiB RAM", "EBS Optimized", "EBS Bandwidth: 2.120 Gbps"),
    M5a8xlarge(InstanceType.M5a8xlarge, 0, 0, "32 vCPUs", "128 GiB RAM", "EBS Optimized", "EBS Bandwidth: 2.120 Gbps"),
    M5a12xlarge(InstanceType.M5a12xlarge, 0, 0, "48 vCPUs", "192 GiB RAM", "EBS Optimized", "EBS Bandwidth: 5 Gbps"),
    M5a16xlarge(InstanceType.M5a16xlarge, 0, 0, "64 vCPUs", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 5 Gbps"),
    M5a24xlarge(InstanceType.M5a24xlarge, 0, 0, "96 vCPUs", "384 GiB RAM", "EBS Optimized", "EBS Bandwidth: 10 Gbps"),
    M5adLarge(InstanceType.M5adLarge, 0, 1, "2 vCPUs", "8 GiB RAM", "1 x 75 GB NVMe SSD", "EBS Bandwidth: Up to 2.120 Gbps"),
    M5adXlarge(InstanceType.M5adXlarge, 0, 1, "4 vCPUs", "16 GiB RAM", "1 x 150 GB NVMe SSD", "EBS Bandwidth: Up to 2.120 Gbps"),
    M5ad2xlarge(InstanceType.M5ad2xlarge, 0, 1, "8 vCPUs", "32 GiB RAM", "1 x 300 GB NVMe SSD", "EBS Bandwidth: Up to 2.120 Gbps"),
    M5ad4xlarge(InstanceType.M5ad4xlarge, 0, 2, "16 vCPUs", "64 GiB RAM", "2 x 300 GB NVMe SSD", "EBS Bandwidth: 2.120 Gbps"),
    M5ad8xlarge(InstanceType.M5ad8xlarge, 0, 2, "32 vCPUs", "128 GiB RAM", "2 x 300 GB NVMe SSD", "EBS Bandwidth: 2.120 Gbps"),
    M5ad12xlarge(InstanceType.M5ad12xlarge, 0, 2, "48 vCPUs", "192 GiB RAM", "2 x 900 GB NVMe SSD", "EBS Bandwidth: 5 Gbps"),
    M5ad16xlarge(InstanceType.M5ad16xlarge, 0, 2, "64 vCPUs", "256 GiB RAM", "2 x 900 GB NVMe SSD", "EBS Bandwidth: 5 Gbps"),
    M5ad24xlarge(InstanceType.M5ad24xlarge, 0, 4, "96 vCPUs", "384 GiB RAM", "4 x 900 GB NVMe SSD", "EBS Bandwidth: 10 Gbps"),
    M5nLarge(InstanceType.M5nLarge, 0, 0, "2 vCPUs", "8 GiB RAM", "EBS Optimized", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    M5nXlarge(InstanceType.M5nXlarge, 0, 0, "4 vCPUs", "16 GiB RAM", "EBS Optimized", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    M5n2xlarge(InstanceType.M5n2xlarge, 0, 0, "8 vCPUs", "32 GiB RAM", "EBS Optimized", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    M5n4xlarge(InstanceType.M5n4xlarge, 0, 0, "16 vCPUs", "64 GiB RAM", "EBS Optimized", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: 4.75 Gbps"),
    M5n8xlarge(InstanceType.M5n8xlarge, 0, 0, "32 vCPUs", "128 GiB RAM", "EBS Optimized", "Networking Performance: 25 Gbps", "EBS Bandwidth: 6.8 Gbps"),
    M5n12xlarge(InstanceType.M5n12xlarge, 0, 0, "48 vCPUs", "192 GiB RAM", "EBS Optimized", "Networking Performance: 50 Gbps", "EBS Bandwidth: 9.5 Gbps"),
    M5n16xlarge(InstanceType.M5n16xlarge, 0, 0, "64 vCPUs", "256 GiB RAM", "EBS Optimized", "Networking Performance: 75 Gbps", "EBS Bandwidth: 13.6 Gbps"),
    M5n24xlarge(InstanceType.M5n24xlarge, 0, 0, "96 vCPUs", "384 GiB RAM", "EBS Optimized", "Networking Performance: 100 Gbps", "EBS Bandwidth: 19 Gbps"),
    M5nMetal(InstanceType.M5nMetal, 0, 0, "96 CPUs", "384 GiB RAM", "EBS Optimized", "Networking Performance: 100 Gbps", "EBS Bandwidth: 19 Gbps"),
    M5znLarge(InstanceType.M5znLarge, 0, 0, "2 vCPUs", "8 GiB RAM", "EBS Optimized", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 3.17 Gbps"),
    M5znXlarge(InstanceType.M5znXlarge, 0, 0, "4 vCPUs", "16 GiB RAM", "EBS Optimized", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 3.17 Gbps"),
    M5zn2xlarge(InstanceType.M5zn2xlarge, 0, 0, "8 vCPUs", "32 GiB RAM", "EBS Optimized", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: 3.17 Gbps"),
    M5zn3xlarge(InstanceType.M5zn3xlarge, 0, 0, "12 vCPUs", "48 GiB RAM", "EBS Optimized", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: 4.75 Gbps"),
    M5zn6xlarge(InstanceType.M5zn6xlarge, 0, 0, "24 vCPUs", "96 GiB RAM", "EBS Optimized", "Networking Performance: 50 Gbps", "EBS Bandwidth: 9.5 Gbps"),
    M5zn12xlarge(InstanceType.M5zn12xlarge, 0, 0, "48 vCPUs", "192 GiB RAM", "EBS Optimized", "Networking Performance: 100 Gbps", "EBS Bandwidth: 19 Gbps"),
    M5znMetal(InstanceType.M5znMetal, 0, 0, "48 vCPUs", "192 GiB RAM", "EBS Optimized", "Networking Performance: 100 Gbps", "EBS Bandwidth: 19 Gbps"),
    M6aLarge(InstanceType.M6aLarge, 0, 0, "2 vCPU", "8 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 6.6 Gbps"),
    M6aXlarge(InstanceType.M6aXlarge, 0, 0, "4 vCPU", "16 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 6.6 Gbps"),
    M6a2xlarge(InstanceType.M6a2xlarge, 0, 0, "8 vCPU", "32 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 6.6 Gbps"),
    M6a4xlarge(InstanceType.M6a4xlarge, 0, 0, "16 vCPU", "64 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 6.6 Gbps"),
    M6a8xlarge(InstanceType.M6a8xlarge, 0, 0, "32 vCPU", "128 GiB RAM", "EBS Optimized", "EBS Bandwidth: 6.6 Gbps"),
    M6a12xlarge(InstanceType.M6a12xlarge, 0, 0, "48 vCPU", "192 GiB RAM", "EBS Optimized", "EBS Bandwidth: 10 Gbps"),
    M6a16xlarge(InstanceType.M6a16xlarge, 0, 0, "64 vCPU", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 13.3 Gbps"),
    M6a24xlarge(InstanceType.M6a24xlarge, 0, 0, "96 vCPU", "384 GiB RAM", "EBS Optimized", "EBS Bandwidth: 20 Gbps"),
    M6a32xlarge(InstanceType.M6a32xlarge, 0, 0, "128 vCPU", "512 GiB RAM", "EBS Optimized", "EBS Bandwidth: 26.6 Gbps"),
    M6a48xlarge(InstanceType.M6a48xlarge, 0, 0, "192 vCPU", "768 GiB RAM", "EBS Optimized", "EBS Bandwidth: 40 Gbps"),
    M6aMetal(InstanceType.M6aMetal, 0, 0, "192 vCPU", "768 GiB RAM", "EBS Optimized", "EBS Bandwidth: 40 Gbps"),
    M6gMedium(InstanceType.M6gMedium, 0, 0, "1 vCPU", "4 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 4.75 Gbps"),
    M6gLarge(InstanceType.M6gLarge, 0, 0, "2 vCPUs", "8 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 4.75 Gbps"),
    M6gXlarge(InstanceType.M6gXlarge, 0, 0, "4 vCPUs", "16 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 4.75 Gbps"),
    M6g2xlarge(InstanceType.M6g2xlarge, 0, 0, "8 vCPUs", "32 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 4.75 Gbps"),
    M6g4xlarge(InstanceType.M6g4xlarge, 0, 0, "16 vCPUs", "64 GiB RAM", "EBS Optimized", "EBS Bandwidth: 4.75 Gbps"),
    M6g8xlarge(InstanceType.M6g8xlarge, 0, 0, "32 vCPUs", "128 GiB RAM", "EBS Optimized", "EBS Bandwidth: 9 Gbps"),
    M6g12xlarge(InstanceType.M6g12xlarge, 0, 0, "48 vCPUs", "192 GiB RAM", "EBS Optimized", "EBS Bandwidth: 13.5 Gbps"),
    M6g16xlarge(InstanceType.M6g16xlarge, 0, 0, "64 vCPUs", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 19 Gbps"),
    M6gMetal(InstanceType.M6gMetal, 0, 0, "64 vCPUs", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 19 Gbps"),
    M6gdMedium(InstanceType.M6gdMedium, 0, 1, "1 vCPU", "4 GiB RAM", "1 x 59 GiB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    M6gdLarge(InstanceType.M6gdLarge, 0, 1, "2 vCPU", "8 GiB RAM", "1 x 118 GiB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    M6gdXlarge(InstanceType.M6gdXlarge, 0, 1, "4 vCPU", "16 GiB RAM", "1 x 237 GiB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    M6gd2xlarge(InstanceType.M6gd2xlarge, 0, 1, "8 vCPU", "32 GiB RAM", "1 x 474 GiB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    M6gd4xlarge(InstanceType.M6gd4xlarge, 0, 1, "16 vCPU", "64 GiB RAM", "1 x 950 GiB NVMe SSD", "EBS Bandwidth: 4.75 Gbps"),
    M6gd8xlarge(InstanceType.M6gd8xlarge, 0, 1, "32 vCPU", "128 GiB RAM", "1 x 1900 GiB NVMe SSD", "EBS Bandwidth: 9 Gbps"),
    M6gd12xlarge(InstanceType.M6gd12xlarge, 0, 2, "48 vCPU", "192 GiB RAM", "2 x 1425 GiB NVMe SSD", "EBS Bandwidth: 13.5 Gbps"),
    M6gd16xlarge(InstanceType.M6gd16xlarge, 0, 2, "64 vCPU", "256 GiB RAM", "2 x 1900 GiB NVMe SSD", "EBS Bandwidth: 19 Gbps"),
    M6gdMetal(InstanceType.M6gdMetal, 0, 2, "64 vCPU", "256 GiB RAM", "2 x 1900 GiB NVMe SSD", "EBS Bandwidth: 19 Gbps"),
    M6iLarge(InstanceType.M6iLarge, 0, 0, "2 vCPU", "8 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    M6iXlarge(InstanceType.M6iXlarge, 0, 0, "4 vCPU", "16 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    M6i2xlarge(InstanceType.M6i2xlarge, 0, 0, "8 vCPU", "32 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    M6i4xlarge(InstanceType.M6i4xlarge, 0, 0, "16 vCPU", "64 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    M6i8xlarge(InstanceType.M6i8xlarge, 0, 0, "32 vCPU", "128 GiB RAM", "EBS Bandwidth: 10 Gbps"),
    M6i12xlarge(InstanceType.M6i12xlarge, 0, 0, "48 vCPU", "192 GiB RAM", "EBS Bandwidth: 15 Gbps"),
    M6i16xlarge(InstanceType.M6i16xlarge, 0, 0, "64 vCPU", "256 GiB RAM", "EBS Bandwidth: 20 Gbps"),
    M6i24xlarge(InstanceType.M6i24xlarge, 0, 0, "96 vCPU", "384 GiB RAM", "EBS Bandwidth: 30 Gbps"),
    M6i32xlarge(InstanceType.M6i32xlarge, 0, 0, "128 vCPU", "512 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    M6iMetal(InstanceType.M6iMetal, 0, 0, "128 CPU", "512 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    M6inLarge(InstanceType.M6inLarge, 0, 0, "2 vCPU", "8 GiB RAM", "EBS Bandwidth: Up to 25 Gbps"),
    M6inXlarge(InstanceType.M6inXlarge, 0, 0, "4 vCPU", "16 GiB RAM", "EBS Bandwidth: Up to 25 Gbps"),
    M6in2xlarge(InstanceType.M6in2xlarge, 0, 0, "8 vCPU", "32 GiB RAM", "EBS Bandwidth: Up to 25 Gbps"),
    M6in4xlarge(InstanceType.M6in4xlarge, 0, 0, "16 vCPU", "64 GiB RAM", "EBS Bandwidth: Up to 25 Gbps"),
    M6in8xlarge(InstanceType.M6in8xlarge, 0, 0, "32 vCPU", "128 GiB RAM", "EBS Bandwidth: 25 Gbps"),
    M6in12xlarge(InstanceType.M6in12xlarge, 0, 0, "48 vCPU", "192 GiB RAM", "EBS Bandwidth: 37.5 Gbps"),
    M6in16xlarge(InstanceType.M6in16xlarge, 0, 0, "64 vCPU", "256 GiB RAM", "EBS Bandwidth: 50 Gbps"),
    M6in24xlarge(InstanceType.M6in24xlarge, 0, 0, "96 vCPU", "384 GiB RAM", "EBS Bandwidth: 75 Gbps"),
    M6in32xlarge(InstanceType.M6in32xlarge, 0, 0, "128 vCPU", "512 GiB RAM", "EBS Bandwidth: 100 Gbps"),
    M6inMetal(InstanceType.M6inMetal, 0, 0, "128 CPU", "512 GiB RAM", "EBS Bandwidth: 100 Gbps"),
    M6idLarge(InstanceType.M6idLarge, 0, 1, "2 vCPU", "8 GiB RAM", "EBS Bandwidth: Up to 10 Gbps", "1 x 118 GiB NVMe SSD"),
    M6idXlarge(InstanceType.M6idXlarge, 0, 1, "4 vCPU", "16 GiB RAM", "EBS Bandwidth: Up to 10 Gbps", "1 x 237 GiB NVMe SSD"),
    M6id2xlarge(InstanceType.M6id2xlarge, 0, 1, "8 vCPU", "32 GiB RAM", "EBS Bandwidth: Up to 10 Gbps", "1 x 474 GiB NVMe SSD"),
    M6id4xlarge(InstanceType.M6id4xlarge, 0, 1, "16 vCPU", "64 GiB RAM", "EBS Bandwidth: Up to 10 Gbps", "1 x 950 GiB NVMe SSD"),
    M6id8xlarge(InstanceType.M6id8xlarge, 0, 1, "32 vCPU", "128 GiB RAM", "EBS Bandwidth: 10 Gbps", "1 x 1900 GiB NVMe SSD"),
    M6id12xlarge(InstanceType.M6id12xlarge, 0, 2, "48 vCPU", "192 GiB RAM", "EBS Bandwidth: 15 Gbps", "2 x 1425 GiB NVMe SSD"),
    M6id16xlarge(InstanceType.M6id16xlarge, 0, 2, "64 vCPU", "256 GiB RAM", "EBS Bandwidth: 20 Gbps", "2 x 1900 GiB NVMe SSD"),
    M6id24xlarge(InstanceType.M6id24xlarge, 0, 4, "96 vCPU", "384 GiB RAM", "EBS Bandwidth: 30 Gbps", "4 x 1425 GiB NVMe SSD"),
    M6id32xlarge(InstanceType.M6id32xlarge, 0, 4, "128 vCPU", "512 GiB RAM", "EBS Bandwidth: 40 Gbps", "4 x 1900 GiB NVMe SSD"),
    M6idMetal(InstanceType.M6idMetal, 0, 4, "128 CPU", "512 GiB RAM", "EBS Bandwidth: 40 Gbps", "4 x 1900 GiB NVMe SSD"),
    M6idnLarge(InstanceType.M6idnLarge, 0, 1, "2 vCPU", "8 GiB RAM", "EBS Bandwidth: Up to 25 Gbps", "1 x 118 GiB NVMe SSD"),
    M6idnXlarge(InstanceType.M6idnXlarge, 0, 1, "4 vCPU", "16 GiB RAM", "EBS Bandwidth: Up to 25 Gbps", "1 x 237 GiB NVMe SSD"),
    M6idn2xlarge(InstanceType.M6idn2xlarge, 0, 1, "8 vCPU", "32 GiB RAM", "EBS Bandwidth: Up to 25 Gbps", "1 x 474 GiB NVMe SSD"),
    M6idn4xlarge(InstanceType.M6idn4xlarge, 0, 1, "16 vCPU", "64 GiB RAM", "EBS Bandwidth: Up to 25 Gbps", "1 x 950 GiB NVMe SSD"),
    M6idn8xlarge(InstanceType.M6idn8xlarge, 0, 1, "32 vCPU", "128 GiB RAM", "EBS Bandwidth: 25 Gbps", "1 x 1900 GiB NVMe SSD"),
    M6idn12xlarge(InstanceType.M6idn12xlarge, 0, 2, "48 vCPU", "192 GiB RAM", "EBS Bandwidth: 37.5 Gbps", "2 x 1425 GiB NVMe SSD"),
    M6idn16xlarge(InstanceType.M6idn16xlarge, 0, 2, "64 vCPU", "256 GiB RAM", "EBS Bandwidth: 50 Gbps", "2 x 1900 GiB NVMe SSD"),
    M6idn24xlarge(InstanceType.M6idn24xlarge, 0, 4, "96 vCPU", "384 GiB RAM", "EBS Bandwidth: 75 Gbps", "4 x 1425 GiB NVMe SSD"),
    M6idn32xlarge(InstanceType.M6idn32xlarge, 0, 4, "128 vCPU", "512 GiB RAM", "EBS Bandwidth: 100 Gbps", "4 x 1900 GiB NVMe SSD"),
    M6idnMetal(InstanceType.M6idnMetal, 0, 4, "128 CPU", "512 GiB RAM", "EBS Bandwidth: 100 Gbps", "4 x 1900 GiB NVMe SSD"),
    M7aMedium(InstanceType.M7aMedium, 0, 0, "1 vCPU", "4 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 12.5 Gbps"),
    M7aLarge(InstanceType.M7aLarge, 0, 0, "2 vCPU", "8 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 12.5 Gbps"),
    M7aXlarge(InstanceType.M7aXlarge, 0, 0, "4 vCPU", "16 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 12.5 Gbps"),
    M7a2xlarge(InstanceType.M7a2xlarge, 0, 0, "8 vCPU", "32 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 12.5 Gbps"),
    M7a4xlarge(InstanceType.M7a4xlarge, 0, 0, "16 vCPU", "64 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 12.5 Gbps"),
    M7a8xlarge(InstanceType.M7a8xlarge, 0, 0, "32 vCPU", "128 GiB RAM", "EBS Optimized", "EBS Bandwidth: 10 Gbps"),
    M7a12xlarge(InstanceType.M7a12xlarge, 0, 0, "48 vCPU", "192 GiB RAM", "EBS Optimized", "EBS Bandwidth: 15 Gbps"),
    M7a16xlarge(InstanceType.M7a16xlarge, 0, 0, "64 vCPU", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 20 Gbps"),
    M7a24xlarge(InstanceType.M7a24xlarge, 0, 0, "96 vCPU", "384 GiB RAM", "EBS Optimized", "EBS Bandwidth: 30 Gbps"),
    M7a32xlarge(InstanceType.M7a32xlarge, 0, 0, "128 vCPU", "512 GiB RAM", "EBS Optimized", "EBS Bandwidth: 40 Gbps"),
    M7a48xlarge(InstanceType.M7a48xlarge, 0, 0, "192 vCPU", "768 GiB RAM", "EBS Optimized", "EBS Bandwidth: 40 Gbps"),
    M7aMetal48xl(InstanceType.M7aMetal48xl, 0, 0, "192 vCPU", "768 GiB RAM", "EBS Optimized", "EBS Bandwidth: 40 Gbps"),
    M7iLarge(InstanceType.M7iLarge, 0, 0, "2 vCPU", "8 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7iXlarge(InstanceType.M7iXlarge, 0, 0, "4 vCPU", "16 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7i2xlarge(InstanceType.M7i2xlarge, 0, 0, "8 vCPU", "32 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7i4xlarge(InstanceType.M7i4xlarge, 0, 0, "16 vCPU", "64 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7i8xlarge(InstanceType.M7i8xlarge, 0, 0, "32 vCPU", "128 GiB RAM", "EBS Optimized", "EBS Bandwidth: 10 Gbps"),
    M7i12xlarge(InstanceType.M7i12xlarge, 0, 0, "48 vCPU", "192 GiB RAM", "EBS Optimized", "EBS Bandwidth: 15 Gbps"),
    M7i16xlarge(InstanceType.M7i16xlarge, 0, 0, "64 vCPU", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 20 Gbps"),
    M7i24xlarge(InstanceType.M7i24xlarge, 0, 0, "96 vCPU", "384 GiB RAM", "EBS Optimized", "EBS Bandwidth: 30 Gbps"),
    M7i48xlarge(InstanceType.M7i48xlarge, 0, 0, "192 vCPU", "768 GiB RAM", "EBS Optimized", "EBS Bandwidth: 40 Gbps"),
    M7iMetal24xl(InstanceType.M7iMetal24xl, 0, 0, "96 vCPU", "384 GiB RAM", "EBS Optimized", "EBS Bandwidth: 30 Gbps"),
    M7iMetal48xl(InstanceType.M7iMetal48xl, 0, 0, "192 vCPU", "768 GiB RAM", "EBS Optimized", "EBS Bandwidth: 40 Gbps"),
    M7iFlexLarge(InstanceType.M7iFlexLarge, 0, 0, "2 vCPU", "8 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7iFlexXlarge(InstanceType.M7iFlexXlarge, 0, 0, "4 vCPU", "16 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7iFlex2xlarge(InstanceType.M7iFlex2xlarge, 0, 0, "8 vCPU", "32 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7iFlex4xlarge(InstanceType.M7iFlex4xlarge, 0, 0, "16 vCPU", "64 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7iFlex8xlarge(InstanceType.M7iFlex8xlarge, 0, 0, "32 vCPU", "128 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7gMedium(InstanceType.M7gMedium, 0, 0, "1 vCPU", "4 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7gLarge(InstanceType.M7gLarge, 0, 0, "2 vCPU", "8 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7gXlarge(InstanceType.M7gXlarge, 0, 0, "4 vCPU", "16 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7g2xlarge(InstanceType.M7g2xlarge, 0, 0, "8 vCPU", "32 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7g4xlarge(InstanceType.M7g4xlarge, 0, 0, "16 vCPU", "64 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps"),
    M7g8xlarge(InstanceType.M7g8xlarge, 0, 0, "32 vCPU", "128 GiB RAM", "EBS Optimized", "EBS Bandwidth: 10 Gbps"),
    M7g12xlarge(InstanceType.M7g12xlarge, 0, 0, "48 vCPU", "192 GiB RAM", "EBS Optimized", "EBS Bandwidth: 15 Gbps"),
    M7g16xlarge(InstanceType.M7g16xlarge, 0, 0, "64 vCPU", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 20 Gbps"),
    M7gMetal(InstanceType.M7gMetal, 0, 0, "64 vCPU", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 20 Gbps"),
    M7gdMedium(InstanceType.M7gdMedium, 0, 1, "1 vCPU", "4 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps", "59 GB NVMe SSD"),
    M7gdLarge(InstanceType.M7gdLarge, 0, 1, "2 vCPU", "8 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps", "118 GB NVMe SSD"),
    M7gdXlarge(InstanceType.M7gdXlarge, 0, 1, "4 vCPU", "16 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps", "237 GB NVMe SSD"),
    M7gd2xlarge(InstanceType.M7gd2xlarge, 0, 1, "8 vCPU", "32 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps", "474 GB NVMe SSD"),
    M7gd4xlarge(InstanceType.M7gd4xlarge, 0, 1, "16 vCPU", "64 GiB RAM", "EBS Optimized", "EBS Bandwidth: Up to 10 Gbps", "950 GB NVMe SSD"),
    M7gd8xlarge(InstanceType.M7gd8xlarge, 0, 1, "32 vCPU", "128 GiB RAM", "EBS Optimized", "EBS Bandwidth: 10 Gbps", "1900 GB NVMe SSD"),
    M7gd12xlarge(InstanceType.M7gd12xlarge, 0, 2, "48 vCPU", "192 GiB RAM", "EBS Optimized", "EBS Bandwidth: 15 Gbps", "2 x 1425 GB NVMe SSD"),
    M7gd16xlarge(InstanceType.M7gd16xlarge, 0, 2, "64 vCPU", "256 GiB RAM", "EBS Optimized", "EBS Bandwidth: 20 Gbps", "2 x 1900 GB NVMe SSD"),
    M1_SMALL(InstanceType.M1Small, 1, 0, "1 EC2 Compute Unit (1 virtual core with 1 EC2 Compute Unit)", "1.7 GiB RAM", "160 GB instance storage", "32-bit or 64-bit platform", "Networking Performance: Low", "EBS-Optimized Available: No"),
    M1Medium(InstanceType.M1Medium, 1, 0, "3.75 GiB RAM", "M1 Medium Instance", "2 EC2 Compute Unit (1 virtual core with 2 EC2 Compute Unit)", "410 GB instance storage", "32-bit or 64-bit platform", "Networking Performance: Moderate", "EBS-Optimized Available: No"),
    M1_LARGE(InstanceType.M1Large, 2, 0, "4 EC2 Compute Units (2 virtual cores with 2 EC2 Compute Units each)", "7.5 GiB RAM", "850 GB instance storage", "Networking Performance: Moderate", "EBS-Optimized Available: 500 Mbps"),
    M1_XLARGE(InstanceType.M1Xlarge, 4, 0, "15 GiB RAM", "M1 Extra Large Instance", "8 EC2 Compute Units (4 virtual cores with 2 EC2 Compute Units each)", "1,690 GB instance storage", "Networking Performance: High", "EBS-Optimized Available: 1000 Mbps"),
    T1Micro(InstanceType.T1Micro, 0, 0, "1 vCPU", "0.6131 GiB RAM", "32-bit or 64-bit platform"),
    T2Nano(InstanceType.T2Nano, 0, 0, "1 vCPU", "0.5 GiB RAM", "32-bit or 64-bit platform"),
    T2Micro(InstanceType.T2Micro, 0, 0, "1 vCPU", "1 GiB RAM", "32-bit or 64-bit platform"),
    T2Small(InstanceType.T2Small, 0, 0, "1 vCPU", "2 GiB RAM", "32-bit or 64-bit platform"),
    T2Medium(InstanceType.T2Medium, 0, 0, "2 vCPUs", "4 GiB RAM"),
    T2Large(InstanceType.T2Large, 0, 0, "2 vCPUs", "8 GiB RAM"),
    T2Xlarge(InstanceType.T2Xlarge, 0, 0, "4 vCPUs", "16 GiB RAM"),
    T22xlarge(InstanceType.T22xlarge, 0, 0, "8 vCPUs", "32 GiB RAM"),
    T3Nano(InstanceType.T3Nano, 0, 0, "2 vCPUs", "0.5 GiB RAM"),
    T3Micro(InstanceType.T3Micro, 0, 0, "2 vCPUs", "1 GiB RAM"),
    T3Small(InstanceType.T3Small, 0, 0, "2 vCPUs", "2 GiB RAM"),
    T3Medium(InstanceType.T3Medium, 0, 0, "2 vCPUs", "4 GiB RAM"),
    T3Large(InstanceType.T3Large, 0, 0, "2 vCPUs", "8 GiB RAM"),
    T3Xlarge(InstanceType.T3Xlarge, 0, 0, "4 vCPUs", "16 GiB RAM"),
    T32xlarge(InstanceType.T32xlarge, 0, 0, "8 vCPUs", "32 GiB RAM"),
    T3aNano(InstanceType.T3aNano, 0, 0, "2 vCPUs", "0.5 GiB RAM"),
    T3aMicro(InstanceType.T3aMicro, 0, 0, "2 vCPUs", "1 GiB RAM"),
    T3aSmall(InstanceType.T3aSmall, 0, 0, "2 vCPUs", "2 GiB RAM"),
    T3aMedium(InstanceType.T3aMedium, 0, 0, "2 vCPUs", "4 GiB RAM"),
    T3aLarge(InstanceType.T3aLarge, 0, 0, "2 vCPUs", "8 GiB RAM"),
    T3aXlarge(InstanceType.T3aXlarge, 0, 0, "4 vCPUs", "16 GiB RAM"),
    T3a2xlarge(InstanceType.T3a2xlarge, 0, 0, "8 vCPUs", "32 GiB RAM"),
    T4gNano(InstanceType.T4gNano, 0, 0, "2 vCPUs", "0.5 GiB RAM"),
    T4gMicro(InstanceType.T4gMicro, 0, 0, "2 vCPUs", "1 GiB RAM"),
    T4gSmall(InstanceType.T4gSmall, 0, 0, "2 vCPUs", "2 GiB RAM"),
    T4gMedium(InstanceType.T4gMedium, 0, 0, "2 vCPUs", "4 GiB RAM"),
    T4gLarge(InstanceType.T4gLarge, 0, 0, "2 vCPUs", "8 GiB RAM"),
    T4gXlarge(InstanceType.T4gXlarge, 0, 0, "4 vCPUs", "16 GiB RAM"),
    T4g2xlarge(InstanceType.T4g2xlarge, 0, 0, "8 vCPUs", "32 GiB RAM"),
    A1Medium(InstanceType.A1Medium, 0, 0, "1 vCPUs", "2 GiB RAM"),
    A1Large(InstanceType.A1Large, 0, 0, "2 vCPUs", "4 GiB RAM"),
    A1Xlarge(InstanceType.A1Xlarge, 0, 0, "4 vCPUs", "8 GiB RAM"),
    A12xlarge(InstanceType.A12xlarge, 0, 0, "8 vCPUs", "16 GiB RAM"),
    A14xlarge(InstanceType.A14xlarge, 0, 0, "16 vCPUs", "32 GiB RAM"),
    A1Metal(InstanceType.A1Metal, 0, 0, "16 CPUs", "32 GiB RAM"),
    Mac1Metal(InstanceType.Mac1Metal, 0, 0, "12 vCPUs", "32 GiB RAM", "Networking Performance: 10 Gbps", "EBS Bandwidth: 8 Gbps"),
    Mac2Metal(InstanceType.Mac2Metal, 0, 0, "8 vCPUs", "16 GiB RAM", "Networking Performance: 10 Gbps", "EBS Bandwidth: 8 Gbps"),
    Mac2M2Metal(InstanceType.Mac2M2Metal, 0, 0, "8 vCPUs", "24 GiB RAM", "Networking Performance: 10 Gbps", "EBS Bandwidth: 8 Gbps"),
    Mac2M2proMetal(InstanceType.Mac2M2proMetal, 0, 0, "12 vCPUs", "32 GiB RAM", "Networking Performance: 10 Gbps", "EBS Bandwidth: 8 Gbps"),
    C3Large(InstanceType.C3Large, 0, 2, "3.75 GiB RAM, 2 vCPUs, 7 EC2 Compute Units, 32 GB of SSD-based local instance storage"),
    C3Xlarge(InstanceType.C3Xlarge, 0, 2, "7 GiB RAM, 4 vCPUs, 14 EC2 Compute Units, 80 GB of SSD-based local instance storage"),
    C32xlarge(InstanceType.C32xlarge, 0, 2, "15 GiB RAM, 8 vCPUs, 28 EC2 Compute Units, 160 GB of SSD-based local instance storage"),
    C34xlarge(InstanceType.C34xlarge, 0, 2, "30 GiB RAM, 16 vCPUs, 55 EC2 Compute Units, 320 GB of SSD-based local instance storage"),
    C38xlarge(InstanceType.C38xlarge, 0, 2, "60 GiB RAM, 32 vCPUs, 108 EC2 Compute Units, 640 GB of SSD-based local instance storage"),
    C5large(InstanceType.C5Large, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: Up to 3.5 Gbps"),
    C5Xlarge(InstanceType.C5Xlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Optmized Storage", "EBS Bandwidth: Up to 3.5 Gbps"),
    C52xlarge(InstanceType.C52xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: Up to 3.5 Gbps"),
    C54xlarge(InstanceType.C54xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 3.5 Gbps"),
    C59xlarge(InstanceType.C59xlarge, 0, 0, "36 vCPUs", "72 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 7 Gbps"),
    C512xlarge(InstanceType.C512xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 7 Gbps"),
    C518xlarge(InstanceType.C518xlarge, 0, 0, "72 vCPUs", "144 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 14 Gbps"),
    C524xlarge(InstanceType.C524xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 14 Gbps"),
    C5Metal(InstanceType.C5Metal, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 14 Gbps"),
    C5aLarge(InstanceType.C5aLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: Up to 3.17 Gbps"),
    C5aXlarge(InstanceType.C5aXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Optmized Storage", "EBS Bandwidth: Up to 3.17 Gbps"),
    C5a2xlarge(InstanceType.C5a2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: Up to 3.17 Gbps"),
    C5a4xlarge(InstanceType.C5a4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 3.17 Gbps"),
    C5a8xlarge(InstanceType.C5a8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 3.17 Gbps"),
    C5a12xlarge(InstanceType.C5a12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 4.75 Gbps"),
    C5a16xlarge(InstanceType.C5a16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 6.3 Gbps"),
    C5a24xlarge(InstanceType.C5a24xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Optimized Storage", "EBS Bandwidth: 9.5 Gbps"),
    C5adLarge(InstanceType.C5adLarge, 0, 1, "2 vCPUs", "4 GiB RAM", "1 x 75 GB NVMe SSD", "EBS Bandwidth: Up to 3.17 Gbps"),
    C5adXlarge(InstanceType.C5adXlarge, 0, 1, "4 vCPUs", "8 GiB RAM", "1 x 150 GB NVMe SSD", "EBS Bandwidth: Up to 3.17 Gbps"),
    C5ad2xlarge(InstanceType.C5ad2xlarge, 0, 1, "8 vCPUs", "16 GiB RAM", "1 x 300 GB NVMe SSD", "EBS Bandwidth: Up to 3.17 Gbps"),
    C5ad4xlarge(InstanceType.C5ad4xlarge, 0, 2, "16 vCPUs", "32 GiB RAM", "2 x 300 GB NVMe SSD", "EBS Bandwidth: Up to 3.17 Gbps"),
    C5ad8xlarge(InstanceType.C5ad8xlarge, 0, 2, "32 vCPUs", "64 GiB RAM", "2 x 600 GB NVMe SSD", "EBS Bandwidth: 3.17 Gbps"),
    C5ad12xlarge(InstanceType.C5ad12xlarge, 0, 2, "48 vCPUs", "96 GiB RAM", "2 x 900 GB NVMe SSD", "EBS Bandwidth: 4.75 Gbps"),
    C5ad16xlarge(InstanceType.C5ad16xlarge, 0, 2, "64 vCPUs", "128 GiB RAM", "2 x 1200 GB NVMe SSD", "EBS Bandwidth: 6.3 Gbps"),
    C5ad24xlarge(InstanceType.C5ad24xlarge, 0, 2, "96 vCPUs", "192 GiB RAM", "2 x 1900 GB NVMe SSD", "EBS Bandwidth: 9.5 Gbps"),
    C5dLarge(InstanceType.C5dLarge, 0, 1, "2 vCPUs", "4 GiB RAM", "1 x 50 GB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    C5dXlarge(InstanceType.C5dXlarge, 0, 1, "4 vCPUs", "8 GiB RAM", "1 x 100 GB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    C5d2xlarge(InstanceType.C5d2xlarge, 0, 1, "8 vCPUs", "16 GiB RAM", "1 x 225 GB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    C5d4xlarge(InstanceType.C5d4xlarge, 0, 1, "16 vCPUs", "32 GiB RAM", "1 x 450 GB NVMe SSD", "EBS Bandwidth: 4.75 Gbps"),
    C5d9xlarge(InstanceType.C5d9xlarge, 0, 1, "36 vCPUs", "72 GiB RAM", "1 x 900 GB NVMe SSD", "EBS Bandwidth: 9.5 Gbps"),
    C5d12xlarge(InstanceType.C5d12xlarge, 0, 2, "48 vCPUs", "96 GiB RAM", "2 x 900 GB NVMe SSD", "EBS Bandwidth: 9.5 Gbps"),
    C5d18xlarge(InstanceType.C5d18xlarge, 0, 2, "72 vCPUs", "144 GiB RAM", "2 x 900 GB NVMe SSD", "EBS Bandwidth: 19 Gbps"),
    C5d24xlarge(InstanceType.C5d24xlarge, 0, 4, "96 vCPUs", "192 GiB RAM", "4 x 900 GB NVMe SSD", "EBS Bandwidth: 19 Gbps"),
    C5dMetal(InstanceType.C5dMetal, 0, 4, "96 CPUs", "192 GiB RAM", "4 x 900 GB NVMe SSD", "EBS Bandwidth: 19 Gbps"),
    C5nLarge(InstanceType.C5nLarge, 0, 0, "2 vCPUs", "5.25 GiB RAM", "EBS Bandwidth: Up to 4.75 Gbps"),
    C5nXlarge(InstanceType.C5nXlarge, 0, 0, "4 vCPUs", "10.5 GiB RAM", "EBS Bandwidth: Up to 4.75 Gbps"),
    C5n2xlarge(InstanceType.C5n2xlarge, 0, 0, "8 vCPUs", "21 GiB RAM", "EBS Bandwidth: Up to 4.75 Gbps"),
    C5n4xlarge(InstanceType.C5n4xlarge, 0, 0, "16 vCPUs", "42 GiB RAM", "EBS Bandwidth: 4.75 Gbps"),
    C5n9xlarge(InstanceType.C5n9xlarge, 0, 0, "36 vCPUs", "96 GiB RAM", "EBS Bandwidth: 9.5 Gbps"),
    C5n18xlarge(InstanceType.C5n18xlarge, 0, 0, "72 vCPUs", "192 GiB RAM", "EBS Bandwidth: 19 Gbps"),
    C5nMetal(InstanceType.C5nMetal, 0, 0, "72 vCPUs", "192 GiB RAM", "EBS Bandwidth: 19 Gbps"),
    C6aLarge(InstanceType.C6aLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 6.6 Gbps"),
    C6aXlarge(InstanceType.C6aXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 6.6 Gbps"),
    C6a2xlarge(InstanceType.C6a2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 6.6 Gbps"),
    C6a4xlarge(InstanceType.C6a4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: Up to 6.6 Gbps"),
    C6a8xlarge(InstanceType.C6a8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: 6.6 Gbps"),
    C6a12xlarge(InstanceType.C6a12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: 10 Gbps"),
    C6a16xlarge(InstanceType.C6a16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 13.3 Gbps"),
    C6a24xlarge(InstanceType.C6a24xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Bandwidth: 20 Gbps"),
    C6a32xlarge(InstanceType.C6a32xlarge, 0, 0, "128 vCPUs", "256 GiB RAM", "EBS Bandwidth: 26.6 Gbps"),
    C6a48xlarge(InstanceType.C6a48xlarge, 0, 0, "192 vCPUs", "384 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C6aMetal(InstanceType.C6aMetal, 0, 0, "192 vCPUs", "384 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C6gMedium(InstanceType.C6gMedium, 0, 0, "1 vCPU", "2 GiB RAM", "EBS Bandwidth: Up to 4.75 Gbps"),
    C6gLarge(InstanceType.C6gLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 4.75 Gbps"),
    C6gXlarge(InstanceType.C6gXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 4.75 Gbps"),
    C6g2xlarge(InstanceType.C6g2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 4.75 Gbps"),
    C6g4xlarge(InstanceType.C6g4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: 4.75 Gbps"),
    C6g8xlarge(InstanceType.C6g8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: 9 Gbps"),
    C6g12xlarge(InstanceType.C6g12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: 13.5 Gbps"),
    C6g16xlarge(InstanceType.C6g16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 19 Gbps"),
    C6gMetal(InstanceType.C6gMetal, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 19 Gbps"),
    C6gdMedium(InstanceType.C6gdMedium, 0, 1, "1 vCPU", "2 GiB RAM", "1 x 59 GB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    C6gdLarge(InstanceType.C6gdLarge, 0, 1, "2 vCPUs", "4 GiB RAM", "1 x 118 GB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    C6gdXlarge(InstanceType.C6gdXlarge, 0, 1, "4 vCPUs", "8 GiB RAM", "1 x 237 GB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    C6gd2xlarge(InstanceType.C6gd2xlarge, 0, 1, "8 vCPUs", "16 GiB RAM", "1 x 474 GB NVMe SSD", "EBS Bandwidth: Up to 4.75 Gbps"),
    C6gd4xlarge(InstanceType.C6gd4xlarge, 0, 1, "16 vCPUs", "32 GiB RAM", "1 x 950 GB NVMe SSD", "EBS Bandwidth: 4.75 Gbps"),
    C6gd8xlarge(InstanceType.C6gd8xlarge, 0, 1, "32 vCPUs", "64 GiB RAM", "1 x 1900 GB NVMe SSD", "EBS Bandwidth: 9 Gbps"),
    C6gd12xlarge(InstanceType.C6gd12xlarge, 0, 2, "48 vCPUs", "96 GiB RAM", "2 x 1425 GB NVMe SSD", "EBS Bandwidth: 13.5 Gbps"),
    C6gd16xlarge(InstanceType.C6gd16xlarge, 0, 2, "64 vCPUs", "128 GiB RAM", "2 x 1900 GB NVMe SSD", "EBS Bandwidth: 19 Gbps"),
    C6gdMetal(InstanceType.C6gdMetal, 0, 2, "64 vCPUs", "128 GiB RAM", "2 x 1900 GB NVMe SSD", "EBS Bandwidth: 19 Gbps"),
    C6gnMedium(InstanceType.C6gnMedium, 0, 0, "1 vCPU", "2 GiB RAM", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 9.5 Gbps"),
    C6gnLarge(InstanceType.C6gnLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 9.5 Gbps"),
    C6gnXlarge(InstanceType.C6gnXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 9.5 Gbps"),
    C6gn2xlarge(InstanceType.C6gn2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 9.5 Gbps"),
    C6gn4xlarge(InstanceType.C6gn4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "Networking Performance: 25 Gbps", "EBS Bandwidth: 9.5 Gbps"),
    C6gn8xlarge(InstanceType.C6gn8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "Networking Performance: 50 Gbps", "EBS Bandwidth: 19 Gbps"),
    C6gn12xlarge(InstanceType.C6gn12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "Networking Performance: 75 Gbps", "EBS Bandwidth: 28.5 Gbps"),
    C6gn16xlarge(InstanceType.C6gn16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "Networking Performance: 100 Gbps", "EBS Bandwidth: 38 Gbps"),
    C6iLarge(InstanceType.C6iLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C6iXlarge(InstanceType.C6iXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C6i2xlarge(InstanceType.C6i2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C6i4xlarge(InstanceType.C6i4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C6i8xlarge(InstanceType.C6i8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: 10 Gbps"),
    C6i12xlarge(InstanceType.C6i12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: 15 Gbps"),
    C6i16xlarge(InstanceType.C6i16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 20 Gbps"),
    C6i24xlarge(InstanceType.C6i24xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Bandwidth: 30 Gbps"),
    C6i32xlarge(InstanceType.C6i32xlarge, 0, 0, "128 vCPUs", "256 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C6iMetal(InstanceType.C6iMetal, 0, 0, "128 vCPUs", "256 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C6idLarge(InstanceType.C6idLarge, 0, 1, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C6idXlarge(InstanceType.C6idXlarge, 0, 1, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C6id2xlarge(InstanceType.C6id2xlarge, 0, 1, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C6id4xlarge(InstanceType.C6id4xlarge, 0, 1, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C6id8xlarge(InstanceType.C6id8xlarge, 0, 1, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: 10 Gbps"),
    C6id12xlarge(InstanceType.C6id12xlarge, 0, 2, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: 15 Gbps"),
    C6id16xlarge(InstanceType.C6id16xlarge, 0, 2, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 20 Gbps"),
    C6id24xlarge(InstanceType.C6id24xlarge, 0, 4, "96 vCPUs", "192 GiB RAM", "EBS Bandwidth: 30 Gbps"),
    C6id32xlarge(InstanceType.C6id32xlarge, 0, 4, "128 vCPUs", "256 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C6idMetal(InstanceType.C6idMetal, 0, 4, "128 vCPUs", "256 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C6inLarge(InstanceType.C6inLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 25 Gpbs"),
    C6inXlarge(InstanceType.C6inXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 25 Gpbs"),
    C6in2xlarge(InstanceType.C6in2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 25 Gpbs"),
    C6in4xlarge(InstanceType.C6in4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: Up to 25 Gpbs"),
    C6in8xlarge(InstanceType.C6in8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: 25 Gpbs"),
    C6in12xlarge(InstanceType.C6in12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: 37.5 Gpbs"),
    C6in16xlarge(InstanceType.C6in16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 50 Gpbs"),
    C6in24xlarge(InstanceType.C6in24xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Bandwidth: 75 Gpbs"),
    C6in32xlarge(InstanceType.C6in32xlarge, 0, 0, "128 vCPUs", "512 GiB RAM", "EBS Bandwidth: 100 Gpbs"),
    C6inMetal(InstanceType.C6inMetal, 0, 0, "128 vCPUs", "512 GiB RAM", "EBS Bandwidth: 25 Gpbs"),
    C7aMedium(InstanceType.C7aMedium, 0, 0, "1 vCPUs", "2 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7aLarge(InstanceType.C7aLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7aXlarge(InstanceType.C7aXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7a2xlarge(InstanceType.C7a2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7a4xlarge(InstanceType.C7a4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7a8xlarge(InstanceType.C7a8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: 10 Gbps"),
    C7a12xlarge(InstanceType.C7a12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: 15 Gbps"),
    C7a16xlarge(InstanceType.C7a16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 20 Gbps"),
    C7a24xlarge(InstanceType.C7a24xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Bandwidth: 30 Gbps"),
    C7a32xlarge(InstanceType.C7a32xlarge, 0, 0, "128 vCPUs", "256 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C7a48xlarge(InstanceType.C7a48xlarge, 0, 0, "192 vCPUs", "384 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C7aMetal48xl(InstanceType.C7aMetal48xl, 0, 0, "192 vCPUs", "384 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C7iLarge(InstanceType.C7iLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7iXlarge(InstanceType.C7iXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7i2xlarge(InstanceType.C7i2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7i4xlarge(InstanceType.C7i4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7i8xlarge(InstanceType.C7i8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: 10 Gbps"),
    C7i12xlarge(InstanceType.C7i12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: 15 Gbps"),
    C7i16xlarge(InstanceType.C7i16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 20 Gbps"),
    C7i24xlarge(InstanceType.C7i24xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Bandwidth: 30 Gbps"),
    C7i48xlarge(InstanceType.C7i48xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C7iMetal24xl(InstanceType.C7iMetal24xl, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Bandwidth: 30 Gbps"),
    C7iMetal48xl(InstanceType.C7iMetal48xl, 0, 0, "96 vCPUs", "192 GiB RAM", "EBS Bandwidth: 40 Gbps"),
    C7gMedium(InstanceType.C7gMedium, 0, 0, "1 vCPUs", "2 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7gLarge(InstanceType.C7gLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7gXlarge(InstanceType.C7gXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7g2xlarge(InstanceType.C7g2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7g4xlarge(InstanceType.C7g4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7g8xlarge(InstanceType.C7g8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: 10 Gbps"),
    C7g12xlarge(InstanceType.C7g12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: 15 Gbps"),
    C7g16xlarge(InstanceType.C7g16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 20 Gbps"),
    C7gMetal(InstanceType.C7gMetal, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 20 Gbps"),
    C7gdMedium(InstanceType.C7gdMedium, 0, 1, "1 vCPUs", "2 GiB RAM", "EBS Bandwidth: Up to 10 Gbps", "59 Gb NVMe SSD"),
    C7gdLarge(InstanceType.C7gdLarge, 0, 1, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 10 Gbps", "118 Gb NVMe SSD"),
    C7gdXlarge(InstanceType.C7gdXlarge, 0, 1, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 10 Gbps", "237 Gb NVMe SSD"),
    C7gd2xlarge(InstanceType.C7gd2xlarge, 0, 1, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 10 Gbps", "474 Gb NVMe SSD"),
    C7gd4xlarge(InstanceType.C7gd4xlarge, 0, 1, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: Up to 10 Gbps", "950 Gb NVMe SSD"),
    C7gd8xlarge(InstanceType.C7gd8xlarge, 0, 1, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: 10 Gbps", "1900 Gb NVMe SSD"),
    C7gd12xlarge(InstanceType.C7gd12xlarge, 0, 2, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: 15 Gbps", "2 x 1425 Gb NVMe SSD"),
    C7gd16xlarge(InstanceType.C7gd16xlarge, 0, 2, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: 20 Gbps", "2 x 1900 Gb NVMe SSD"),
    C7gnMedium(InstanceType.C7gnMedium, 0, 0, "1 vCPUs", "2 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7gnLarge(InstanceType.C7gnLarge, 0, 0, "2 vCPUs", "4 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7gnXlarge(InstanceType.C7gnXlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7gn2xlarge(InstanceType.C7gn2xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7gn4xlarge(InstanceType.C7gn4xlarge, 0, 0, "16 vCPUs", "32 GiB RAM", "EBS Bandwidth: Up to 10 Gbps"),
    C7gn8xlarge(InstanceType.C7gn8xlarge, 0, 0, "32 vCPUs", "64 GiB RAM", "EBS Bandwidth: Up to 20 Gbps"),
    C7gn12xlarge(InstanceType.C7gn12xlarge, 0, 0, "48 vCPUs", "96 GiB RAM", "EBS Bandwidth: Up to 30 Gbps"),
    C7gn16xlarge(InstanceType.C7gn16xlarge, 0, 0, "64 vCPUs", "128 GiB RAM", "EBS Bandwidth: Up to 40 Gbps"),
    C1_MEDIUM(InstanceType.C1Medium, 1, 0, "5 EC2 Compute Units (2 virtual cores with 2.5 EC2 Compute Units each)", "1.7 GiB RAM", "350 GB of instance storage", "32-bit or 64-bit platform", "Networking Performance: Moderate", "EBS-Optimized Available: No"),
    C1_XLARGE(InstanceType.C1Xlarge, 4, 0, "20 EC2 Compute Units (8 virtual cores with 2.5 EC2 Compute Units each)", "7 GiB RAM", "1690 GB of instance storage", "Networking Performance: High", "EBS-Optimized Available: No"),
    Cc28xlarge(InstanceType.Cc28xlarge, 4, 0, "88 EC2 Compute Units (2 x Intel Xeon E5-2670, eight-core)", "60.5 GiB RAM", "3370 GB of instance storage", "Networking Performance: 10 Gbps)", "EBS-Optimized Available: No"),
    C4Large(InstanceType.C4Large, 0, 0, "3.75 GiB RAM, 2 vCPUs"),
    C4Xlarge(InstanceType.C4Xlarge, 0, 0, "7.5 GiB RAM, 4 vCPUs"),
    C42xlarge(InstanceType.C42xlarge, 0, 0, "15 GiB RAM, 8 vCPUs"),
    C44xlarge(InstanceType.C44xlarge, 0, 0, "30 GiB RAM, 16 vCPUs"),
    C48xlarge(InstanceType.C48xlarge, 0, 0, "60 GiB RAM, 36 vCPUs"),
    F12xlarge(InstanceType.F12xlarge, 0, 1, "1 FPGA", "8 vCPUs", "122 GiB RAM"),
    F14xlarge(InstanceType.F14xlarge, 0, 1, "2 FPGA", "16 vCPUs", "244 GiB RAM"),
    F116xlarge(InstanceType.F116xlarge, 0, 4, "8 FPGA", "64 vCPUs", "976 GiB RAM"),
    G22xlarge(InstanceType.G22xlarge, 0, 1, "15 GiB memory, 26 EC2 Compute Units, 1 x NVIDIA GRID GPU (Kepler GK104), 60 GB of local instance storage"),
    G28xlarge(InstanceType.G28xlarge, 0, 2, "60 GiB memory, 32 vCPUs, 4 x NVIDIA GPU, 240 GB of local instance storage"),
    G3sXlarge(InstanceType.G3sXlarge, 0, 0, "30.5 GiB RAM", "4 vCPUs", "1 x NVIDIA GPU", "Networking Performance: Up to 10 Gbps"),
    G34xlarge(InstanceType.G34xlarge, 0, 0, "122 GiB RAM", "16 vCPUs", "1 x NVIDIA GPU", "Networking Performance: Up to 10 Gbps"),
    G38xlarge(InstanceType.G38xlarge, 0, 0, "244 GiB RAM", "32 vCPUs", "2 x NVIDIA GPU", "Networking Performance: 10 Gbps"),
    G316xlarge(InstanceType.G316xlarge, 0, 0, "488 GiB RAM", "64 vCPUs", "4 x NVIDIA GPU", "Networking Performance: 20 Gbps"),
    G4adXlarge(InstanceType.G4adXlarge, 0, 0, "16 GiB RAM", "4 vCPUs", "1 x AMD Radeon Pro V520 GPU", "Networking Performance: Up to 10 Gbps"),
    G4ad2xlarge(InstanceType.G4ad2xlarge, 0, 0, "32 GiB RAM", "8 vCPUs", "1 x AMD Radeon Pro V520 GPU", "Networking Performance: Up to 10 Gbps"),
    G4ad4xlarge(InstanceType.G4ad4xlarge, 0, 0, "64 GiB RAM", "16 vCPUs", "1 x AMD Radeon Pro V520 GPU", "Networking Performance: Up to 10 Gbps"),
    G4ad8xlarge(InstanceType.G4ad8xlarge, 0, 0, "128 GiB RAM", "32 vCPUs", "2 x AMD Radeon Pro V520 GPU", "Networking Performance: 15 Gbps"),
    G4ad16xlarge(InstanceType.G4ad16xlarge, 0, 0, "256 GiB RAM", "64 vCPUs", "4 x AMD Radeon Pro V520 GPU", "Networking Performance: 25 Gbps"),
    G4dnXlarge(InstanceType.G4dnXlarge, 0, 1, "1 GPU", "4 vCPUs", "16 GiB RAM", "1 x 125 NVMe SSD", "Networking Performance: Up to 25 Gbps"),
    G4dn2xlarge(InstanceType.G4dn2xlarge, 0, 1, "1 GPU", "8 vCPUs", "32 GiB RAM", "1 x 225 NVMe SSD", "Networking Performance: Up to 25 Gbps"),
    G4dn4xlarge(InstanceType.G4dn4xlarge, 0, 1, "1 GPU", "16 vCPUs", "64 GiB RAM", "1 x 225 NVMe SSD", "Networking Performance: Up to 25 Gbps"),
    G4dn8xlarge(InstanceType.G4dn8xlarge, 0, 1, "1 GPU", "32 vCPUs", "128 GiB RAM", "1 x 900 NVMe SSD", "Networking Performance: 50 Gbps"),
    G4dn12xlarge(InstanceType.G4dn12xlarge, 0, 1, "1 GPU", "64 vCPUs", "256 GiB RAM", "1 x 900 NVMe SSD", "Networking Performance: 50 Gbps"),
    G4dn16xlarge(InstanceType.G4dn16xlarge, 0, 1, "4 GPU", "48 vCPUs", "192 GiB RAM", "1 x 900 NVMe SSD", "Networking Performance: 50 Gbps"),
    G4dnMetal(InstanceType.G4dnMetal, 0, 2, "8 GPU", "96 vCPUs", "384 GiB RAM", "2 x 900 NVMe SSD", "Networking Performance: 100 Gbps"),
    G5Xlarge(InstanceType.G5Xlarge, 0, 1, "16 GiB RAM", "4 vCPUs", "1 x NVIDIA A10G Tensor Core GPU", "Networking Performance: Up to 10 Gbps"),
    G52xlarge(InstanceType.G52xlarge, 0, 1, "32 GiB RAM", "8 vCPUs", "1 x NVIDIA A10G Tensor Core GPU", "Networking Performance: Up to 10 Gbps"),
    G54xlarge(InstanceType.G54xlarge, 0, 1, "64 GiB RAM", "16 vCPUs", "1 x NVIDIA A10G Tensor Core GPU", "Networking Performance: Up to 25 Gbps"),
    G58xlarge(InstanceType.G58xlarge, 0, 1, "128 GiB RAM", "32 vCPUs", "1 x NVIDIA A10G Tensor Core GPU", "Networking Performance: 25 Gbps"),
    G512xlarge(InstanceType.G512xlarge, 0, 1, "192 GiB RAM", "48 vCPUs", "4 x NVIDIA A10G Tensor Core GPU", "Networking Performance: 40 Gbps"),
    G516xlarge(InstanceType.G516xlarge, 0, 1, "256 GiB RAM", "64 vCPUs", "1 x NVIDIA A10G Tensor Core GPU", "Networking Performance: 25 Gbps"),
    G524xlarge(InstanceType.G524xlarge, 0, 1, "384 GiB RAM", "96 vCPUs", "4 x NVIDIA A10G Tensor Core GPU", "Networking Performance: 50 Gbps"),
    G548xlarge(InstanceType.G548xlarge, 0, 2, "768 GiB RAM", "192 vCPUs", "8 x NVIDIA A10G Tensor Core GPU", "Networking Performance: 100 Gbps"),
    G5gXlarge(InstanceType.G5gXlarge, 0, 0, "8 GiB RAM", "4 vCPUs", "1 x NVIDIA T4G Tensor GPU", "Networking Performance: Up to 10 Gbps"),
    G5g2xlarge(InstanceType.G5g2xlarge, 0, 0, "16 GiB RAM", "8 vCPUs", "1 x NVIDIA T4G Tensor GPU", "Networking Performance: Up to 10 Gbps"),
    G5g4xlarge(InstanceType.G5g4xlarge, 0, 0, "32 GiB RAM", "16 vCPUs", "1 x NVIDIA T4G Tensor GPU", "Networking Performance: Up to 10 Gbps"),
    G5g8xlarge(InstanceType.G5g8xlarge, 0, 0, "64 GiB RAM", "32 vCPUs", "1 x NVIDIA T4G Tensor GPU", "Networking Performance: 12 Gbps"),
    G5g16xlarge(InstanceType.G5g16xlarge, 0, 0, "128 GiB RAM", "64 vCPUs", "2 x NVIDIA T4G Tensor GPU", "Networking Performance: 25 Gbps"),
    G5gMetal(InstanceType.G5gMetal, 0, 0, "128 GiB RAM", "64 vCPUs", "2 x NVIDIA T4G Tensor GPU", "Networking Performance: 25 Gbps"),
    H12xlarge(InstanceType.H12xlarge, 1, 0, "8 vCPUs", "32 GiB RAM", "Networking Performance: Up to 10 Gigabit", "1 x 2TB HDD"),
    H14xlarge(InstanceType.H14xlarge, 2, 0, "16 vCPUs", "64 GiB RAM", "Networking Performance: Up to 10 Gigabit", "2 x 2TB HDD"),
    H18xlarge(InstanceType.H18xlarge, 4, 0, "32 vCPUs", "128 GiB RAM", "Networking Performance: 10 Gigabit", "4 x 2TB HDD"),
    H116xlarge(InstanceType.H116xlarge, 8, 0, "64 vCPUs", "256 GiB RAM", "Networking Performance: 25 Gigabit", "8 x 2TB HDD"),
    Cg14xlarge(InstanceType.Cg14xlarge, 2, 0, "33.5 EC2 Compute Units (2 x Intel Xeon X5570, quad-core)", "22 GiB RAM", "2 x NVIDIA Tesla Fermi M2050 GPUs", "1690 GB of instance storage", "Networking Performance: 10 Gbps", "EBS-Optimized Available: No"),
    P2Xlarge(InstanceType.P2Xlarge, 0, 0, "61 GiB RAM, 4 vCPUs, 1 GPU, Networking Performance: High"),
    P28xlarge(InstanceType.P28xlarge, 0, 0, "488 GiB RAM, 32 vCPUs, 8 GPU, Networking Performance: 10 Gbps"),
    P216xlarge(InstanceType.P216xlarge, 0, 0, "732 GiB RAM, 64 vCPUs, 16 GPU, Networking Performance: 20 Gbps"),
    P32xlarge(InstanceType.P32xlarge, 0, 0, "1 GPU", "16 GB GPU RAM", "8 vCPUs", "61 GB RAM", "Networking Performance: Up to 10Gbps", "EBS Bandwidth: 1.5Gbps"),
    P38xlarge(InstanceType.P38xlarge, 0, 0, "4 GPUs", "64 GB GPU RAM", "32 vCPUs", "244 GB RAM", "Networking Performance: 10Gbps", "EBS Bandwidth: 7Gbps"),
    P316xlarge(InstanceType.P316xlarge, 0, 0, "8 GPUs", "128 GB GPU RAM", "64 vCPUs", "488 GB RAM", "Networking Performance: 25Gbps", "EBS Bandwidth: 14Gbps"),
    P3dn24xlarge(InstanceType.P3dn24xlarge, 0, 0, "8 GPUs", "256 GB GPU RAM", "96 vCPUs", "768 GB RAM", "Networking Performance: 100Gbps", "EBS Bandwidth: 14Gbps"),
    P4d24xlarge(InstanceType.P4d24xlarge, 0, 8, "8 GPU A100", "96 vCPUs", "1152 GB RAM", "320 GB GPU memory", "8 x 1 TB NVMe SSD", "Networking Performance: 400 Gbps", "EBS Bandwidth: 19 Gbps"),
    P4de24xlarge(InstanceType.P4de24xlarge, 0, 8, "8 GPU A100", "96 vCPUs", "1152 GB RAM", "640 GB GPU memory", "8 x 1 TB NVMe SSD", "Networking Performance: 400 Gbps", "EBS Bandwidth: 19 Gbps"),
    P548xlarge(InstanceType.P548xlarge, 0, 8, "8 GPU H100", "192 vCPUs", "2 TB RAM", "640 GB GPU memory", "8 x 3.84 TB NVMe SSD", "Networking Performance: 900 Gbps", "EBS Bandwidth: 80 Gbps"),
    R3Large(InstanceType.R3Large, 0, 1, "2 vCPUs", "15 GiB RAM", "1 x 32 GB of SSD-based instance storage"),
    R3XLarge(InstanceType.R3Xlarge, 0, 1, "4 vCPUs", "30.5 GiB RAM", "1 x 80 GB of SSD-based instance storage"),
    R32xlarge(InstanceType.R32xlarge, 0, 1, "8 vCPUs", "61 GiB RAM", "1 x 160 GB of SSD-based instance storage"),
    R34xlarge(InstanceType.R34xlarge, 0, 1, "16 vCPUs", "122 GiB RAM", "1 x 320 GB of SSD-based instance storage"),
    R38xlarge(InstanceType.R38xlarge, 0, 2, "32 vCPUs", "244 GiB RAM", "2 x 320 GB of SSD-based instance storage", "Networking Performance: 10 Gbps"),
    R4Large(InstanceType.R4Large, 0, 0, "2 vCPUs", "15.25 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R4Xlarge(InstanceType.R4Xlarge, 0, 0, "4 vCPUs", "30.5 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R42xlarge(InstanceType.R42xlarge, 0, 0, "8 vCPUs", "61 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R44xlarge(InstanceType.R44xlarge, 0, 0, "16 vCPUs", "122 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R48xlarge(InstanceType.R48xlarge, 0, 0, "32 vCPUs", "244 GiB RAM", "Networking Performance: 10 Gbps"),
    R416xlarge(InstanceType.R416xlarge, 0, 0, "64 vCPUs", "488 GiB RAM", "Networking Performance: 20 Gbps"),
    R5Large(InstanceType.R5Large, 0, 0, "2 vCPUs", "16 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5Xlarge(InstanceType.R5Xlarge, 0, 0, "4 vCPUs", "32 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R52xlarge(InstanceType.R52xlarge, 0, 0, "8 vCPUs", "64 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R54xlarge(InstanceType.R54xlarge, 0, 0, "16 vCPUs", "128 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R58xlarge(InstanceType.R58xlarge, 0, 0, "32 vCPUs", "256 GiB RAM", "Networking Performance: 10 Gbps"),
    R512xlarge(InstanceType.R512xlarge, 0, 0, "48 vCPUs", "384 GiB RAM", "Networking Performance: 10 Gbps"),
    R516xlarge(InstanceType.R516xlarge, 0, 0, "64 vCPUs", "512 GiB RAM", "Networking Performance: 25 Gbps"),
    R524xlarge(InstanceType.R524xlarge, 0, 0, "96 vCPUs", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    R5Metal(InstanceType.R5Metal, 0, 0, "96 vCPUs", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    R5aLarge(InstanceType.R5aLarge, 0, 0, "2 vCPUs", "16 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5aXlarge(InstanceType.R5aXlarge, 0, 0, "4 vCPUs", "32 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5a2xlarge(InstanceType.R5a2xlarge, 0, 0, "8 vCPUs", "64 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5a4xlarge(InstanceType.R5a4xlarge, 0, 0, "16 vCPUs", "128 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5a8xlarge(InstanceType.R5a8xlarge, 0, 0, "32 vCPUs", "256 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5a12xlarge(InstanceType.R5a12xlarge, 0, 0, "48 vCPUs", "384 GiB RAM", "Networking Performance: 10 Gbps"),
    R5a16xlarge(InstanceType.R5a16xlarge, 0, 0, "64 vCPUs", "512 GiB RAM", "Networking Performance: 12 Gbps"),
    R5a24xlarge(InstanceType.R5a24xlarge, 0, 0, "96 vCPUs", "768 GiB RAM", "Networking Performance: 20 Gbps"),
    R5bLarge(InstanceType.R5bLarge, 0, 0, "2 vCPUs", "16 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5bXlarge(InstanceType.R5bXlarge, 0, 0, "4 vCPUs", "32 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5b2xlarge(InstanceType.R5b2xlarge, 0, 0, "8 vCPUs", "64 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5b4xlarge(InstanceType.R5b4xlarge, 0, 0, "16 vCPUs", "128 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5b8xlarge(InstanceType.R5b8xlarge, 0, 0, "32 vCPUs", "256 GiB RAM", "Networking Performance: 10 Gbps"),
    R5b12xlarge(InstanceType.R5b12xlarge, 0, 0, "48 vCPUs", "384 GiB RAM", "Networking Performance: 10 Gbps"),
    R5b16xlarge(InstanceType.R5b16xlarge, 0, 0, "64 vCPUs", "512 GiB RAM", "Networking Performance: 20 Gbps"),
    R5b24xlarge(InstanceType.R5b24xlarge, 0, 0, "96 vCPUs", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    R5bMetal(InstanceType.R5bMetal, 0, 0, "96 CPUs", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    R5dLarge(InstanceType.R5dLarge, 0, 1, "2 vCPUs", "16 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5dXlarge(InstanceType.R5dXlarge, 0, 1, "4 vCPUs", "32 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5d2xlarge(InstanceType.R5d2xlarge, 0, 1, "8 vCPUs", "64 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5d4xlarge(InstanceType.R5d4xlarge, 0, 2, "16 vCPUs", "128 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R5d8xlarge(InstanceType.R5d8xlarge, 0, 2, "32 vCPUs", "256 GiB RAM", "Networking Performance: 10 Gbps"),
    R5d12xlarge(InstanceType.R5d12xlarge, 0, 2, "48 vCPUs", "384 GiB RAM", "Networking Performance: 10 Gbps"),
    R5d16xlarge(InstanceType.R5d16xlarge, 0, 4, "64 vCPUs", "512 GiB RAM", "Networking Performance: 25 Gbps"),
    R5d24xlarge(InstanceType.R5d24xlarge, 0, 4, "96 vCPUs", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    R5dMetal(InstanceType.R5dMetal, 0, 4, "96 vCPUs", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    R5dnLarge(InstanceType.R5dnLarge, 0, 1, "2 vCPUs", "16 GiB RAM", "1 x 75 NVMe SSD", "Networking Performance: Up to 25 Gbps"),
    R5dnXlarge(InstanceType.R5dnXlarge, 0, 1, "4 vCPUs", "32 GiB RAM", "1 x 150 NVMe SSD", "Networking Performance: Up to 25 Gbps"),
    R5dn2xlarge(InstanceType.R5dn2xlarge, 0, 1, "8 vCPUs", "64 GiB RAM", "1 x 300 NVMe SSD", "Networking Performance: Up to 25 Gbps"),
    R5dn4xlarge(InstanceType.R5dn4xlarge, 0, 2, "16 vCPUs", "128 GiB RAM", "2 x 300 NVMe SSD", "Networking Performance: Up to 25 Gbps"),
    R5dn8xlarge(InstanceType.R5dn8xlarge, 0, 2, "32 vCPUs", "256 GiB RAM", "2 x 600 NVMe SSD", "Networking Performance: 25 Gbps"),
    R5dn12xlarge(InstanceType.R5dn12xlarge, 0, 2, "48 vCPUs", "384 GiB RAM", "2 x 900 NVMe SSD", "Networking Performance: 50 Gbps"),
    R5dn16xlarge(InstanceType.R5dn16xlarge, 0, 4, "64 vCPUs", "512 GiB RAM", "4 x 600 NVMe SSD", "Networking Performance: 75 Gbps"),
    R5dn24xlarge(InstanceType.R5dn24xlarge, 0, 4, "96 vCPUs", "768 GiB RAM", "4 x 900 NVMe SSD", "Networking Performance: 100 Gbps"),
    R5dnMetal(InstanceType.R5dnMetal, 0, 4, "96 CPUs", "768 GiB RAM", "4 x 900 NVMe SSD", "Networking Performance: 100 Gbps"),
    R5adLarge(InstanceType.R5adLarge, 0, 1, "2 vCPUs", "16 GiB RAM", "1 x 75 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R5adXlarge(InstanceType.R5adXlarge, 0, 1, "4 vCPUs", "32 GiB RAM", "1 x 150 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R5ad2xlarge(InstanceType.R5ad2xlarge, 0, 1, "8 vCPUs", "64 GiB RAM", "1 x 300 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R5ad4xlarge(InstanceType.R5ad4xlarge, 0, 2, "16 vCPUs", "128 GiB RAM", "2 x 300 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R5ad8xlarge(InstanceType.R5ad8xlarge, 0, 2, "32 vCPUs", "256 GiB RAM", "2 x 300 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R5ad12xlarge(InstanceType.R5ad12xlarge, 0, 2, "48 vCPUs", "384 GiB RAM", "2 x 900 NVMe SSD", "Networking Performance: 10 Gbps"),
    R5ad16xlarge(InstanceType.R5ad16xlarge, 0, 2, "64 vCPUs", "512 GiB RAM", "2 x 900 NVMe SSD", "Networking Performance: 10 Gbps"),
    R5ad24xlarge(InstanceType.R5ad24xlarge, 0, 4, "96 vCPUs", "768 GiB RAM", "4 x 900 NVMe SSD", "Networking Performance: 20 Gbps"),
    R5nLarge(InstanceType.R5nLarge, 0, 0, "2 vCPUs", "16 GiB RAM", "Networking Performance: Up to 25 Gbps"),
    R5nXlarge(InstanceType.R5nXlarge, 0, 0, "4 vCPUs", "32 GiB RAM", "Networking Performance: Up to 25 Gbps"),
    R5n2xlarge(InstanceType.R5n2xlarge, 0, 0, "8 vCPUs", "64 GiB RAM", "Networking Performance: Up to 25 Gbps"),
    R5n4xlarge(InstanceType.R5n4xlarge, 0, 0, "16 vCPUs", "128 GiB RAM", "Networking Performance: Up to 25 Gbps"),
    R5n8xlarge(InstanceType.R5n8xlarge, 0, 0, "32 vCPUs", "256 GiB RAM", "Networking Performance: 25 Gbps"),
    R5n12xlarge(InstanceType.R5n12xlarge, 0, 0, "48 vCPUs", "384 GiB RAM", "Networking Performance: 50 Gbps"),
    R5n16xlarge(InstanceType.R5n16xlarge, 0, 0, "64 vCPUs", "512 GiB RAM", "Networking Performance: 75 Gbps"),
    R5n24xlarge(InstanceType.R5n24xlarge, 0, 0, "96 vCPUs", "768 GiB RAM", "Networking Performance: 100 Gbps"),
    R5nMetal(InstanceType.R5nMetal, 0, 0, "96 CPUs", "768 GiB RAM", "Networking Performance: 100 Gbps"),
    R6aLarge(InstanceType.R6aLarge, 0, 0, "2 vCPUs", "16 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    R6aXlarge(InstanceType.R6aXlarge, 0, 0, "4 vCPUs", "32 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    R6a2xlarge(InstanceType.R6a2xlarge, 0, 0, "8 vCPUs", "64 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    R6a4xlarge(InstanceType.R6a4xlarge, 0, 0, "16 vCPUs", "128 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    R6a8xlarge(InstanceType.R6a8xlarge, 0, 0, "32 vCPUs", "256 GiB RAM", "Networking Performance: 12.5 Gbps", "EBS Bandwidth: 10 Gbps"),
    R6a12xlarge(InstanceType.R6a12xlarge, 0, 0, "48 vCPUs", "384 GiB RAM", "Networking Performance: 18.75 Gbps", "EBS Bandwidth: 15 Gbps"),
    R6a16xlarge(InstanceType.R6a16xlarge, 0, 0, "64 vCPUs", "512 GiB RAM", "Networking Performance: 25 Gbps", "EBS Bandwidth: 20 Gbps"),
    R6a24xlarge(InstanceType.R6a24xlarge, 0, 0, "96 vCPUs", "768 GiB RAM", "Networking Performance:  37.5 Gbps", "EBS Bandwidth: 30 Gbps"),
    R6a32xlarge(InstanceType.R6a32xlarge, 0, 0, "128 vCPUs", "1024 GiB RAM", "Networking Performance: 50 Gbps", "EBS Bandwidth: 40 Gbps"),
    R6a48xlarge(InstanceType.R6a48xlarge, 0, 0, "192 vCPUs", "1536 GiB RAM", "Networking Performance: 50 Gbps", "EBS Bandwidth: 40 Gbps"),
    R6aMetal(InstanceType.R6aMetal, 0, 0, "192 vCPUs", "1536 GiB RAM", "Networking Performance: 50 Gbps", "EBS Bandwidth: 40 Gbps"),
    R6gMedium(InstanceType.R6gMedium, 0, 0, "1 vCPU", "8 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R6gLarge(InstanceType.R6gLarge, 0, 0, "2 vCPUs", "16 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R6gXlarge(InstanceType.R6gXlarge, 0, 0, "4 vCPUs", "32 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R6g2xlarge(InstanceType.R6g2xlarge, 0, 0, "8 vCPUs", "64 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R6g4xlarge(InstanceType.R6g4xlarge, 0, 0, "16 vCPUs", "128 GiB RAM", "Networking Performance: Up to 10 Gbps"),
    R6g8xlarge(InstanceType.R6g8xlarge, 0, 0, "32 vCPUs", "256 GiB RAM", "Networking Performance: 12 Gbps"),
    R6g12xlarge(InstanceType.R6g12xlarge, 0, 0, "48 vCPUs", "384 GiB RAM", "Networking Performance: 20 Gbps"),
    R6g16xlarge(InstanceType.R6g16xlarge, 0, 0, "64 vCPUs", "512 GiB RAM", "Networking Performance: 25 Gbps"),
    R6gMetal(InstanceType.R6gMetal, 0, 0, "64 vCPUs", "512 GiB RAM", "Networking Performance: 25 Gbps"),
    R6gdMedium(InstanceType.R6gdMedium, 0, 1, "1 vCPU", "8 GiB RAM", "1 x 59 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R6gdLarge(InstanceType.R6gdLarge, 0, 1, "2 vCPUs", "16 GiB RAM", "1 x 118 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R6gdXlarge(InstanceType.R6gdXlarge, 0, 1, "4 vCPUs", "32 GiB RAM", "1 x 237 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R6gd2xlarge(InstanceType.R6gd2xlarge, 0, 1, "8 vCPUs", "64 GiB RAM", "1 x 474 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R6gd4xlarge(InstanceType.R6gd4xlarge, 0, 1, "16 vCPUs", "128 GiB RAM", "1 x 950 NVMe SSD", "Networking Performance: Up to 10 Gbps"),
    R6gd8xlarge(InstanceType.R6gd8xlarge, 0, 1, "32 vCPUs", "256 GiB RAM", "1 x 1900 NVMe SSD", "Networking Performance: 12 Gbps"),
    R6gd12xlarge(InstanceType.R6gd12xlarge, 0, 2, "48 vCPUs", "384 GiB RAM", "2 x 1425 NVMe SSD", "Networking Performance: 20 Gbps"),
    R6gd16xlarge(InstanceType.R6gd16xlarge, 0, 2, "64 vCPUs", "512 GiB RAM", "2 x 1900 NVMe SSD", "Networking Performance: 25 Gbps"),
    R6gdMetal(InstanceType.R6gdMetal, 0, 2, "64 vCPUs", "512 GiB RAM", "2 x 1900 NVMe SSD", "Networking Performance: 25 Gbps"),
    R6iLarge(InstanceType.R6iLarge, 0, 0, "2 vCPU", "16 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R6iXlarge(InstanceType.R6iXlarge, 0, 0, "4 vCPU", "32 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R6i2xlarge(InstanceType.R6i2xlarge, 0, 0, "8 vCPU", "64 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R6i4xlarge(InstanceType.R6i4xlarge, 0, 0, "16 vCPU", "128 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R6i8xlarge(InstanceType.R6i8xlarge, 0, 0, "32 vCPU", "256 GiB RAM", "Networking Performance: 12.5 Gbps"),
    R6i12xlarge(InstanceType.R6i12xlarge, 0, 0, "48 vCPU", "384 GiB RAM", "Networking Performance: 18.75 Gbps"),
    R6i16xlarge(InstanceType.R6i16xlarge, 0, 0, "64 vCPU", "512 GiB RAM", "Networking Performance: 25 Gbps"),
    R6i24xlarge(InstanceType.R6i24xlarge, 0, 0, "96 vCPU", "768 GiB RAM", "Networking Performance: 37.5 Gbps"),
    R6i32xlarge(InstanceType.R6i32xlarge, 0, 0, "128 vCPU", "1024 GiB RAM", "Networking Performance: 50 Gbps"),
    R6iMetal(InstanceType.R6iMetal, 0, 0, "128 CPU", "1024 GiB RAM", "Networking Performance: 50 Gbps"),
    R6inLarge(InstanceType.R6inLarge, 0, 0, "2 vCPU", "16 GiB RAM", "Networking Performance: Up to 25 Gbps"),
    R6inXlarge(InstanceType.R6inXlarge, 0, 0, "4 vCPU", "32 GiB RAM", "Networking Performance: Up to 30 Gbps"),
    R6in2xlarge(InstanceType.R6in2xlarge, 0, 0, "8 vCPU", "64 GiB RAM", "Networking Performance: Up to 40 Gbps"),
    R6in4xlarge(InstanceType.R6in4xlarge, 0, 0, "16 vCPU", "128 GiB RAM", "Networking Performance: Up to 50 Gbps"),
    R6in8xlarge(InstanceType.R6in8xlarge, 0, 0, "32 vCPU", "256 GiB RAM", "Networking Performance: 50 Gbps"),
    R6in12xlarge(InstanceType.R6in12xlarge, 0, 0, "48 vCPU", "384 GiB RAM", "Networking Performance: 75 Gbps"),
    R6in16xlarge(InstanceType.R6in16xlarge, 0, 0, "64 vCPU", "512 GiB RAM", "Networking Performance: 100 Gbps"),
    R6in24xlarge(InstanceType.R6in24xlarge, 0, 0, "96 vCPU", "768 GiB RAM", "Networking Performance: 150 Gbps"),
    R6in32xlarge(InstanceType.R6in32xlarge, 0, 0, "128 vCPU", "1024 GiB RAM", "Networking Performance: 200 Gbps"),
    R6inMetal(InstanceType.R6inMetal, 0, 0, "128 CPU", "1024 GiB RAM", "Networking Performance: 200 Gbps"),
    R6idLarge(InstanceType.R6idLarge, 0, 1, "2 vCPU", "16 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "1 x 118 GB NVMe SSD"),
    R6idXlarge(InstanceType.R6idXlarge, 0, 1, "4 vCPU", "32 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "1 x 237 GB NVMe SSD"),
    R6id2xlarge(InstanceType.R6id2xlarge, 0, 1, "8 vCPU", "64 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "1 x 474 GB NVMe SSD"),
    R6id4xlarge(InstanceType.R6id4xlarge, 0, 1, "16 vCPU", "128 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "1 x 950 GB NVMe SSD"),
    R6id8xlarge(InstanceType.R6id8xlarge, 0, 1, "32 vCPU", "256 GiB RAM", "Networking Performance: 12.5 Gbps", "1 x 1900 GB NVMe SSD"),
    R6id12xlarge(InstanceType.R6id12xlarge, 0, 2, "48 vCPU", "384 GiB RAM", "Networking Performance: 18.75 Gbps", "2 x 1425 GB NVMe SSD"),
    R6id16xlarge(InstanceType.R6id16xlarge, 0, 2, "64 vCPU", "512 GiB RAM", "Networking Performance: 25 Gbps", "2 x 1900 GB NVMe SSD"),
    R6id24xlarge(InstanceType.R6id24xlarge, 0, 4, "96 vCPU", "768 GiB RAM", "Networking Performance: 37.5 Gbps", "4 x 1425 GB NVMe SSD"),
    R6id32xlarge(InstanceType.R6id32xlarge, 0, 4, "128 vCPU", "1024 GiB RAM", "Networking Performance: 50 Gbps", "4 x 1900 GB NVMe SSD"),
    R6idMetal(InstanceType.R6idMetal, 0, 4, "128 CPU", "1024 GiB RAM", "Networking Performance: 50 Gbps", "4 x 1900 GB NVMe SSD"),
    R6idnLarge(InstanceType.R6idnLarge, 0, 1, "2 vCPU", "16 GiB RAM", "Networking Performance: Up to 25 Gbps", "1 x 118 GB NVMe SSD"),
    R6idnXlarge(InstanceType.R6idnXlarge, 0, 1, "4 vCPU", "32 GiB RAM", "Networking Performance: Up to 30 Gbps", "1 x 237 GB NVMe SSD"),
    R6idn2xlarge(InstanceType.R6idn2xlarge, 0, 1, "8 vCPU", "64 GiB RAM", "Networking Performance: Up to 40 Gbps", "1 x 474 GB NVMe SSD"),
    R6idn4xlarge(InstanceType.R6idn4xlarge, 0, 1, "16 vCPU", "128 GiB RAM", "Networking Performance: Up to 50 Gbps", "1 x 950 GB NVMe SSD"),
    R6idn8xlarge(InstanceType.R6idn8xlarge, 0, 1, "32 vCPU", "256 GiB RAM", "Networking Performance: 50 Gbps", "1 x 1900 GB NVMe SSD"),
    R6idn12xlarge(InstanceType.R6idn12xlarge, 0, 2, "48 vCPU", "384 GiB RAM", "Networking Performance: 75 Gbps", "2 x 1425 GB NVMe SSD"),
    R6idn16xlarge(InstanceType.R6idn16xlarge, 0, 2, "64 vCPU", "512 GiB RAM", "Networking Performance: 100 Gbps", "2 x 1900 GB NVMe SSD"),
    R6idn24xlarge(InstanceType.R6idn24xlarge, 0, 4, "96 vCPU", "768 GiB RAM", "Networking Performance: 150 Gbps", "4 x 1425 GB NVMe SSD"),
    R6idn32xlarge(InstanceType.R6idn32xlarge, 0, 4, "128 vCPU", "1024 GiB RAM", "Networking Performance: 200 Gbps", "4 x 1900 GB NVMe SSD"),
    R6idnMetal(InstanceType.R6idnMetal, 0, 4, "128 CPU", "1024 GiB RAM", "Networking Performance: 200 Gbps", "4 x 1900 GB NVMe SSD"),
    R7aMedium(InstanceType.R7aMedium, 0, 0, "1 vCPUs", "8 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    R7aLarge(InstanceType.R7aLarge, 0, 0, "2 vCPUs", "16 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    R7aXlarge(InstanceType.R7aXlarge, 0, 0, "4 vCPUs", "32 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    R7a2xlarge(InstanceType.R7a2xlarge, 0, 0, "8 vCPUs", "64 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    R7a4xlarge(InstanceType.R7a4xlarge, 0, 0, "16 vCPUs", "128 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    R7a8xlarge(InstanceType.R7a8xlarge, 0, 0, "32 vCPUs", "256 GiB RAM", "Networking Performance: 12.5 Gbps", "EBS Bandwidth: 10 Gbps"),
    R7a12xlarge(InstanceType.R7a12xlarge, 0, 0, "48 vCPUs", "384 GiB RAM", "Networking Performance: 18.75 Gbps", "EBS Bandwidth: 15 Gbps"),
    R7a16xlarge(InstanceType.R7a16xlarge, 0, 0, "64 vCPUs", "512 GiB RAM", "Networking Performance: 25 Gbps", "EBS Bandwidth: 20 Gbps"),
    R7a24xlarge(InstanceType.R7a24xlarge, 0, 0, "96 vCPUs", "768 GiB RAM", "Networking Performance: 37.5 Gbps", "EBS Bandwidth: 30 Gbps"),
    R7a32xlarge(InstanceType.R7a32xlarge, 0, 0, "128 vCPUs", "1024 GiB RAM", "Networking Performance: 50 Gbps", "EBS Bandwidth: 40 Gbps"),
    R7a48xlarge(InstanceType.R7a48xlarge, 0, 0, "192 vCPUs", "1536 GiB RAM", "Networking Performance: 50 Gbps", "EBS Bandwidth: 40 Gbps"),
    R7aMetal48xl(InstanceType.R7aMetal48xl, 0, 0, "192 vCPUs", "1536 GiB RAM", "Networking Performance: 50 Gbps", "EBS Bandwidth: 40 Gbps"),
    R7iLarge(InstanceType.R7iLarge, 0, 0, "2 vCPU", "16 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7iXlarge(InstanceType.R7iXlarge, 0, 0, "4 vCPU", "32 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7i2xlarge(InstanceType.R7i2xlarge, 0, 0, "8 vCPU", "64 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7i4xlarge(InstanceType.R7i4xlarge, 0, 0, "16 vCPU", "128 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7i8xlarge(InstanceType.R7i8xlarge, 0, 0, "32 vCPU", "256 GiB RAM", "Networking Performance: 12.5 Gbps"),
    R7i12xlarge(InstanceType.R7i12xlarge, 0, 0, "48 vCPU", "384 GiB RAM", "Networking Performance: 18.75 Gbps"),
    R7i16xlarge(InstanceType.R7i16xlarge, 0, 0, "64 vCPU", "512 GiB RAM", "Networking Performance: 25 Gbps"),
    R7i24xlarge(InstanceType.R7i24xlarge, 0, 0, "96 vCPU", "768 GiB RAM", "Networking Performance: 37.5 Gbps"),
    R7i48xlarge(InstanceType.R7i48xlarge, 0, 0, "192 vCPU", "1024 GiB RAM", "Networking Performance: 50 Gbps"),
    R7iMetal24xl(InstanceType.R7iMetal24xl, 0, 0, "96 CPU", "1024 GiB RAM", "Networking Performance: 37.5 Gbps"),
    R7iMetal48xl(InstanceType.R7iMetal48xl, 0, 0, "192 vCPU", "1024 GiB RAM", "Networking Performance: 50 Gbps"),
    R7izLarge(InstanceType.R7izLarge, 0, 0, "2 vCPU", "16 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7izXlarge(InstanceType.R7izXlarge, 0, 0, "4 vCPU", "32 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7iz2xlarge(InstanceType.R7iz2xlarge, 0, 0, "8 vCPU", "64 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7iz4xlarge(InstanceType.R7iz4xlarge, 0, 0, "16 vCPU", "128 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7iz8xlarge(InstanceType.R7iz8xlarge, 0, 0, "32 vCPU", "256 GiB RAM", "Networking Performance: 12.5 Gbps"),
    R7iz12xlarge(InstanceType.R7iz12xlarge, 0, 0, "48 vCPU", "384 GiB RAM", "Networking Performance: 25 Gbps"),
    R7iz16xlarge(InstanceType.R7iz16xlarge, 0, 0, "64 vCPU", "512 GiB RAM", "Networking Performance: 25 Gbps"),
    R7iz32xlarge(InstanceType.R7iz32xlarge, 0, 0, "128 vCPU", "1024 GiB RAM", "Networking Performance: 50 Gbps"),
    R7izMetal16l(InstanceType.R7izMetal16xl, 0, 0, "64 CPU", "512 GiB RAM", "Networking Performance: 25 Gbps"),
    R7izMetal32xl(InstanceType.R7izMetal32xl, 0, 0, "128 vCPU", "1024 GiB RAM", "Networking Performance: 50 Gbps"),
    R7gMedium(InstanceType.R7gMedium, 0, 0, "1 vCPU", "8 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7gLarge(InstanceType.R7gLarge, 0, 0, "2 vCPU", "16 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7gXlarge(InstanceType.R7gXlarge, 0, 0, "4 vCPU", "32 GiB RAM", "Networking Performance: Up to 12.5 Gbps"),
    R7g2xlarge(InstanceType.R7g2xlarge, 0, 0, "8 vCPU", "64 GiB RAM", "Networking Performance: Up to 15 Gbps"),
    R7g4xlarge(InstanceType.R7g4xlarge, 0, 0, "16 vCPU", "128 GiB RAM", "Networking Performance: Up to 15 Gbps"),
    R7g8xlarge(InstanceType.R7g8xlarge, 0, 0, "32 vCPU", "256 GiB RAM", "Networking Performance: 15 Gbps"),
    R7g12xlarge(InstanceType.R7g12xlarge, 0, 0, "48 vCPU", "384 GiB RAM", "Networking Performance: 12.5 Gbps"),
    R7g16xlarge(InstanceType.R7g16xlarge, 0, 0, "64 vCPU", "512 GiB RAM", "Networking Performance: 30 Gbps"),
    R7gMetal(InstanceType.R7gMetal, 0, 0, "96 CPU", "1024 GiB RAM", "Networking Performance: 30 Gbps"),
    R7gdMedium(InstanceType.R7gdMedium, 0, 1, "1 vCPU", "8 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "59 Gb NVMe SSD"),
    R7gdLarge(InstanceType.R7gdLarge, 0, 1, "2 vCPU", "16 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "118 Gb NVMe SSD"),
    R7gdXlarge(InstanceType.R7gdXlarge, 0, 1, "4 vCPU", "32 GiB RAM", "Networking Performance: Up to 12.5 Gbps", "237 Gb NVMe SSD"),
    R7gd2xlarge(InstanceType.R7gd2xlarge, 0, 1, "8 vCPU", "64 GiB RAM", "Networking Performance: Up to 15 Gbps", "474 Gb NVMe SSD"),
    R7gd4xlarge(InstanceType.R7gd4xlarge, 0, 1, "16 vCPU", "128 GiB RAM", "Networking Performance: Up to 15 Gbps", "950 Gb NVMe SSD"),
    R7gd8xlarge(InstanceType.R7gd8xlarge, 0, 1, "32 vCPU", "256 GiB RAM", "Networking Performance: 15 Gbps", "1900 Gb NVMe SSD"),
    R7gd12xlarge(InstanceType.R7gd12xlarge, 0, 2, "48 vCPU", "384 GiB RAM", "Networking Performance: 12.5 Gbps", "2 x 1425 Gb NVMe SSD"),
    R7gd16xlarge(InstanceType.R7gd16xlarge, 0, 2, "64 vCPU", "512 GiB RAM", "Networking Performance: 30 Gbps", "2 x 1900 Gb NVMe SSD"),
    U3tb156xlarge(InstanceType.U3tb156xlarge, 0, 0, "224 vCPUs", "3 TiB RAM"),
    U6tb156xlarge(InstanceType.U6tb156xlarge, 0, 0, "224 vCPUs", "6 TiB RAM"),
    U6tb1112xlarge(InstanceType.U6tb1112xlarge, 0, 0, "448 vCPUs", "6 TiB RAM"),
    U6tb1Metal(InstanceType.U6tb1Metal, 0, 0, "448 vCPUs", "6 TiB RAM"),
    U9tb1112xlarge(InstanceType.U9tb1112xlarge, 0, 0, "448 vCPUs", "9 TiB RAM"),
    U9tb1Metal(InstanceType.U9tb1Metal, 0, 0, "448 vCPUs", "9 TiB RAM"),
    U12tb1112xlarge(InstanceType.U12tb1112xlarge, 0, 0, "448 vCPUs", "12 TiB RAM"),
    U12tb1Metal(InstanceType.U12tb1Metal, 0, 0, "448 vCPUs", "12 TiB RAM"),
    U18tb1112xlarge(InstanceType.U18tb1112xlarge, 0, 0, "448 vCPUs", "18 TiB RAM"),
    U18tb1Metal(InstanceType.U18tb1Metal, 0, 0, "448 vCPUs", "18 TiB RAM"),
    U24tb1112xlarge(InstanceType.U24tb1112xlarge, 0, 0, "448 vCPUs", "24 TiB RAM"),
    U24tb1Metal(InstanceType.U24tb1Metal, 0, 0, "448 vCPUs", "24 TiB RAM"),
    M2Xlarge(InstanceType.M2Xlarge, 1, 0, "6.5 EC2 Compute Units (2 virtual cores with 3.25 EC2 Compute Units each)", "17.1 GiB RAM", "420 GB of instance storage", "Networking Performance: Moderate", "EBS-Optimized Available: No"),
    M22xlarge(InstanceType.M22xlarge, 1, 0, "13 EC2 Compute Units (4 virtual cores with 3.25 EC2 Compute Units each)", "34.2 GiB RAM", "850 GB of instance storage", "Networking Performance: Moderate", "EBS-Optimized Available: No"),
    M24xlarge(InstanceType.M24xlarge, 2, 0, "26 EC2 Compute Units (8 virtual cores with 3.25 EC2 Compute Units each)", "68.4 GiB RAM", "1690 GB of instance storage", "Networking Performance: High", "EBS-Optimized Available: 1000 Mbps"),
    Cr18xlarge(InstanceType.Cr18xlarge, 0, 2, "88 EC2 Compute Units (2 x Intel Xeon E5-2670, eight-core. Intel Turbo, NUMA)", "244 GiB RAM", "240 GB of SSD instance storage", "Networking Performance: 10 Gbps", "EBS-Optimized Available: No"),
    I2Xlarge(InstanceType.I2Xlarge, 0, 1, "30.5 GiB RAM, 4 vCPUs, 14 EC2 Compute Units, 800 GB of SSD-based instance storage"),
    I22xlarge(InstanceType.I22xlarge, 0, 2, "61 GiB RAM, 8 vCPUs, 27 EC2 Compute Units, 2 x 800 GB of SSD-based instance storage"),
    I24xlarge(InstanceType.I24xlarge, 0, 4, "122 GiB RAM, 16 vCPUs, 53 EC2 Compute Units, 4 x 800 GB of SSD-based instance storage"),
    I28xlarge(InstanceType.I28xlarge, 0, 8, "244 GiB RAM, 32 vCPUs, 104 EC2 Compute Units, 8 x 800 GB of SSD-based instance storage, Networking Performance: 10 Gbps"),
    I3Large(InstanceType.I3Large, 0, 1, "15.25 GiB RAM", "2 vCPUs", "Networking Performance: Up to 10 Gbps"),
    I3Xlarge(InstanceType.I3Xlarge, 0, 1, "30.5 GiB RAM", "4 vCPUs", "Networking Performance: Up to 10 Gbps"),
    I32xlarge(InstanceType.I32xlarge, 0, 1, "61 GiB RAM", "8 vCPUs", "Networking Performance: Up to 10 Gbps"),
    I34xlarge(InstanceType.I34xlarge, 0, 2, "122 GiB RAM", "16 vCPUs", "Networking Performance: Up to 10 Gbps"),
    I38xlarge(InstanceType.I38xlarge, 0, 4, "244 GiB RAM", "32 vCPUs", "Networking Performance: 10 Gbps"),
    I316xlarge(InstanceType.I316xlarge, 0, 8, "488 GiB RAM", "64 vCPUs", "Networking Performance: 25 Gbps"),
    I3Metal(InstanceType.I3Metal, 0, 8, "512 GiB RAM", "72 vCPUs", "Networking Performance: 25 Gbps"),
    I4iLarge(InstanceType.I4iLarge, 0, 1, "16 GiB RAM", "2 vCPUs", "Networking Performance: Up to 10 Gbps", "EBS Bandwidth: Up to 10 Gbps", "1 x 468 GB SSD"),
    I4iXlarge(InstanceType.I4iXlarge, 0, 1, "32 GiB RAM", "4 vCPUs", "Networking Performance: Up to 10 Gbps", "EBS Bandwidth: Up to 10 Gbps", "1 x 937 GB SSD"),
    I4i2xlarge(InstanceType.I4i2xlarge, 0, 1, "64 GiB RAM", "8 vCPUs", "Networking Performance: Up to 12 Gbps", "EBS Bandwidth: Up to 10 Gbps", "1 x 1,875 GB SSD"),
    I4i4xlarge(InstanceType.I4i4xlarge, 0, 1, "128 GiB RAM", "16 vCPUs", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 10 Gbps", "1 x 3,750 GB SSD"),
    I4i8xlarge(InstanceType.I4i8xlarge, 0, 2, "246 GiB RAM", "32 vCPUs", "Networking Performance: 18.75 Gbps", "EBS Bandwidth: 10 Gbps", "2 x 3,750 GB SSD"),
    I4i12xlarge(InstanceType.I4i12xlarge, 0, 3, "384 GiB RAM", "48 vCPUs", "Networking Performance: 37.5 Gbps", "EBS Bandwidth: 15 Gbps", "3 x 3,750 GB SSD"),
    I4i16xlarge(InstanceType.I4i16xlarge, 0, 4, "512 GiB RAM", "64 vCPUs", "Networking Performance: 37.5 Gbps", "EBS Bandwidth: 20 Gbps", "4 x 3,750 GB SSD"),
    I4i24xlarge(InstanceType.I4i24xlarge, 0, 6, "768 GiB RAM", "96 vCPUs", "Networking Performance: 75 Gbps", "EBS Bandwidth: 30 Gbps", "6 x 3,750 GB SSD"),
    I4i32xlarge(InstanceType.I4i32xlarge, 0, 8, "1024 GiB RAM", "128 vCPUs", "Networking Performance: 75 Gbps", "EBS Bandwidth: 40 Gbps", "8 x 3,750 GB SSD"),
    I4iMetal(InstanceType.I4iMetal, 0, 8, "1024 GiB RAM", "128 vCPUs", "Networking Performance: 75,  Gbps", "EBS Bandwidth: 40 Gbps", "8 x 3,750 GB SSD"),
    I4gLarge(InstanceType.I4gLarge, 0, 1, "16 GiB RAM", "2 vCPUs", "Networking Performance: Up to 10 Gbps", "EBS Bandwidth: Up to 10 Gbps", "1 x 468 GB SSD"),
    I4gXlarge(InstanceType.I4gXlarge, 0, 1, "32 GiB RAM", "4 vCPUs", "Networking Performance: Up to 10 Gbps", "EBS Bandwidth: Up to 10 Gbps", "1 x 937 GB SSD"),
    I4g2xlarge(InstanceType.I4g2xlarge, 0, 1, "64 GiB RAM", "8 vCPUs", "Networking Performance: Up to 12 Gbps", "EBS Bandwidth: Up to 10 Gbps", "1 x 1,875 GB SSD"),
    I4g4xlarge(InstanceType.I4g4xlarge, 0, 1, "128 GiB RAM", "16 vCPUs", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 10 Gbps", "1 x 3,750 GB SSD"),
    I4g8xlarge(InstanceType.I4g8xlarge, 0, 2, "246 GiB RAM", "32 vCPUs", "Networking Performance: 18.75 Gbps", "EBS Bandwidth: 10 Gbps", "2 x 3,750 GB SSD"),
    I4g16xlarge(InstanceType.I4g16xlarge, 0, 4, "512 GiB RAM", "64 vCPUs", "Networking Performance: 37.5 Gbps", "EBS Bandwidth: 20 Gbps", "4 x 3,750 GB SSD"),
    I3enLarge(InstanceType.I3enLarge, 0, 1, "16 GiB RAM", "2 vCPUs", "1 x 1250 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    I3enXlarge(InstanceType.I3enXlarge, 0, 1, "32 GiB RAM", "4 vCPUs", "1 x 2500 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    I3en2xlarge(InstanceType.I3en2xlarge, 0, 2, "64 GiB RAM", "8 vCPUs", "2 x 2500 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    I3en3xlarge(InstanceType.I3en3xlarge, 0, 1, "96 GiB RAM", "12 vCPUs", "1 x 7500 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    I3en6xlarge(InstanceType.I3en6xlarge, 0, 2, "192 GiB RAM", "24 vCPUs", "2 x 7500 GB of SSD-based instance storage", "Networking Performance: 25 Gbps"),
    I3en12xlarge(InstanceType.I3en12xlarge, 0, 4, "384 GiB RAM", "48 vCPUs", "4 x 7500 GB of SSD-based instance storage", "Networking Performance: 50 Gbps"),
    I3en24xlarge(InstanceType.I3en24xlarge, 0, 8, "768 GiB RAM", "96 vCPUs", "8 x 7500 GB of SSD-based instance storage", "Networking Performance: 100 Gbps"),
    I3enMetal(InstanceType.I3enMetal, 0, 8, "768 GiB RAM", "96 vCPUs", "8 x 7500 GB of SSD-based instance storage", "Networking Performance: 100 Gbps"),
    Im4gnLarge(InstanceType.Im4gnLarge, 0, 1, "8 GiB RAM", "2 vCPUs", "1 x 937 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    Im4gnXlarge(InstanceType.Im4gnXlarge, 0, 1, "16 GiB RAM", "4 vCPUs", "1 x 1875 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    Im4gn2xlarge(InstanceType.Im4gn2xlarge, 0, 1, "32 GiB RAM", "8 vCPUs", "1 x 3750 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    Im4gn4xlarge(InstanceType.Im4gn4xlarge, 0, 1, "64 GiB RAM", "16 vCPUs", "1 x 7500 GB of SSD-based instance storage", "Networking Performance: 25 Gbps"),
    Im4gn8xlarge(InstanceType.Im4gn8xlarge, 0, 2, "128 GiB RAM", "32 vCPUs", "2 x 7500 GB of SSD-based instance storage", "Networking Performance: 50 Gbps"),
    Im4gn16xlarge(InstanceType.Im4gn16xlarge, 0, 4, "256 GiB RAM", "64 vCPUs", "4 x 7500 GB of SSD-based instance storage", "Networking Performance: 100 Gbps"),
    Is4genMedium(InstanceType.Is4genMedium, 0, 1, "6 GiB RAM", "1 vCPUs", "1 x 937 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    Is4genLarge(InstanceType.Is4genLarge, 0, 1, "12 GiB RAM", "2 vCPUs", "1 x 1875 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    Is4genXlarge(InstanceType.Is4genXlarge, 0, 1, "24 GiB RAM", "4 vCPUs", "1 x 3750 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    Is4gen2xlarge(InstanceType.Is4gen2xlarge, 0, 1, "48 GiB RAM", "8 vCPUs", "1 x 7500 GB of SSD-based instance storage", "Networking Performance: Up to 25 Gbps"),
    Is4gen4xlarge(InstanceType.Is4gen4xlarge, 0, 2, "96 GiB RAM", "16 vCPUs", "2 x 7500 GB of SSD-based instance storage", "Networking Performance: 25 Gbps"),
    Is4gen8xlarge(InstanceType.Is4gen8xlarge, 0, 4, "192 GiB RAM", "32 vCPUs", "4 x 7500 GB of SSD-based instance storage", "Networking Performance: 50 Gbps"),
    Inf1Xlarge(InstanceType.Inf1Xlarge, 0, 0, "4 vCPUs", "8 GiB RAM", "1 Inferentia chip", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    Inf12xlarge(InstanceType.Inf12xlarge, 0, 0, "8 vCPUs", "16 GiB RAM", "1 Inferentia chip", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    Inf16xlarge(InstanceType.Inf16xlarge, 0, 0, "24 vCPUs", "48 GiB RAM", "4 Inferentia chip", "Networking Performance: 25 Gbps", "EBS Bandwidth: 4.75 Gbps"),
    Inf124xlarge(InstanceType.Inf124xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "16 Inferentia chip", "Networking Performance: 100 Gbps", "EBS Bandwidth: 19 Gbps"),
    Inf2Xlarge(InstanceType.Inf2Xlarge, 0, 0, "4 vCPUs", "16 GiB RAM", "1 Inferentia2 chip", "Networking Performance: Up to 15 Gbps", "EBS Bandwidth: Up to 10 Gbps"),
    Inf28xlarge(InstanceType.Inf28xlarge, 0, 0, "32 vCPUs", "128 GiB RAM", "1 Inferentia2 chip", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: 10 Gbps"),
    Inf224xlarge(InstanceType.Inf224xlarge, 0, 0, "96 vCPUs", "384 GiB RAM", "6 Inferentia2 chip", "Networking Performance: 50 Gbps", "EBS Bandwidth: 30 Gbps"),
    Inf248xlarge(InstanceType.Inf248xlarge, 0, 0, "192 vCPUs", "768 GiB RAM", "12 Inferentia2 chip", "Networking Performance: 100 Gbps", "EBS Bandwidth: 60 Gbps"),
    D2Xlarge(InstanceType.D2Xlarge, 3, 0, "14 EC2 Compute Units (4 virtual cores)", "30.5 GiB RAM", "Networking Performance: Moderate", "EBS-Optimized Available: By Default"),
    D22xlarge(InstanceType.D22xlarge, 6, 0, "28 EC2 Compute Units (8 virtual cores)", "61 GiB RAM", "Networking Performance: High", "EBS-Optimized Available: By Default"),
    D24xlarge(InstanceType.D24xlarge, 12, 0, "56 EC2 Compute Units (16 virtual cores)", "122 GiB RAM", "Networking Performance: High", "EBS-Optimized Available: By Default"),
    D28xlarge(InstanceType.D28xlarge, 36, 0, "116 EC2 Compute Units (36 virtual cores)", "244 GiB RAM", "Networking Performance: 10 Gbps", "EBS-Optimized Available: By Default"),
    D3Xlarge(InstanceType.D3Xlarge, 3, 0, "4 vCPUs", "32 GiB RAM", "3 x 2 TB HDD", "Networking Performance: Up to 15 Gbps", "EBS Bandwidth: 850 Mbps"),
    D32xlarge(InstanceType.D32xlarge, 6, 0, "8 vCPUs", "64 GiB RAM", "6 x 2 TB HDD", "Networking Performance: Up to 15 Gbps", "EBS Bandwidth: 1700 Mbps"),
    D34xlarge(InstanceType.D34xlarge, 12, 0, "16 vCPUs", "128 GiB RAM", "12 x 2 TB HDD", "Networking Performance: Up to 15 Gbps", "EBS Bandwidth: 2800 Mbps"),
    D38xlarge(InstanceType.D38xlarge, 24, 0, "32 vCPUs", "256 GiB RAM", "24 x 2 TB HDD", "Networking Performance: 25 Gbps", "EBS Bandwidth: 5000 Mbps"),
    D3enXlarge(InstanceType.D3enXlarge, 2, 0, "4 vCPUs", "16 GiB RAM", "2 x 14 TB HDD", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: 850 Mbps"),
    D3en2xlarge(InstanceType.D3en2xlarge, 4, 0, "8 vCPUs", "32 GiB RAM", "4 x 14 TB HDD", "Networking Performance: Up to 25 Gbps", "EBS Bandwidth: 1700 Mbps"),
    D3en4xlarge(InstanceType.D3en4xlarge, 8, 0, "16 vCPUs", "64 GiB RAM", "8 x 14 TB HDD", "Networking Performance: 25 Gbps", "EBS Bandwidth: 2800 Mbps"),
    D3en6xlarge(InstanceType.D3en6xlarge, 12, 0, "24 vCPUs", "96 GiB RAM", "12 x 14 TB HDD", "Networking Performance: 40 Gbps", "EBS Bandwidth: 4000 Mbps"),
    D3en8xlarge(InstanceType.D3en8xlarge, 16, 0, "32 vCPUs", "128 GiB RAM", "16 x 14 TB HDD", "Networking Performance: 50 Gbps", "EBS Bandwidth: 5000 Mbps"),
    D3en12xlarge(InstanceType.D3en12xlarge, 24, 0, "48 vCPUs", "192 GiB RAM", "24 x 14 TB HDD", "Networking Performance: 75 Gbps", "EBS Bandwidth: 7000 Mbps"),
    Dl124xlarge(InstanceType.Dl124xlarge, 2, 0, "96 vCPUs", "768 GiB RAM", "4 x 1 TB SSD", "Networking Performance: 400 Gbps", "EBS Bandwidth: 19 Gbps"),
    Dl2q24xlarge(InstanceType.Dl2q24xlarge, 2, 0, "96 vCPUs", "768 GiB RAM", "4 x 1 TB SSD", "Networking Performance: 100 Gbps", "EBS Bandwidth: 19 Gbps"),
    Hpc6a48xlarge(InstanceType.Hpc6a48xlarge, 0, 0, "96 CPU", "384 GiB RAM", "Networking Performance: 25 Gbps"),
    Hpc6id32xlarge(InstanceType.Hpc6id32xlarge, 0, 4, "64 CPU", "1024 GiB RAM", "Networking Performance: 25 Gbps"),
    Hpc7a12xlarge(InstanceType.Hpc7a12xlarge, 0, 0, "24 CPU", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    Hpc7a24xlarge(InstanceType.Hpc7a24xlarge, 0, 0, "48 CPU", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    Hpc7a48xlarge(InstanceType.Hpc7a48xlarge, 0, 0, "96 CPU", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    Hpc7a96xlarge(InstanceType.Hpc7a96xlarge, 0, 0, "192 CPU", "768 GiB RAM", "Networking Performance: 25 Gbps"),
    Hpc7g4xlarge(InstanceType.Hpc7g4xlarge, 0, 0, "16 CPU", "128 GiB RAM", "Networking Performance: 25 Gbps"),
    Hpc7g8xlarge(InstanceType.Hpc7g8xlarge, 0, 0, "32 CPU", "128 GiB RAM", "Networking Performance: 25 Gbps"),
    Hpc7g16xlarge(InstanceType.Hpc7g16xlarge, 0, 0, "64 CPU", "128 GiB RAM", "Networking Performance: 25 Gbps"),
    Hs18xlarge(InstanceType.Hs18xlarge, 24, 0, "35 EC2 Compute Units (16 virtual cores)", "117 GiB RAM", "24 hard disk drives each with 2 TB of instance storage", "Networking Performance: 10 Gbps", "Storage I/O Performance: Very High", "EBS-Optimized Available: No"),
    Hi14xlarge(InstanceType.Hi14xlarge, 0, 2, "35 EC2 Compute Units (16 virtual cores)", "60.5 GiB RAM", "2 SSD-based volumes each with 1024 GB of instance storage", "Networking Performance: 10 Gbps", "Storage I/O Performance: Very High", "EBS-Optimized Available: No"),
    Vt13xlarge(InstanceType.Vt13xlarge, 0, 0, "12 vCPUs", "24 GiB RAM", "1 x U30 accelerator", "Networking Performance: 3.125 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    Vt16xlarge(InstanceType.Vt16xlarge, 0, 0, "24 vCPUs", "48 GiB RAM", "2 x U30 accelerator", "Networking Performance: 3.125 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    Vt124xlarge(InstanceType.Vt124xlarge, 0, 0, "96 vCPUs", "192 GiB RAM", "8 x U30 accelerator", "Networking Performance: 3.125 Gbps", "EBS Bandwidth: Up to 4.75 Gbps"),
    X116xlarge(InstanceType.X116xlarge, 0, 2, "? vCPUs", "? GiB RAM", "? GB of SSD-based instance storage", "Networking Performance: 10 Gbps Ethernet", "EBS-Optimized Available: By Default"),
    X132xlarge(InstanceType.X132xlarge, 0, 2, "128 vCPUs", "1952 GiB RAM", "2 x 1920 GB of SSD-based instance storage", "Networking Performance: 10 Gbps Ethernet", "EBS-Optimized Available: By Default"),
    X2gdmedium(InstanceType.X2gdMedium, 0, 1, "1 vCPUs", "16 GiB RAM", "1 x 59 GB of SSD-based instance storage", "Networking Performance: Up to 10 Gbps Ethernet", "EBS: Up to 4.75 Gbps"),
    X2gdlarge(InstanceType.X2gdLarge, 0, 1, "2 vCPUs", "32 GiB RAM", "1 x 118 GB of SSD-based instance storage", "Networking Performance: Up to 10 Gbps Ethernet", "EBS: Up to 4.75 Gbps"),
    X2gdxlarge(InstanceType.X2gdXlarge, 0, 1, "4 vCPUs", "64 GiB RAM", "1 x 237 GB of SSD-based instance storage", "Networking Performance: Up to 10 Gbps Ethernet", "EBS: Up to 4.75 Gbps"),
    X2gd2xlarge(InstanceType.X2gd2xlarge, 0, 1, "8 vCPUs", "128 GiB RAM", "1 x 475 GB of SSD-based instance storage", "Networking Performance: Up to 10 Gbps Ethernet", "EBS: Up to 4.75 Gbps"),
    X2gd4xlarge(InstanceType.X2gd4xlarge, 0, 1, "16 vCPUs", "256 GiB RAM", "1 x 950 GB of SSD-based instance storage", "Networking Performance: Up to 10 Gbps Ethernet", "EBS: 4.75 Gbps"),
    X2gd8xlarge(InstanceType.X2gd8xlarge, 0, 1, "32 vCPUs", "512 GiB RAM", "1 x 1900 GB of SSD-based instance storage", "Networking Performance: 12 Gbps Ethernet", "EBS: 9.5 Gbps"),
    X2gd12xlarge(InstanceType.X2gd12xlarge, 0, 2, "48 vCPUs", "768 GiB RAM", "2 x 1425 GB of SSD-based instance storage", "Networking Performance: 20 Gbps Ethernet", "EBS: 14.25 Gbps"),
    X2gd16xlarge(InstanceType.X2gd16xlarge, 0, 2, "64 vCPUs", "1024 GiB RAM", "2 x 1900 GB of SSD-based instance storage", "Networking Performance: 25 Gbps Ethernet", "EBS: 19 Gbps"),
    X2gdMetal(InstanceType.X2gdMetal, 0, 2, "64 vCPUs", "1024 GiB RAM", "2 x 1900 GB of SSD-based instance storage", "Networking Performance: 25 Gbps Ethernet", "EBS: 19 Gbps"),
    X2iezn2xlarge(InstanceType.X2iezn2xlarge, 0, 0, "8 vCPUs", "256 GiB", "EBS Bandwidth: 3.17 Gbps"),
    X2iezn4xlarge(InstanceType.X2iezn4xlarge, 0, 0, "16 vCPUs", "512 GiB", "EBS Bandwidth: 4.75 Gbps"),
    X2iezn6xlarge(InstanceType.X2iezn6xlarge, 0, 0, "24 vCPUs", "768 GiB", "EBS Bandwidth: 9.5 Gbps"),
    X2iezn8xlarge(InstanceType.X2iezn8xlarge, 0, 0, "32 vCPUs", "1024 GiB", "EBS Bandwidth: 12 Gbps"),
    X2iezn12xlarge(InstanceType.X2iezn12xlarge, 0, 0, "48 vCPUs", "1536 GiB", "EBS Bandwidth: 19 Gbps"),
    X2ieznMetal(InstanceType.X2ieznMetal, 0, 0, "48 vCPUs", "1536 GiB", "EBS Bandwidth: 19 Gbps"),
    X2idn16xlarge(InstanceType.X2idn16xlarge, 0, 1, "64 vCPUs", "1024 GiB", "EBS Bandwidth: 40 Gbps", "1 x 1900 GB NVMe SSD"),
    X2idn24xlarge(InstanceType.X2idn24xlarge, 0, 2, "96 vCPUs", "1536 GiB", "EBS Bandwidth: 60 Gbps", "2 x 1425 GB NVMe SSD"),
    X2idn32xlarge(InstanceType.X2idn32xlarge, 0, 2, "128 vCPUs", "2048 GiB", "EBS Bandwidth: 80 Gbps", "2 x 1900 GB NVMe SSD"),
    X2idnMetal(InstanceType.X2idnMetal, 0, 2, "128 vCPUs", "2048 GiB", "EBS Bandwidth: 80 Gbps", "2 x 1900 GB NVMe SSD"),
    X2iednXlarge(InstanceType.X2iednXlarge, 0, 1, "4 vCPUs", "128 GiB", "EBS Bandwidth: Up to 20 Gbps", "1 x 118 GB NVMe SSD"),
    X2iedn2xlarge(InstanceType.X2iedn2xlarge, 0, 1, "8 vCPUs", "256 GiB", "EBS Bandwidth: Up to 20 Gbps", "1 x 237 GB NVMe SSD"),
    X2iedn4xlarge(InstanceType.X2iedn4xlarge, 0, 1, "16 vCPUs", "512 GiB", "EBS Bandwidth: Up to 20 Gbps", "1 x 475 GB NVMe SSD"),
    X2iedn8xlarge(InstanceType.X2iedn8xlarge, 0, 1, "32 vCPUs", "1024 GiB", "EBS Bandwidth: 20 Gbps", "1 x 950 GB NVMe SSD"),
    X2iedn16xlarge(InstanceType.X2iedn16xlarge, 0, 1, "64 vCPUs", "2048 GiB", "EBS Bandwidth: 40 Gbps", "1 x 1900 GB NVMe SSD"),
    X2iedn24xlarge(InstanceType.X2iedn24xlarge, 0, 2, "96 vCPUs", "3072 GiB", "EBS Bandwidth: 60 Gbps", "2 x 1425 GB NVMe SSD"),
    X2iedn32xlarge(InstanceType.X2iedn32xlarge, 0, 2, "128 vCPUs", "4096 GiB", "EBS Bandwidth: 80 Gbps", "2 x 1900 GB NVMe SSD"),
    X2iednMetal(InstanceType.X2iednMetal, 0, 2, "128 vCPUs", "4096 GiB", "EBS Bandwidth: 80 Gbps", "2 x 1900 GB NVMe SSD"),
    X1eXlarge(InstanceType.X1eXlarge, 0, 1, "4 vCPUs", "122 GiB", "1 x 120 GB SSD", "EBS Bandwidth: 500 Mbps"),
    X1e2xlarge(InstanceType.X1e2xlarge, 0, 1, "8 vCPUs", "244 GiB", "1 x 240 GB SSD", "EBS Bandwidth: 1,000 Mbps"),
    X1e4xlarge(InstanceType.X1e4xlarge, 0, 1, "16 vCPUs", "488 GiB", "1 x 480 GB SSD", "EBS Bandwidth: 1,750 Mbps"),
    X1e8xlarge(InstanceType.X1e8xlarge, 0, 1, "32 vCPUs", "976 GiB", "1 x 960 GB SSD", "EBS Bandwidth: 3,500 Mbps"),
    X1e16xlarge(InstanceType.X1e16xlarge, 0, 1, "64 vCPUs", "1,952 GiB", "1 x 1,920 GB SSD", "EBS Bandwidth: 7,000 Mbps"),
    X1e32xlarge(InstanceType.X1e32xlarge, 0, 2, "128 vCPUs", "3,904 GiB", "2 x 1,920 GB SSD", "EBS Bandwidth: 14,000 Mbps"),
    Z1dLarge(InstanceType.Z1dLarge, 0, 1, "2 vCPUs", "16 GiB", "1 x 75 NVMe SSD", "Networking Performance: Up to 10,000 Mbps", "EBS Bandwidth: Up to 2,333 Mbps"),
    Z1dXlarge(InstanceType.Z1dXlarge, 0, 1, "4 vCPUs", "32 GiB", "1 x 150 NVMe SSD", "Networking Performance: Up to 10,000 Mbps", "EBS Bandwidth: Up to 2,333 Mbps"),
    Z1d2xlarge(InstanceType.Z1d2xlarge, 0, 1, "8 vCPUs", "64 GiB", "1 x 300 NVMe SSD", "Networking Performance: Up to 10,000 Mbps", "EBS Bandwidth: 2,333 Mbps"),
    Z1d3xlarge(InstanceType.Z1d3xlarge, 0, 1, "12 vCPUs", "96 GiB", "1 x 450 NVMe SSD", "Networking Performance: Up to 10,000 Mbps", "EBS Bandwidth: 3,500 Mbps"),
    Z1d6xlarge(InstanceType.Z1d6xlarge, 0, 1, "24 vCPUs", "192 GiB", "1 x 900 NVMe SSD", "Networking Performance: 10,000 Mbps", "EBS Bandwidth: 7,000 Mbps"),
    Z1d12xlarge(InstanceType.Z1d12xlarge, 0, 2, "48 vCPUs", "384 GiB", "2 x 900 NVMe SSD", "Networking Performance: 25,000 Mbps", "EBS Bandwidth: 14,000 Mbps"),
    Z1dMetal(InstanceType.Z1dMetal, 0, 2, "48 vCPUs", "384 GiB", "2 x 900 NVMe SSD", "Networking Performance: 25,000 Mbps", "EBS Bandwidth: 14,000 Mbps"),
    Trn12xlarge(InstanceType.Trn12xlarge, 0, 1, "8 vCPUs", "1 Trainium Accelerator", "32 GB RAM", "0.5 TB NVMe SSD", "Network bandwidth: Up to 12.5 Gbps"),
    Trn132xlarge(InstanceType.Trn132xlarge, 0, 4, "128 vCPUs", "16 Trainium Accelerators", "512 GB RAM", "8 TB NVMe SSD", "Network bandwidth: 800 Gbps"),
    Trn1n32xlarge(InstanceType.Trn1n32xlarge, 0, 4, "128 vCPUs", "16 Trainium Accelerators", "512 GB RAM", "8 TB NVMe SSD", "Network bandwidth: 1600 Gbps");

    public static final EC2InstanceType DEFAULT;
    private final String name;
    private final int ssdCnt;
    private final int magneticDiscCnt;
    private String description;
    private final InstanceType apiParameterValue;
    @VisibleForTesting
    final String family;

    private EC2InstanceType(InstanceType apiParameterValue, int magneticDiscCnt, int ssdCnt, String ... descriptionLines) {
        this.name = EC2InstanceType.generateName(apiParameterValue);
        this.ssdCnt = ssdCnt;
        this.magneticDiscCnt = magneticDiscCnt;
        this.description = descriptionLines.length > 1 ? Joiner.on((char)'\n').join((Object[])descriptionLines) : StringUtils.replace((String)descriptionLines[0], (String)",", (String)"\n");
        if (ssdCnt == 0 && magneticDiscCnt == 0) {
            this.description = this.description + "\nEBS only";
        }
        this.apiParameterValue = apiParameterValue;
        this.family = StringUtils.substringBefore((String)apiParameterValue.toString(), (String)".").toUpperCase();
    }

    @VisibleForTesting
    static String generateName(InstanceType apiParameterValue) {
        String[] familyIdAndType = apiParameterValue.toString().split("\\.");
        String familyId = familyIdAndType[0].toUpperCase();
        String familyName = InstanceFamilyData.familyNames.get(familyId);
        Preconditions.checkNotNull((Object)familyName, (Object)("Unknown family " + familyId));
        String s = familyIdAndType[1].replaceFirst("xlarge", "X Large");
        return familyId + " " + familyName + " " + StringUtils.capitalize((String)s);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getSsdCnt() {
        return this.ssdCnt;
    }

    public InstanceType getAwsInstanceType() {
        return this.apiParameterValue;
    }

    public boolean supports(VirtualizationType virtualisation) {
        switch (virtualisation) {
            case Hvm: {
                return InstanceFamilyData.currentGeneration.contains(this.family) || InstanceFamilyData.oldGenerationWithHvm.contains(this.family);
            }
            case Paravirtual: {
                return InstanceFamilyData.currentGenerationWithPv.contains(this.family) || InstanceFamilyData.oldGenerationWithPv.contains(this.family);
            }
        }
        throw new UnsupportedOperationException("Unknown virtualisation: " + virtualisation);
    }

    public static EC2InstanceType from(InstanceType instanceType) {
        Preconditions.checkNotNull((Object)instanceType);
        for (EC2InstanceType ec2InstanceType : EC2InstanceType.values()) {
            if (ec2InstanceType.getAwsInstanceType() != instanceType) continue;
            return ec2InstanceType;
        }
        throw new IllegalArgumentException("Unknown instance type: " + instanceType);
    }

    public String toString() {
        return this.name;
    }

    /*
     * Opcode count of 23109 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        DEFAULT = M1_SMALL;
    }
}

