/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.ActiveInstance;
import com.amazonaws.services.ec2.model.AmazonEC2Exception;
import com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsResult;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.SpotFleetRequestConfig;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.ec2.InstanceStatus;
import com.atlassian.aws.ec2.RemoteEC2InstanceImpl;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.model.SpotFleetRequestId;
import com.atlassian.aws.ec2.model.SpotRequestId;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InstanceTerminator
extends RemoteEC2InstanceImpl.CatchingRunnableDecorator {
    private static final Logger log = Logger.getLogger(InstanceTerminator.class);

    InstanceTerminator(AWSAccount awsAccount, InstanceStatus instanceStatus, Runnable taskCanceller) {
        super("terminator()", InstanceTerminator.newTerminator(awsAccount, instanceStatus, taskCanceller));
    }

    private static boolean terminateInstance(AmazonEC2 amazonEc2, @Nullable String instanceId) {
        if (instanceId == null) {
            return true;
        }
        log.info((Object)("Requesting that EC2 instance " + instanceId + " be shut down."));
        TerminateInstancesRequest terminateInstacesRequest = new TerminateInstancesRequest().withInstanceIds(new String[]{instanceId});
        TerminateInstancesResult terminateInstancesResult = amazonEc2.terminateInstances(terminateInstacesRequest);
        List terminatingInstances = terminateInstancesResult.getTerminatingInstances();
        for (InstanceStateChange terminatingInstance : terminatingInstances) {
            log.info((Object)("Requested transition of EC2 instance " + terminatingInstance.getInstanceId() + ", state will change from : " + terminatingInstance.getPreviousState() + " to " + terminatingInstance.getCurrentState() + ")"));
        }
        return !terminatingInstances.isEmpty();
    }

    private static boolean cancelSpotFleetRequest(AmazonEC2 amazonEc2, InstanceStatus instanceStatus, String spotFleetRequestId) {
        DescribeSpotFleetRequestsResult describeSpotInstanceRequestsResult;
        CancelSpotFleetRequestsRequest cancelRequest = new CancelSpotFleetRequestsRequest().withSpotFleetRequestIds(new String[]{spotFleetRequestId});
        try {
            amazonEc2.cancelSpotFleetRequests(cancelRequest);
            log.info((Object)("Requested cancellation of spot request " + spotFleetRequestId));
        }
        catch (AmazonServiceException e) {
            log.warn((Object)"Error when cancelling the request", (Throwable)e);
        }
        DescribeSpotFleetInstancesRequest describeSpotFleetInstancesRequest = new DescribeSpotFleetInstancesRequest().withSpotFleetRequestId(spotFleetRequestId);
        DescribeSpotFleetInstancesResult describeSpotFleetInstancesResult = amazonEc2.describeSpotFleetInstances(describeSpotFleetInstancesRequest);
        ActiveInstance activeInstance = (ActiveInstance)Iterables.getOnlyElement((Iterable)describeSpotFleetInstancesResult.getActiveInstances(), null);
        if (activeInstance != null) {
            instanceStatus.setInstanceId(activeInstance.getInstanceId());
        }
        DescribeSpotFleetRequestsRequest describeSpotInstanceRequestsRequest = new DescribeSpotFleetRequestsRequest().withSpotFleetRequestIds(new String[]{spotFleetRequestId});
        try {
            describeSpotInstanceRequestsResult = amazonEc2.describeSpotFleetRequests(describeSpotInstanceRequestsRequest);
        }
        catch (AmazonServiceException e) {
            AmazonServiceErrorCode.INVALID_SPOT_FLEET_REQUEST_ID_NOT_FOUND.rethrowIfNot(e);
            return true;
        }
        SpotFleetRequestConfig describedSpotFleetRequest = (SpotFleetRequestConfig)Iterables.getOnlyElement((Iterable)describeSpotInstanceRequestsResult.getSpotFleetRequestConfigs());
        return AwsSupportConstants.SpotFleetRequestState.isFinal(describedSpotFleetRequest.getSpotFleetRequestState());
    }

    private static boolean cancelSpotInstanceRequest(AmazonEC2 amazonEc2, InstanceStatus instanceStatus, String spotInstanceRequestId) {
        DescribeSpotInstanceRequestsResult describeSpotInstanceRequestsResult;
        CancelSpotInstanceRequestsRequest cancelRequest = new CancelSpotInstanceRequestsRequest().withSpotInstanceRequestIds(new String[]{spotInstanceRequestId});
        try {
            amazonEc2.cancelSpotInstanceRequests(cancelRequest);
            log.info((Object)("Requested cancellation of spot request " + spotInstanceRequestId));
        }
        catch (AmazonServiceException e) {
            log.warn((Object)"Error when cancelling the request", (Throwable)e);
        }
        DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest = new DescribeSpotInstanceRequestsRequest().withSpotInstanceRequestIds(new String[]{spotInstanceRequestId});
        try {
            describeSpotInstanceRequestsResult = amazonEc2.describeSpotInstanceRequests(describeSpotInstanceRequestsRequest);
        }
        catch (AmazonServiceException e) {
            AmazonServiceErrorCode.INVALID_SPOT_INSTANCE_REQUEST_ID_NOT_FOUND.rethrowIfNot(e);
            return true;
        }
        SpotInstanceRequest describedSpotRequest = (SpotInstanceRequest)Iterables.getOnlyElement((Iterable)describeSpotInstanceRequestsResult.getSpotInstanceRequests());
        String describedInstanceId = describedSpotRequest.getInstanceId();
        if (StringUtils.isNotBlank((CharSequence)describedInstanceId)) {
            instanceStatus.setInstanceId(describedInstanceId);
        }
        return AwsSupportConstants.SpotInstanceRequestState.isFinal(describedSpotRequest.getState());
    }

    private static boolean cancelSpotRequest(AmazonEC2 amazonEc2, InstanceStatus instanceStatus) {
        String spotInstanceRequestId = instanceStatus.getSpotInstanceRequestId();
        String instanceId = instanceStatus.getInstanceId();
        if (instanceId != null || spotInstanceRequestId == null) {
            return true;
        }
        if (SpotRequestId.isValid(spotInstanceRequestId)) {
            return InstanceTerminator.cancelSpotInstanceRequest(amazonEc2, instanceStatus, spotInstanceRequestId);
        }
        if (SpotFleetRequestId.isValid(spotInstanceRequestId)) {
            return InstanceTerminator.cancelSpotFleetRequest(amazonEc2, instanceStatus, spotInstanceRequestId);
        }
        throw new IllegalArgumentException("Unknown spot instance request id " + spotInstanceRequestId);
    }

    @NotNull
    private static Runnable newTerminator(final AWSAccount awsAccount, final InstanceStatus instanceStatus, final Runnable selfCanceller) {
        return new Runnable(){
            private volatile boolean isSpotRequestClosed;
            {
                this.isSpotRequestClosed = instanceStatus.getSpotInstanceRequestId() == null;
            }

            @Override
            public void run() {
                this.runTermination();
                selfCanceller.run();
            }

            private void runTermination() {
                if (this.isTerminated(instanceStatus.getState())) {
                    log.info((Object)("Instance " + (Object)((Object)instanceStatus.getState()) + " is already terminated."));
                    return;
                }
                log.debug((Object)("Started termination task for instance/spot request " + instanceStatus.getSensibleId()));
                try {
                    boolean isInstanceTerminated;
                    if (!this.isSpotRequestClosed) {
                        this.isSpotRequestClosed = InstanceTerminator.cancelSpotRequest((AmazonEC2)awsAccount.getAmazonEc2(), instanceStatus);
                    }
                    if ((isInstanceTerminated = InstanceTerminator.terminateInstance((AmazonEC2)awsAccount.getAmazonEc2(), instanceStatus.getInstanceId())) && this.isSpotRequestClosed) {
                        log.debug((Object)("Instance " + instanceStatus.getSensibleId() + " has been terminated"));
                    }
                }
                catch (AmazonEC2Exception e) {
                    if (AmazonServiceErrorCode.UNAUTHORISED_OPERATION.is((AmazonServiceException)((Object)e))) {
                        log.error((Object)("Bamboo Server does not have permissions to terminate " + instanceStatus.getSensibleId() + ". Leaving instance running, you are responsible for its termination."));
                    }
                    log.warn((Object)("Failed to order cancellation/termination of instance " + instanceStatus.getSensibleId() + ".  Will retry."), (Throwable)e);
                    throw e;
                }
                catch (RuntimeException e) {
                    log.warn((Object)("Failed to order cancellation/termination of instance " + instanceStatus.getSensibleId() + ".  Will retry."), (Throwable)e);
                    throw e;
                }
            }

            private boolean isTerminated(AwsSupportConstants.InstanceStateName state) {
                return state == AwsSupportConstants.InstanceStateName.Terminated || state == AwsSupportConstants.InstanceStateName.ShuttingDown;
            }
        };
    }

    public static void terminate(AWSAccount awsAccount, ScheduledExecutorService scheduledExecutorService, InstanceStatus instanceStatus) {
        final LinkedBlockingDeque queue = new LinkedBlockingDeque(1);
        Supplier ref = Suppliers.memoize((Supplier)new Supplier<Future<?>>(){

            public Future<?> get() {
                try {
                    return (Future)queue.takeFirst();
                }
                catch (InterruptedException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
        Runnable taskCanceller = () -> {
            boolean mayInterruptIfRunning = false;
            ((Future)ref.get()).cancel(false);
        };
        InstanceTerminator terminator = new InstanceTerminator(awsAccount, instanceStatus, taskCanceller);
        queue.add(scheduledExecutorService.scheduleWithFixedDelay(terminator, 0L, 5L, TimeUnit.MINUTES));
    }
}

