/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.RequestSpotFleetResult;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.model.SubnetId;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AwsSpotFleetInstanceRequest
implements InstanceReservationDescription {
    private final Collection<SpotFleetLaunchSpecification> spotFleetLaunchSpecifications;
    private final String spotFleetRequestId;
    private final Supplier<String> availabilityZone = this.uniqSupplier(e -> {
        SpotPlacement placement = e.getPlacement();
        return placement != null ? placement.getAvailabilityZone() : "n/a";
    });
    private final Supplier<SubnetId> subnetId = this.uniqSupplier(e -> SubnetId.fromNullable(e.getSubnetId()));
    private final Supplier<InstanceType> instanceType = this.uniqSupplier(launchSpec -> {
        String instanceType1 = launchSpec.getInstanceType();
        return instanceType1 != null ? InstanceType.fromValue((String)instanceType1) : null;
    });

    public AwsSpotFleetInstanceRequest(String spotFleetRequestId, Collection<SpotFleetLaunchSpecification> spotFleetLaunchSpecifications) {
        this.spotFleetRequestId = spotFleetRequestId;
        this.spotFleetLaunchSpecifications = spotFleetLaunchSpecifications;
    }

    @NotNull
    public static Collection<InstanceReservationDescription> create(RequestSpotFleetResult requestSpotFleetResult, Collection<SpotFleetLaunchSpecification> launchSpecifications) {
        return Collections.singleton(new AwsSpotFleetInstanceRequest(requestSpotFleetResult.getSpotFleetRequestId(), launchSpecifications));
    }

    @Override
    public String getInstanceId() {
        return null;
    }

    public String getSpotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    @Override
    public String getAvailabilityZone() {
        return (String)this.availabilityZone.get();
    }

    @Override
    @Nullable
    public SubnetId getSubnet() {
        return (SubnetId)this.subnetId.get();
    }

    @Override
    @NotNull
    public String getAddress() {
        return "none";
    }

    @Override
    @Nullable
    public InstanceType getInstanceType() {
        return (InstanceType)this.instanceType.get();
    }

    @Override
    @NotNull
    public String getHostname() {
        return "none";
    }

    @Override
    public AwsSupportConstants.InstanceStateName getState() {
        return AwsSupportConstants.InstanceStateName.SpotOpen;
    }

    @Override
    public String getStateDescription() {
        return this.getState().toString();
    }

    @NotNull
    private <T> Supplier<T> uniqSupplier(Function<SpotFleetLaunchSpecification, T> converter) {
        return Suppliers.memoize(() -> this.uniq(converter));
    }

    @Nullable
    private <T> T uniq(Function<SpotFleetLaunchSpecification, T> converter) {
        Set values = this.spotFleetLaunchSpecifications.stream().map(converter).collect(Collectors.toSet());
        if (values.size() == 1) {
            return (T)Iterables.getOnlyElement(values);
        }
        return null;
    }
}

