/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk.launch;

import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.ec2.AvailabilityZoneChooser;
import com.atlassian.aws.ec2.InstanceLaunchConfiguration;
import com.atlassian.aws.ec2.InstanceStatus;
import com.atlassian.aws.ec2.SubnetChooser;
import com.atlassian.aws.ec2.awssdk.InstanceLauncher;
import com.atlassian.aws.ec2.awssdk.launch.AwsInstanceLauncher;
import com.atlassian.aws.ec2.awssdk.launch.AwsSpotInstanceLauncher;

public class InstanceLauncherFactory {
    private final SubnetChooser subnetChooser;
    final AWSAccount awsAccount;

    public InstanceLauncherFactory(AWSAccount awsAccount) {
        this.awsAccount = awsAccount;
        this.subnetChooser = new SubnetChooser(new AvailabilityZoneChooser(), awsAccount);
    }

    public InstanceLauncher newLauncher(InstanceLaunchConfiguration instanceConfiguration, InstanceStatus instanceStatus) {
        return instanceConfiguration.getSpotInstanceBid() > 0.0 ? this.newSpotInstanceLauncher(instanceConfiguration, instanceStatus) : this.newOnDemandInstanceLauncher(instanceConfiguration, instanceStatus);
    }

    public InstanceLauncher newOnDemandInstanceLauncher(InstanceLaunchConfiguration instanceConfiguration, InstanceStatus instanceStatus) {
        return new AwsInstanceLauncher(this.awsAccount, this.subnetChooser, instanceConfiguration, instanceStatus);
    }

    public InstanceLauncher newSpotInstanceLauncher(InstanceLaunchConfiguration instanceConfiguration, InstanceStatus instanceStatus) {
        InstanceLauncher fallbackLauncher = this.newOnDemandInstanceLauncher(instanceConfiguration, instanceStatus);
        return new AwsSpotInstanceLauncher(this.awsAccount, this.subnetChooser, instanceConfiguration, instanceStatus, fallbackLauncher);
    }
}

